/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart;

import com.ez.graphs.flowchart.TSENodeComparator;
import com.ez.graphs.flowchart.model.FlowChartLayout;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.model.ParsFile;
import com.ez.graphs.flowchart.model.SourceInfo;
import com.ez.graphs.flowchart.ui.UINodeProvider;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.tomsawyer.drawing.geometry.shared.TSOvalShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowchartGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FlowchartGraphModel.class);
    private TSNodeBuilder nodeBuilder;
    private TSEdgeBuilder edgeBuilder;
    private FlowElement flowModel;
    private UINodeProvider uiNodeProvider;
    private String prjName;
    public Map<TSENode, SourceInfo> tsToElem = new HashMap<TSENode, SourceInfo>();
    private Map<String, ParsFile> files;
    private boolean tsNodeResizability;

    public FlowchartGraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
    }

    private void initialize() {
        this.uiNodeProvider = new UINodeProvider();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.tsToElem.clear();
        this.outForGISV.clear();
        IPreferenceStore store = PreferenceUtils.getPreferenceStore();
        this.tsNodeResizability = store.getBoolean("showFlowchartAsText");
    }

    public void clear() {
        this.files = null;
        this.prjName = "";
        this.flowModel = null;
    }

    public String getMsgForLayoutDecision() {
        return null;
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        this.initialize();
        this.nodeBuilder = this.graphManager.getNodeBuilder();
        this.edgeBuilder = this.graphManager.getEdgeBuilder();
        if (this.nodeBuilder == null) {
            this.nodeBuilder = new TSNodeBuilder();
            this.graphManager.setNodeBuilder(this.nodeBuilder);
        }
        if (this.edgeBuilder == null) {
            this.edgeBuilder = new TSEdgeBuilder();
            this.graphManager.setEdgeBuilder(this.edgeBuilder);
        }
        this.nodeBuilder.setResizability(3);
        L.debug("traverse graph model and add nodes to graph");
        this.createGraphElements(pmonitor);
        L.debug("loading graph finished");
    }

    private void createGraphElements(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (this.flowModel != null) {
            if (!monitor.isCanceled()) {
                FlowChartLayout.draw(this, this.flowModel, (IProgressMonitor)monitor.newChild(100));
            }
        } else {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(FlowchartGraphModel.class, "noresults.node.name"));
            L.debug("no results for flow chart");
        }
    }

    public TSENode createPointNode() {
        TSENode node = this.nodeBuilder.addNode(this.graph);
        node.setShape((TSShape)TSOvalShape.getInstance());
        node.setSize(4.0, 4.0);
        node.setResizability(0x1000000);
        node.setAttribute("IS_DEAD_CODE", (Object)Boolean.TRUE);
        this.uiNodeProvider.setUINode(node, "SPECIAL_NODE");
        return node;
    }

    public TSENode createNode(FlowElement elem) {
        String type = elem.getType();
        SourceInfo si = elem.getSourceInfo();
        String name = si != null && si.getText() != null ? si.getText() : "";
        String nodeType = "";
        TSENode tsNode = this.nodeBuilder.addNode(this.graph);
        tsNode.setName((Object)name);
        tsNode.setTooltipText(name);
        tsNode.setAttribute("RESOURCE_TYPE_INTEGER", (Object)type);
        tsNode.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
        this.tsToElem.put(tsNode, si);
        String inventoryCategory = "";
        if (type.equalsIgnoreCase("Section")) {
            nodeType = "Section";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "section.lbl");
        }
        if (type.equalsIgnoreCase("Paragraph") || type.equalsIgnoreCase("LabelStatement")) {
            nodeType = "Paragraph";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "paragraphs.lbl");
        }
        if (type.equalsIgnoreCase("Statement")) {
            nodeType = "default";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "statements.lbl");
        }
        if (type.equalsIgnoreCase("ExitStatement")) {
            nodeType = "default";
            tsNode.setAttribute("exitstatement", (Object)true);
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "exits.lbl");
        }
        if (type.equalsIgnoreCase("IfStatement")) {
            int idx;
            String nodeString = tsNode.getText();
            if (nodeString != null && (idx = nodeString.indexOf(" ")) > 0 && !this.tsNodeResizability) {
                String nodeStringTruncate = nodeString.substring(0, nodeString.indexOf(" "));
                tsNode.setAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY", (Object)nodeString);
                tsNode.setName((Object)nodeStringTruncate);
            }
            nodeType = "IF_Statemnt";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "ifStmt.lbl");
        }
        if (type.equalsIgnoreCase("FlowControlStatement")) {
            nodeType = "Flow_Control_Statemnt";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "flowControl.lbl");
            if (elem.getProperties() != null && elem.getProperties().getProperty("IdRef") != null) {
                tsNode.setAttribute("flow_control_statement, paragraph_ref id", (Object)elem.getProperties().getProperty("IdRef"));
            }
        }
        if (type.equalsIgnoreCase("SwitchState")) {
            nodeType = "default";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "switch.lbl");
        }
        if (type.equalsIgnoreCase("Case")) {
            nodeType = "Case Staement";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "CaseStmt.lbl");
        }
        if (type.equalsIgnoreCase("PerformVarTimesState")) {
            nodeType = "default";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "perform.lbl");
        }
        if (type.equalsIgnoreCase("WhileState")) {
            nodeType = "IF_Statemnt";
            inventoryCategory = Messages.getString(FlowchartGraphModel.class, "while.lbl");
        }
        if (!inventoryCategory.equalsIgnoreCase("")) {
            this.putEntriesInGISV(inventoryCategory, tsNode);
        } else {
            L.debug("Other category for inventory {}", tsNode.getName());
        }
        this.uiNodeProvider.setUINode(tsNode, nodeType);
        this.uiNodeProvider.setNodeFullText(this.tsNodeResizability);
        if (this.tsNodeResizability) {
            int firstIndex;
            tsNode.setResizability(1);
            tsNode.setAttribute("resizability", (Object)Boolean.TRUE);
            String text = tsNode.getText();
            if (text != null && (firstIndex = text.indexOf("\n")) > 0) {
                tsNode.setResizability(3);
            }
        }
        return tsNode;
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        if (!gNode.hasAttribute("mainframe project name")) {
            gNode.setAttribute("mainframe project name", (Object)this.prjName);
        }
        return null;
    }

    public void setMainframeProjectName(String prjName) {
        this.prjName = prjName;
    }

    public void setIRModel(FlowElement fm) {
        this.flowModel = fm;
    }

    public FlowElement getIrModel() {
        return this.flowModel;
    }

    public String getSourcePath(TSENode node) {
        String path = null;
        if (this.tsToElem.containsKey(node)) {
            SourceInfo si = this.tsToElem.get(node);
            String fileID = si.getFileID();
            if (si.getSecondFileID() == null) {
                ParsFile file = this.files.get(fileID);
                if (file.getPath() != null) {
                    path = file.getPath();
                } else {
                    L.debug("no path for: {}", (Object)file.getName());
                }
            } else {
                L.warn("Source files are different. Cannot get resource.");
            }
        }
        return path;
    }

    public int[] getTxtSelSg(TSENode node) {
        int[] sg = null;
        if (this.tsToElem.containsKey(node)) {
            SourceInfo si = this.tsToElem.get(node);
            sg = new int[]{si.getSline(), si.getScolumn(), si.getEline(), si.getEcolumn()};
        }
        return sg;
    }

    public void dispose() {
        this.tsToElem.clear();
        this.tsToElem = null;
        super.dispose();
    }

    public void setFiles(Map<String, ParsFile> filesMap) {
        this.files = filesMap;
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    public void writeGraphToFile(TSEGraph graph, String prgName, String pathSelected) {
        block9: {
            String pathToWrite = String.valueOf(pathSelected) + "/" + prgName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block9;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + prgName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    List attrNames = node.getAttributeNames();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : attrNames) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (!stmtType.equals("")) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

