/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart;

import com.ez.graphs.flowchart.FlowchartGraphModel;
import com.ez.graphs.flowchart.model.FlowChartRepairLayoutCommand;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.model.ParsFile;
import com.ez.graphs.flowchart.model.XMLParser;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.GraphMouseActionsHookAdapter;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.TSCommandInterface;
import com.tomsawyer.interactive.command.TSGroupCommand;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowchartGraphJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String layoutAttribute = "firstTimeLayout";
    private static final Logger L = LoggerFactory.getLogger(FlowchartGraphJob.class);
    private GraphMouseActionsHook mouseActionsHook = new GraphMouseActionsHook();
    private String programType;

    public FlowchartGraphJob(EZEntityID ezId) {
        super(ezId);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new FlowchartGraphModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(false);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((com.ez.workspace.analysis.graph.model.GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    private void fillGraphModel(EZEntityID input, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ProjectInfo pi = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        String prjLocation = (String)pi.getInfo().get("projectLocation");
        String prjName = (String)pi.getInfo().get("projectName");
        Path path = new Path(prjLocation);
        EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)input.getSegment(EZSourceProgramIDSg.class);
        boolean err = false;
        String message = null;
        String programName = null;
        if (path == null || path.isEmpty()) {
            err = true;
        } else {
            programName = prgIdSg.getProgramName();
            Integer programTypeId = prgIdSg.getTypeId();
            Integer prgId = prgIdSg.getProgramId();
            if (19 == programTypeId) {
                L.debug("program {} with id: {} ", (Object)programName, (Object)prgId);
                prgId = prgIdSg.getAncestorId();
                String string = programName = prgIdSg.getAncestorName() != null ? prgIdSg.getAncestorName() : programName;
            }
            if (2 == programTypeId || 3 == programTypeId) {
                programName = programName.contains(":") ? programName.substring(programName.indexOf(":") + 1, programName.length()).trim() : programName;
            }
            this.programType = String.valueOf(programTypeId);
            path = path.append("IR");
            L.debug("searching for file {} in path {}", (Object)programName, (Object)path);
            programName = programName.concat("_").concat(String.valueOf(prgId)).concat(".xml");
            path = path.append(programName);
            String irFilePath = path.toOSString();
            monitor.worked(20);
            monitor.subTask(Messages.getString(FlowchartGraphJob.class, "monitor.loading"));
            XMLParser parser = new XMLParser();
            FlowElement fm = parser.getModel(irFilePath, prjName, programTypeId, (IProgressMonitor)monitor.newChild(80));
            if (parser.getExceptionStatus() != 0) {
                L.debug("parser exception status {}", (Object)parser.getExceptionStatus());
                switch (parser.getExceptionStatus()) {
                    case 5: {
                        message = Messages.getString(FlowchartGraphJob.class, "notauthorized.errorMessage", new String[]{programName});
                        break;
                    }
                    case 6: {
                        message = Messages.getString(FlowchartGraphJob.class, "filenotfound.errorMessage", new String[]{programName});
                        break;
                    }
                    case 9: {
                        message = Messages.getString(FlowchartGraphJob.class, "httpnotfound.error");
                        break;
                    }
                    case 10: {
                        message = Messages.getString(FlowchartGraphJob.class, "file.service.error");
                        break;
                    }
                    case 7: {
                        message = Messages.getString(FlowchartGraphJob.class, "authorization.genericexception.errorMessage", new String[]{programName});
                        break;
                    }
                    default: {
                        message = Messages.getString(FlowchartGraphJob.class, "notshared.file.flowchart", new String[]{programName});
                    }
                }
                err = true;
            } else {
                Map<String, ParsFile> filesMap = parser.getFilesM();
                ((FlowchartGraphModel)this.graphModel).setMainframeProjectName(prjName);
                ((FlowchartGraphModel)this.graphModel).setIRModel(fm);
                ((FlowchartGraphModel)this.graphModel).setFiles(filesMap);
            }
        }
        if (err) {
            if (message == null) {
                message = Messages.getString(FlowchartGraphJob.class, "no.file.flowchart", new String[]{programName});
            }
            FlowchartGraphJob.openMessageDialog(message);
        }
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.subTask(Messages.getString(FlowchartGraphJob.class, "monitor.locating"));
        List inputs = this.analysis.getContextListValue("input_list");
        Object pathSelected = this.analysis.getContextValue("selected path");
        if (pathSelected != null && !pathSelected.toString().trim().equals("")) {
            TSEGraph mainGraph = this.graphModel.getGraph();
            for (EZEntityID entity : inputs) {
                EZSourceProgramIDSg progId = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                this.fillGraphModel(entity, monitor);
                this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = this.graphModel.getGraph();
                ((FlowchartGraphModel)this.graphModel).writeGraphToFile(newGraph, progId.getProgramName(), pathSelected.toString());
                newGraph.dispose();
            }
            this.graphModel.setGraph(mainGraph);
        } else if (inputs != null && inputs.size() > 0) {
            EZEntityID input = (EZEntityID)inputs.get(0);
            this.fillGraphModel(input, monitor);
        }
        monitor.setWorkRemaining(0);
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
    }

    public List<ContributionItem> getMenuItems() {
        ArrayList<ContributionItem> menuItems = new ArrayList<ContributionItem>();
        menuItems.add((ContributionItem)new ActionContributionItem((IAction)this.fitAction));
        menuItems.add((ContributionItem)new Separator());
        menuItems.add((ContributionItem)new ActionContributionItem((IAction)this.select));
        menuItems.add((ContributionItem)new ActionContributionItem((IAction)this.pan));
        menuItems.add((ContributionItem)new ActionContributionItem((IAction)this.mzoom));
        menuItems.add((ContributionItem)new ActionContributionItem((IAction)this.izoom));
        menuItems.add((ContributionItem)new ActionContributionItem((IAction)this.nedges));
        this.contributeRedrawEntry(menuItems);
        this.contributeEdgesEntries(menuItems);
        return menuItems;
    }

    public List<ContributionItem> getToolBarItems() {
        ArrayList<ContributionItem> toolbars = new ArrayList<ContributionItem>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add((ContributionItem)new Separator());
        this.contributeRedrawEntry(toolbars);
        toolbars.add((ContributionItem)new Separator());
        toolbars.add((ContributionItem)new ActionContributionItem((IAction)this.fitAction));
        toolbars.add((ContributionItem)new Separator());
        toolbars.add((ContributionItem)new ActionContributionItem((IAction)this.select));
        toolbars.add((ContributionItem)new ActionContributionItem((IAction)this.pan));
        toolbars.add((ContributionItem)new ActionContributionItem((IAction)this.mzoom));
        toolbars.add((ContributionItem)new ActionContributionItem((IAction)this.izoom));
        toolbars.add((ContributionItem)new ActionContributionItem((IAction)this.nedges));
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        graph.setAttribute(layoutAttribute, (Object)false);
        TSGroupCommand cmd = new TSGroupCommand();
        Boolean firstTime = (Boolean)graph.getAttributeValue(layoutAttribute);
        if (firstTime != null || !firstTime.booleanValue()) {
            FlowChartRepairLayoutCommand repairLayout = new FlowChartRepairLayoutCommand((TSDGraph)graph);
            cmd.add((TSCommandInterface)repairLayout);
            graph.setAttribute(layoutAttribute, (Object)false);
        }
        return cmd;
    }

    private static void openMessageDialog(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)Messages.getString(FlowchartGraphJob.class, "dialogConnErrTitle"), (String)message);
            }
        });
    }

    public class GraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public GraphInfo(EZEntityID id) {
            super(id);
            SharedImages.registerImage("programFlowChart", "icons/programflowchart.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("programFlowChart");
            }
            return this.image;
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            List inputs = FlowchartGraphJob.this.analysis.getContextListValue("input_list");
            for (EZEntityID entity : inputs) {
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                buf.append(prgSg.getListableName());
                if (inputs.indexOf(entity) == inputs.size() - 1) continue;
                buf.append(", ");
            }
            String prjName = (String)FlowchartGraphJob.this.analysis.getContextValue("input_project_names");
            String label = Messages.getString(FlowchartGraphJob.class, "analysis.title", new String[]{buf.toString(), prjName});
            return label;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }
    }

    public class GraphMouseActionsHook
    extends GraphMouseActionsHookAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public List getRightClickContributions(TSENode tsNode) {
            boolean isDeadCode = (Boolean)(tsNode.getAttributeValue("IS_DEAD_CODE") != null ? tsNode.getAttributeValue("IS_DEAD_CODE") : Boolean.valueOf(false));
            if (isDeadCode) {
                return null;
            }
            return super.getRightClickContributions(tsNode);
        }

        public void makeSelection(TSENode node) {
            final String path = ((FlowchartGraphModel)this.graphModel).getSourcePath(node);
            if (path != null && !path.isEmpty()) {
                final int[] bounds = ((FlowchartGraphModel)this.graphModel).getTxtSelSg(node);
                final String editorId = Utils.getEditorId((String)FlowchartGraphJob.this.programType);
                final ProjectInfo pi = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Utils.openEditor((String)path, (int[])bounds, (String)editorId, (String)pi.getName());
                    }
                });
            }
        }

        public void makeSelection4Properties(TSENode node) {
        }
    }
}

