/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ProgramsCollector;
import com.ez.report.application.ui.collectors.ProgramsParamCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class FlowChartInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<EZEntityID> inputPrograms = null;
    private boolean hasAssemblerAncestors = false;

    public FlowChartInputsFilter(List<EZEntityID> inputPrograms, boolean hasAssemblerAncestors) {
        this.inputPrograms = inputPrograms;
        this.hasAssemblerAncestors = hasAssemblerAncestors;
    }

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            String wizardName = Messages.getString(FlowChartInputsFilter.class, "wizard.title");
            wizard.setWindowTitle(wizardName);
            String noResourceErrMsg = Messages.getString(FlowChartInputsFilter.class, "err.message");
            if (this.inputPrograms == null || this.inputPrograms != null && this.inputPrograms.size() > 1) {
                SingleSelectionPage selectProgramsPage = new SingleSelectionPage("single program page", true);
                selectProgramsPage.setTitle(Messages.getString(FlowChartInputsFilter.class, "page.title"));
                selectProgramsPage.setDescription(Messages.getString(FlowChartInputsFilter.class, "page.description"));
                selectProgramsPage.setErrMsgNoResource(noResourceErrMsg);
                if (this.inputPrograms == null) {
                    ProgramsCollector pc = new ProgramsCollector();
                    pc.setProgramsQuery(Utils.AVAILABLE_PROGRAMS_FORFLOWCHART_QUERY);
                    selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
                } else {
                    ArrayList<ProgramInput> availablePrograms = new ArrayList<ProgramInput>();
                    HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
                    for (EZEntityID entID : this.inputPrograms) {
                        EZSourceProgramIDSg ezProgSg = (EZSourceProgramIDSg)entID.getSegment(EZSourceProgramIDSg.class);
                        ProgramInput inpt = new ProgramInput(ezProgSg.getProgramName());
                        if (ezProgSg.getProgramId() != null) {
                            inpt.setProgramID(ezProgSg.getProgramId());
                        }
                        if (ezProgSg.getTypeId() != null) {
                            inpt.setType(ezProgSg.getTypeId());
                        }
                        availablePrograms.add(inpt);
                        availableTypesForFilters.add(inpt.getTypeCode());
                    }
                    wizard.set(selectProgramsPage.getAvailablePropName(), availablePrograms);
                    selectProgramsPage.setHasInputsAsSelected(true);
                    selectProgramsPage.setAvailableTypesForFilters(availableTypesForFilters);
                }
                wizard.addPage((IWizardPage)selectProgramsPage);
            }
            if (System.getProperty("test") != null) {
                SelectPathPage selectPathPage = new SelectPathPage("tests page");
                wizard.addPage((IWizardPage)selectPathPage);
            } else {
                SingleSelectionPage selectAssemblerPage = new SingleSelectionPage("single assembler program page", true);
                selectAssemblerPage.setTitle(Messages.getString(FlowChartInputsFilter.class, "ass.page.title"));
                selectAssemblerPage.setDescription(Messages.getString(FlowChartInputsFilter.class, "ass.page.description"));
                selectAssemblerPage.setLeftGroupLabel(Messages.getString(FlowChartInputsFilter.class, "av.object.type"));
                selectAssemblerPage.setRightGroupLabel(Messages.getString(FlowChartInputsFilter.class, "sel.object.type"));
                selectAssemblerPage.setErrMsgNoResource(noResourceErrMsg);
                ProgramsParamCollector asspc = new ProgramsParamCollector();
                if (this.inputPrograms != null && this.inputPrograms.size() == 1 || this.hasAssemblerAncestors) {
                    EZEntityID entID;
                    HashSet<String> ancestorProgramsName = new HashSet<String>();
                    entID = this.inputPrograms.get(0);
                    EZSourceProgramIDSg ezProgSg = (EZSourceProgramIDSg)entID.getSegment(EZSourceProgramIDSg.class);
                    ancestorProgramsName.add(ezProgSg.getProgramName());
                    asspc.setParameters(ancestorProgramsName);
                }
                asspc.setProgramsQuery(AbstractProjectInputsFilter.getASSEMBLER_SCL_CHILDREN_QUERY(null));
                asspc.completeTempTableName("string_param_temp", true);
                selectAssemblerPage.setResourcesCollector((ResourcesCollector)asspc);
                wizard.addPage((IWizardPage)selectAssemblerPage);
            }
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selectedAssChildren = wizard.getList("SELECTED_ASS_RESOURCES");
        List selected = System.getProperty("test") != null ? wizard.getList("available resources") : wizard.getList("selected resources");
        if (selected != null) {
            final HashSet<String> parents = new HashSet<String>();
            final ArrayList<ProgramInput> toComplete = new ArrayList<ProgramInput>();
            final ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo prjInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            final EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(prjInfo);
            for (ProgramInput pi : selected) {
                if (pi.getTypeCode() == 8) {
                    if (selectedAssChildren != null) continue;
                    parents.add(pi.getName());
                    toComplete.add(pi);
                    continue;
                }
                if (pi.getTypeCode() == 13) {
                    parents.add(pi.getName());
                    toComplete.add(pi);
                    continue;
                }
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(pi.getName(), pi.getProgramID(), pi.getTypeCode());
                if (pi.getAncestorName() != null) {
                    prgIdSg.setAncestorName(pi.getAncestorName());
                }
                entity.addSegment((EZSegment)prgIdSg);
                list.add(entity);
            }
            if (!parents.isEmpty()) {
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = service.getProjectHandler(prjIdSg.getProjectName(), null);
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        FlowChartInputsFilter.this.addAssemblerSCLChildren(conn, parents, toComplete, list, prjIdSg);
                    }
                }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
            analysis.addContextValue("input_list", list);
            analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
        }
    }
}

