/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.dataset;

import com.ez.graphs.dataset.TSENodeComparator;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.datasetflow.DatasetGraphBuilder;
import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DatasetGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DatasetGraphModel.class);
    private Map<String, Iterable<InfoData>> flowResults;
    private Collection<VSAMInput> inputNames;
    private ProjectInfo ezsourcePrj;
    boolean loadedOnce = false;

    public DatasetGraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public void setFlowResults(Map<String, Iterable<InfoData>> dsFlowResults) {
        this.flowResults = dsFlowResults;
    }

    public void setEZsourcePrj(ProjectInfo ezsourcePrj) {
        this.ezsourcePrj = ezsourcePrj;
    }

    public void loadGraph(IProgressMonitor pMonitor) {
        block7: {
            final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)100);
            this.initGraph();
            if (this.inputNames == null || this.inputNames.isEmpty()) {
                this.graphManager.setNodeBuilder((TSNodeBuilder)((AnalysisGraphManager)this.graphManager).makeNodeBuilder());
                TSENode node = (TSENode)this.graph.addNode();
                node.setName((Object)Messages.getString(DatasetGraphModel.class, "noresults.node.name"));
                L.debug("empty dataflow model");
            } else {
                Runnable stopCode = new Runnable(){

                    @Override
                    public void run() {
                        if (monitor.isCanceled()) {
                            throw new CanceledException("DatasetFlow graph was canceled");
                        }
                    }
                };
                DatasetGraphBuilder graphBuilder = new DatasetGraphBuilder(stopCode, this.graphManager);
                try {
                    boolean hasGraph = graphBuilder.fillTSGraph(this.inputNames, this.flowResults, this.graph, this.outForGISV, (IProgressMonitor)monitor.newChild(100));
                    if (!hasGraph) {
                        L.debug("no dataset flow graph for inputNames: {}", this.inputNames);
                    } else if (this.flowResults != null) {
                        this.flowResults.clear();
                        this.flowResults = null;
                    }
                }
                catch (CanceledException canceledException) {
                    LogUtil.displayErrorMessage(null, (String)Messages.getString(DatasetGraphModel.class, "graph.canceled.errorlog.message"), (String)"", (Plugin)Activator.getDefault(), (boolean)false);
                    L.info("Datasetflow graph was canceled by user");
                    if (this.flowResults == null) break block7;
                    this.flowResults.clear();
                    this.flowResults = null;
                }
            }
        }
        this.loadedOnce = true;
    }

    private void initGraph() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZEntityID id;
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT") && (id = (objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT")).getEntID()) != null && id.getSegment(EZSourceProjectIDSg.class) == null) {
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.ezsourcePrj));
            entity.addEntitySegments(id);
            objType.setEntID(entity);
        }
        return objType;
    }

    public void setInputNames(Collection<VSAMInput> inputs) {
        this.inputNames = inputs;
    }

    void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        block9: {
            String newLine = System.getProperty("line.separator");
            String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block9;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (!stmtType.equals("")) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

