/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.dataset;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.dataset.DatasetFlowGraphMouseActionsHook;
import com.ez.graphs.dataset.DatasetGraphModel;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.datasetflow.DSFlowEdgeLegendInfo;
import com.ez.mainframe.gui.datasetflow.DSFlowNodeLegendInfo;
import com.ez.mainframe.gui.datasetflow.DatasetFlow;
import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DatasetFlowGraphJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DatasetFlowGraphJob.class);
    private DatasetFlowGraphMouseActionsHook mouseActionsHook;
    private String tabName;
    private static final int MAXNAMES = 10;
    private int limit = -1;

    public DatasetFlowGraphJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new DatasetFlowGraphMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new DatasetFlowGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new DatasetGraphModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor pmonitor) {
        L.debug("compute results");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ProjectInfo prjInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        try {
            List old = this.analysis.getContextListValue("selected resources");
            List inputs = BaseResourceInput4GUI.extractNonGUIObjects((Collection)old);
            this.analysis.addContextValue("selected resources", (Object)inputs);
            if (((DatasetGraphModel)graphModel).loadedOnce) {
                this.recheckInputs(prjInfo.getName(), inputs, (IProgressMonitor)monitor.newChild(5));
            }
            ((DatasetGraphModel)graphModel).setInputNames(inputs);
            ((DatasetGraphModel)graphModel).setEZsourcePrj(prjInfo);
            if (inputs != null && !inputs.isEmpty()) {
                Object path;
                Direction direction = (Direction)this.analysis.getContextValue("directed");
                Integer limitObj = (Integer)this.analysis.getContextValue("datasetflow threshold");
                if (limitObj != null) {
                    this.limit = limitObj;
                }
                List excluded = this.analysis.getContextListValue("excluded datasets");
                List excludedInpts = null;
                if (excluded != null) {
                    excludedInpts = BaseResourceInput4GUI.extractNonGUIObjects((Collection)excluded);
                    this.analysis.addContextValue("excluded datasets", (Object)excludedInpts);
                }
                if ((path = this.analysis.getContextValue("selected path")) != null && !path.toString().trim().equals("")) {
                    TSEGraph mainGraph = graphModel.getGraph();
                    for (VSAMInput stepInput : inputs) {
                        ArrayList<VSAMInput> inputList = new ArrayList<VSAMInput>();
                        inputList.add(stepInput);
                        Map<String, Iterable<InfoData>> dsFlowResults = this.doDatabaseAccess(prjInfo.getName(), direction, this.limit, excludedInpts, inputList, (IProgressMonitor)monitor.newChild(40));
                        if (!monitor.isCanceled()) {
                            ((DatasetGraphModel)graphModel).setFlowResults(dsFlowResults);
                            ((DatasetGraphModel)graphModel).setInputNames(inputList);
                            graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                            TSEGraph newGraph = graphModel.getGraph();
                            ((DatasetGraphModel)graphModel).writeGraphToFile(newGraph, stepInput.getName(), path.toString());
                            newGraph.dispose();
                            continue;
                        }
                        if (dsFlowResults == null) continue;
                        dsFlowResults.clear();
                        dsFlowResults = null;
                    }
                    graphModel.setGraph(mainGraph);
                } else {
                    Map<String, Iterable<InfoData>> dsFlowResults = this.doDatabaseAccess(prjInfo.getName(), direction, this.limit, excludedInpts, inputs, (IProgressMonitor)monitor.newChild(40));
                    if (!monitor.isCanceled()) {
                        ((DatasetGraphModel)graphModel).setFlowResults(dsFlowResults);
                    } else if (dsFlowResults != null) {
                        dsFlowResults.clear();
                        dsFlowResults = null;
                    }
                }
            }
        }
        catch (Throwable t) {
            L.error("while generating DatasetFlow graph", t);
            LogUtil.displayErrorMessage((Throwable)t, (String)Messages.getString(DatasetFlowGraphJob.class, "errorlog.generating.errormessage"), (String)Messages.getString(DatasetFlowGraphJob.class, "errorlog.generating.errortitle"), (Plugin)Activator.getDefault(), (boolean)true);
        }
        monitor.setWorkRemaining(0);
    }

    private void recheckInputs(String projectName, final List<VSAMInput> inputs, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(projectName, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                    Collection res = DatasetFlow.checkInputs((EZSourceConnection)conn, (List)inputs);
                    if (res == null) {
                        inputs.clear();
                    } else {
                        HashSet<VSAMInput> toRem = new HashSet<VSAMInput>();
                        for (VSAMInput inp : inputs) {
                            if (res.contains(inp)) continue;
                            toRem.add(inp);
                        }
                        inputs.removeAll(toRem);
                    }
                }
            }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException e) {
            L.error("", (Throwable)e);
        }
        catch (Exception e) {
            L.error("", (Throwable)e);
        }
    }

    private Map<String, Iterable<InfoData>> doDatabaseAccess(String projectName, final Direction direction, final int limit, final List<VSAMInput> excluded, final List<VSAMInput> inputs, IProgressMonitor pmonitor) {
        final DatasetFlow[] dsFlow = new DatasetFlow[1];
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(projectName, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                    dsFlow[0] = new DatasetFlow(direction);
                    dsFlow[0].setLimit(limit);
                    dsFlow[0].setInputs(inputs);
                    dsFlow[0].setExcludes(excluded);
                    dsFlow[0].find(conn, monitor);
                }
            }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException e) {
            L.error("", (Throwable)e);
        }
        catch (Exception e) {
            L.error("", (Throwable)e);
        }
        return dsFlow[0] != null ? dsFlow[0].getResults() : new HashMap();
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
    }

    private void addEntriesToLegend(LegendPanel legend) {
        Utils.setImageProvider((LegendPanel)legend);
        this.addNodesToLegend(legend);
        this.addEdgesToLegend(legend);
    }

    private void addNodesToLegend(LegendPanel legend) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<DSFlowNodeLegendInfo>(){

            @Override
            public int compare(DSFlowNodeLegendInfo nodeType1, DSFlowNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (DSFlowNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            legend.placeLegendEntry(nodeLegendInfo.getColorboxImagePath(), nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<DSFlowEdgeLegendInfo>(){

            @Override
            public int compare(DSFlowEdgeLegendInfo edgeType1, DSFlowEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (DSFlowEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    public class DatasetFlowGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public DatasetFlowGraphInfo(EZEntityID id) {
            super(id);
            SharedImages.registerImage("datasetFlow", "icons/datasetflow.png");
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("datasetFlow");
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            StringBuilder inputsText = new StringBuilder();
            String inputsTextMore = "";
            List inputs = DatasetFlowGraphJob.this.analysis.getContextListValue("input_list");
            int idx = 0;
            int all = inputs.size();
            for (EZEntityID entity : inputs) {
                if (truncate && idx >= 10) {
                    inputsTextMore = String.valueOf(inputsTextMore) + (all - idx);
                    break;
                }
                ++idx;
                EZSourceDatasetIDSg datasetSg = (EZSourceDatasetIDSg)entity.getSegment(EZSourceDatasetIDSg.class);
                inputsText.append(datasetSg.getDatasetName());
                if (datasetSg.getDatasetMemberName() != null && !datasetSg.getDatasetMemberName().isEmpty()) {
                    inputsText.append("(");
                    inputsText.append(datasetSg.getDatasetMemberName());
                    inputsText.append(")");
                }
                if (inputs.indexOf(entity) == inputs.size() - 1) continue;
                inputsText.append(", ");
            }
            if (inputsTextMore.isEmpty()) {
                DatasetFlowGraphJob.this.tabName = Messages.getString(DatasetFlowGraphJob.class, "tabName", new String[]{inputsText.toString(), DatasetFlowGraphJob.this.analysis.getContextValue("input_project_names").toString()});
            } else {
                DatasetFlowGraphJob.this.tabName = Messages.getString(DatasetFlowGraphJob.class, "tabName.more", new String[]{inputsText.toString(), inputsTextMore, DatasetFlowGraphJob.this.analysis.getContextValue("input_project_names").toString()});
            }
            return DatasetFlowGraphJob.this.tabName;
        }

        public String getTooltip() {
            StringBuilder tooltipText = new StringBuilder(DatasetFlowGraphJob.this.tabName);
            Direction direction = (Direction)DatasetFlowGraphJob.this.analysis.getContextValue("directed");
            if (DatasetFlowGraphJob.this.limit != -1) {
                if (direction != null) {
                    tooltipText.append(Messages.getString(DatasetFlowGraphJob.class, "tooltip", new String[]{direction.toString(), String.valueOf(DatasetFlowGraphJob.this.limit)}));
                } else {
                    tooltipText.append(Messages.getString(DatasetFlowGraphJob.class, "tooltip.null.direction", new String[]{String.valueOf(DatasetFlowGraphJob.this.limit)}));
                }
            } else if (direction != null) {
                tooltipText.append(Messages.getString(DatasetFlowGraphJob.class, "tooltip.negative.limit", new String[]{direction.toString()}));
            }
            return tooltipText.toString();
        }

        public boolean hasLegend() {
            return true;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){
                private LegendPanel legend;

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    this.legend = new LegendPanel((Composite)sc, 0);
                    DatasetFlowGraphJob.this.addEntriesToLegend(this.legend);
                    sc.setContent((Control)this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    this.legend.pack();
                    sc.setMinSize(this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = this.legend.getSize().x;
                    int x = this.legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }
    }
}

