/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph.transactioncallgraph;

import com.ez.graphs.callgraph.transactioncallgraph.TransactionCollector;
import com.ez.graphs.callgraph.transactioncallgraph.TransactionInput;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TransactionCallgraphInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TransactionCallgraphInputsFilter.class);

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(TransactionCallgraphInputsFilter.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        String title = Messages.getString(TransactionCallgraphInputsFilter.class, "page.title");
        String description = Messages.getString(TransactionCallgraphInputsFilter.class, "page.description");
        InputsWithSettingsPage selectProgramsPage = new InputsWithSettingsPage("programs page", true, true);
        selectProgramsPage.setTitle(title);
        selectProgramsPage.setDescription(description);
        selectProgramsPage.setLeftGroupLabel(Messages.getString(TransactionCallgraphInputsFilter.class, "av.object.type"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(TransactionCallgraphInputsFilter.class, "sel.object.type"));
        selectProgramsPage.setErrMsgNoResource(Messages.getString(TransactionCallgraphInputsFilter.class, "err.message"));
        TransactionCollector sc = new TransactionCollector();
        sc.setResourcesQuery("EZReports_TransactionCallgraph");
        selectProgramsPage.setResourcesCollector((ResourcesCollector)sc);
        wizard.addPage((IWizardPage)selectProgramsPage);
        if (System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo projectName = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(projectName);
            HashMap<String, EZSourceTransactionIDSg> transactionsMap = new HashMap<String, EZSourceTransactionIDSg>();
            for (BaseMainframeResource4GUI inpt : selected) {
                TransactionInput si = (TransactionInput)inpt.getObject();
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                String transactionName = si.getName();
                EZSourceTransactionIDSg trIdSg = new EZSourceTransactionIDSg(transactionName);
                entity.addSegment((EZSegment)trIdSg);
                list.add(entity);
                transactionsMap.put(transactionName, trIdSg);
            }
            analysis.addContextValue("input_list", list);
            analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
            this.computeRelatedPrograms(analysis, prjIdSg.getProjectName(), transactionsMap);
        }
    }

    protected void computeRelatedPrograms(AbstractAnalysis analysis, String prjName, Map<String, EZSourceTransactionIDSg> transactionsMap) throws Exception {
        String[][] ret = com.ez.cobol.callgraph.utils.Utils.searchAfterMappedProgram((String)prjName, transactionsMap.keySet());
        if (ret == null) {
            L.debug("no results for inputs: " + transactionsMap.keySet());
            return;
        }
        String[][] stringArray = ret;
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            EZSourceTransactionIDSg trIdSg;
            String[] result = stringArray[n2];
            String resourceName = result[0];
            String programName = result[3];
            Integer programId = Integer.valueOf(result[2]);
            Integer typeId = Integer.valueOf(result[4]);
            String ancestorName = result[5];
            Integer isProgramMapped = Integer.valueOf(result[7]);
            Integer occurId = Integer.valueOf(result[6]);
            EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(programName, programId, typeId, Boolean.valueOf(occurId > 0));
            if (Utils.filterNullValue((String)ancestorName) != null) {
                prgIdSg.setAncestorName(ancestorName);
            }
            if ((trIdSg = transactionsMap.get(resourceName)) != null) {
                trIdSg.addRelatedProgramDetails(prgIdSg, Boolean.valueOf(isProgramMapped == 0));
            } else {
                L.warn("not found transaction id segment for " + resourceName);
            }
            ++n2;
        }
    }
}

