/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph.screencallgraph;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.callgraph.screencallgraph.ScreenCallGraphAnalysis;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ScreenInput;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.collectors.ScreenCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScreenCallgraphInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ScreenCallgraphInputsFilter.class);

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(ScreenCallGraphAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        String title = Messages.getString(ScreenCallGraphAnalysis.class, "page.title");
        String description = Messages.getString(ScreenCallGraphAnalysis.class, "page.description");
        InputsWithSettingsPage selectProgramsPage = new InputsWithSettingsPage("programs page", true, true);
        selectProgramsPage.setAvailablePropName(description);
        selectProgramsPage.setTitle(title);
        selectProgramsPage.setLeftGroupLabel(Messages.getString(ScreenCallGraphAnalysis.class, "av.object.type"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(ScreenCallGraphAnalysis.class, "sel.object.type"));
        selectProgramsPage.setErrMsgNoResource(Messages.getString(ScreenCallGraphAnalysis.class, "err.message"));
        ScreenCollector sc = new ScreenCollector(false);
        sc.setQueryName("EZReports_ScreenFlow_ADS_BMS_NATURAL");
        selectProgramsPage.setResourcesCollector((ResourcesCollector)sc);
        wizard.addPage((IWizardPage)selectProgramsPage);
        if (System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo projectName = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(projectName);
            for (ScreenInput si : selected) {
                EZEntityID entity = new EZEntityID();
                EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(si.getResourceID(), si.getScreenName(), si.getType(), si.getOccurID());
                scrIdSg.setMapSet(si.getMapSet());
                entity.addSegment((EZSegment)prjIdSg);
                entity.addSegment((EZSegment)scrIdSg);
                list.add(entity);
            }
            analysis.addContextValue("input_list", list);
            analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
            this.computeRelatedPrograms(analysis);
        }
    }

    protected void computeRelatedPrograms(AbstractAnalysis analysis) throws Exception {
        ProjectInfo projectInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
        String prjName = projectInfo.getName();
        List inputs = analysis.getContextListValue("input_list");
        final HashMap<Integer, EZSourceScreenIDSg> bmsScreens = new HashMap<Integer, EZSourceScreenIDSg>();
        final HashMap<Integer, EZSourceScreenIDSg> adsScreens = new HashMap<Integer, EZSourceScreenIDSg>();
        final HashMap<Integer, EZSourceScreenIDSg> natScreens = new HashMap<Integer, EZSourceScreenIDSg>();
        final HashMap<Integer, EZSourceScreenIDSg> smartScreens = new HashMap<Integer, EZSourceScreenIDSg>();
        final HashMap<Integer, EZSourceScreenIDSg> tpmsxScreens = new HashMap<Integer, EZSourceScreenIDSg>();
        for (Object inpObj : inputs) {
            EZEntityID input = (EZEntityID)inpObj;
            EZSourceScreenIDSg scrIdSg = (EZSourceScreenIDSg)input.getSegment(EZSourceScreenIDSg.class);
            int scrType = scrIdSg.getScreenType();
            switch (scrType) {
                case 118: {
                    adsScreens.put(scrIdSg.getMapID(), scrIdSg);
                    break;
                }
                case 119: {
                    bmsScreens.put(scrIdSg.getMapID(), scrIdSg);
                    break;
                }
                case 120: {
                    natScreens.put(scrIdSg.getMapID(), scrIdSg);
                    break;
                }
                case 121: {
                    smartScreens.put(scrIdSg.getMapID(), scrIdSg);
                    break;
                }
                case 101: {
                    tpmsxScreens.put(scrIdSg.getMapID(), scrIdSg);
                }
            }
        }
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(prjName, null);
        ph.executeWithLock(ph, new IMFRunnable(){

            public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                ScreenCallgraphInputsFilter.this.screenToPrgProcedures(conn, bmsScreens, adsScreens, natScreens, smartScreens, tpmsxScreens);
            }
        }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
    }

    private void screenToPrgProcedures(EZSourceConnection conn, Map<Integer, EZSourceScreenIDSg> bmsScreens, Map<Integer, EZSourceScreenIDSg> adsScreens, Map<Integer, EZSourceScreenIDSg> natScreens, Map<Integer, EZSourceScreenIDSg> smartScreens, Map<Integer, EZSourceScreenIDSg> tpmsxScreens) {
        EZSourceScreenIDSg scrSg;
        EZSourceProgramIDSg prgIdSg;
        Integer typeId;
        Integer programId;
        int n;
        int n2;
        String[][] stringArray;
        if (!bmsScreens.isEmpty()) {
            L.debug("bms Screens not empty");
            String[][] bmsResult = Utils.runProc((EZSourceConnection)conn, (String)"EZReports_ScreenFlow_BMS_Selective", bmsScreens.keySet(), (EZSourceDataType)EZSourceDataType.Integer);
            if (bmsResult != null && bmsResult.length > 0) {
                stringArray = bmsResult;
                n2 = bmsResult.length;
                n = 0;
                while (n < n2) {
                    String[] bms = stringArray[n];
                    programId = Integer.valueOf(bms[1]);
                    typeId = Integer.valueOf(bms[3]);
                    prgIdSg = new EZSourceProgramIDSg(bms[2], programId, typeId);
                    scrSg = bmsScreens.get(Integer.valueOf(bms[6]));
                    if (scrSg != null) {
                        scrSg.addProgram(prgIdSg);
                    } else {
                        L.warn("there is not bms corresponding screen for " + bms[2]);
                    }
                    ++n;
                }
            }
        }
        if (!adsScreens.isEmpty()) {
            L.debug("ads Screens not empty");
            String[][] adsResult = Utils.runProc((EZSourceConnection)conn, (String)"EZReports_ScreenFlow_ADS_Selective", adsScreens.keySet(), (EZSourceDataType)EZSourceDataType.Integer);
            if (adsResult != null && adsResult.length > 0) {
                stringArray = adsResult;
                n2 = adsResult.length;
                n = 0;
                while (n < n2) {
                    String[] ads = stringArray[n];
                    programId = Integer.valueOf(ads[1]);
                    typeId = Integer.valueOf(ads[3]);
                    prgIdSg = new EZSourceProgramIDSg(ads[2], programId, typeId);
                    scrSg = adsScreens.get(Integer.valueOf(ads[5]));
                    if (scrSg != null) {
                        scrSg.addProgram(prgIdSg);
                    } else {
                        L.warn("there is not corresponding ads screen for " + ads[2]);
                    }
                    ++n;
                }
            }
        }
        if (!natScreens.isEmpty()) {
            L.debug("natural Screens not empty");
            String[][] naturalResult = Utils.runProc((EZSourceConnection)conn, (String)"EZReports_ScreenFlow_NATURAL_Selective", natScreens.keySet(), (EZSourceDataType)EZSourceDataType.Integer);
            if (naturalResult != null && naturalResult.length > 0) {
                stringArray = naturalResult;
                n2 = naturalResult.length;
                n = 0;
                while (n < n2) {
                    String[] nat = stringArray[n];
                    programId = Integer.valueOf(nat[1]);
                    typeId = Integer.valueOf(nat[3]);
                    prgIdSg = new EZSourceProgramIDSg(nat[2], programId, typeId);
                    scrSg = natScreens.get(Integer.valueOf(nat[6]));
                    if (scrSg != null) {
                        scrSg.addProgram(prgIdSg);
                    } else {
                        L.warn("there is not corresponding natural screen for " + nat[2]);
                    }
                    ++n;
                }
            }
        }
        if (!smartScreens.isEmpty()) {
            L.debug("smart Screens not empty");
            String[][] smartResult = Utils.runProc((EZSourceConnection)conn, (String)"EZReports_ScreenFlow_SMART_Selective", smartScreens.keySet(), (EZSourceDataType)EZSourceDataType.Integer);
            if (smartResult != null && smartResult.length > 0) {
                stringArray = smartResult;
                n2 = smartResult.length;
                n = 0;
                while (n < n2) {
                    String[] smart = stringArray[n];
                    programId = Integer.valueOf(smart[1]);
                    typeId = Integer.valueOf(smart[3]);
                    prgIdSg = new EZSourceProgramIDSg(smart[2], programId, typeId);
                    scrSg = smartScreens.get(Integer.valueOf(smart[5]));
                    if (scrSg != null) {
                        scrSg.addProgram(prgIdSg);
                    } else {
                        L.warn("there is not corresponding smart screen for " + smart[2]);
                    }
                    ++n;
                }
            }
        }
        if (!tpmsxScreens.isEmpty()) {
            L.debug("TPMSX Screens not empty");
            String[][] tpmsxtResult = Utils.runProc((EZSourceConnection)conn, (String)"EZReports_ScreenFlow_TPMSX_Selective", tpmsxScreens.keySet(), (EZSourceDataType)EZSourceDataType.Integer);
            if (tpmsxtResult != null && tpmsxtResult.length > 0) {
                stringArray = tpmsxtResult;
                n2 = tpmsxtResult.length;
                n = 0;
                while (n < n2) {
                    String[] tpmsx = stringArray[n];
                    programId = Integer.valueOf(tpmsx[1]);
                    typeId = Integer.valueOf(tpmsx[3]);
                    prgIdSg = new EZSourceProgramIDSg(tpmsx[2], programId, typeId);
                    scrSg = tpmsxScreens.get(Integer.valueOf(tpmsx[4]));
                    if (scrSg != null) {
                        scrSg.addProgram(prgIdSg);
                    } else {
                        L.warn("there is not corresponding TPMSX screen for " + tpmsx[2]);
                    }
                    ++n;
                }
            }
        }
    }
}

