/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph.programcallgraph;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ProgramsCollector;
import com.ez.report.application.ui.collectors.ProgramsParamCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

@Deprecated
public class PrgCallgraphInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<EZEntityID> inputPrograms = null;

    public PrgCallgraphInputsFilter(List<EZEntityID> inputPrograms) {
        this.inputPrograms = inputPrograms;
    }

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            String wizardName = Messages.getString(PrgCallgraphInputsFilter.class, "wizzard.title");
            wizard.setWindowTitle(wizardName);
            InputsWithSettingsPage selectProgramsPage = new InputsWithSettingsPage("programs for callgraph page", true, true);
            if (this.inputPrograms != null) {
                ArrayList<BaseMainframeResource4GUI> selectedPrograms = new ArrayList<BaseMainframeResource4GUI>();
                HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
                for (EZEntityID entID : this.inputPrograms) {
                    EZSourceProgramIDSg ezProgSg = (EZSourceProgramIDSg)entID.getSegment(EZSourceProgramIDSg.class);
                    ProgramInput inpt = new ProgramInput(ezProgSg.getProgramName());
                    if (ezProgSg.getProgramId() != null) {
                        inpt.setProgramID(ezProgSg.getProgramId());
                    }
                    if (ezProgSg.getTypeId() != null) {
                        inpt.setType(ezProgSg.getTypeId());
                    }
                    selectedPrograms.add(new BaseMainframeResource4GUI((BaseResourceInput)inpt));
                    availableTypesForFilters.add(inpt.getTypeCode());
                }
                wizard.set(selectProgramsPage.getAvailablePropName(), selectedPrograms);
                wizard.set(selectProgramsPage.getSelectedPropName(), selectedPrograms);
                selectProgramsPage.setHasInputsAsSelected(true);
                selectProgramsPage.setAvailableTypesForFilters(availableTypesForFilters);
            } else {
                ProgramsCollector pc = new ProgramsCollector();
                pc.setProgramsQuery("SELECT ProgramName, ProgramTypeID, ProgramID FROM Programs where ProgramTypeID in (1, 2, 3, 7, 8, 10, 11, 13) order by ProgramName");
                selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
            }
            selectProgramsPage.setTitle(Messages.getString(PrgCallgraphInputsFilter.class, "page.title"));
            selectProgramsPage.setDescription(Messages.getString(PrgCallgraphInputsFilter.class, "page.description"));
            selectProgramsPage.setErrMsgNoResource(Messages.getString(PrgCallgraphInputsFilter.class, "err.message"));
            wizard.addPage((IWizardPage)selectProgramsPage);
            if (System.getProperty("test") != null) {
                SelectPathPage selectPathPage = new SelectPathPage("tests page");
                wizard.addPage((IWizardPage)selectPathPage);
            } else {
                SelectProgramsPage selectAssemblerPage = new SelectProgramsPage("ass children page", true, false);
                selectAssemblerPage.setSelectedPropName("SELECTED_ASS_RESOURCES");
                selectAssemblerPage.setAvailablePropName("AVAILABLE_ASS_RESOURCES");
                ProgramsParamCollector asspc = new ProgramsParamCollector();
                asspc.setProgramsQuery(AbstractProjectInputsFilter.getASSEMBLER_SCL_CHILDREN_QUERY(null));
                asspc.completeTempTableName("string_param_temp", true);
                selectAssemblerPage.setResourcesCollector((ResourcesCollector)asspc);
                selectAssemblerPage.setTitle(Messages.getString(PrgCallgraphInputsFilter.class, "ass.page.title"));
                selectAssemblerPage.setDescription(Messages.getString(PrgCallgraphInputsFilter.class, "ass.page.description"));
                selectAssemblerPage.setLeftGroupLabel(Messages.getString(PrgCallgraphInputsFilter.class, "av.object.type"));
                selectAssemblerPage.setRightGroupLabel(Messages.getString(PrgCallgraphInputsFilter.class, "sel.object.type"));
                selectAssemblerPage.setErrMsgNoResource(Messages.getString(PrgCallgraphInputsFilter.class, "err.message"));
                wizard.addPage((IWizardPage)selectAssemblerPage);
            }
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selectedAssChildren = wizard.getList("SELECTED_ASS_RESOURCES");
        final ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        ProjectInfo prjInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
        final EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(prjInfo);
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            final HashSet<String> parents = new HashSet<String>();
            final ArrayList<ProgramInput> toComplete = new ArrayList<ProgramInput>();
            for (Object o : selected) {
                ProgramInput pi = null;
                pi = o instanceof BaseMainframeResource4GUI ? (ProgramInput)((BaseMainframeResource4GUI)o).getObject() : (ProgramInput)o;
                if (pi.getTypeCode() == 8) {
                    if (selectedAssChildren != null) continue;
                    parents.add(pi.getName());
                    toComplete.add(pi);
                    continue;
                }
                if (pi.getTypeCode() == 13) {
                    parents.add(pi.getName());
                    toComplete.add(pi);
                    continue;
                }
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(pi.getName(), pi.getProgramID(), pi.getTypeCode());
                entity.addSegment((EZSegment)prgIdSg);
                list.add(entity);
            }
            if (!parents.isEmpty()) {
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = service.getProjectHandler(prjIdSg.getProjectName(), null);
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        PrgCallgraphInputsFilter.this.addAssemblerSCLChildren(conn, parents, toComplete, list, prjIdSg);
                    }
                }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        if (selectedAssChildren != null) {
            for (Object o : selectedAssChildren) {
                ProgramInput pi = null;
                pi = o instanceof BaseMainframeResource4GUI ? (ProgramInput)((BaseMainframeResource4GUI)o).getObject() : (ProgramInput)o;
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(pi.getName(), pi.getProgramID(), pi.getTypeCode());
                if (pi.getAncestorName() != null) {
                    prgIdSg.setAncestorName(pi.getAncestorName());
                }
                entity.addSegment((EZSegment)prgIdSg);
                list.add(entity);
            }
        }
        analysis.addContextValue("input_list", list);
        analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
    }
}

