/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;

public class R2DSMouseActionsHook
extends MainframeMouseActionsHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private GraphAnalysisJob job = null;
    private GraphAnalysisJob.ExpandAction expandAction = null;
    private GraphAnalysisJob.CollapseAction collapseAction = null;
    private GraphAnalysisJob.ExpandAllAction expandAllApps = null;
    private GraphAnalysisJob.CollapseAllAction collapseAllApps = null;

    public R2DSMouseActionsHook(EZEntityID entityId, GraphAnalysisJob job) {
        super(entityId);
        this.job = job;
    }

    public List getRightClickContributions(TSENode node) {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        if (node != null && node.hasAttribute("is ts node for project") && !node.isExpanded()) {
            if (this.expandAction == null) {
                this.expandAction = new GraphAnalysisJob.ExpandAction(this.job);
            }
            this.expandAction.setChecked(false);
            this.expandAction.setNodeToExpand(node);
            String expandLabel = Messages.getString(R2DSMouseActionsHook.class, "expand.text", new String[]{node.getText()});
            this.expandAction.setText(expandLabel);
            this.expandAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.expandAction));
        }
        if (node != null && node.hasAttribute("is ts node for project") && node.isExpanded()) {
            if (this.collapseAction == null) {
                this.collapseAction = new GraphAnalysisJob.CollapseAction(this.job);
            }
            this.collapseAction.setChecked(false);
            this.collapseAction.overview = (TSEOverviewComponent)this.graphInfo.getOverviewComponent();
            String name = (String)node.getAttributeValue("project name key");
            this.collapseAction.toCollapseNode = node;
            String collapseLabel = Messages.getString(R2DSMouseActionsHook.class, "collapse.text", new String[]{name});
            this.collapseAction.setText(collapseLabel);
            this.collapseAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
        }
        contextItems.add(new Separator());
        contextItems.addAll(super.getRightClickContributions(node));
        return contextItems;
    }

    public List getRightClickContributions() {
        ArrayList<ActionContributionItem> contextItems = new ArrayList<ActionContributionItem>();
        if (this.expandAllApps == null) {
            this.expandAllApps = new GraphAnalysisJob.ExpandAllAction(this.job);
        }
        this.expandAllApps.setChecked(false);
        String expandLabel = Messages.getString(R2DSMouseActionsHook.class, "expand.all.text");
        this.expandAllApps.setText(expandLabel);
        this.expandAllApps.setEnabled(TSNestingManager.hasCollapsedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        contextItems.add(new ActionContributionItem((IAction)this.expandAllApps));
        if (this.collapseAllApps == null) {
            this.collapseAllApps = new GraphAnalysisJob.CollapseAllAction(this.job);
        }
        this.collapseAllApps.setChecked(false);
        String collaspseLabel = Messages.getString(R2DSMouseActionsHook.class, "collapse.all.text");
        this.collapseAllApps.setText(collaspseLabel);
        this.collapseAllApps.setEnabled(TSNestingManager.hasExpandedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        contextItems.add(new ActionContributionItem((IAction)this.collapseAllApps));
        contextItems.addAll(super.getRightClickContributions());
        return contextItems;
    }

    public void dispose() {
        if (this.expandAction != null) {
            this.expandAction.dispose();
            this.expandAction = null;
        }
        if (this.collapseAction != null) {
            this.collapseAction.dispose();
            this.collapseAction = null;
        }
        if (this.expandAllApps != null) {
            this.expandAllApps.dispose();
            this.expandAllApps = null;
        }
        if (this.collapseAllApps != null) {
            this.collapseAllApps.dispose();
            this.collapseAllApps = null;
        }
        super.dispose();
    }
}

