/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.callgraph;

import com.ez.cobol.callgraph.CallGraphBuilder;
import com.ez.cobol.callgraph.CallGraphModel;
import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.nodes.ADSDialogProgramNode;
import com.ez.cobol.callgraph.nodes.ADSProcessProgramNode;
import com.ez.cobol.callgraph.nodes.AdabasNode;
import com.ez.cobol.callgraph.nodes.AdsMapNode;
import com.ez.cobol.callgraph.nodes.AlgolProgramNode;
import com.ez.cobol.callgraph.nodes.AsmCsectProgramNode;
import com.ez.cobol.callgraph.nodes.AsmEntryProgramNode;
import com.ez.cobol.callgraph.nodes.AssemblerProgramNode;
import com.ez.cobol.callgraph.nodes.CLFileNode;
import com.ez.cobol.callgraph.nodes.CLProgramNode;
import com.ez.cobol.callgraph.nodes.CobolProgramNode;
import com.ez.cobol.callgraph.nodes.DALFileNode;
import com.ez.cobol.callgraph.nodes.DBFileNode;
import com.ez.cobol.callgraph.nodes.DBINode;
import com.ez.cobol.callgraph.nodes.EZRexxProgramNode;
import com.ez.cobol.callgraph.nodes.FortranProgramNode;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.IdmsRecordNode;
import com.ez.cobol.callgraph.nodes.IdmsSetNode;
import com.ez.cobol.callgraph.nodes.JCLJobNode;
import com.ez.cobol.callgraph.nodes.JCLPgmNode;
import com.ez.cobol.callgraph.nodes.NaturalMapNode;
import com.ez.cobol.callgraph.nodes.NaturalProgramNode;
import com.ez.cobol.callgraph.nodes.PLIProgramNode;
import com.ez.cobol.callgraph.nodes.PrinterFileNode;
import com.ez.cobol.callgraph.nodes.QueueManagerNode;
import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.cobol.callgraph.nodes.ResourceDatacomTableNode;
import com.ez.cobol.callgraph.nodes.ResourceFileNode;
import com.ez.cobol.callgraph.nodes.ResourceSQLTableNode;
import com.ez.cobol.callgraph.nodes.SCLProgramNode;
import com.ez.cobol.callgraph.nodes.ScreenNode;
import com.ez.cobol.callgraph.nodes.SmartDbModuleProgramNode;
import com.ez.cobol.callgraph.nodes.SmartScreenNode;
import com.ez.cobol.callgraph.nodes.SmartSubroutineNode;
import com.ez.cobol.callgraph.nodes.TPMSXMapNode;
import com.ez.cobol.callgraph.nodes.TerminalNode;
import com.ez.cobol.callgraph.nodes.TerminalOrTransactionNode;
import com.ez.cobol.callgraph.nodes.TransactionNode;
import com.ez.cobol.callgraph.nodes.UnknownProgramNode;
import com.ez.cobol.callgraph.utils.R2DSUtils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.graphs.callgraph.R2DSMouseActionsHook;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.data.callgraph.GraphNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.ExportAsCSV;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CallGraphJob
extends AnnotatedGraphJob
implements IMFRunnable {
    private static final Logger L = LoggerFactory.getLogger(CallGraphJob.class);
    private static final String EZREP_PROCEDURE_22 = "EZReports_JobFlowReport_q2_2";
    private static final String EZREP_PROCEDURE_4 = "EZReports_JobFlowReport_q4";
    public static final String ANALYSIS_SCREEN_KEY = "SCREEN_CALLGRAPH";
    public static final String ANALYSIS_JOB_KEY = "JOB_CALLGRAPH";
    public static final String ANALYSIS_PROGRAM_KEY = "PROGRAM_CALLGRAPH";
    public static final String ANALYSIS_TRANSACTION_KEY = "TRANSACTION_CALLGRAPH";
    private static final int MAXNAMES = 10;
    private MainframeMouseActionsHook mouseActionsHook = null;
    private String tabName;
    private Direction cgDirection;
    private Boolean isCgLimited;
    private Integer cgLimitation = null;

    public CallGraphJob(EZEntityID ezId) {
        super(ezId);
        this.initGraphDetails();
        this.mouseActionsHook = R2DSUtils.isR2DSCallgraph((TSEGraphManager)this.graphManager) ? new R2DSMouseActionsHook(ezId, (GraphAnalysisJob)this) : new MainframeMouseActionsHook(ezId);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
            this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
        }
    }

    protected void initGraphDetails() {
        boolean isPrgCallGraph;
        this.graphInfo = new GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.cgDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("callgraph direction: " + this.cgDirection);
        this.isCgLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (this.isCgLimited != null && this.isCgLimited.booleanValue()) {
            this.cgLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("callgraph has limit: " + this.cgLimitation);
        } else {
            L.debug("callgraph isn't limited");
        }
        this.graphModel = new CallGraphModel(new AnalysisGraphManager(), this.cgDirection, this.cgLimitation);
        this.graphManager = this.graphModel.getGraphManager();
        boolean bl = isPrgCallGraph = this.analysis.getContextValue(ANALYSIS_PROGRAM_KEY) != null ? (Boolean)this.analysis.getContextValue(ANALYSIS_PROGRAM_KEY) : false;
        if (this.cgDirection != null && (this.cgDirection.ordinal() == Direction.BACKWARD.ordinal() || this.cgDirection.ordinal() == Direction.FORWARD.ordinal()) && isPrgCallGraph) {
            ArrayList<Class<ExportAsCSV>> impl = new ArrayList<Class<ExportAsCSV>>();
            impl.add(ExportAsCSV.class);
            this.graphManager.setAttribute("extraExportListImplementors", impl);
            this.graphManager.setAttribute("graph direction", (Object)this.cgDirection.ordinal());
            this.graphManager.setAttribute("mainframe project name", this.analysis.getContextValue("input_project_names"));
            if (this.cgLimitation != null) {
                this.graphManager.setAttribute("graph limitation", (Object)this.cgLimitation);
            }
        }
        if (this.cgDirection == null) {
            this.cgDirection = Direction.FORWARD;
        }
        R2DSUtils.markAsR2DSCallgraph((TSEGraphManager)this.graphManager, (Direction.FORWARD.ordinal() == this.cgDirection.ordinal() ? 1 : 0) != 0);
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((com.ez.workspace.analysis.graph.model.GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor monitor) {
        super.computeResults(model, monitor);
        ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        ((CallGraphModel)this.graphModel).setEzsourcePrj(ezsourcePrj);
        if (R2DSUtils.isR2DSCallgraph((TSEGraphManager)this.graphManager)) {
            this.graphManager.setAttribute("projects", this.analysis.getContextValue("projects"));
            this.graphManager.setAttribute("Projects_TS_map", new HashMap());
        }
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(CallGraphJob.class, "collectingData.taskName"));
        IStatus status = com.ez.cobol.callgraph.utils.Utils.collectDataFromBridge((IProgressMonitor)pmonitor.newChild(100), (String)ezsourcePrj.getName(), (IMFRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        } else {
            pmonitor.setWorkRemaining(0);
        }
    }

    private void obtainInputs(EZEntityID input, Map<Integer, EZSourceProgramIDSg> backPrgsInfo, Map<Integer, EZSourceProgramIDSg> forwardPrgsInfo, HashSet<String> prgs, Map<Integer, Set<String[]>> jobInfo, Map<Integer, EZSourceJobIDSg> jobIDs, Map<String, TextSelectionInFile> paths, List<GraphNode> transGraphNodeList, Map<Integer, List<GraphNode>> callgraphResources, Map<Integer, List<GraphNode>> transactionMapping) {
        if (this.analysis.getContextValue(ANALYSIS_TRANSACTION_KEY) != null) {
            EZSourceTransactionIDSg trIdSg = (EZSourceTransactionIDSg)input.getSegment(EZSourceTransactionIDSg.class);
            String transactionName = trIdSg.getTransactionName();
            GraphNode resNode = new GraphNode(transactionName);
            resNode.addProperty("level", (Object)CallGraphModel.transactionLevel);
            resNode.addProperty("resourceType", (Object)14);
            resNode.addProperty("resourceIdSg", (Object)trIdSg);
            resNode.addProperty("node is input for callgraph", (Object)Boolean.TRUE);
            resNode.addProperty("Node_Mainframe", (Object)new GenericProgramRelatedNode(transactionName, ResultElementType.TRANSACTION.getDisplayName()));
            if (callgraphResources != null) {
                transGraphNodeList = callgraphResources.get(14);
            } else {
                callgraphResources = new HashMap<Integer, List<GraphNode>>();
                transGraphNodeList = null;
            }
            if (transGraphNodeList == null) {
                transGraphNodeList = new ArrayList<GraphNode>();
                callgraphResources.put(14, transGraphNodeList);
            }
            transGraphNodeList.add(resNode);
            EZSourceProgramIDSg mappedPrg = trIdSg.getMappedProgramSg();
            if (forwardPrgsInfo != null && mappedPrg != null) {
                L.debug("make graphNode object for transaction: " + transactionName);
                this.completePrgInfo(null, forwardPrgsInfo, prgs, mappedPrg);
                Integer prgId = mappedPrg.getProgramId();
                List<GraphNode> list = transactionMapping.get(prgId);
                if (list == null) {
                    list = new ArrayList<GraphNode>();
                    transactionMapping.put(prgId, list);
                }
                list.add(resNode);
            }
            Set callingPrograms = trIdSg.getProgramDetails();
            for (EZSourceProgramIDSg prgSg : callingPrograms) {
                this.completePrgInfo(backPrgsInfo, null, prgs, prgSg);
            }
        } else if (this.analysis.getContextValue(ANALYSIS_SCREEN_KEY) != null) {
            EZSourceScreenIDSg scrIdSg = (EZSourceScreenIDSg)input.getSegment(EZSourceScreenIDSg.class);
            Set prgSgIds = scrIdSg.getPrograms();
            for (EZSourceProgramIDSg prgIdSg : prgSgIds) {
                this.completePrgInfo(backPrgsInfo, forwardPrgsInfo, prgs, prgIdSg);
            }
            String mapsetName = scrIdSg.getMapSet();
            String scrName = mapsetName != null && !mapsetName.isEmpty() ? mapsetName.concat("-").concat(scrIdSg.getScreenName()) : scrIdSg.getScreenName();
            GraphNode resNode = new GraphNode(scrName);
            resNode.addProperty("level", (Object)CallGraphModel.screenLevel);
            int scrType = scrIdSg.getScreenType();
            int resType = 61;
            switch (scrType) {
                case 118: {
                    resType = 95;
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.ADS_MAP.getDisplayName(), mapsetName));
                    break;
                }
                case 119: {
                    resType = 6;
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.BMS_MAP.getDisplayName(), mapsetName));
                    break;
                }
                case 120: {
                    resType = 61;
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.NATURAL_MAP.getDisplayName(), mapsetName));
                    break;
                }
                case 5: {
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.SMART_SCREEN_IO_MODULE.getDisplayName(), mapsetName));
                    break;
                }
                case 121: {
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.AS400_SCREEN.getDisplayName(), mapsetName));
                    break;
                }
                case 4: {
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.SMART_DB_IO_MODULE.getDisplayName(), mapsetName));
                    break;
                }
                case 6: {
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.SMART_SMART_SUBROUTINE.getDisplayName(), mapsetName));
                    break;
                }
                case 101: {
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.TPMSX_SCREEN.getDisplayName(), mapsetName));
                    break;
                }
                case 14: {
                    resNode.addProperty("Node_Mainframe", (Object)new ScreenNode(scrName, ResultElementType.DDCL_SCREEN.getDisplayName(), mapsetName));
                }
            }
            resNode.addProperty("resourceType", (Object)resType);
            resNode.addProperty("resourceIdSg", (Object)scrIdSg);
            resNode.addProperty("node is input for callgraph", (Object)Boolean.TRUE);
            List<GraphNode> screenGraphNodeList = callgraphResources.get(resType);
            if (screenGraphNodeList == null) {
                screenGraphNodeList = new ArrayList<GraphNode>();
                callgraphResources.put(resType, screenGraphNodeList);
            }
            screenGraphNodeList.add(resNode);
        } else if (this.analysis.getContextValue(ANALYSIS_JOB_KEY) != null) {
            EZSourceJobIDSg jobIdSg = (EZSourceJobIDSg)input.getSegment(EZSourceJobIDSg.class);
            jobIDs.put(jobIdSg.getJobId(), jobIdSg);
        } else {
            EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)input.getSegment(EZSourceProgramIDSg.class);
            this.completePrgInfo(backPrgsInfo, forwardPrgsInfo, prgs, prgIdSg);
        }
    }

    private void completeInputs(String project, Map<Integer, EZSourceProgramIDSg> backPrgsInfo, Map<Integer, EZSourceProgramIDSg> forwardPrgsInfo, HashSet<String> prgs, Map<Integer, Set<String[]>> jobInfo, Map<Integer, EZSourceJobIDSg> jobIDs, Map<String, TextSelectionInFile> paths, Map<Integer, List<GraphNode>> callgraphResources, Map<Integer, List<GraphNode>> transactionMapping) {
        if (!jobIDs.isEmpty()) {
            String[][] jobPaths;
            Object jobId2;
            int n;
            String[][] pgmSteps = com.ez.cobol.callgraph.utils.Utils.runProc((String)EZREP_PROCEDURE_22, jobIDs.keySet(), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
            if (pgmSteps != null) {
                String[][] stringArray = pgmSteps;
                n = pgmSteps.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] cols = stringArray[n2];
                    prgs.add(cols[4]);
                    jobId2 = Integer.valueOf(cols[12]);
                    Set<String[]> results = jobInfo.get(jobId2);
                    if (results == null) {
                        results = new HashSet<String[]>();
                        jobInfo.put((Integer)jobId2, results);
                    }
                    results.add(cols);
                    ++n2;
                }
            }
            if ((jobPaths = com.ez.cobol.callgraph.utils.Utils.runProc((String)"EZReports_JobCallgraph_JobPath", jobIDs.keySet(), (EZSourceDataType)EZSourceDataType.Integer, (String)project)) != null) {
                jobId2 = jobPaths;
                int n3 = jobPaths.length;
                n = 0;
                while (n < n3) {
                    String[] jobPath = jobId2[n];
                    TextSelectionInFile sel = new TextSelectionInFile(jobPath[7], CallGraphBuilder.JOB_TYPE_STRING, new String[]{jobPath[3], jobPath[4], jobPath[5], jobPath[6]});
                    paths.put(String.valueOf(jobPath[0]) + "|" + jobPath[1], sel);
                    ++n;
                }
            }
            ((CallGraphModel)this.graphModel).setJobInfo(jobIDs, jobInfo);
            String[][] progIds = com.ez.cobol.callgraph.utils.Utils.runProc((String)EZREP_PROCEDURE_4, prgs, (EZSourceDataType)EZSourceDataType.String, (String)project);
            if (progIds != null) {
                String[][] stringArray = progIds;
                int jobId2 = progIds.length;
                int n4 = 0;
                while (n4 < jobId2) {
                    List<GraphNode> pgmGraphNodeList;
                    String[] prg = stringArray[n4];
                    Boolean occur = prg[8] != null && !prg[8].isEmpty();
                    EZSourceProgramIDSg pgmSgId = new EZSourceProgramIDSg(prg[0], new Integer(prg[1]), new Integer(prg[2]), occur);
                    String pgmName = pgmSgId.getProgramName();
                    GraphNode resNode = new GraphNode(pgmName);
                    resNode.addProperty("level", (Object)CallGraphModel.pgmLevel);
                    pgmSgId.getProgramId().intValue();
                    int resType = 27;
                    resNode.addProperty("resourceType", (Object)resType);
                    resNode.addProperty("resourceIdSg", (Object)pgmSgId);
                    resNode.addProperty("node is input for callgraph", (Object)Boolean.TRUE);
                    resNode.addProperty("Node_Mainframe", (Object)new GenericProgramRelatedNode(pgmName, ResultElementType.UNKNOWN.getDisplayName()));
                    if (callgraphResources != null) {
                        pgmGraphNodeList = callgraphResources.get(resType);
                    } else {
                        callgraphResources = new HashMap<Integer, List<GraphNode>>();
                        pgmGraphNodeList = null;
                    }
                    if (pgmGraphNodeList == null) {
                        pgmGraphNodeList = new ArrayList<GraphNode>();
                        callgraphResources.put(resType, pgmGraphNodeList);
                    }
                    pgmGraphNodeList.add(resNode);
                    pgmSgId.setAncestorName(prg[3]);
                    String ancestorId = prg[9];
                    if (Utils.filterNullValue((String)ancestorId) != null) {
                        pgmSgId.setAncestorId(Integer.valueOf(ancestorId));
                    }
                    forwardPrgsInfo.put(new Integer(prg[1]), pgmSgId);
                    if (Utils.filterNullValue((String)prg[8]) != null) {
                        TextSelectionInFile sel = new TextSelectionInFile(prg[8], prg[2], new String[]{prg[4], prg[6], prg[5], prg[7]});
                        paths.put(String.valueOf(prg[1]) + "|" + prg[0], sel);
                    }
                    ++n4;
                }
            }
        } else {
            String[][] prgPaths = com.ez.cobol.callgraph.utils.Utils.runProc((String)"EZReports_ProgGraf_programPath", prgs, (EZSourceDataType)EZSourceDataType.String, (String)project);
            if (prgPaths != null) {
                String[][] stringArray = prgPaths;
                int n = prgPaths.length;
                int n5 = 0;
                while (n5 < n) {
                    String[] prgPath = stringArray[n5];
                    TextSelectionInFile sel = new TextSelectionInFile(prgPath[7], prgPath[1], new String[]{prgPath[3], prgPath[5], prgPath[4], prgPath[6]});
                    paths.put(String.valueOf(prgPath[2]) + "|" + prgPath[0], sel);
                    ++n5;
                }
            }
            if (callgraphResources != null) {
                ((CallGraphModel)this.graphModel).setResourcesInfo(callgraphResources, transactionMapping);
            }
        }
        ((CallGraphModel)this.graphModel).setPrograms(backPrgsInfo, forwardPrgsInfo);
        ((CallGraphModel)this.graphModel).setPaths(paths);
    }

    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "compute.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        HashMap backPrgsInfo = Direction.doBackward((Direction)this.cgDirection) ? new HashMap() : null;
        HashMap forwardPrgsInfo = Direction.doForward((Direction)this.cgDirection) ? new HashMap() : null;
        HashSet<String> prgs = new HashSet<String>();
        HashMap<Integer, Set<String[]>> jobInfo = new HashMap<Integer, Set<String[]>>();
        HashMap<Integer, EZSourceJobIDSg> jobIDs = new HashMap<Integer, EZSourceJobIDSg>();
        HashMap<String, TextSelectionInFile> paths = new HashMap<String, TextSelectionInFile>();
        Object transGraphNodeList = null;
        HashMap<Integer, List<GraphNode>> callgraphResources = null;
        HashMap<Integer, List<GraphNode>> transactionMapping = null;
        if (this.analysis.getContextValue(ANALYSIS_TRANSACTION_KEY) != null) {
            L.debug("is transaction callgraph analysis");
            callgraphResources = new HashMap<Integer, List<GraphNode>>();
            transactionMapping = new HashMap<Integer, List<GraphNode>>();
        }
        if (this.analysis.getContextValue(ANALYSIS_SCREEN_KEY) != null && callgraphResources == null) {
            callgraphResources = new HashMap();
        }
        if (this.analysis.getContextValue(ANALYSIS_JOB_KEY) != null && callgraphResources == null) {
            callgraphResources = new HashMap();
        }
        Object path = this.analysis.getContextValue("selected path");
        String project = (String)this.analysis.getContextValue("input_project_names");
        if (path != null && !path.toString().trim().equals("")) {
            TSEGraph mainGraph = this.graphModel.getGraph();
            for (EZEntityID input : inputs) {
                this.obtainInputs(input, backPrgsInfo, forwardPrgsInfo, prgs, jobInfo, jobIDs, paths, transGraphNodeList, callgraphResources, transactionMapping);
                this.completeInputs(project, backPrgsInfo, forwardPrgsInfo, prgs, jobInfo, jobIDs, paths, callgraphResources, transactionMapping);
                this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = this.graphModel.getGraph();
                ((CallGraphModel)this.graphModel).writeGraphToFile(newGraph, input.getSegments(), path.toString());
                newGraph.dispose();
                backPrgsInfo = Direction.doBackward((Direction)this.cgDirection) ? new HashMap() : null;
                forwardPrgsInfo = Direction.doForward((Direction)this.cgDirection) ? new HashMap() : null;
                prgs.clear();
                jobInfo.clear();
                jobIDs.clear();
                paths.clear();
                transGraphNodeList = null;
                callgraphResources = null;
                ((CallGraphModel)this.graphModel).setJobInfo(jobIDs, jobInfo);
                ((CallGraphModel)this.graphModel).setPrograms(backPrgsInfo, forwardPrgsInfo);
                ((CallGraphModel)this.graphModel).setPaths(paths);
                ((CallGraphModel)this.graphModel).setResourcesInfo(callgraphResources, transactionMapping);
            }
            this.graphModel.setGraph(mainGraph);
        } else {
            for (EZEntityID input : inputs) {
                this.obtainInputs(input, backPrgsInfo, forwardPrgsInfo, prgs, jobInfo, jobIDs, paths, transGraphNodeList, callgraphResources, transactionMapping);
            }
            this.completeInputs(project, backPrgsInfo, forwardPrgsInfo, prgs, jobInfo, jobIDs, paths, callgraphResources, transactionMapping);
        }
        monitor.done();
    }

    private void completePrgInfo(Map<Integer, EZSourceProgramIDSg> backPrgsInfo, Map<Integer, EZSourceProgramIDSg> forwardPrgsInfo, HashSet<String> prgs, EZSourceProgramIDSg prgIdSg) {
        Integer prgId = prgIdSg.getProgramId();
        if (forwardPrgsInfo != null) {
            forwardPrgsInfo.put(prgId, prgIdSg);
        }
        if (backPrgsInfo != null) {
            backPrgsInfo.put(prgId, prgIdSg);
        }
        if (backPrgsInfo != null || forwardPrgsInfo != null) {
            prgs.add(prgIdSg.getProgramName());
        }
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor pmonitor, IStatus result) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)monitor, result);
        if (this.gfi != null) {
            this.addFilters(this.gfi);
            HashSet allNodes = new HashSet();
            List graphs = this.graphModel.getGraphs();
            for (TSEGraph gr : graphs) {
                allNodes.addAll(gr.nodes());
            }
            if (this.graphModel != null) {
                this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
            }
        }
        monitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((CallGraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        boolean isJobCallgraph = this.analysis.getContextValue(ANALYSIS_JOB_KEY) != null;
        com.ez.cobol.callgraph.utils.Utils.addMainframeNodesToLegend((LegendPanel)legend, (int)uiStyle, (boolean)isJobCallgraph, (Set)this.graphModel.getNodeTypesForLegend());
        this.addEdgesToLegend(legend);
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(ADSDialogProgramNode.class);
        gfi.registerFilterType(ADSProcessProgramNode.class);
        gfi.registerFilterType(AlgolProgramNode.class);
        gfi.registerFilterType(AssemblerProgramNode.class);
        gfi.registerFilterType(AsmCsectProgramNode.class);
        gfi.registerFilterType(AsmEntryProgramNode.class);
        gfi.registerFilterType(CLProgramNode.class);
        gfi.registerFilterType(CobolProgramNode.class);
        gfi.registerFilterType(FortranProgramNode.class);
        gfi.registerFilterType(JCLJobNode.class);
        gfi.registerFilterType(JCLPgmNode.class);
        gfi.registerFilterType(NaturalProgramNode.class);
        gfi.registerFilterType(PLIProgramNode.class);
        gfi.registerFilterType(EZRexxProgramNode.class);
        gfi.registerFilterType(SCLProgramNode.class);
        gfi.registerFilterType(SmartDbModuleProgramNode.class);
        gfi.registerFilterType(SmartSubroutineNode.class);
        gfi.registerFilterType(UnknownProgramNode.class);
        gfi.registerFilterType(AdabasNode.class);
        gfi.registerFilterType(AdsMapNode.class);
        gfi.registerFilterType(ResourceFileNode.class);
        gfi.registerFilterType(ResourceSQLTableNode.class);
        gfi.registerFilterType(ResourceDatacomTableNode.class);
        gfi.registerFilterType(NaturalMapNode.class);
        gfi.registerFilterType(IdmsSetNode.class);
        gfi.registerFilterType(IdmsRecordNode.class);
        gfi.registerFilterType(TransactionNode.class);
        gfi.registerFilterType(QueueNode.class);
        gfi.registerFilterType(QueueManagerNode.class);
        gfi.registerFilterType(PrinterFileNode.class);
        gfi.registerFilterType(SmartScreenNode.class);
        gfi.registerFilterType(CLFileNode.class);
        gfi.registerFilterType(IMSDBNode.class);
        gfi.registerFilterType(TerminalNode.class);
        gfi.registerFilterType(TerminalOrTransactionNode.class);
        gfi.registerFilterType(TPMSXMapNode.class);
        gfi.registerFilterType(DBFileNode.class);
        gfi.registerFilterType(DALFileNode.class);
        gfi.registerFilterType(DBINode.class);
    }

    public void closing() {
        EZMouseTool mouseTool;
        this.cgDirection = null;
        this.mouseActionsHook = null;
        if (this.canvas != null && this.canvas.getToolManager() != null && (mouseTool = (EZMouseTool)this.canvas.getToolManager().getTool("mouse")) != null) {
            this.canvas.getToolManager().unregister("mouse");
            mouseTool.clean();
        }
        super.closing();
    }

    public class GraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;
        private Image screenImage;
        private Image transactionImage;
        private Image jobImage;

        public GraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage("screenCallgraph", "icons/screen_callgraph.png");
            SharedImages.registerImage("transactionCallgraph", "icons/Transaction.png");
            SharedImages.registerImage("jobCallgraph", "icons/jobcallgraph.png");
            SharedImages.registerImage("programCallgraph", "icons/programcall.png");
        }

        public Image getImage() {
            if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_SCREEN_KEY) != null) {
                if (this.screenImage == null) {
                    this.screenImage = SharedImages.getImage("screenCallgraph");
                    return this.screenImage;
                }
            } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_TRANSACTION_KEY) != null) {
                if (this.transactionImage == null) {
                    this.transactionImage = SharedImages.getImage("transactionCallgraph");
                    return this.transactionImage;
                }
            } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_JOB_KEY) != null && this.jobImage == null) {
                this.jobImage = SharedImages.getImage("jobCallgraph");
                return this.jobImage;
            }
            if (this.image == null) {
                this.image = SharedImages.getImage("programCallgraph");
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            StringBuilder textInputs = new StringBuilder();
            String textInputsMore = "";
            List inputs = CallGraphJob.this.analysis.getContextListValue("input_list");
            if (inputs != null) {
                int idx = 0;
                int all = inputs.size();
                for (EZEntityID input : inputs) {
                    if (truncate && idx >= 10) {
                        textInputsMore = String.valueOf(textInputsMore) + (all - idx);
                        break;
                    }
                    ++idx;
                    if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_TRANSACTION_KEY) != null) {
                        EZSourceTransactionIDSg trIdSg = (EZSourceTransactionIDSg)input.getSegment(EZSourceTransactionIDSg.class);
                        String transactionName = trIdSg.getTransactionName();
                        textInputs.append(transactionName);
                    } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_SCREEN_KEY) != null) {
                        EZSourceScreenIDSg scrIdSg = (EZSourceScreenIDSg)input.getSegment(EZSourceScreenIDSg.class);
                        textInputs.append(scrIdSg.getScreenNameToPrint());
                    } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_JOB_KEY) != null) {
                        EZSourceJobIDSg jobIdSg = (EZSourceJobIDSg)input.getSegment(EZSourceJobIDSg.class);
                        textInputs.append(jobIdSg.getJobExpandedName());
                    } else {
                        EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)input.getSegment(EZSourceProgramIDSg.class);
                        textInputs.append(prgIdSg.getListableName());
                    }
                    if (inputs.indexOf(input) == inputs.size() - 1) continue;
                    textInputs.append(", ");
                }
            }
            String type = CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_JOB_KEY) != null ? Messages.getString(CallGraphJob.class, "job.type") : (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_SCREEN_KEY) != null ? Messages.getString(CallGraphJob.class, "screen.type") : (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_TRANSACTION_KEY) != null ? Messages.getString(CallGraphJob.class, "transaction.type") : Messages.getString(CallGraphJob.class, "program.type")));
            if (textInputsMore.isEmpty()) {
                CallGraphJob.this.tabName = Messages.getString(CallGraphJob.class, "tabName", new String[]{textInputs.toString(), CallGraphJob.this.analysis.getContextValue("input_project_names").toString(), type});
            } else {
                CallGraphJob.this.tabName = Messages.getString(CallGraphJob.class, "tabName.more", new String[]{textInputs.toString(), textInputsMore, CallGraphJob.this.analysis.getContextValue("input_project_names").toString(), type});
            }
            return CallGraphJob.this.tabName;
        }

        public String getTooltip() {
            StringBuilder tooltipText = new StringBuilder(CallGraphJob.this.tabName);
            if (CallGraphJob.this.isCgLimited != null && CallGraphJob.this.isCgLimited.booleanValue()) {
                if (CallGraphJob.this.cgDirection != null) {
                    tooltipText.append(Messages.getString(CallGraphJob.class, "tooltipName.isCgLimited.cgDirection", new String[]{CallGraphJob.this.cgDirection.toString(), CallGraphJob.this.cgLimitation.toString()}));
                } else {
                    tooltipText.append(Messages.getString(CallGraphJob.class, "tooltipName.isCgLimited", new String[]{CallGraphJob.this.cgLimitation.toString()}));
                }
            } else if (CallGraphJob.this.cgDirection != null) {
                tooltipText.append(Messages.getString(CallGraphJob.class, "tooltipName.cgDirection", new String[]{CallGraphJob.this.cgDirection.toString()}));
            }
            return tooltipText.toString();
        }

        public ComponentBuilderInterface getLegendControl() {
            ComponentBuilderInterface cbi = new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    CallGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    com.ez.cobol.callgraph.utils.Utils.setImageProvider((LegendPanel)CallGraphJob.this.legend);
                    int uiStyle = CallGraphJob.this.graphModel.getUIStyle();
                    CallGraphJob.this.addEntriesToLegend(CallGraphJob.this.legend, uiStyle, GraphInfo.this.gfi);
                    sc.setContent((Control)CallGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    CallGraphJob.this.legend.pack();
                    sc.setMinSize(CallGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((CallGraphJob)((GraphInfo)GraphInfo.this).CallGraphJob.this).legend.getSize().x;
                    int x = ((CallGraphJob)((GraphInfo)GraphInfo.this).CallGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
            return cbi;
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            if (CallGraphJob.this.legend != null) {
                CallGraphJob.this.legend.dispose();
                CallGraphJob.this.legend = null;
            }
            if (this.screenImage != null) {
                this.screenImage = null;
            }
            if (this.transactionImage != null) {
                this.transactionImage = null;
            }
            if (this.jobImage != null) {
                this.jobImage = null;
            }
            super.dispose();
        }
    }
}

