/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.Listable;
import com.ez.graphs.aauto.AAutoGraphAnalysis;
import com.ez.graphs.aauto.AAutoWizard;
import com.ez.graphs.internal.Messages;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.wizard.GenericSelectPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectSelectionPage
extends GenericSelectPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectSelectionPage.class);
    private AAutoGraphAnalysis an;
    private AAutoWizard wizard;
    Map<String, ProjectInfo> projectsInfo;

    protected ProjectSelectionPage(String pageName, AAutoWizard wizard) {
        super(pageName);
        this.wizard = wizard;
        this.showReportsOptionGroup = false;
        this.setTitle(Messages.getString(ProjectSelectionPage.class, "prjSelection.pageTitle"));
        this.setDescription(Messages.getString(ProjectSelectionPage.class, "prjSelection.pageDescription"));
    }

    public void setAnalysis(AAutoGraphAnalysis graphAnalysis) {
        this.an = graphAnalysis;
    }

    public boolean isPageComplete() {
        List sel = this.wizard.getList("selected projects");
        L.debug("{}", (Object)sel);
        boolean ret = false;
        ret = sel != null && sel.size() >= this.MINIM_SIZE_OF_SELECTED;
        return ret;
    }

    protected void fillWithProgress() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor pmonitor) throws InvocationTargetException, InterruptedException {
                IProjectsService service;
                List ezprjs;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                monitor.beginTask(Messages.getString(ProjectSelectionPage.class, "task.name"), -1);
                L.debug("getting projects");
                if (!monitor.isCanceled() && (ezprjs = (service = (IProjectsService)ServiceUtils.getService(IProjectsService.class)).getProjects()) != null) {
                    List prjs4GUI = ProjectSelectionPage.this.getProjects4GUI(ezprjs);
                    ProjectSelectionPage.this.setAvailableResources(prjs4GUI);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
            L.trace("operation run");
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProjectSelectionPage.this.an.wasCancelled()) {
                        L.trace("monitor was canceled");
                    }
                }
            });
        }
        catch (Exception e) {
            L.error("error", (Throwable)e);
        }
        super.fillUIWithProgress();
    }

    private List<Listable> getProjects4GUI(List<ProjectInfo> prjsInfo) {
        ArrayList<Listable> resrs = new ArrayList<Listable>();
        String selectedProject = this.wizard.getProject();
        for (ProjectInfo prjInfo : prjsInfo) {
            if (!prjInfo.isZOS() || prjInfo.getName().equals(selectedProject)) continue;
            BaseMainframeResourceInput inpt = new BaseMainframeResourceInput(prjInfo.getName());
            resrs.add((Listable)new BaseMainframeResource4GUI((BaseResourceInput)inpt));
            if (this.projectsInfo == null) {
                this.projectsInfo = new HashMap<String, ProjectInfo>();
            }
            this.projectsInfo.put(prjInfo.getName(), prjInfo);
        }
        return resrs;
    }

    public Map<String, ProjectInfo> getProjectsInfo() {
        return this.projectsInfo;
    }
}

