/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.graphs.aauto.AAutoGraphAnalysis;
import com.ez.graphs.aauto.AAutoGraphChoisePage;
import com.ez.graphs.aauto.AAutoWizard;
import com.ez.graphs.aauto.AAutoWizardDialog;
import com.ez.graphs.aauto.ProjectSelectionPage;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceAAUTONetworkInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.AAutoJob;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.AAutoJobCollector;
import com.ez.report.application.ui.collectors.AAutoNetworkCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.AAUTONetworkIDSg;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class NetworkInputsFilter
extends ProjectInputsFilter {
    public static final String SELECTION_BY_JOBS = "selectionByJobs";
    public static final String SELECTED_NETWORKS = "selectedNetworks";
    public static final String SELECTED_JOBS = "selectedJobs";
    public static final String SELECTED_PROJECTS = "selectedProjects";
    private boolean onProject = false;
    private boolean onAAUTOJobs = false;
    private List<EZObjectType> inputs;
    private AAutoGraphAnalysis an;

    public NetworkInputsFilter() {
        this.onProject = true;
    }

    public NetworkInputsFilter(List<EZObjectType> inputs) {
        this.onProject = false;
        this.onAAUTOJobs = !(inputs.get(0) instanceof EZSourceAAUTONetworkInputType);
        this.inputs = inputs;
    }

    protected PrepareReportWizard getWizard() {
        AAutoWizard wizard = new AAutoWizard(this.onProject);
        String wizardName = Messages.getString(NetworkInputsFilter.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        String description = this.onProject ? Messages.getString(AAutoGraphChoisePage.class, "page.desc1") : (this.onAAUTOJobs ? Messages.getString(AAutoGraphChoisePage.class, "page.desc2") : Messages.getString(AAutoGraphChoisePage.class, "page.desc3"));
        AAutoGraphChoisePage choisePage = new AAutoGraphChoisePage("ByJobsOrNetworksPageName", description, SELECTION_BY_JOBS, this.onProject);
        choisePage.setLimitGraphText(Messages.getString(NetworkInputsFilter.class, "limit.grp.text"), Messages.getString(NetworkInputsFilter.class, "limit.grp.lbl.text"));
        wizard.addPage((IWizardPage)choisePage);
        if (!this.onProject) {
            wizard.set(SELECTION_BY_JOBS, this.onAAUTOJobs);
        }
        if (this.onProject) {
            SelectProgramsPage selectPage = new SelectProgramsPage("NetworksPageName", false, false);
            AAutoNetworkCollector collector = new AAutoNetworkCollector();
            selectPage.setResourcesCollector((ResourcesCollector)collector);
            selectPage.setLeftGroupLabel(Messages.getString(NetworkInputsFilter.class, "av.nets.lbl"));
            selectPage.setRightGroupLabel(Messages.getString(NetworkInputsFilter.class, "sel.nets.lbl"));
            selectPage.setSelectedPropName(SELECTED_NETWORKS);
            selectPage.setTitle(Messages.getString(NetworkInputsFilter.class, "net.page.title"));
            selectPage.setDescription(Messages.getString(NetworkInputsFilter.class, "net.page.description"));
            selectPage.setErrMsgNoResource(Messages.getString(NetworkInputsFilter.class, "net.err.message"));
            wizard.addPage((IWizardPage)selectPage);
        } else {
            this.prepareInputs(wizard);
        }
        if (this.onProject || !this.onAAUTOJobs) {
            SelectProgramsPage selectJobsPage = new SelectProgramsPage("JobsPageName", false, false);
            AAutoJobCollector jobcollector = new AAutoJobCollector();
            selectJobsPage.setResourcesCollector((ResourcesCollector)jobcollector);
            selectJobsPage.setLeftGroupLabel(Messages.getString(NetworkInputsFilter.class, "av.jobs.lbl"));
            selectJobsPage.setRightGroupLabel(Messages.getString(NetworkInputsFilter.class, "sel.jobs.lbl"));
            selectJobsPage.setSelectedPropName(SELECTED_JOBS);
            selectJobsPage.setTitle(Messages.getString(NetworkInputsFilter.class, "page.title"));
            selectJobsPage.setDescription(Messages.getString(NetworkInputsFilter.class, "page.description"));
            selectJobsPage.setErrMsgNoResource(Messages.getString(NetworkInputsFilter.class, "err.message"));
            wizard.addPage((IWizardPage)selectJobsPage);
            if (System.getProperty("test") != null) {
                SelectPathPage selectPathPage = new SelectPathPage("tests page");
                wizard.addPage((IWizardPage)selectPathPage);
            }
        }
        ProjectSelectionPage page = new ProjectSelectionPage("zOS project page", wizard);
        page.setAnalysis(this.an);
        page.setLeftGroupLabel(Messages.getString(NetworkInputsFilter.class, "av.object.type"));
        page.setRightGroupLabel(Messages.getString(NetworkInputsFilter.class, "sel.object.type"));
        wizard.addPage((IWizardPage)page);
        return wizard;
    }

    private void prepareInputs(PrepareReportWizard wizard) {
        ArrayList<AAutoNetwork> inputsForWizard = new ArrayList<AAutoNetwork>();
        for (EZObjectType objType : this.inputs) {
            EZSourceAAUTOJobIDSg sg;
            EZEntityID entityId = objType.getEntID();
            AAutoNetwork inp = null;
            if (this.onAAUTOJobs) {
                sg = (EZSourceAAUTOJobIDSg)entityId.getSegment(EZSourceAAUTOJobIDSg.class);
                if (sg.isIncompleteSegment()) {
                    wizard.set("must complete aauto job id", (Object)Boolean.TRUE);
                }
                inp = new AAutoJob(sg.getJobId(), sg.getJobName());
            } else {
                sg = (AAUTONetworkIDSg)entityId.getSegment(AAUTONetworkIDSg.class);
                inp = new AAutoNetwork(sg.getNetworkId(), sg.getResourceName(), sg.getExpandedNetworkName());
            }
            inputsForWizard.add(inp);
        }
        String key = this.onAAUTOJobs ? SELECTED_JOBS : SELECTED_NETWORKS;
        wizard.set(key, inputsForWizard);
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
        List sel = wizard.getList("selected projects");
        if (sel != null) {
            ArrayList<ProjectInfo> selectedPrjs = new ArrayList<ProjectInfo>();
            ProjectSelectionPage page = (ProjectSelectionPage)wizard.getPage("zOS project page");
            Map<String, ProjectInfo> prjsInfo = page.getProjectsInfo();
            for (BaseMainframeResource4GUI prjInput : sel) {
                if (!prjsInfo.containsKey(prjInput.getListableName())) continue;
                selectedPrjs.add(prjsInfo.get(prjInput.getListableName()));
            }
            this.an.addContextValue(SELECTED_PROJECTS, selectedPrjs);
        }
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        AAutoWizardDialog dialog = new AAutoWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    public void setAnalysis(AAutoGraphAnalysis an) {
        this.an = an;
    }
}

