/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.graphs.aauto.AAutoGraphJob;
import com.ez.graphs.aauto.AAutoGraphModel;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;

public class AAutoMouseActionsHook
extends MainframeMouseActionsHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private AAutoGraphJob analysisJob = null;
    private GraphAnalysisJob.ExpandAction expandAction = null;
    private GraphAnalysisJob.CollapseAction collapseAction = null;
    private GraphAnalysisJob.ExpandAllAction expandAllApps = null;
    private GraphAnalysisJob.CollapseAllAction collapseAllApps = null;

    public AAutoMouseActionsHook(EZEntityID entityId, AAutoGraphJob job) {
        super(entityId);
        this.analysisJob = job;
    }

    public List getRightClickContributions(TSENode node) {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        if (node != null && node.hasAttribute("aauto network") && !node.isExpanded() && node.hasChildGraph()) {
            if (this.expandAction == null) {
                this.expandAction = new GraphAnalysisJob.ExpandAction((GraphAnalysisJob)this.analysisJob);
            }
            this.expandAction.setChecked(false);
            this.expandAction.setNodeToExpand(node);
            String expandLabel = Messages.getString(AAutoGraphJob.class, "expand.text", new String[]{node.getText()});
            this.expandAction.setText(expandLabel);
            this.expandAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.expandAction));
        } else if (node != null && !node.isViewable() && node.hasAttribute("PARENT")) {
            if (this.expandAction == null) {
                this.expandAction = new GraphAnalysisJob.ExpandAction((GraphAnalysisJob)this.analysisJob);
            }
            if (node.hasAttribute("PARENT")) {
                TSENode parrentNode = (TSENode)node.getAttributeValue("PARENT");
                this.expandAction.setNodeToExpand(parrentNode);
                String expandLabel = Messages.getString(AAutoGraphJob.class, "expand.text", new String[]{parrentNode.getText()});
                this.expandAction.setText(expandLabel);
                this.expandAction.setEnabled(!parrentNode.isExpanded());
            }
            this.expandAction.setChecked(false);
            contextItems.add(new ActionContributionItem((IAction)this.expandAction));
        }
        if (node != null && node.hasAttribute("aauto network") && node.isExpanded()) {
            if (this.collapseAction == null) {
                this.collapseAction = new GraphAnalysisJob.CollapseAction(this.analysisJob){

                    public void execute(IProgressMonitor monitor) {
                        super.execute(monitor);
                        ((AAutoGraphModel)AAutoMouseActionsHook.this.graphModel).addLabelsForMetaEdges();
                    }
                };
            }
            this.collapseAction.setChecked(false);
            String name = (String)node.getAttributeValue("network name");
            this.collapseAction.toCollapseNode = node;
            this.collapseAction.overview = (TSEOverviewComponent)this.graphInfo.getOverviewComponent();
            String collapseLabel = Messages.getString(AAutoGraphJob.class, "collapse.text", new String[]{name});
            this.collapseAction.setText(collapseLabel);
            this.collapseAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
        } else if (node != null && node.hasAttribute("aauto jobs within a network to fold") && node.isViewable()) {
            if (this.collapseAction == null) {
                this.collapseAction = new GraphAnalysisJob.CollapseAction(this.analysisJob){

                    public void execute(IProgressMonitor monitor) {
                        super.execute(monitor);
                        ((AAutoGraphModel)AAutoMouseActionsHook.this.graphModel).addLabelsForMetaEdges();
                    }
                };
            }
            this.collapseAction.setChecked(false);
            TSENode appNode = (TSENode)node.getAttributeValue("PARENT");
            String name = (String)appNode.getAttributeValue("network name");
            this.collapseAction.toCollapseNode = appNode;
            this.collapseAction.overview = (TSEOverviewComponent)this.graphInfo.getOverviewComponent();
            String collapseLabel = Messages.getString(AAutoGraphJob.class, "collapse.text", new String[]{name});
            this.collapseAction.setText(collapseLabel);
            this.collapseAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
        }
        contextItems.add(new Separator());
        contextItems.addAll(super.getRightClickContributions(node));
        return contextItems;
    }

    public List getRightClickContributions() {
        ArrayList<ActionContributionItem> contextItems = new ArrayList<ActionContributionItem>();
        if (this.expandAllApps == null) {
            this.expandAllApps = new GraphAnalysisJob.ExpandAllAction(this.analysisJob){

                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(GraphAnalysisJob.class, "expand.task.text"), -1);
                    AAutoMouseActionsHook.this.graphModel.getGraph().expandAll();
                    this.removeMetaEdges();
                    ArrayList<TSCommand> cmds = new ArrayList<TSCommand>();
                    TSCommand cmd = AAutoMouseActionsHook.this.analysisJob.doLayout(1, AAutoMouseActionsHook.this.graphModel.getGraph());
                    cmds.add(cmd);
                    AAutoMouseActionsHook.this.analysisJob.transmitCommands(cmds);
                    AAutoMouseActionsHook.this.canvas.requestFocus();
                    monitor.done();
                }

                private void removeMetaEdges() {
                    LinkedList metaEdgeNodePairList = new LinkedList();
                    LinkedList metaEdgesToRemove = new LinkedList();
                    AAutoMouseActionsHook.this.graphManager.checkMetaEdges(metaEdgeNodePairList, metaEdgesToRemove);
                    LinkedList insertedMetaEdges = new LinkedList();
                    for (TSDEdge edge : metaEdgesToRemove) {
                        edge.discardAllLabels();
                        edge.discardAllPathNodes();
                    }
                    AAutoMouseActionsHook.this.graphManager.updateMetaEdges(metaEdgeNodePairList, metaEdgesToRemove, insertedMetaEdges);
                }
            };
        }
        this.expandAllApps.setChecked(false);
        String expandLabel = Messages.getString(AAutoGraphJob.class, "expand.all.text");
        this.expandAllApps.setText(expandLabel);
        this.expandAllApps.setEnabled(TSNestingManager.hasCollapsedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        contextItems.add(new ActionContributionItem((IAction)this.expandAllApps));
        if (this.collapseAllApps == null) {
            this.collapseAllApps = new GraphAnalysisJob.CollapseAllAction(this.analysisJob){

                public void execute(IProgressMonitor monitor) {
                    super.execute(monitor);
                    ((AAutoGraphModel)AAutoMouseActionsHook.this.graphModel).addLabelsForMetaEdges();
                    ArrayList<TSCommand> cmds = new ArrayList<TSCommand>();
                    TSCommand cmd = AAutoMouseActionsHook.this.analysisJob.doLayout(1, AAutoMouseActionsHook.this.graphModel.getGraph());
                    cmds.add(cmd);
                    AAutoMouseActionsHook.this.analysisJob.transmitCommands(cmds);
                    AAutoMouseActionsHook.this.canvas.requestFocus();
                }
            };
        }
        this.collapseAllApps.setChecked(false);
        String collaspseLabel = Messages.getString(AAutoGraphJob.class, "collapse.all.text");
        this.collapseAllApps.setText(collaspseLabel);
        this.collapseAllApps.setEnabled(TSNestingManager.hasExpandedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        contextItems.add(new ActionContributionItem((IAction)this.collapseAllApps));
        contextItems.addAll(super.getRightClickContributions());
        return contextItems;
    }

    public void dispose() {
        if (this.expandAction != null) {
            this.expandAction.dispose();
            this.expandAction = null;
        }
        if (this.collapseAction != null) {
            this.collapseAction.dispose();
            this.collapseAction = null;
        }
        if (this.expandAllApps != null) {
            this.expandAllApps.dispose();
            this.expandAllApps = null;
        }
        if (this.collapseAllApps != null) {
            this.collapseAllApps.dispose();
            this.collapseAllApps = null;
        }
        super.dispose();
    }
}

