/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.graphs.aauto.TSENodeComparator;
import com.ez.graphs.aauto.model.Network;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.graphs.GraphRestrictionsLegendInfo;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.model.segments.AAUTONetworkIDSg;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEEdgeLabel;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.complexity.TSENestingManager;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSBaseLayoutWorker;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSLayoutOperationCommand;
import com.tomsawyer.interactive.command.editing.TSSwingLayoutWorker;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import images.LoadSVGImages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAutoGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AAutoGraphModel.class);
    public static final String BACKWARD_RESULTS = "BACKWARD";
    public static final String FORWARD_RESULTS = "FORWARD";
    public static final String NETWORK_DETAILS = "NETWORK_DETAILS";
    public static final String JOB_NODES = "JOB_NODES";
    public static final String INPUT_JOBS_IN_NETWORKS = "jobInputInNetworks";
    public static final String JOBS_IN_NETWORKS = "all_JOBS_IN_NETWORKS";
    public static final String JOBS_IN_JCL = "all_AAUTO_JOBS_MATCHED_IN_JCL";
    private Integer graphLimitation;
    private Direction graphDirection;
    private AbstractAnalysis analysis;
    private static final String LAYOUT_LEVEL = "LEVEL";
    private Map<Integer, List<TSENode>> tsNodeLevels = new HashMap<Integer, List<TSENode>>();
    public static final String NODES_TO_FOLD_LIST = "aauto jobs within a network to fold";
    public static final String IS_TS_NODE_NETWORK = "aauto network";
    public static final String NETWORK_NAME_KEY = "network name";
    private static final String AAUTO_EDITOR_AS_STRING = String.valueOf(300);
    private final String JCL_EDITOR_AS_STRING = String.valueOf(22);
    private ProjectInfo ezsourcePrj;
    public static final String NETWORKS_FROM_LIMIT_WITH_CHILDREN = "networks from limit level with children";
    public static final String NETWORKS_WITH_FLAG_FW = "newtorks triggererd by flag(s), forward";
    public static final String NETWORKS_WITH_FLAG_BW = "newtorks triggererd by flag(s), backward";
    public static final String NETWORKS_VS_FLAGS = "networks vs flags, used for backward graph";
    private Map<Pair<TSENode, TSENode>, List<String>> labelsInfoForMetaEdges;
    private List<Boolean> triggeringInfo;

    public AAutoGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis, Direction graphDirection, Integer graphLimitation) {
        this.graphManager = graphManager;
        this.analysis = (AbstractAnalysis)analysis;
        this.graphLimitation = graphLimitation;
        this.graphDirection = graphDirection;
        this.initGraph();
    }

    private void initGraph() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.restrictionTypesSetForLegend.clear();
        this.ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
    }

    public void loadGraph(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        pmonitor.setTaskName(Messages.getString(AAutoGraphModel.class, "loading.graph"));
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        this.initGraph();
        this.graphManager.startBatchProcessing(true);
        pmonitor.worked(50);
        String[][] details = (String[][])this.analysis.getContextValue(NETWORK_DETAILS);
        if (details != null) {
            Object isGroupByNet;
            HashMap<String, Network> networks = new HashMap<String, Network>();
            HashMap<String, Pair<String, String>> networksGoToSourceInfo = new HashMap<String, Pair<String, String>>();
            String[][] stringArray = details;
            int n = details.length;
            int n2 = 0;
            while (n2 < n) {
                String[] detail = stringArray[n2];
                networks.put(detail[0], new Network(detail[0], detail[1], detail[2]));
                if (Utils.filterNullValue((String)detail[4]) != null) {
                    networksGoToSourceInfo.put(detail[0], (Pair<String, String>)new Pair((Object)detail[4], (Object)detail[3]));
                }
                ++n2;
            }
            this.analysis.addContextValue(NETWORK_DETAILS, null);
            HashMap<String, TSENode> networkTSNodes = new HashMap<String, TSENode>();
            this.processResults(networks, networksGoToSourceInfo, networkTSNodes, false);
            this.processResults(networks, networksGoToSourceInfo, networkTSNodes, true);
            Map<String, List<TSENode>> jclJobsNodes = this.createJobGraphs(networks, networksGoToSourceInfo, networkTSNodes);
            this.processTriggeredNetworks(networks, networkTSNodes, jclJobsNodes, networksGoToSourceInfo);
            Map jobInputInNetworks = (Map)this.analysis.getContextValue(INPUT_JOBS_IN_NETWORKS);
            if (jobInputInNetworks != null) {
                for (AAutoNetwork network : jobInputInNetworks.keySet()) {
                    List inputJobIds = (List)jobInputInNetworks.get(network);
                    TSENode networkTS = (TSENode)networkTSNodes.get(String.valueOf(network.getNetwkId()));
                    TSGraph childGraph = networkTS.getChildGraph();
                    Map jobNodes = (Map)childGraph.getAttributeValue(JOB_NODES);
                    for (String jobKey : jobNodes.keySet()) {
                        if (!inputJobIds.contains(jobKey.substring(0, jobKey.indexOf("#")))) continue;
                        TSNode jobNode = (TSNode)jobNodes.get(jobKey);
                        this.markReachedJobs(true, jobNode);
                        this.markReachedJobs(false, jobNode);
                    }
                    TSENestingManager.expand((TSDNode)networkTS);
                }
            }
            if ((isGroupByNet = this.analysis.getContextValue("group jobs by networks")) != null && !((Boolean)isGroupByNet).booleanValue()) {
                this.graph.expandAll();
            } else {
                GraphAnalysisJob.createMetaEdges((TSEGraphManager)this.graphManager);
                this.addLabelsForMetaEdges();
            }
        } else {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(AAutoGraphModel.class, "no.results.node.lbl"));
        }
        this.graphManager.endBatchProcessing();
    }

    private void markReachedJobs(boolean isForward, TSNode jobNode) {
        if (this.graphDirection.equals((Object)Direction.BOTH) || isForward && this.graphDirection.equals((Object)Direction.FORWARD) || !isForward && this.graphDirection.equals((Object)Direction.BACKWARD)) {
            LinkedList reachedNodes = new LinkedList();
            LinkedList reachedEdges = new LinkedList();
            if (isForward) {
                jobNode.findChildren(reachedNodes, reachedEdges, -2L, false);
            } else {
                jobNode.findParents(reachedNodes, reachedEdges, -2L, false);
            }
            jobNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            this.markSpecialNode(jobNode);
            for (TSENode reached : reachedNodes) {
                reached.setAttribute("Text_Color", (Object)TSEColor.blue);
            }
            for (TSEEdge edge : reachedEdges) {
                edge.setAttribute("Color", (Object)TSEColor.blue);
            }
        }
    }

    private Map<String, List<TSENode>> createJobGraphs(Map<String, Network> networks, Map<String, Pair<String, String>> networksGoToSourceInfo, Map<String, TSENode> networkTSNodes) {
        int n;
        int n2;
        String[][] stringArray;
        String[][] jobsInJCL;
        String[][] jobsInNetworks = (String[][])this.analysis.getContextValue(JOBS_IN_NETWORKS);
        Map jobsInJCLMap = (Map)this.analysis.getContextValue(JOBS_IN_JCL);
        HashMap<String, String[]> jobInJCLMap = new HashMap<String, String[]>();
        if (jobsInJCLMap != null && (jobsInJCL = (String[][])jobsInJCLMap.get(this.ezsourcePrj.getName())) != null) {
            stringArray = jobsInJCL;
            n2 = jobsInJCL.length;
            n = 0;
            while (n < n2) {
                String[] res = stringArray[n];
                jobInJCLMap.put(res[1], res);
                ++n;
            }
        }
        HashMap<String, List<TSENode>> jclJobsNodes = new HashMap<String, List<TSENode>>();
        if (jobsInNetworks != null) {
            stringArray = jobsInNetworks;
            n2 = jobsInNetworks.length;
            n = 0;
            while (n < n2) {
                String[] result = stringArray[n];
                String networkId = result[6];
                TSENode networkNode = networkTSNodes.get(networkId);
                if (networkNode == null) {
                    L.warn("ts node for network {} not found!", (Object)networkId);
                } else {
                    String succKey;
                    TSNode succNode;
                    TSGraph childGraph = networkNode.getChildGraph();
                    HashMap<String, TSNode> jobNodes = null;
                    if (childGraph == null) {
                        childGraph = this.graphManager.addGraph();
                        networkNode.setChildGraph(childGraph);
                        jobNodes = new HashMap<String, TSNode>();
                        childGraph.setAttribute(JOB_NODES, jobNodes);
                    } else {
                        jobNodes = (HashMap<String, TSNode>)childGraph.getAttributeValue(JOB_NODES);
                    }
                    TSNode prevNode = null;
                    if (result[5] != null) {
                        String prevKey = this.getUniqueKeyForJob(result[5], result[4], this.ezsourcePrj.getName());
                        prevNode = (TSNode)jobNodes.get(prevKey);
                    }
                    if ((succNode = (TSNode)jobNodes.get(succKey = this.getUniqueKeyForJob(result[2], result[1], this.ezsourcePrj.getName()))) == null) {
                        succNode = this.graphManager.getNodeBuilder().addNode((TSEGraph)childGraph);
                        TSESVGImage image = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"JCLJob.svg");
                        succNode.setAttribute("uiImage", (Object)image);
                        TSEColor fillColor = new TSEColor(0, 0, 128);
                        TSEColor txtColor = TSEColor.white;
                        this.setNodeUI(succNode, fillColor, txtColor);
                        succNode.setName((Object)(String.valueOf(result[0]) + " - " + result[1]));
                        succNode.setAttribute("PARENT", (Object)networkNode);
                        this.putEntryInGraphInventory(networkNode, (TSENode)succNode);
                        jobNodes.put(succKey, succNode);
                        succNode.setAttribute(NODES_TO_FOLD_LIST, jobNodes.values());
                        succNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(String.valueOf(result[0]) + " - " + result[1], ResultElementType.JCL_JOB.getDisplayName()));
                        this.createJobInputType(succNode, result[0], result[2], jobInJCLMap, jclJobsNodes, this.ezsourcePrj);
                    }
                    if (prevNode != null) {
                        childGraph.addEdge(prevNode, succNode);
                    }
                }
                ++n;
            }
        }
        this.analysis.addContextValue(JOBS_IN_NETWORKS, null);
        return jclJobsNodes;
    }

    private void createJobTriggerEdge(TSENode jclJobNode, TSENode netwNode, String flagName, TextSelectionInFile sel) {
        boolean found = false;
        List edges = jclJobNode.buildInAndOutEdges();
        for (TSEEdge edge : edges) {
            if (!edge.getTargetNode().equals(netwNode)) continue;
            if (edge.getLabels() == null || edge.getLabels().size() <= 0) break;
            TSEEdgeLabel label = (TSEEdgeLabel)edge.getLabels().get(0);
            found = label.getName().equals(flagName);
            break;
        }
        if (!found) {
            TSEEdge edge;
            edge = this.graphManager.getEdgeBuilder().addEdge(this.graphManager, jclJobNode, netwNode);
            TSEEdgeLabel tseLabel = this.graphManager.getLabelBuilder().addEdgeLabel(edge);
            tseLabel.setName((Object)flagName);
            double centerY = edge.getBounds().getCenterY();
            double centerX = edge.getBounds().getCenterX();
            tseLabel.getAttachmentPoint();
            tseLabel.setCenterY(centerY);
            tseLabel.setCenterX(centerX);
            HashSet<TextSelectionInFile> set = new HashSet<TextSelectionInFile>();
            set.add(sel);
            edge.setAttribute("FILE", set);
            edge.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
            edge.setAttribute("Edge_Style", (Object)3);
        }
    }

    private void createJobInputType(TSNode node, String jobName, String aautoJobId, Map<String, String[]> jobInJCLMap, Map<String, List<TSENode>> jclJobsNodes, ProjectInfo ezsourcePrj) {
        boolean isJCL = jobInJCLMap != null && jobInJCLMap.containsKey(jobName);
        int type = isJCL ? 22 : 301;
        EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(type), "EZ_OBJECT_TYPE_FOR_MAINFRAME");
        EZEntityID entityId = new EZEntityID();
        entityId.addSegment((EZSegment)new EZSourceProjectIDSg(ezsourcePrj));
        if (isJCL) {
            String[] jclJobDetails = jobInJCLMap.get(jobName);
            EZSourceJobIDSg jclJobSg = new EZSourceJobIDSg(jobName, jclJobDetails[0], Integer.valueOf(22), jclJobDetails[2]);
            jclJobSg.setDeleted(!"1".equals(jclJobDetails[8]));
            entityId.addSegment((EZSegment)jclJobSg);
            inputType.addProperty("mainframe resource id sg", (Object)jclJobSg);
            HashSet<TextSelectionInFile> set = new HashSet<TextSelectionInFile>();
            set.add(new TextSelectionInFile(jclJobDetails[7], this.JCL_EDITOR_AS_STRING, new String[]{jclJobDetails[3], jclJobDetails[4], jclJobDetails[5], jclJobDetails[6]}));
            node.setAttribute("FILE", set);
            node.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
            List<TSENode> nodes = jclJobsNodes.get(jclJobDetails[0]);
            if (nodes == null) {
                nodes = new ArrayList<TSENode>();
                jclJobsNodes.put(jclJobDetails[0], nodes);
            }
            nodes.add((TSENode)node);
        }
        EZSourceAAUTOJobIDSg aautoJobSg = new EZSourceAAUTOJobIDSg(jobName, Integer.valueOf(aautoJobId));
        entityId.addSegment((EZSegment)aautoJobSg);
        inputType.setEntID(entityId);
        node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
        node.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(jobName, ResultElementType.JCL_JOB.getDisplayName()));
    }

    private void createNetworkInputType(TSENode node, Network network, ProjectInfo ezsourcePrj) {
        EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(300), "EZ_OBJECT_TYPE_FOR_MAINFRAME");
        AAUTONetworkIDSg networkSg = new AAUTONetworkIDSg(Integer.valueOf(network.getNetworkid()), network.getNetworkName(), network.getNetwkExpandedName());
        inputType.setName(network.getNetworkName());
        EZEntityID entityId = new EZEntityID();
        entityId.addSegment((EZSegment)new EZSourceProjectIDSg(ezsourcePrj));
        entityId.addSegment((EZSegment)networkSg);
        inputType.setEntID(entityId);
        node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
        node.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(network.getNetworkName(), ResultElementType.NETWORK.getDisplayName()));
    }

    private String getUniqueKeyForJob(String jobid, String jobNumber, String prjName) {
        return String.valueOf(prjName) + "#" + jobid + "#" + jobNumber;
    }

    private void processResults(Map<String, Network> networks, Map<String, Pair<String, String>> networksGoToSourceInfo, Map<String, TSENode> networkTSNodes, boolean isBackward) {
        String[][] results = null;
        String key = FORWARD_RESULTS;
        if (isBackward) {
            key = BACKWARD_RESULTS;
        }
        if ((results = (String[][])this.analysis.getContextValue(key)) != null) {
            TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                String prevNetworkId = result[0];
                String tgtNetworkId = result[1];
                boolean isInput = prevNetworkId != null && tgtNetworkId == null;
                TSENode prevNetworkNode = this.getOrCreateTSNode(prevNetworkId, result, isBackward, isInput, networks, networksGoToSourceInfo, networkTSNodes, this.ezsourcePrj);
                isInput = tgtNetworkId != null && prevNetworkId == null;
                TSENode tgtNetworkNode = this.getOrCreateTSNode(tgtNetworkId, result, isBackward, isInput, networks, networksGoToSourceInfo, networkTSNodes, this.ezsourcePrj);
                if (prevNetworkNode != null && tgtNetworkNode != null) {
                    TSEEdge edge = null;
                    List outs = prevNetworkNode.outEdges();
                    for (TSEEdge ed : outs) {
                        if (!ed.getTargetNode().equals(tgtNetworkNode)) continue;
                        edge = ed;
                        break;
                    }
                    if (edge == null) {
                        edgeBuilder.addEdge(this.graphManager, prevNetworkNode, tgtNetworkNode);
                    }
                }
                ++n2;
            }
        }
        this.analysis.addContextValue(key, null);
    }

    private void processTriggeredNetworks(Map<String, Network> networks, Map<String, TSENode> networkTSNodes, Map<String, List<TSENode>> jclJobsNodes, Map<String, Pair<String, String>> networksGoToSourceInfo) {
        String[][] netwsWithFlag;
        this.labelsInfoForMetaEdges = new HashMap<Pair<TSENode, TSENode>, List<String>>();
        boolean resultsFromExternalProjects = false;
        boolean withTriggeredNetws = false;
        if ((this.graphDirection.equals((Object)Direction.FORWARD) || this.graphDirection.equals((Object)Direction.BOTH)) && !jclJobsNodes.isEmpty() && (netwsWithFlag = (String[][])this.analysis.getContextValue(NETWORKS_WITH_FLAG_FW)) != null) {
            withTriggeredNetws = true;
            String[][] stringArray = netwsWithFlag;
            int n = netwsWithFlag.length;
            int n2 = 0;
            while (n2 < n) {
                String[] netwWithFlag = stringArray[n2];
                TSENode netwNode = networkTSNodes.get(netwWithFlag[0]);
                if (netwNode == null) {
                    netwNode = this.getOrCreateTSNode(netwWithFlag[0], null, false, false, networks, networksGoToSourceInfo, networkTSNodes, this.ezsourcePrj);
                }
                TextSelectionInFile sel = new TextSelectionInFile(netwWithFlag[3], this.JCL_EDITOR_AS_STRING, new String[]{netwWithFlag[4], netwWithFlag[5], netwWithFlag[6], netwWithFlag[7]});
                List<TSENode> jclNodes = jclJobsNodes.get(netwWithFlag[2]);
                TSENode parentNetw = null;
                for (TSENode jclNode : jclNodes) {
                    this.createJobTriggerEdge(jclNode, netwNode, netwWithFlag[1], sel);
                    if (parentNetw != null) continue;
                    parentNetw = (TSENode)jclNode.getAttributeValue("PARENT");
                }
                this.computeMetaEdgeInfo(netwWithFlag[1], parentNetw, netwNode);
                ++n2;
            }
        }
        if (this.graphDirection.equals((Object)Direction.BOTH) || this.graphDirection.equals((Object)Direction.BACKWARD)) {
            Map flagsAndNets = (Map)this.analysis.getContextValue(NETWORKS_VS_FLAGS);
            Map resultsPerProject = (Map)this.analysis.getContextValue(NETWORKS_WITH_FLAG_BW);
            if (resultsPerProject != null) {
                withTriggeredNetws = true;
                for (ProjectInfo prjInfo : resultsPerProject.keySet()) {
                    String[][] results;
                    int n;
                    String[][] stringArray;
                    String[][] jobsInJCL;
                    String prj = prjInfo.getName();
                    boolean isCurrentPrj = this.ezsourcePrj.getName().equals(prj);
                    Map jobsInJCLMap = (Map)this.analysis.getContextValue(JOBS_IN_JCL);
                    HashMap<String, String[]> jobInJCLMap = new HashMap<String, String[]>();
                    if (jobsInJCLMap != null && (jobsInJCL = (String[][])jobsInJCLMap.get(prj)) != null) {
                        stringArray = jobsInJCL;
                        n = jobsInJCL.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String[] res = stringArray[n3];
                            jobInJCLMap.put(res[1], res);
                            ++n3;
                        }
                    }
                    stringArray = results = (String[][])resultsPerProject.get(prjInfo);
                    n = results.length;
                    int n4 = 0;
                    while (n4 < n) {
                        List netIDsFromCurrentGraph;
                        String jobKey;
                        Map jobNodes;
                        TSNode jobNode;
                        TSGraph childGraph;
                        String netwKey;
                        String[] result = stringArray[n4];
                        TSENode netnode = null;
                        String string = netwKey = !isCurrentPrj ? prj.concat("#").concat(result[0]) : result[0];
                        if (!networks.containsKey(netwKey)) {
                            Network networkModel = new Network(result[0], result[1], result[2]);
                            networks.put(netwKey, networkModel);
                        }
                        netnode = this.getOrCreateTSNode(netwKey, null, true, false, networks, networksGoToSourceInfo, networkTSNodes, prjInfo);
                        if (!isCurrentPrj) {
                            resultsFromExternalProjects = true;
                            TSESVGImage image = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"network_ext.svg");
                            netnode.setAttribute("uiImage", (Object)image);
                        }
                        if ((childGraph = netnode.getChildGraph()) == null) {
                            childGraph = this.graphManager.addGraph();
                            netnode.setChildGraph(childGraph);
                            childGraph.setAttribute(JOB_NODES, new HashMap());
                        }
                        if ((jobNode = (TSNode)(jobNodes = (Map)childGraph.getAttributeValue(JOB_NODES)).get(jobKey = this.getUniqueKeyForJob(result[4], result[5], prj))) == null) {
                            jobNode = this.graphManager.getNodeBuilder().addNode((TSEGraph)childGraph);
                            TSESVGImage image = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"JCLJob.svg");
                            jobNode.setAttribute("uiImage", (Object)image);
                            TSEColor fillColor = new TSEColor(0, 0, 128);
                            TSEColor txtColor = TSEColor.white;
                            this.setNodeUI(jobNode, fillColor, txtColor);
                            jobNode.setName((Object)(String.valueOf(result[6]) + "-" + result[5]));
                            jobNode.setAttribute("PARENT", (Object)netnode);
                            this.putEntryInGraphInventory(netnode, (TSENode)jobNode);
                            jobNodes.put(jobKey, jobNode);
                            jobNode.setAttribute(NODES_TO_FOLD_LIST, jobNodes.values());
                            jobNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(String.valueOf(result[6]) + " - " + result[5], ResultElementType.JCL_JOB.getDisplayName()));
                            this.createJobInputType(jobNode, result[6], result[4], jobInJCLMap, jclJobsNodes, prjInfo);
                        }
                        if ((netIDsFromCurrentGraph = (List)flagsAndNets.get(result[3])) != null && !netIDsFromCurrentGraph.isEmpty()) {
                            for (String netID : netIDsFromCurrentGraph) {
                                TSENode netNodeFromCurrentGraph = networkTSNodes.get(netID);
                                this.createJobTriggerEdge((TSENode)jobNode, netNodeFromCurrentGraph, result[3], new TextSelectionInFile(result[7], this.JCL_EDITOR_AS_STRING, new String[]{result[8], result[9], result[10], result[11]}));
                                this.computeMetaEdgeInfo(result[3], netnode, netNodeFromCurrentGraph);
                            }
                        }
                        ++n4;
                    }
                }
            }
        }
        if (withTriggeredNetws) {
            this.triggeringInfo = new ArrayList<Boolean>();
            this.triggeringInfo.add(resultsFromExternalProjects);
        }
    }

    private void computeMetaEdgeInfo(String flag, TSENode firstNode, TSENode secondNode) {
        List<String> flags;
        Pair pair;
        Set<Pair<TSENode, TSENode>> nodesPair = this.labelsInfoForMetaEdges.keySet();
        if (!nodesPair.contains(pair = new Pair((Object)firstNode, (Object)secondNode))) {
            this.labelsInfoForMetaEdges.put((Pair<TSENode, TSENode>)pair, new ArrayList());
        }
        if (!(flags = this.labelsInfoForMetaEdges.get(pair)).contains(flag)) {
            flags.add(flag);
        }
    }

    public List<Boolean> getTriggeringInfo() {
        return this.triggeringInfo;
    }

    protected void addLabelsForMetaEdges() {
        if (this.labelsInfoForMetaEdges != null && !this.labelsInfoForMetaEdges.isEmpty()) {
            for (Pair<TSENode, TSENode> nodesPair : this.labelsInfoForMetaEdges.keySet()) {
                TSEEdge metaedge = (TSEEdge)this.graphManager.getMetaEdge((TSDNode)nodesPair.getFirst(), (TSDNode)nodesPair.getSecond());
                if (metaedge == null || !metaedge.getLabels().isEmpty()) continue;
                TSEEdgeLabel tseLabel = this.graphManager.getLabelBuilder().addEdgeLabel(metaedge);
                double centerY = metaedge.getBounds().getCenterY();
                double centerX = metaedge.getBounds().getCenterX();
                tseLabel.setCenterY(centerY);
                tseLabel.setCenterX(centerX);
                List<String> labels = this.labelsInfoForMetaEdges.get(nodesPair);
                if (labels.size() == 1) {
                    tseLabel.setName((Object)labels.get(0));
                    tseLabel.setTooltipText(labels.get(0));
                    continue;
                }
                tseLabel.setName((Object)("#" + labels.size()));
                StringBuilder build = new StringBuilder();
                for (String labelStr : labels) {
                    build.append(labelStr).append("\n");
                }
                tseLabel.setTooltipText(build.toString());
            }
        }
    }

    private TSENode getOrCreateTSNode(String networkId, String[] result, boolean isBackward, boolean isInput, Map<String, Network> networks, Map<String, Pair<String, String>> networksGoToSourceInfo, Map<String, TSENode> networkTSNodes, ProjectInfo projectInfo) {
        TSENode networkNode = null;
        if (networkId != null && (networkNode = networkTSNodes.get(networkId)) == null) {
            networkNode = this.graphManager.getNodeBuilder().addNode(this.graph);
            if (isInput) {
                networkNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            }
            if (result != null) {
                Set networksWithChildren;
                Integer ord = Integer.valueOf(result[2]);
                this.addLevel(networkNode, isBackward ? -2 * ord : 2 * ord);
                if (this.graphLimitation != null && ord == this.graphLimitation && (networksWithChildren = (Set)this.analysis.getContextValue(NETWORKS_FROM_LIMIT_WITH_CHILDREN)).contains(networkId)) {
                    networkNode.setAttribute("node is not expanded, but can be expanded, in callgraph", (Object)Boolean.TRUE);
                    this.restrictionTypesSetForLegend.add(GraphRestrictionsLegendInfo.LIMIT_RESTRICTION);
                }
            }
            Network network = networks.get(networkId);
            boolean isCurrentPrj = this.ezsourcePrj.getName().equals(projectInfo.getName());
            String netwName = isCurrentPrj ? network.getNetworkName() : projectInfo.getName().concat(":").concat(network.getNetworkName());
            networkNode.setName((Object)netwName);
            String tooltipName = isCurrentPrj ? network.getEntireName() : projectInfo.getName().concat(":").concat(network.getEntireName());
            networkNode.setTooltipText(tooltipName);
            if (!isCurrentPrj) {
                networkNode.setAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY", (Object)network.getNetworkName());
            }
            networkTSNodes.put(networkId, networkNode);
            TSESVGImage image = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"network.svg");
            networkNode.setAttribute("uiImage", (Object)image);
            networkNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(network.getEntireName(), ResultElementType.NETWORK.getDisplayName()));
            TSEColor fillColor = TSEColor.gray;
            TSEColor txtColor = TSEColor.black;
            this.setNodeUI((TSNode)networkNode, fillColor, txtColor);
            networkNode.setAttribute(IS_TS_NODE_NETWORK, (Object)Boolean.TRUE);
            networkNode.setAttribute(NETWORK_NAME_KEY, (Object)network.getNetworkName());
            networkNode.setAttribute("mainframe project name", (Object)projectInfo.getName());
            this.putEntryInGraphInventory(projectInfo.getName(), networkNode);
            this.createNetworkInputType(networkNode, network, projectInfo);
            if (networksGoToSourceInfo != null && networksGoToSourceInfo.containsKey(networkId)) {
                Pair<String, String> goToSourceInfo = networksGoToSourceInfo.get(networkId);
                String line = (String)goToSourceInfo.getSecond();
                Integer lineInt = 0;
                if (line != null) {
                    lineInt = 1 + Integer.valueOf(line);
                }
                TextSelectionInFile textSelectionInFile = new TextSelectionInFile((String)goToSourceInfo.getFirst(), AAUTO_EDITOR_AS_STRING, new Integer[]{lineInt});
                HashSet<TextSelectionInFile> set = new HashSet<TextSelectionInFile>();
                set.add(textSelectionInFile);
                networkNode.setAttribute("FILE", set);
                networkNode.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
            }
        }
        return networkNode;
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
        }
        this.markSpecialNode((TSNode)node);
    }

    public void setNodeUI(TSNode node, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("Fill_Color", (Object)fillColor);
        if (textColor != null) {
            node.setAttribute("Color", (Object)textColor);
            if ("!svg".equals(node.getAttributeValue("uiStyle"))) {
                node.setAttribute("Text_Color", (Object)textColor);
            }
        }
        this.setNodeUI((TSENode)node);
    }

    private void putEntryInGraphInventory(Object parentNode, TSENode node) {
        if (parentNode instanceof String) {
            HashMap nodes = (HashMap)this.outForGISV.get(parentNode);
            if (nodes == null) {
                nodes = new HashMap();
                this.outForGISV.put(parentNode, nodes);
            }
            nodes.put(node, new HashSet());
        } else if (parentNode instanceof TSENode) {
            String prjName = (String)((TSENode)parentNode).getAttributeValue("mainframe project name");
            Map nodesTree = (Map)this.outForGISV.get(prjName);
            Set children = (Set)nodesTree.get(parentNode);
            children.add(node);
        }
    }

    private void markSpecialNode(TSNode node) {
        if (node.hasAttribute("node is input for callgraph") && ((Boolean)node.getAttributeValue("node is input for callgraph")).booleanValue()) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        }
        if (node.hasAttribute("node is not expanded, but can be expanded, in callgraph")) {
            node.setAttribute("expandable node", (Object)true);
        }
    }

    public TSCommand createCustomHLayoutCommand(TSDGraph graph, TSSwingCanvas canvass) {
        TSELayoutCommand layoutCommand = null;
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSLayoutInputTailor inputTaylor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        Set<Integer> keys = this.tsNodeLevels.keySet();
        ArrayList<Integer> keysList = new ArrayList<Integer>(keys);
        Collections.sort(keysList);
        L.debug("levels: {}", keysList);
        int i = 0;
        while (i < keysList.size() - 1) {
            Integer pos1 = (Integer)keysList.get(i);
            List<TSENode> list1 = this.tsNodeLevels.get(pos1);
            Integer pos2 = (Integer)keysList.get(i + 1);
            List<TSENode> list2 = this.tsNodeLevels.get(pos2);
            double distance = 100.0;
            inputTaylor.addSeparationConstraint(list1, list2, 3, distance, 0);
            inputTaylor.addAlignmentConstraint(list1, 1, 0, 0);
            ++i;
        }
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        if (canvas == null) {
            canvas = canvass;
        }
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        layoutPreferenceTailor.setDrawingFitToCanvas();
        layoutCommand = new TSELayoutCommand((TSEGraph)graph, (TSViewportCanvas)canvas, (TSServiceInputDataInterface)inputData, 1){

            protected TSBaseLayoutWorker createLayoutWorker() {
                return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                    public void processEventsAfterLayout() {
                        L.debug("nothing to process after layout");
                    }
                };
            }
        };
        layoutCommand.setCoalesced(true);
        return layoutCommand;
    }

    private void addLevel(TSENode tNode, Integer ord) {
        if (tNode.hasAttribute(LAYOUT_LEVEL)) {
            return;
        }
        List<TSENode> nodes = this.tsNodeLevels.get(ord);
        if (nodes == null) {
            nodes = new ArrayList<TSENode>();
            this.tsNodeLevels.put(ord, nodes);
        }
        nodes.add(tNode);
        tNode.setAttribute(LAYOUT_LEVEL, (Object)ord);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT")) {
            objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        }
        return objType;
    }

    public void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        block9: {
            String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block9;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("JCL to programs") || allAttrNames.toString().trim().equals("Sources") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (stmtType != null) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

