/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.IConnectionRunnable;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.graphs.aauto.AAutoContentProvider;
import com.ez.graphs.aauto.AAutoGraphModel;
import com.ez.graphs.aauto.AAutoMouseActionsHook;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.AAutoUtils;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.AAutoJob;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAutoGraphJob
extends GraphAnalysisJob
implements IConnectionRunnable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AAutoGraphJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;
    private Direction graphDirection;
    private Boolean isGraphLimited;
    private Integer graphLimitation = null;
    private static final String FORWARD_NETWORK_PROC_NAME = "EZViewer_AAuto_Graph_Forward";
    private static final String BACKWARD_NETWORK_PROC_NAME = "EZViewer_AAuto_Graph_Backward";
    private static final String NETWORK_DETAILS_PROC_NAME = "EZViewer_AAuto_Network_Details";
    private static final String JOBS_IN_NETWORKS_PROC_NAME = "EZViewer_AAuto_JobsInNetworks";
    private static final String NETWORKS_FOR_EACH_JOB_PROC_NAME = "EZViewer_AAuto_NetworksPerJob";
    private static final String NETWORKS_TRIGGERED_FORWARD_PROC = "EZViewer_AAuto_Graph_Networks_Triggered_Forward";
    private static final String NETWORKS_VS_FLAGS = "EZViewer_AAuto_Graph_NetworksVsFlags";
    private static final String NETWORKS_TRIGGERED_BACKWARD_PROC = "EZViewer_AAuto_Graph_Networks_Triggered_Backward";
    private static final int MAXNAMES = 2;

    public AAutoGraphJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new AAutoMouseActionsHook(id, this);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new AAutoGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("graph direction: {}", (Object)this.graphDirection);
        this.isGraphLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (this.isGraphLimited != null && this.isGraphLimited.booleanValue()) {
            this.graphLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("graph has limit: {}", (Object)this.graphLimitation);
        } else {
            L.debug("graph isn't limited");
        }
        this.graphModel = new AAutoGraphModel(new AnalysisGraphManager(), this.analysis, this.graphDirection, this.graphLimitation);
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            AAutoContentProvider icp = new AAutoContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        String ezsourcePrj = (String)this.analysis.getContextValue("input_project_names");
        IStatus status = Utils.collectDataFromBridge((IProgressMonitor)monitor, (String)ezsourcePrj, (IConnectionRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        }
    }

    private String getAAutoJobDetailsProc(ServerType dbEngine) {
        String tempTableName = com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)dbEngine, (String)"string_param_temp");
        return String.format("select JobId, JobName from AAUTOJobs where jobName in (select * from %s )", tempTableName);
    }

    private void fillInputs(EZSourceConnection conn, String project, List<AAutoJob> selectedJobs, List<AAutoNetwork> selectedNetworks, SubMonitor monitor) {
        String[][] network2;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        if (selectedJobs == null) {
            L.debug("aauto graph on networks");
        } else {
            int n;
            Boolean mustCompleteInputs = (Boolean)this.analysis.getContextValue("must complete aauto job id");
            if (mustCompleteInputs != null && mustCompleteInputs.booleanValue()) {
                L.debug("inputs have incomplete segments");
                HashSet<String> jobNames = new HashSet<String>();
                for (AAutoJob job : selectedJobs) {
                    jobNames.add(job.getJobName());
                }
                String[][] aautoJobs = Utils.runSQLQuery((EZSourceConnection)conn, (String)this.getAAutoJobDetailsProc(conn.getProjectInfo().getDbEngine()), jobNames, (EZSourceDataType)EZSourceDataType.String, (IProgressMonitor)pmonitor.newChild(100));
                if (aautoJobs != null) {
                    String[][] stringArray = aautoJobs;
                    n = aautoJobs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] result = stringArray[n2];
                        for (AAutoJob job : selectedJobs) {
                            if (!job.getJobName().equals(result[1]) || job.getJobId() != null) continue;
                            job.setResourceID(Integer.valueOf(result[0]));
                            L.debug("jcl job {} was matched with an aauto job having id {}", (Object)result[1], (Object)result[0]);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            HashMap<String[][], ArrayList<String>> jobInputInNetworks = new HashMap<String[][], ArrayList<String>>();
            HashSet allInputJobIDs = new HashSet();
            for (AAutoJob job : selectedJobs) {
                if (job.getJobId() != null) {
                    allInputJobIDs.add(job.getJobId());
                    continue;
                }
                L.debug("jcl job hasn't corresponding aauto job {}", (Object)job.getJobName());
            }
            if (!allInputJobIDs.isEmpty()) {
                AAutoJob jobInNetworksResult = Utils.runProc((EZSourceConnection)conn, (String)NETWORKS_FOR_EACH_JOB_PROC_NAME, (Collection)allInputJobIDs, (EZSourceDataType)EZSourceDataType.Integer);
                if (jobInNetworksResult != null) {
                    AAutoJob job;
                    job = jobInNetworksResult;
                    int n3 = ((String[][])job).length;
                    n = 0;
                    while (n < n3) {
                        String[] result = job[n];
                        String jobId = result[0];
                        String netId = result[1];
                        String name = result[2];
                        String netwkExpandedName = result[3];
                        network2 = new AAutoNetwork(Integer.valueOf(netId), name, netwkExpandedName);
                        if (selectedNetworks == null || selectedNetworks.contains(network2)) {
                            ArrayList<String> jobs = (ArrayList<String>)jobInputInNetworks.get(network2);
                            if (jobs == null) {
                                jobs = new ArrayList<String>();
                                jobInputInNetworks.put(network2, jobs);
                            }
                            jobs.add(jobId);
                        }
                        ++n;
                    }
                }
                this.analysis.addContextValue("jobInputInNetworks", jobInputInNetworks);
            }
            selectedNetworks = new ArrayList(jobInputInNetworks.keySet());
        }
        if (selectedNetworks.isEmpty()) {
            L.debug("graph without results");
        } else {
            String[] res;
            HashSet<String> networkIDsFromLimit;
            ArrayList<Integer> nwkIds = new ArrayList<Integer>();
            for (AAutoNetwork nwk : selectedNetworks) {
                nwkIds.add(nwk.getNetwkId());
            }
            boolean noLimit = this.graphLimitation == null;
            ParameterInfo[] pInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4)};
            Object[] params = new Object[]{noLimit ? null : this.graphLimitation};
            HashSet<Integer> allNetworkIDs = new HashSet<Integer>();
            HashSet<String> networksToMark = new HashSet<String>();
            this.analysis.addContextValue("networks from limit level with children", networksToMark);
            this.analysis.addContextValue("all_AAUTO_JOBS_MATCHED_IN_JCL", new HashMap());
            boolean markOnlyExpandable = WorkspacePrefUtils.getPreferenceStore().getBoolean("graphHighlightedOnlyExpandableAtLimit");
            if (!pmonitor.isCanceled() && (this.graphDirection.equals((Object)Direction.FORWARD) || this.graphDirection.equals((Object)Direction.BOTH))) {
                pmonitor.subTask(Messages.getString(AAutoGraphJob.class, "compute.forward.taskName"));
                String[][] forwardResults = com.ez.mainframe.data.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)FORWARD_NETWORK_PROC_NAME, (Object[])params, (ParameterInfo[])pInfo, nwkIds, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                if (forwardResults != null) {
                    networkIDsFromLimit = new HashSet<String>();
                    network2 = forwardResults;
                    int netwkExpandedName = forwardResults.length;
                    int name = 0;
                    while (name < netwkExpandedName) {
                        res = network2[name];
                        allNetworkIDs.add(Integer.valueOf(res[1]));
                        if (this.graphLimitation != null && Integer.valueOf(res[2]) == this.graphLimitation) {
                            networkIDsFromLimit.add(res[1]);
                        }
                        ++name;
                    }
                    if (markOnlyExpandable) {
                        this.collectNetworksWithChildren(conn, (IProgressMonitor)pmonitor, networkIDsFromLimit, networksToMark, true);
                    } else {
                        networksToMark.addAll(networkIDsFromLimit);
                    }
                }
                this.analysis.addContextValue("FORWARD", (Object)forwardResults);
            }
            if (!pmonitor.isCanceled() && (this.graphDirection.equals((Object)Direction.BACKWARD) || this.graphDirection.equals((Object)Direction.BOTH))) {
                pmonitor.subTask(Messages.getString(AAutoGraphJob.class, "compute.backward.taskName"));
                String[][] backResults = com.ez.mainframe.data.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)BACKWARD_NETWORK_PROC_NAME, (Object[])params, (ParameterInfo[])pInfo, nwkIds, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                if (backResults != null) {
                    networkIDsFromLimit = new HashSet();
                    network2 = backResults;
                    int netwkExpandedName = backResults.length;
                    int name = 0;
                    while (name < netwkExpandedName) {
                        res = network2[name];
                        allNetworkIDs.add(Integer.valueOf(res[0]));
                        if (this.graphLimitation != null && Integer.valueOf(res[2]) == this.graphLimitation) {
                            networkIDsFromLimit.add(res[0]);
                        }
                        ++name;
                    }
                    if (markOnlyExpandable) {
                        this.collectNetworksWithChildren(conn, (IProgressMonitor)pmonitor, networkIDsFromLimit, networksToMark, false);
                    } else {
                        networksToMark.addAll(networkIDsFromLimit);
                    }
                }
                this.analysis.addContextValue("BACKWARD", (Object)backResults);
            }
            if (!pmonitor.isCanceled()) {
                String[][] jobsInNetworks = Utils.runProc((EZSourceConnection)conn, (String)JOBS_IN_NETWORKS_PROC_NAME, allNetworkIDs, (EZSourceDataType)EZSourceDataType.Integer);
                this.analysis.addContextValue("all_JOBS_IN_NETWORKS", (Object)jobsInNetworks);
                if (!pmonitor.isCanceled() && jobsInNetworks != null) {
                    String[][] jclJobs;
                    HashSet<String> jobNames = new HashSet<String>();
                    network2 = jobsInNetworks;
                    int netwkExpandedName = jobsInNetworks.length;
                    int name = 0;
                    while (name < netwkExpandedName) {
                        String[] result = network2[name];
                        jobNames.add(result[0]);
                        ++name;
                    }
                    HashSet<Integer> jclJobsId = new HashSet<Integer>();
                    if (!jobNames.isEmpty() && (jclJobs = Utils.runProc((String)"EZReports_GatheringSources_JCL", jobNames, (EZSourceDataType)EZSourceDataType.String, (String)project)) != null) {
                        String[][] stringArray = jclJobs;
                        int n = jclJobs.length;
                        int network2 = 0;
                        while (network2 < n) {
                            String[] jcljobDetails = stringArray[network2];
                            jclJobsId.add(Integer.valueOf(jcljobDetails[0]));
                            ++network2;
                        }
                        Map jclJobsPerPrj = (Map)this.analysis.getContextValue("all_AAUTO_JOBS_MATCHED_IN_JCL");
                        ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
                        jclJobsPerPrj.put(ezsourcePrj.getName(), jclJobs);
                    }
                    this.collectNetworksTriggeredByFlags(conn, (IProgressMonitor)pmonitor, jclJobsId, allNetworkIDs);
                }
            }
            String[][] details = Utils.runProc((EZSourceConnection)conn, (String)NETWORK_DETAILS_PROC_NAME, allNetworkIDs, (EZSourceDataType)EZSourceDataType.Integer);
            this.analysis.addContextValue("NETWORK_DETAILS", (Object)details);
        }
    }

    private void collectNetworksWithChildren(EZSourceConnection conn, IProgressMonitor monitor, Set<String> networkIDsFromLimit, Set<String> networksWithChildren, boolean fw) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (!pmonitor.isCanceled() && !networkIDsFromLimit.isEmpty()) {
            ServerType serverType = conn.getProjectInfo().getDbEngine();
            String[][] aautoNetworksWithChildren = Utils.runSQLQuery((EZSourceConnection)conn, (String)(fw ? AAutoUtils.getNetworksUsedFwQuery((ServerType)serverType) : AAutoUtils.getNetworksUsedBwQuery((ServerType)serverType)), networkIDsFromLimit, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            if (!pmonitor.isCanceled() && aautoNetworksWithChildren != null) {
                String[][] stringArray = aautoNetworksWithChildren;
                int n = aautoNetworksWithChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    networksWithChildren.add(result[0]);
                    ++n2;
                }
            }
        }
    }

    public void runWithProgress(EZSourceConnection conn, IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        pmonitor.subTask(Messages.getString(AAutoGraphJob.class, "collecting.data"));
        List selectedJobs = this.analysis.getContextListValue("selectedJobs");
        List selectedNetworks = this.analysis.getContextListValue("selectedNetworks");
        Object path = this.analysis.getContextValue("selected path");
        String project = (String)this.analysis.getContextValue("project_name");
        if (path != null && !path.toString().trim().equals("")) {
            TSEGraph mainGraph = this.graphModel.getGraph();
            for (AAutoJob input : selectedJobs) {
                ArrayList<AAutoJob> singleJob = new ArrayList<AAutoJob>();
                singleJob.add(input);
                this.fillInputs(conn, project, singleJob, selectedNetworks, pmonitor);
                this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = this.graphModel.getGraph();
                ((AAutoGraphModel)this.graphModel).writeGraphToFile(newGraph, input.getJobName(), path.toString());
                newGraph.dispose();
            }
            this.graphModel.setGraph(mainGraph);
        } else {
            this.fillInputs(conn, project, selectedJobs, selectedNetworks, pmonitor);
        }
        pmonitor.done();
    }

    private void collectNetworksTriggeredByFlags(EZSourceConnection conn, IProgressMonitor monitor, Set<Integer> jclJobsId, Set<Integer> allNetworkIDs) {
        String[][] results;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (!pmonitor.isCanceled() && (this.graphDirection.equals((Object)Direction.FORWARD) || this.graphDirection.equals((Object)Direction.BOTH)) && !jclJobsId.isEmpty()) {
            results = Utils.runStoredProcedure((EZSourceConnection)conn, (String)NETWORKS_TRIGGERED_FORWARD_PROC, (Object[])new Object[0], jclJobsId, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.analysis.addContextValue("newtorks triggererd by flag(s), forward", (Object)results);
            if (!pmonitor.isCanceled() && results != null) {
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    String netID = result[0];
                    allNetworkIDs.add(Integer.valueOf(netID));
                    ++n2;
                }
            }
        }
        if (!pmonitor.isCanceled() && (this.graphDirection.equals((Object)Direction.BACKWARD) || this.graphDirection.equals((Object)Direction.BOTH))) {
            results = Utils.runProc((EZSourceConnection)conn, (String)NETWORKS_VS_FLAGS, allNetworkIDs, (EZSourceDataType)EZSourceDataType.Integer);
            ArrayList<String> flagsList = new ArrayList<String>();
            if (results != null) {
                HashMap<String, ArrayList<String>> networksWithFlags = new HashMap<String, ArrayList<String>>();
                String[][] stringArray = results;
                int netID = results.length;
                int n = 0;
                while (n < netID) {
                    String[] netWithFlags = stringArray[n];
                    String flagName = netWithFlags[2];
                    ArrayList<String> nets = (ArrayList<String>)networksWithFlags.get(flagName);
                    if (nets == null) {
                        nets = new ArrayList<String>();
                        networksWithFlags.put(flagName, nets);
                    }
                    nets.add(netWithFlags[0]);
                    ++n;
                }
                flagsList.addAll(networksWithFlags.keySet());
                this.analysis.addContextValue("networks vs flags, used for backward graph", networksWithFlags);
            }
            String[][] results1 = Utils.runProc((EZSourceConnection)conn, (String)NETWORKS_TRIGGERED_BACKWARD_PROC, flagsList, (EZSourceDataType)EZSourceDataType.String);
            HashMap<ProjectInfo, String[][]> resultsPerProjects = new HashMap<ProjectInfo, String[][]>();
            if (results1 != null) {
                ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
                resultsPerProjects.put(ezsourcePrj, results1);
                if (!pmonitor.isCanceled()) {
                    String[][] stringArray = results1;
                    int n = results1.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String[] result = stringArray[n3];
                        String netID = result[0];
                        allNetworkIDs.add(Integer.valueOf(netID));
                        ++n3;
                    }
                }
            }
            this.computeJobsTriggeringNetworksFromExternaProjects(resultsPerProjects, flagsList);
            this.analysis.addContextValue("newtorks triggererd by flag(s), backward", resultsPerProjects);
        }
    }

    private void computeJobsTriggeringNetworksFromExternaProjects(final Map<ProjectInfo, String[][]> resultsPerProjects, final List<String> flagsList) {
        List selectedPrjs = this.analysis.getContextListValue("selectedProjects");
        if (selectedPrjs != null && !selectedPrjs.isEmpty()) {
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            for (final ProjectInfo prjInfo : selectedPrjs) {
                IMFProjectHandler ph = service.getProjectHandler(prjInfo.getName(), null);
                try {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                            String[][] results = Utils.runProc((EZSourceConnection)conn, (String)AAutoGraphJob.NETWORKS_TRIGGERED_BACKWARD_PROC, (Collection)flagsList, (EZSourceDataType)EZSourceDataType.String);
                            ArrayList<String> jobNames = new ArrayList<String>();
                            if (results != null) {
                                resultsPerProjects.put(prjInfo, results);
                                String[][] stringArray = results;
                                int n = results.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String[] result = stringArray[n2];
                                    if (!jobNames.contains(result[6])) {
                                        jobNames.add(result[6]);
                                    }
                                    ++n2;
                                }
                            }
                            if (!jobNames.isEmpty()) {
                                List<EZSourceDataType> typess = Arrays.asList(new EZSourceDataType[jobNames.size()]);
                                Collections.fill(typess, EZSourceDataType.String);
                                String[][] jclJobs = conn.executeSQL("EZReports_GatheringSources_JCL", typess, jobNames);
                                Map jclJobsPerPrj = (Map)AAutoGraphJob.this.analysis.getContextValue("all_AAUTO_JOBS_MATCHED_IN_JCL");
                                jclJobsPerPrj.put(prjInfo.getName(), jclJobs);
                            }
                        }
                    }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException e) {
                    L.error("", (Throwable)e);
                }
                catch (ExecutionException e) {
                    L.error("", (Throwable)e);
                }
            }
        }
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((AAutoGraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph, this.canvas);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        Utils.setImageProvider((LegendPanel)legend);
        legend.placeLegendEntry("icons/legend/network_40.png", Messages.getString(AAutoGraphJob.class, "legend.label.network"));
        legend.placeLegendEntry("icons/legend/JCLJob.png", Messages.getString(AAutoGraphJob.class, "legend.label.JCLJob"));
        com.ez.gdb.core.utils.Utils.addRestrictionMarkersToLegend((LegendPanel)legend, (Set)this.graphModel.getRestrictionTypesForLegend());
        List<Boolean> triggeringInfo = ((AAutoGraphModel)this.graphModel).getTriggeringInfo();
        if (triggeringInfo != null) {
            legend.placeLegendEntry("icons/legend/rightDotBlackArrow.GIF", Messages.getString(AAutoGraphJob.class, "legend.label.flag"));
            if (triggeringInfo.get(0).booleanValue()) {
                legend.placeLegendEntry("icons/legend/network_ext_40.png", Messages.getString(AAutoGraphJob.class, "legend.label.network_ext"));
            }
        }
    }

    public class AAutoGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;
        private String tabName;

        public AAutoGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage("aautograph", "icons/network.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("aautograph");
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            ProjectInfo ezsourcePrj = (ProjectInfo)AAutoGraphJob.this.analysis.getContextValue("PROJECT_INFO");
            StringBuffer buff = new StringBuffer();
            List selected = AAutoGraphJob.this.analysis.getContextListValue("selectedJobs");
            if (selected == null) {
                selected = AAutoGraphJob.this.analysis.getContextListValue("selectedNetworks");
            }
            if (selected != null) {
                int idx = 0;
                int inptsSize = selected.size();
                for (BaseMainframeResourceInput net : selected) {
                    if (truncate && idx >= 2) {
                        int size = inptsSize - idx;
                        buff.append(Messages.getString(AAutoGraphJob.class, "more.lbl", new String[]{String.valueOf(size)}));
                        break;
                    }
                    ++idx;
                    buff.append(net.getName());
                    if (selected.indexOf(net) == selected.size() - 1) continue;
                    buff.append(", ");
                }
            }
            buff.append("(");
            buff.append(ezsourcePrj.getName());
            buff.append(")");
            buff.append(Messages.getString(AAutoGraphJob.class, "analysis.name"));
            this.tabName = buff.toString();
            return this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(this.tabName);
            if (AAutoGraphJob.this.graphDirection != null) {
                buf.append("; ");
                buf.append(AAutoGraphJob.this.graphDirection.toString());
            }
            if (AAutoGraphJob.this.isGraphLimited != null && AAutoGraphJob.this.isGraphLimited.booleanValue()) {
                buf.append("; ");
                buf.append(Messages.getString(AAutoGraphJob.class, "level.text"));
                buf.append(" " + AAutoGraphJob.this.graphLimitation);
            }
            return buf.toString();
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){
                private LegendPanel legend;

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    this.legend = new LegendPanel((Composite)sc, 0);
                    int uiStyle = AAutoGraphJob.this.graphModel.getUIStyle();
                    AAutoGraphJob.this.addEntriesToLegend(this.legend, uiStyle, AAutoGraphInfo.this.gfi);
                    sc.setContent((Control)this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    this.legend.pack();
                    sc.setMinSize(this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = this.legend.getSize().x;
                    int x = this.legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            AAutoGraphJob.this.legend = null;
            super.dispose();
        }
    }
}

