/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.graphs.ImpactMainPage;
import com.ez.graphs.internal.Messages;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AAutoGraphChoisePage
extends ImpactMainPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Button byJobChoice;
    private String selectionByJobsKey;
    private Button groupByAppButton;
    private boolean showJobOrNetGroup;

    protected AAutoGraphChoisePage(String pageName, String pagedesc, String selectionByJobsKey, boolean showJobOrNetGroup) {
        super(pageName, true, true);
        this.setTitle(Messages.getString(AAutoGraphChoisePage.class, "page.title"));
        this.setDescription(pagedesc);
        this.selectionByJobsKey = selectionByJobsKey;
        this.showJobOrNetGroup = showJobOrNetGroup;
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginTop = 50;
        gl.marginLeft = 40;
        gl.verticalSpacing = 30;
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        page.setLayoutData((Object)gd);
        page.setLayout((Layout)gl);
        if (this.showJobOrNetGroup) {
            Group byJobOrNetGroup = new Group(page, parent.getStyle());
            byJobOrNetGroup.setText(Messages.getString(AAutoGraphChoisePage.class, "desc.txt"));
            GridData data = new GridData(768);
            byJobOrNetGroup.setLayoutData((Object)data);
            gl = new GridLayout();
            byJobOrNetGroup.setLayout((Layout)gl);
            this.byJobChoice = new Button((Composite)byJobOrNetGroup, 16);
            this.byJobChoice.setText(Messages.getString(AAutoGraphChoisePage.class, "byJob.btn.txt"));
            Button byNetChoice = new Button((Composite)byJobOrNetGroup, 16);
            byNetChoice.setText(Messages.getString(AAutoGraphChoisePage.class, "byNet.btn.txt"));
            InputChoiceSelection ics = new InputChoiceSelection();
            this.byJobChoice.addSelectionListener((SelectionListener)ics);
            byNetChoice.addSelectionListener((SelectionListener)ics);
        }
        this.wizard = (PrepareReportWizard)this.getWizard();
        ImpactMainPage.ChoiceSelection cs = new ImpactMainPage.ChoiceSelection();
        this.createOptionsGroup(page, cs);
        this.setControl((Control)page);
    }

    private void createOptionsGroup(Composite parent, ImpactMainPage.ChoiceSelection cs) {
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setText(Messages.getString(AAutoGraphChoisePage.class, "graph.options.group"));
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setLayout((Layout)new GridLayout());
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        Composite limitComp = new Composite((Composite)optionsGroup, 0);
        limitComp.setLayoutData((Object)new GridData());
        limitComp.setLayout((Layout)new GridLayout(3, false));
        this.limitCheckboxButton = new Button(limitComp, 32);
        if (this.limitButtonText != null) {
            this.limitCheckboxButton.setText(this.limitButtonText);
        } else {
            this.limitCheckboxButton.setText(Messages.getString(AAutoGraphChoisePage.class, "limit.cg.btn.txt"));
        }
        this.limitCheckboxButton.setLayoutData((Object)new GridData());
        this.limitCheckboxButton.addSelectionListener((SelectionListener)cs);
        this.limitCheckboxButton.setSelection(isLimited);
        this.wizard.set("is graph limited", (Object)isLimited);
        this.thresholdLimit = new Text(limitComp, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AAutoGraphChoisePage.this.catchThresholdLimit();
                AAutoGraphChoisePage.this.setPageComplete(AAutoGraphChoisePage.this.isPageComplete());
            }
        });
        this.thresholdLimitLbl = new Label(limitComp, 0);
        this.thresholdLimitLbl.setText(Messages.getString(AAutoGraphChoisePage.class, "level.threshold.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        this.thresholdLimitLbl.setLayoutData((Object)data);
        this.thresholdLimit.getAccessible().addRelation(2, this.thresholdLimitLbl.getAccessible());
        this.thresholdLimitLbl.getAccessible().addRelation(3, this.thresholdLimit.getAccessible());
        this.thresholdLimit.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = AAutoGraphChoisePage.this.thresholdLimitLbl.getText();
            }
        });
        this.thresholdLimitLbl.setEnabled(isLimited);
        this.thresholdLimit.setEnabled(isLimited);
        Label lbl = new Label((Composite)optionsGroup, 258);
        data = new GridData(768);
        lbl.setLayoutData((Object)data);
        Composite directionComp = new Composite((Composite)optionsGroup, 0);
        directionComp.setLayoutData((Object)new GridData());
        directionComp.setLayout((Layout)new GridLayout(3, false));
        this.forwardButton = new Button(directionComp, 16);
        this.forwardButton.setText(Messages.getString(AAutoGraphChoisePage.class, "forward.btn.txt"));
        this.forwardButton.setLayoutData((Object)new GridData());
        this.forwardButton.addSelectionListener((SelectionListener)cs);
        this.forwardButton.setData((Object)Direction.FORWARD);
        this.forwardButton.setSelection(true);
        this.wizard.set("graph direction: forward or backward or both", (Object)Direction.FORWARD);
        this.backwardButton = new Button(directionComp, 16);
        this.backwardButton.setText(Messages.getString(AAutoGraphChoisePage.class, "backward.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        this.backwardButton.setLayoutData((Object)data);
        this.backwardButton.addSelectionListener((SelectionListener)cs);
        this.backwardButton.setData((Object)Direction.BACKWARD);
        this.backwardButton.setSelection(false);
        this.bothButton = new Button(directionComp, 16);
        this.bothButton.setText(Messages.getString(AAutoGraphChoisePage.class, "both.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        this.bothButton.setLayoutData((Object)data);
        this.bothButton.addSelectionListener((SelectionListener)cs);
        this.bothButton.setData((Object)Direction.BOTH);
        this.bothButton.setSelection(false);
        lbl = new Label((Composite)optionsGroup, 258);
        data = new GridData(768);
        data.horizontalSpan = 3;
        lbl.setLayoutData((Object)data);
        Composite groupByComp = new Composite((Composite)optionsGroup, 0);
        groupByComp.setLayout((Layout)new GridLayout());
        groupByComp.setLayoutData((Object)new GridData());
        this.groupByAppButton = new Button(groupByComp, 32);
        this.groupByAppButton.setLayoutData((Object)new GridData());
        this.groupByAppButton.setText(Messages.getString(AAutoGraphChoisePage.class, "collapse.txt"));
        SelectionAdapter groupByAppListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                AAutoGraphChoisePage.this.wizard.set("group jobs by networks", (Object)b.getSelection());
            }
        };
        this.groupByAppButton.addSelectionListener((SelectionListener)groupByAppListener);
        boolean defaultValuueGroupBy = true;
        this.groupByAppButton.setSelection(defaultValuueGroupBy);
        this.wizard.set("group jobs by networks", (Object)defaultValuueGroupBy);
    }

    @Override
    public boolean isPageComplete() {
        boolean ret = super.isPageComplete();
        if (ret && this.showJobOrNetGroup && this.wizard.getValue(this.selectionByJobsKey) == null) {
            ret = false;
        }
        return ret;
    }

    class InputChoiceSelection
    extends SelectionAdapter {
        InputChoiceSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            ((PrepareReportWizard)AAutoGraphChoisePage.this.getWizard()).set(AAutoGraphChoisePage.this.selectionByJobsKey, (Object)(AAutoGraphChoisePage.this.showJobOrNetGroup && AAutoGraphChoisePage.this.byJobChoice.getSelection() ? 1 : 0));
            AAutoGraphChoisePage.this.setPageComplete(true);
        }
    }
}

