/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.aauto;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.aauto.AAutoGraphJob;
import com.ez.graphs.aauto.NetworkInputsFilter;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.List;

public class AAutoGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected AAutoGraphJob job = null;
    List<ProjectInfo> projectsInfo;

    @Override
    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (AAutoGraphJob)wk.getJob(id, AAutoGraphJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            String prjName = null;
            for (Object inpObj : inputs) {
                if (inpObj instanceof EZSourceProjectInputType) {
                    prjName = ((EZSourceProjectInputType)inpObj).getName();
                    ProjectInfo pi = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                    this.addContextValue("PROJECT_INFO", pi);
                    continue;
                }
                EZObjectType ezObjectType = (EZObjectType)inpObj;
                EZEntityID entity = ezObjectType.getEntID();
                if (entity == null) continue;
                ProjectInfo pi = ((EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class)).getProjectInfo();
                this.addContextValue("PROJECT_INFO", pi);
                prjName = pi.getName();
                break;
            }
            this.addContextValue("input_list", inputs);
            this.addContextValue("input_project_names", prjName);
        }
    }

    @Override
    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public String getLabelType() {
        return Messages.getString(AAutoGraphAnalysis.class, "property.lbl");
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_AAUTO_GRAPH_ANALYSIS;
    }

    @Override
    protected InputsFilter getInputsFilter() {
        NetworkInputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        iFilter = inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType ? new NetworkInputsFilter() : new NetworkInputsFilter(inputs);
        iFilter.setAnalysis(this);
        return iFilter;
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        Object prj1 = this.getContextValue("PROJECT_INFO");
        Object prj2 = a2.getContextValue("PROJECT_INFO");
        boolean bl = ret = this.type.equals((Object)a2.getType()) && prj1.equals(prj2);
        if (ret) {
            List job1 = this.getContextListValue("selectedJobs");
            List job2 = a2.getContextListValue("selectedJobs");
            if (job1 != null) {
                ret = job2 != null && job1.equals(job2);
            } else {
                boolean bl2 = ret = job2 == null;
            }
            if (ret) {
                if (job1 == null) {
                    List net1 = this.getContextListValue("selectedNetworks");
                    List net2 = a2.getContextListValue("selectedNetworks");
                    if (net1 != null) {
                        ret = net2 != null && net1.equals(net2);
                    } else {
                        boolean bl3 = ret = net2 == null;
                    }
                }
                if (ret) {
                    Direction cgDirection = (Direction)this.getContextValue("graph direction: forward or backward or both");
                    cgDirection = cgDirection == null ? Direction.BOTH : cgDirection;
                    Direction cgDirection1 = (Direction)a2.getContextValue("graph direction: forward or backward or both");
                    Direction direction = cgDirection1 = cgDirection1 == null ? Direction.BOTH : cgDirection1;
                    if (!cgDirection.equals((Object)cgDirection1)) {
                        ret = false;
                    }
                    if (ret) {
                        Boolean isLimited1 = (Boolean)this.getContextValue("is graph limited");
                        isLimited1 = isLimited1 == null ? false : isLimited1;
                        Boolean isLimited2 = (Boolean)a2.getContextValue("is graph limited");
                        if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
                            ret = false;
                        }
                        if (ret && isLimited1.booleanValue()) {
                            Integer cgLimitation1 = (Integer)this.getContextValue("limit number for graph levels");
                            Integer cgLimitation2 = (Integer)a2.getContextValue("limit number for graph levels");
                            if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                                ret = false;
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    public void setAvailableprojectsInfo(List<ProjectInfo> projectsInfo) {
        this.projectsInfo = projectsInfo;
    }
}

