/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs;

import com.ez.graphs.internal.Messages;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SettingsCallgraphPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private boolean showSelectDirection = true;
    private boolean showLimitCg = true;
    protected Button backwardButton;
    protected Button forwardButton;
    protected Button bothButton;
    protected Button limitCgButton;
    protected Text thresholdLimit;
    protected Label thresholdLimitLbl;
    private static final String errorMsg = Messages.getString(SettingsCallgraphPage.class, "level.thresold.error");
    private String limitGroupButtonText = null;
    protected String limitGraphLblText = null;

    public SettingsCallgraphPage(String pageName, boolean showSelectDirection, boolean showLimitCg) {
        super(pageName);
        this.showSelectDirection = showSelectDirection;
        this.showLimitCg = showLimitCg;
    }

    protected void createContent(Composite composite) {
        ChoiceSelection cs = new ChoiceSelection();
        Composite fakeParent = new Composite(composite, composite.getStyle());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 45;
        fakeParent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 50;
        gl.marginRight = 5;
        fakeParent.setLayout((Layout)gl);
        if (this.showSelectDirection) {
            this.createDirectionGroup(fakeParent, cs);
        }
        if (this.showLimitCg) {
            this.createLimitGroup(fakeParent, cs);
        }
    }

    private void createLimitGroup(Composite parent, ChoiceSelection cs) {
        Group limitGroup = new Group(parent, parent.getStyle());
        if (this.limitGroupButtonText != null) {
            limitGroup.setText(this.limitGroupButtonText);
        } else {
            limitGroup.setText(Messages.getString(SettingsCallgraphPage.class, "limit.group.txt"));
        }
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 16384;
        data.minimumWidth = 300;
        limitGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(2, false);
        limitGroup.setLayout((Layout)gl);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.limitCgButton = new Button((Composite)limitGroup, 32);
        if (this.limitGraphLblText != null) {
            this.limitCgButton.setText(this.limitGraphLblText);
        } else {
            this.limitCgButton.setText(Messages.getString(SettingsCallgraphPage.class, "limit.cg.btn.txt"));
        }
        data = new GridData();
        data.horizontalSpan = 2;
        this.limitCgButton.setLayoutData((Object)data);
        this.limitCgButton.addSelectionListener((SelectionListener)cs);
        this.limitCgButton.setSelection(isLimited);
        this.wizard.set("is graph limited", (Object)isLimited);
        this.thresholdLimitLbl = new Label((Composite)limitGroup, 0);
        this.thresholdLimitLbl.setText(Messages.getString(SettingsCallgraphPage.class, "level.threshold.txt"));
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        this.thresholdLimitLbl.setLayoutData((Object)data);
        this.thresholdLimit = new Text((Composite)limitGroup, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SettingsCallgraphPage.this.catchThresholdLimit();
                SettingsCallgraphPage.this.setPageComplete(SettingsCallgraphPage.this.isPageComplete());
            }
        });
        this.thresholdLimitLbl.setEnabled(isLimited);
        this.thresholdLimit.setEnabled(isLimited);
    }

    private void createDirectionGroup(Composite parent, ChoiceSelection cs) {
        Group settingsGroup = new Group(parent, parent.getStyle());
        settingsGroup.setText(Messages.getString(((Object)((Object)this)).getClass(), "direction.group.txt"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 16384;
        data.minimumWidth = 300;
        settingsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 20;
        settingsGroup.setLayout((Layout)gl);
        this.forwardButton = new Button((Composite)settingsGroup, 16);
        this.forwardButton.setText(Messages.getString(SettingsCallgraphPage.class, "forward.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        this.forwardButton.setLayoutData((Object)data);
        this.forwardButton.addSelectionListener((SelectionListener)cs);
        this.forwardButton.setData((Object)Direction.FORWARD);
        this.forwardButton.setSelection(true);
        this.wizard.set("graph direction: forward or backward or both", (Object)Direction.FORWARD);
        this.backwardButton = new Button((Composite)settingsGroup, 16);
        this.backwardButton.setText(Messages.getString(SettingsCallgraphPage.class, "backward.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        this.backwardButton.setLayoutData((Object)data);
        this.backwardButton.addSelectionListener((SelectionListener)cs);
        this.backwardButton.setData((Object)Direction.BACKWARD);
        this.backwardButton.setSelection(false);
        this.bothButton = new Button((Composite)settingsGroup, 16);
        this.bothButton.setText(Messages.getString(SettingsCallgraphPage.class, "both.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        this.bothButton.setLayoutData((Object)data);
        this.bothButton.addSelectionListener((SelectionListener)cs);
        this.bothButton.setData((Object)Direction.BOTH);
        this.bothButton.setSelection(false);
    }

    public boolean isPageComplete() {
        boolean ret = true;
        if (this.showSelectDirection && this.wizard.getValue("graph direction: forward or backward or both") == null) {
            ret = false;
        }
        if (ret && this.showLimitCg && Boolean.TRUE.equals(this.wizard.getValue("is graph limited")) && this.wizard.getValue("limit number for graph levels") == null) {
            ret = false;
        }
        return ret;
    }

    public void setLimitGraphText(String limitGroupButtonText, String limitGraphLblText) {
        this.limitGroupButtonText = limitGroupButtonText;
        this.limitGraphLblText = limitGraphLblText;
    }

    protected void catchThresholdLimit() {
        block6: {
            String text = this.thresholdLimit.getText();
            Integer threshold = null;
            try {
                try {
                    threshold = Integer.valueOf(text);
                    if (threshold < 0) {
                        this.setErrorMessage(errorMsg);
                        break block6;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    this.wizard.set("limit number for graph levels", (Object)threshold);
                }
            }
            finally {
                this.wizard.set("limit number for graph levels", (Object)threshold);
            }
        }
    }

    public class ChoiceSelection
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (!b.equals(SettingsCallgraphPage.this.limitCgButton) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                SettingsCallgraphPage.this.wizard.set("graph direction: forward or backward or both", (Object)direction);
            }
            if (b.equals(SettingsCallgraphPage.this.limitCgButton) && SettingsCallgraphPage.this.showLimitCg) {
                boolean isCgLimited = SettingsCallgraphPage.this.limitCgButton.getSelection();
                SettingsCallgraphPage.this.wizard.set("is graph limited", (Object)isCgLimited);
                SettingsCallgraphPage.this.thresholdLimitLbl.setEnabled(isCgLimited);
                SettingsCallgraphPage.this.thresholdLimit.setEnabled(isCgLimited);
                if (isCgLimited) {
                    SettingsCallgraphPage.this.catchThresholdLimit();
                } else {
                    SettingsCallgraphPage.this.wizard.set("limit number for graph levels", null);
                    SettingsCallgraphPage.this.setErrorMessage(null);
                }
            }
            SettingsCallgraphPage.this.setPageComplete(SettingsCallgraphPage.this.isPageComplete());
        }
    }
}

