/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainframeGraphAnalysis
extends AbstractAnalysis {
    private static final Logger L = LoggerFactory.getLogger(MainframeGraphAnalysis.class);

    public MainframeGraphAnalysis() {
        this.addContextValue("JOB_BELONGS_TO", "GRAPH_JOB");
    }

    public void setInputs(List inputs) {
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        if (inputs != null) {
            String prjName = null;
            for (Object inpObj : inputs) {
                if (inpObj instanceof EZSourceProjectInputType) {
                    prjName = ((EZSourceProjectInputType)inpObj).getName();
                    this.addContextValue("input_list", inputs);
                    ProjectInfo pi = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                    this.addContextValue("PROJECT_INFO", pi);
                    continue;
                }
                EZEntityID entity = ((EZObjectType)inpObj).getEntID();
                list.add(entity);
                if (entity == null) continue;
                ProjectInfo pi = ((EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class)).getProjectInfo();
                this.addContextValue("PROJECT_INFO", pi);
                prjName = pi.getName();
            }
            if (!list.isEmpty()) {
                this.addContextValue("input_list", list);
            }
            this.addContextValue("input_project_names", prjName);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        List inputs1 = this.getContextListValue("input_list");
        List inputs2 = a2.getContextListValue("input_list");
        boolean ret = this.type.equals((Object)a2.getType()) && inputs1.equals(inputs2);
        return ret;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    protected EZEntityID makeID() {
        return null;
    }

    public boolean scopeIsShared() {
        return false;
    }

    public boolean filterInputs() {
        boolean ret = false;
        InputsFilter iFilter = this.getInputsFilter();
        if (iFilter != null) {
            ret = iFilter.filter((AbstractAnalysis)this);
        }
        return ret;
    }

    protected InputsFilter getInputsFilter() {
        ProjectInputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            iFilter = new ProjectInputsFilter();
        }
        return iFilter;
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }
}

