/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs;

import com.ez.graphs.internal.Messages;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImpactMainPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private boolean showSelectDirection = true;
    private boolean showLimitCg = true;
    private boolean showLimitResources = false;
    protected Button backwardButton;
    protected Button forwardButton;
    protected Button bothButton;
    protected Button limitCheckboxButton;
    protected Button limitResourcesButton;
    protected Text thresholdLimit;
    protected Label thresholdLimitLbl;
    private static final String errorMsg = Messages.getString(ImpactMainPage.class, "level.thresold.error");
    private String limitGroupText = null;
    protected String limitButtonText = null;
    private String directionGroupText = null;

    public ImpactMainPage(String pageName, boolean showSelectDirection, boolean showLimitCg) {
        super(pageName);
        this.showSelectDirection = showSelectDirection;
        this.showLimitCg = showLimitCg;
    }

    public ImpactMainPage(String pageName, boolean showSelectDirection, boolean showLimitCg, boolean showLimitResources) {
        this(pageName, showSelectDirection, showLimitCg);
        this.showLimitResources = showLimitResources;
    }

    protected void createContent(Composite composite) {
        ChoiceSelection cs = new ChoiceSelection();
        Composite fakeParent = new Composite(composite, composite.getStyle());
        GridData data = new GridData(4);
        data.horizontalIndent = 45;
        fakeParent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 50;
        gl.marginRight = 5;
        fakeParent.setLayout((Layout)gl);
        if (this.showSelectDirection || this.showLimitCg) {
            this.createDirectionGroup(fakeParent, cs);
        }
        if (this.showLimitResources) {
            this.createRestrictionsGroup(fakeParent, cs);
        }
    }

    private void createRestrictionsGroup(Composite parent, ChoiceSelection cs) {
        Group limitGroup = new Group(parent, parent.getStyle());
        if (this.limitGroupText != null) {
            limitGroup.setText(this.limitGroupText);
        } else {
            limitGroup.setText(Messages.getString(ImpactMainPage.class, "limit.group.txt"));
        }
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 16384;
        limitGroup.setLayoutData((Object)data);
        FormLayout fl = new FormLayout();
        limitGroup.setLayout((Layout)fl);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        boolean value = store.getBoolean("callgraphWithoutResources");
        this.limitResourcesButton = new Button((Composite)limitGroup, 32);
        if (this.limitButtonText != null) {
            this.limitResourcesButton.setText(this.limitButtonText);
        } else {
            this.limitResourcesButton.setText(Messages.getString(ImpactMainPage.class, "limit.resources.btn.txt"));
        }
        FormData fdata2 = new FormData();
        fdata2.top = new FormAttachment((Control)this.limitCheckboxButton, 15, 16384);
        this.limitResourcesButton.setLayoutData((Object)fdata2);
        this.limitResourcesButton.addSelectionListener((SelectionListener)cs);
        this.limitResourcesButton.setSelection(value);
        this.wizard.set("graph without resources", (Object)value);
        final Group resGroup = new Group((Composite)limitGroup, 0);
        GridLayout gl = new GridLayout(4, false);
        resGroup.setLayout((Layout)gl);
        resGroup.setText("Resources");
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(83, 0);
        fd.top = new FormAttachment((Control)this.limitResourcesButton, 5);
        resGroup.setLayoutData((Object)fd);
        resGroup.setEnabled(!value);
        for (final String lbl : Utils.resourceTypesLbl.keySet()) {
            Button button = new Button((Composite)resGroup, 32);
            button.setText(lbl);
            boolean isChecked = store.getBoolean(lbl);
            this.addResStateToWizard(lbl, isChecked);
            button.setSelection(isChecked);
            button.setEnabled(!value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button sourceBtn = (Button)e.getSource();
                    ImpactMainPage.this.addResStateToWizard(lbl, sourceBtn.getSelection());
                }
            });
        }
        this.limitResourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                resGroup.setEnabled(!ImpactMainPage.this.limitResourcesButton.getSelection());
                Control[] controlArray = resGroup.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setEnabled(!ImpactMainPage.this.limitResourcesButton.getSelection());
                    ++n2;
                }
            }
        });
    }

    private void addResStateToWizard(String btnLbl, boolean btnState) {
        HashMap<String, Boolean> states = this.wizard.getMap("graph resources checked or not");
        if (states == null) {
            states = new HashMap<String, Boolean>();
            this.wizard.set("graph resources checked or not", states);
        }
        states.put(btnLbl, btnState);
    }

    private void createDirectionGroup(Composite parent, ChoiceSelection cs) {
        Group directionGroup = new Group(parent, parent.getStyle());
        if (this.directionGroupText != null) {
            directionGroup.setText(this.directionGroupText);
        } else {
            directionGroup.setText(Messages.getString(((Object)((Object)this)).getClass(), "direction.group.txt"));
        }
        GridData data = new GridData(4);
        directionGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, true);
        gl.horizontalSpacing = 100;
        directionGroup.setLayout((Layout)gl);
        if (this.showSelectDirection) {
            this.forwardButton = new Button((Composite)directionGroup, 16);
            this.forwardButton.setText(Messages.getString(ImpactMainPage.class, "forward.btn.txt"));
            this.forwardButton.addSelectionListener((SelectionListener)cs);
            this.forwardButton.setData((Object)Direction.FORWARD);
            this.forwardButton.setSelection(true);
            this.wizard.set("graph direction: forward or backward or both", (Object)Direction.FORWARD);
            this.backwardButton = new Button((Composite)directionGroup, 16);
            this.backwardButton.setText(Messages.getString(ImpactMainPage.class, "backward.btn.txt"));
            this.backwardButton.addSelectionListener((SelectionListener)cs);
            this.backwardButton.setData((Object)Direction.BACKWARD);
            this.backwardButton.setSelection(false);
            this.bothButton = new Button((Composite)directionGroup, 16);
            this.bothButton.setText(Messages.getString(ImpactMainPage.class, "both.btn.txt"));
            this.bothButton.addSelectionListener((SelectionListener)cs);
            this.bothButton.setData((Object)Direction.BOTH);
            this.bothButton.setSelection(false);
        }
        if (this.showLimitCg) {
            Composite fakeGr = new Composite((Composite)directionGroup, parent.getStyle());
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalSpan = 3;
            data.minimumWidth = 480;
            fakeGr.setLayoutData((Object)data);
            FormLayout fl = new FormLayout();
            fakeGr.setLayout((Layout)fl);
            this.createLimitGroup(fakeGr, cs);
        }
    }

    private void createLimitGroup(Composite comp, ChoiceSelection cs) {
        Label sep = null;
        if (this.showSelectDirection) {
            sep = new Label(comp, 258);
            sep.setAlignment(16384);
            FormData fdata = new FormData();
            fdata.left = new FormAttachment(0, 0);
            fdata.right = new FormAttachment(100, 0);
            fdata.top = new FormAttachment((Control)comp, 10);
            sep.setLayoutData((Object)fdata);
        }
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.limitCheckboxButton = new Button(comp, 32);
        if (this.limitButtonText != null) {
            this.limitCheckboxButton.setText(this.limitButtonText);
        } else {
            this.limitCheckboxButton.setText(Messages.getString(ImpactMainPage.class, "limit.cg.btn.txt"));
        }
        FormData fdata = new FormData();
        fdata.top = new FormAttachment((Control)(sep != null ? sep : comp), 15);
        this.limitCheckboxButton.setLayoutData((Object)fdata);
        this.limitCheckboxButton.addSelectionListener((SelectionListener)cs);
        this.limitCheckboxButton.setSelection(isLimited);
        this.wizard.set("is graph limited", (Object)isLimited);
        this.thresholdLimitLbl = new Label(comp, 0);
        this.thresholdLimitLbl.setText(Messages.getString(ImpactMainPage.class, "level.threshold.txt"));
        fdata = new FormData();
        fdata.top = new FormAttachment((Control)this.limitCheckboxButton, 15);
        this.thresholdLimitLbl.setLayoutData((Object)fdata);
        this.thresholdLimit = new Text(comp, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        fdata = new FormData();
        fdata.top = new FormAttachment((Control)this.limitCheckboxButton, 15);
        fdata.left = new FormAttachment((Control)this.thresholdLimitLbl, 5);
        fdata.right = new FormAttachment(100, 0);
        this.thresholdLimit.setLayoutData((Object)fdata);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImpactMainPage.this.catchThresholdLimit();
                ImpactMainPage.this.setPageComplete(ImpactMainPage.this.isPageComplete());
            }
        });
        this.thresholdLimitLbl.setEnabled(isLimited);
        this.thresholdLimit.setEnabled(isLimited);
    }

    public boolean isPageComplete() {
        boolean ret = true;
        if (this.showSelectDirection && this.wizard.getValue("graph direction: forward or backward or both") == null) {
            ret = false;
        }
        if (ret && this.showLimitCg && Boolean.TRUE.equals(this.wizard.getValue("is graph limited")) && this.wizard.getValue("limit number for graph levels") == null) {
            ret = false;
        }
        return ret;
    }

    public void setLimitGraphText(String limitGroupButtonText, String limitGraphLblText) {
        this.limitGroupText = limitGroupButtonText;
        this.limitButtonText = limitGraphLblText;
    }

    public void setDirectionGroupText(String directionGroupText) {
        this.directionGroupText = directionGroupText;
    }

    protected void catchThresholdLimit() {
        block6: {
            String text = this.thresholdLimit.getText();
            Integer threshold = null;
            try {
                try {
                    threshold = Integer.valueOf(text);
                    if (threshold < 0) {
                        this.setErrorMessage(errorMsg);
                        break block6;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    this.wizard.set("limit number for graph levels", (Object)threshold);
                }
            }
            finally {
                this.wizard.set("limit number for graph levels", (Object)threshold);
            }
        }
    }

    public class ChoiceSelection
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if ((b.equals(ImpactMainPage.this.backwardButton) || b.equals(ImpactMainPage.this.forwardButton) || b.equals(ImpactMainPage.this.bothButton)) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                ImpactMainPage.this.wizard.set("graph direction: forward or backward or both", (Object)direction);
            }
            if (b.equals(ImpactMainPage.this.limitCheckboxButton) && ImpactMainPage.this.showLimitCg) {
                boolean isCgLimited = ImpactMainPage.this.limitCheckboxButton.getSelection();
                ImpactMainPage.this.wizard.set("is graph limited", (Object)isCgLimited);
                ImpactMainPage.this.thresholdLimitLbl.setEnabled(isCgLimited);
                ImpactMainPage.this.thresholdLimit.setEnabled(isCgLimited);
                if (isCgLimited) {
                    ImpactMainPage.this.catchThresholdLimit();
                } else {
                    ImpactMainPage.this.wizard.set("limit number for graph levels", null);
                    ImpactMainPage.this.setErrorMessage(null);
                }
            }
            if (b.equals(ImpactMainPage.this.limitResourcesButton)) {
                boolean isResourcesLimited = ImpactMainPage.this.limitResourcesButton.getSelection();
                ImpactMainPage.this.wizard.set("graph without resources", (Object)isResourcesLimited);
            }
            ImpactMainPage.this.setPageComplete(ImpactMainPage.this.isPageComplete());
        }
    }
}

