/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.utils;

import com.ez.cobol.callgraph.CallgraphEdgeLegendInfo;
import com.ez.cobol.callgraph.nodes.ParagraphNode;
import com.ez.cobol.callgraph.utils.CallgraphEdgeUtils;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CgBuilder;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.Target;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsFromPrg;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsToPrj;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.callgraph.ResourceLink;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphUtils.class);
    public static final String IMS_SEGMENT_TYPE = "IMSSegmentUsageInfo";
    public static final String IMS_SEGMENT_BY_PCB_TYPE_USAGE_INFO = "IMSPCBUsageInfo";
    public static final String IMS_MOD_TYPE = "IMSMODUsageInfo";
    public static final String IMS_TRAN_TYPE = "IMSTransactionUsageInfo";
    public static final String EXT_TRAN_USAGE_INFO = "ExtTranUsageInfo";
    public static final String EXT_IMSTRAN_USAGE_INFO = "ExtIMSTranUsageInfo";
    public static final String EXT_SQL_TABLE_USAGE_INFO = "ExtSQLUsageInfo";
    public static final String EXT_PROGRAM_USAGE_INFO = "ExtProgramUsageInfo";
    public static final String EXT_FILE_USAGE_INFO = "ExtFileUsageInfo";
    public static final String EXT_BMS_USAGE_INFO = "ExtBMSUsageInfo";
    public static final String EXT_IMS_MOD_USAGE_INFO = "ExtIMSMODUsageInfo";
    public static final String EXT_IMS_SEG_USAGE_INFO = "ExtIMSSegmentUsageInfo";
    public static final String CHILDREN_GRAPHS = "child_graphs";
    public static final String CG_OTHER_PRJ_ANALYSIS = "continueCG_otherPrj_analysis";
    public static final String RESTRICTION_RESOURCES = "while restrictions resources tag";
    public static final String LASTLEVEL_RESOURCES_TOMARK = "lastLevelResourcestoMark";
    public static final String IMS_GN_STMT_TYPE = "691";
    public static final String IMS_GNP_STMT_TYPE = "692";
    public static final String CICSREG_TR_QUERY = "SELECT MFCICSInfo.CICSName, MFCICSTransaction.TransCode \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSTransaction ON MFCICSGroupVsEntityLinks.TransID = MFCICSTransaction.TransID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 2) ";
    public static final String CICSREG_PRG_QUERY = "SELECT MFCICSInfo.CICSName, MFCICSProgram.ProgName \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSProgram ON MFCICSGroupVsEntityLinks.ProgID = MFCICSProgram.ProgID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 1) ";
    public static final String CICSREG_FILE_QUERY = "SELECT MFCICSInfo.CICSName, MFCICSFile.DDName \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSFile ON MFCICSGroupVsEntityLinks.FileID = MFCICSFile.FileID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 0) ";
    public static final String CICSREG_BMS_QUERY = "SELECT MFCICSInfo.CICSName, MFCICSMap.MapName \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSMap ON MFCICSGroupVsEntityLinks.MapID = MFCICSMap.MapID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 3) ";
    public static final String QUOTE = "'";
    public static Set<String> resourceTypes = new HashSet<String>(){
        {
            this.add("SQLUsageInfo");
            this.add("TranUsageInfo");
            this.add("FileUsageInfo");
            this.add("ScreenUsageInfo");
            this.add("MQManUsageInfo");
            this.add("MQQUsageInfo");
            this.add(GraphUtils.IMS_SEGMENT_TYPE);
            this.add("IMSTerminalUsageInfo");
            this.add(GraphUtils.IMS_TRAN_TYPE);
            this.add("IMSMqUsageInfo");
            this.add(GraphUtils.IMS_MOD_TYPE);
            this.add("AdabasFileUsageInfo");
            this.add("DatacomUsageInfo");
            this.add("DALUsageInfo");
            this.add("DBIUsageInfo");
            this.add("IDMSRecordUsageInfo");
            this.add("IDMSSetUsageInfo");
        }
    };
    public static Set<String> extCFResourceTypes = new HashSet<String>(){
        {
            this.add(GraphUtils.EXT_TRAN_USAGE_INFO);
            this.add(GraphUtils.EXT_IMSTRAN_USAGE_INFO);
            this.add(GraphUtils.EXT_PROGRAM_USAGE_INFO);
        }
    };
    public static Set<String> extDAResourceTypes = new HashSet<String>(){
        {
            this.add(GraphUtils.EXT_SQL_TABLE_USAGE_INFO);
            this.add(GraphUtils.EXT_FILE_USAGE_INFO);
            this.add(GraphUtils.EXT_BMS_USAGE_INFO);
            this.add(GraphUtils.EXT_IMS_MOD_USAGE_INFO);
            this.add(GraphUtils.EXT_IMS_SEG_USAGE_INFO);
        }
    };
    public static Set<String> extResourceTypes = new HashSet<String>(){
        {
            this.addAll(extCFResourceTypes);
            this.addAll(extDAResourceTypes);
        }
    };
    private static final String commandResource = "select prgRid, $stmt.@rid.asString() as stmtRid, bRead, $stmt.typeId as typeId, $stmt.codeBlockOrdinalNumber as codeBlockOrdinalNumber, out('ResourceLink')[0].@rid.asString() as proxyRid from @@@@@EZLEGACY@RESTYPE@@@@ \n let $stmt = in('Uses')[0] \n where bRead in [1,2] and prgRid in [@@@@@EZLEGACY@@@@] FETCHPLAN in_*:-2 out_*:-2 ";
    private static final String commandScrMapping = "select @rid.asString() as scrRid, $p.@rid.asString() as prgRid from GenericScreenProxy\nlet $p = out('ScreenMapping').out('ProxyFor')[0]\nwhere $p in [@@@@@EZLEGACY@@@@] FETCHPLAN in_*:-2 out_*:-2 ";
    private static final String commandExtResource = "select prgRid, $stmt.@rid.asString() as stmtRid, $stmt.typeId as typeId, $stmt.codeBlockOrdinalNumber as codeBlockOrdinalNumber, name.asString() as usageName, location, locationType, type, bRead, mapSet, dbName, out('ResourceLink')[0].@rid.asString() as proxyRid from @@@@@EZLEGACY@RESTYPE@@@@ \n let $stmt = in('Uses')[0] \n where prgRid in [@@@@@EZLEGACY@@@@] FETCHPLAN in_*:-2 out_*:-2 ";
    private static final String commandResourceFile = "select prgRid, out('ResourceLink')[0].asString() as ddNameProxy, @rid.asString() as usage, in('UsesFile').in('HasS').in('ProxyFor').out('InContext').@rid.asString() as pgmCtx, bRead, $stmt.@rid.asString() as stmtRid, bRead, $stmt.typeId as typeId, $stmt.codeBlockOrdinalNumber as codeBlockOrdinalNumber \nfrom FileUsageInfo \n let $stmt = in('UsesFile')[0] \n where  bRead in [1,2] and prgRid in [@@@@@EZLEGACY@@@@] and in('UsesFile')[0].typeId not in [12,29,122,1819,124,1821,118,1815]";
    private static final String commandFileCtx = "select prgRid, in.@rid.asString() as pgmCtx, in.out('ContextOf')[0].@rid.asString() as jclPgmRid \nfrom InContext  where prgRid in [@@@@@EZLEGACY@@@@] limit -1";
    private static final String commandDataset4 = "select set(in('ProxyFor').out('InContext').out('ContextOf').@rid).asString() as jclpgms from Program where @Rid in [ @@@@@EZLEGACY@@@@]";
    private static final String commandDataset3 = "select in.asString() as ddcard, out.asString() as ddNameProxy, jclPgmRid from ProxyFor where jclPgmRid in [@@@@@EZLEGACY@@@@]";
    private static final String commandResourceIMSSegment = "select prgRid, out('ResourceLink').out('IMSProxyOf').out('IMSSSource').@rid.asString() as physicalIMS,  $stmt.@rid.asString() as stmtRid, bRead, $stmt.typeId as typeId, $stmt.codeBlockOrdinalNumber as codeBlockOrdinalNumber, out('ResourceLink')[0].@rid.asString() as proxyRid   from IMSSegmentUsageInfo \n let $stmt = in('UsesIMSSegment')[0] \n where bRead in [1,2] and prgRid in [@@@@@EZLEGACY@@@@]";
    private static final String commandResourceIMSSegmentByPCB = "select prgRid, $stmt.@rid.asString() as stmtRid, $stmt.typeId as typeId, $stmt.codeBlockOrdinalNumber as codeBlockOrdinalNumber,  bRead, out('ResourceLink').@rid.asString() as proxyPCB from IMSPCBUsageInfo \n let $stmt = in('UsesIMSPCB')[0] \n where bRead in [3] and prgRid in [@@@@@EZLEGACY@@@@]";
    public static final String UE_MAP = "ue map";
    public static final String PROJECTS_TS_MAP_KEY = "Projects_TS_map";
    public static final String MF_PROJECT_SGS = "mf_projects_sgs";

    public static Map<String, Object> buildResources(String prjName, String usageInfo, OrientExtendedGraph ograph, StringBuilder sb, boolean withCB, boolean isIMSHierarchical, IProgressMonitor pmonitor) {
        HashMap<String, Object> results;
        block22: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(GraphUtils.class, "collectingResources.taskName", new String[]{usageInfo}));
            results = new HashMap<String, Object>();
            String query = null;
            CloseableIterable res = null;
            if (monitor.isCanceled()) break block22;
            switch (usageInfo) {
                case "FileUsageInfo": {
                    String jclPGM;
                    query = commandResourceFile.replace("@@@@@EZLEGACY@@@@", sb.toString());
                    query = query.replace("@@@@@EZLEGACY@RESTYPE@@@@", usageInfo);
                    res = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                    if (res == null || !res.iterator().hasNext()) break;
                    query = commandFileCtx.replace("@@@@@EZLEGACY@@@@", sb.toString());
                    CloseableIterable res1 = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                    HashMap<String, HashSet<String>> pgmCtxs = new HashMap<String, HashSet<String>>();
                    HashMap<String, String> jclMap = new HashMap<String, String>();
                    if (res1 != null && res1.iterator().hasNext()) {
                        for (OrientElement elem : res1) {
                            String prgRid = (String)elem.getProperty("prgRid");
                            String pgmCtx = (String)elem.getProperty("pgmCtx");
                            if (pgmCtx == null) continue;
                            Set<String> ctxSet = (Set)pgmCtxs.get(prgRid);
                            if (ctxSet == null) {
                                ctxSet = new HashSet<String>();
                                pgmCtxs.put(prgRid, (HashSet<String>)ctxSet);
                            }
                            ctxSet.add(pgmCtx);
                            String jclPgmRid = (String)elem.getProperty("jclPgmRid");
                            jclMap.put(pgmCtx, jclPgmRid);
                        }
                    }
                    ArrayList<String[]> info = new ArrayList<String[]>();
                    HashMap<Pair<String, String>, List<String>> firstMap = new HashMap<Pair<String, String>, List<String>>();
                    HashSet<String> usageRids = new HashSet<String>();
                    for (OrientElement elem : res) {
                        String usageRid = (String)elem.getProperty("usage");
                        String prgRid = (String)elem.getProperty("prgRid");
                        String stmtV = (String)elem.getProperty("stmtRid");
                        Integer bRead = (Integer)elem.getProperty("bRead");
                        String typeId = (String)elem.getProperty("typeId");
                        Integer codeBlockOrdinalNumber = (Integer)elem.getProperty("codeBlockOrdinalNumber");
                        usageRids.add(usageRid);
                        info.add(new String[]{prgRid, stmtV, bRead.toString(), usageRid, typeId, withCB ? codeBlockOrdinalNumber.toString() : null});
                        String ddnameProxyRid = (String)elem.getProperty("ddNameProxy");
                        if (pgmCtxs.containsKey(prgRid)) {
                            for (String ctxRid : (Set)pgmCtxs.get(prgRid)) {
                                String jclPgmRid = (String)jclMap.get(ctxRid.trim());
                                GraphUtils.collectInfoFromJob(firstMap, usageRid, ddnameProxyRid, jclPgmRid);
                            }
                            continue;
                        }
                        String jclPgmRid = null;
                        GraphUtils.collectInfoFromJob(firstMap, usageRid, ddnameProxyRid, jclPgmRid);
                    }
                    results.put(CgBuilder.getKey(prjName, "resources_Info_" + usageInfo), info);
                    long start = System.currentTimeMillis();
                    String query4 = commandDataset4.replace("@@@@@EZLEGACY@@@@", sb.toString());
                    start = System.currentTimeMillis();
                    CloseableIterable jclPgms = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query4)).execute(new Object[0]);
                    L.debug("execute query for jclPgms in " + (System.currentTimeMillis() - start) + " ms");
                    L.debug("executed query: " + query4);
                    Iterator iterator = jclPgms.iterator();
                    if (jclPgms == null || !iterator.hasNext() || (jclPGM = (String)((OrientElement)iterator.next()).getProperty("jclpgms")).length() <= 2) break;
                    jclPGM = GraphUtils.splitEntries(jclPGM);
                    String query3 = commandDataset3.replace("@@@@@EZLEGACY@@@@", jclPGM);
                    start = System.currentTimeMillis();
                    CloseableIterable ddcards = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query3)).execute(new Object[0]);
                    L.debug("execute query for ddcards in " + (System.currentTimeMillis() - start) + " ms");
                    L.debug("executed query: " + query3);
                    if (ddcards == null || !ddcards.iterator().hasNext()) break;
                    HashMap<Pair<String, String>, List<String>> proxies = new HashMap<Pair<String, String>, List<String>>();
                    for (OrientElement oe : ddcards) {
                        String ddcardRid = (String)oe.getProperty("ddcard");
                        String ddnameProxyRid = (String)oe.getProperty("ddNameProxy");
                        String jclPgmRid = (String)oe.getProperty("jclPgmRid");
                        GraphUtils.collectInfoFromJob(proxies, ddcardRid, ddnameProxyRid, jclPgmRid);
                    }
                    HashMap<String, List> datasets = new HashMap<String, List>();
                    for (Pair pair : firstMap.keySet()) {
                        if (proxies.get(pair) == null) continue;
                        for (String usageRid : (List)firstMap.get(pair)) {
                            List infoList = (List)datasets.get(usageRid);
                            if (infoList == null) {
                                datasets.put(usageRid, (List)proxies.get(pair));
                                continue;
                            }
                            infoList.addAll((Collection)proxies.get(pair));
                        }
                    }
                    results.put(CgBuilder.getKey(prjName, "resources_Info_Datasets"), datasets);
                    break;
                }
                case "IMSSegmentUsageInfo": {
                    if (withCB && isIMSHierarchical) {
                        GraphUtils.buildIMSResourcesByPCB(prjName, IMS_SEGMENT_BY_PCB_TYPE_USAGE_INFO, ograph, sb, results);
                        GraphUtils.buildIMSResources(prjName, usageInfo, ograph, sb, withCB, true, results);
                        break;
                    }
                    GraphUtils.buildIMSResources(prjName, usageInfo, ograph, sb, withCB, false, results);
                    break;
                }
                default: {
                    query = commandResource.replace("@@@@@EZLEGACY@@@@", sb.toString());
                    query = query.replace("@@@@@EZLEGACY@RESTYPE@@@@", usageInfo);
                    res = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                    if (res == null || !res.iterator().hasNext()) break;
                    ArrayList<String[]> info = new ArrayList<String[]>();
                    for (OrientElement elem : res) {
                        String prgVId = (String)elem.getProperty("prgRid");
                        String stmtV = (String)elem.getProperty("stmtRid");
                        Integer bRead = (Integer)elem.getProperty("bRead");
                        String typeId = (String)elem.getProperty("typeId");
                        Integer codeBlockOrdinalNumber = (Integer)elem.getProperty("codeBlockOrdinalNumber");
                        String proxyRid = (String)elem.getProperty("proxyRid");
                        info.add(new String[]{prgVId, stmtV, bRead.toString(), proxyRid, typeId, withCB ? codeBlockOrdinalNumber.toString() : null});
                    }
                    results.put(CgBuilder.getKey(prjName, "resources_Info_" + usageInfo), info);
                }
            }
        }
        return results;
    }

    public static Map<String, Object> buildResources(String prjName, String usageInfo, OrientExtendedGraph ograph, StringBuilder sb, boolean withCB, IProgressMonitor pmonitor) {
        return GraphUtils.buildResources(prjName, usageInfo, ograph, sb, withCB, false, pmonitor);
    }

    public static Map<String, Object> buildExtResources(String prjName, String usageInfo, OrientBaseGraph ograph, StringBuilder prgIdsSb, boolean withCB, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(GraphUtils.class, "collectingResources.ext.taskName", new String[]{usageInfo}));
        HashMap<String, Object> results = new HashMap<String, Object>();
        String query = null;
        CloseableIterable res = null;
        if (!monitor.isCanceled()) {
            String string = usageInfo;
            string.hashCode();
            query = commandExtResource.replace("@@@@@EZLEGACY@@@@", prgIdsSb.toString());
            query = query.replace("@@@@@EZLEGACY@RESTYPE@@@@", usageInfo);
            res = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
            if (res != null && res.iterator().hasNext()) {
                ArrayList<String[]> info = new ArrayList<String[]>();
                for (OrientElement elem : res) {
                    String prgVId = (String)elem.getProperty("prgRid");
                    String location = (String)elem.getProperty("location");
                    Integer locationType = (Integer)elem.getProperty("locationType");
                    Integer type = (Integer)elem.getProperty("type");
                    String mapSet = (String)elem.getProperty("mapSet");
                    String dbName = (String)elem.getProperty("dbName");
                    String stmtV = (String)elem.getProperty("stmtRid");
                    Integer bRead = (Integer)elem.getProperty("bRead");
                    String typeId = (String)elem.getProperty("typeId");
                    Integer codeBlockOrdinalNumber = (Integer)elem.getProperty("codeBlockOrdinalNumber");
                    String proxyRid = (String)elem.getProperty("proxyRid");
                    info.add(new String[]{prgVId, stmtV, proxyRid, typeId, (String)elem.getProperty("usageName"), location, locationType.toString(), type != null ? type.toString() : null, withCB ? codeBlockOrdinalNumber.toString() : null, bRead.toString(), mapSet != null ? mapSet : dbName});
                }
                results.put(CgBuilder.getKey(prjName, "resources_Info_" + usageInfo), info);
            }
        }
        return results;
    }

    private static void buildIMSResources(String prjName, String usageInfo, OrientExtendedGraph ograph, StringBuilder sb, boolean withCB, boolean withPCB, Map<String, Object> results) {
        String query = null;
        CloseableIterable res = null;
        query = commandResourceIMSSegment.replace("@@@@@EZLEGACY@@@@", sb.toString());
        res = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query = query.replace("@@@@@EZLEGACY@RESTYPE@@@@", usageInfo))).execute(new Object[0]);
        if (res != null && res.iterator().hasNext()) {
            ArrayList<String[]> info = new ArrayList<String[]>();
            for (OrientElement elem : res) {
                boolean excludeUsage;
                String prgVId = (String)elem.getProperty("prgRid");
                String physicalRids = (String)elem.getProperty("physicalIMS");
                String stmtV = (String)elem.getProperty("stmtRid");
                Integer bRead = (Integer)elem.getProperty("bRead");
                String typeId = (String)elem.getProperty("typeId");
                Integer codeBlockOrdinalNumber = (Integer)elem.getProperty("codeBlockOrdinalNumber");
                String proxyRid = (String)elem.getProperty("proxyRid");
                boolean bl = excludeUsage = withPCB && (IMS_GN_STMT_TYPE.equals(typeId) || IMS_GNP_STMT_TYPE.equals(typeId));
                if (excludeUsage) continue;
                info.add(new String[]{prgVId, stmtV, bRead.toString(), proxyRid, typeId, withCB ? String.valueOf(codeBlockOrdinalNumber) : null, physicalRids});
            }
            results.put(CgBuilder.getKey(prjName, "resources_Info_" + usageInfo), info);
        }
    }

    private static void buildIMSResourcesByPCB(String prjName, String usageInfo, OrientExtendedGraph ograph, StringBuilder sb, Map<String, Object> results) {
        String query = null;
        CloseableIterable res = null;
        query = commandResourceIMSSegmentByPCB.replace("@@@@@EZLEGACY@@@@", sb.toString());
        res = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query = query.replace("@@@@@EZLEGACY@RESTYPE@@@@", usageInfo))).execute(new Object[0]);
        if (res != null && res.iterator().hasNext()) {
            ArrayList<String[]> info = new ArrayList<String[]>();
            for (OrientElement elem : res) {
                String pcbProxy = (String)elem.getProperty("proxyPCB");
                String prgVId = (String)elem.getProperty("prgRid");
                String stmtV = (String)elem.getProperty("stmtRid");
                Integer bRead = (Integer)elem.getProperty("bRead");
                String typeId = (String)elem.getProperty("typeId");
                Integer codeBlockOrdinalNumber = (Integer)elem.getProperty("codeBlockOrdinalNumber");
                info.add(new String[]{prgVId, stmtV, bRead.toString(), pcbProxy, typeId, String.valueOf(codeBlockOrdinalNumber)});
            }
            results.put(CgBuilder.getKey(prjName, "resources_Info_" + usageInfo), info);
        }
    }

    public static Map<String, Object> buildScreenMapping(String prjName, OrientExtendedGraph ograph, StringBuilder prgIdsSb, IProgressMonitor pmonitor) {
        String query;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(GraphUtils.class, "collecting.scrMapp.taskName"));
        HashMap<String, Object> results = new HashMap<String, Object>();
        CloseableIterable res = null;
        if (!monitor.isCanceled() && (res = (CloseableIterable)ograph.command((OCommandRequest)new OCommandSQL(query = commandScrMapping.replace("@@@@@EZLEGACY@@@@", prgIdsSb.toString()))).execute(new Object[0])) != null && res.iterator().hasNext()) {
            ArrayList<String[]> info = new ArrayList<String[]>();
            results.put(CgBuilder.getKey(prjName, "generic screen mapp"), info);
            for (OrientElement elem : res) {
                String prgVId = (String)elem.getProperty("prgRid");
                String scrRid = (String)elem.getProperty("scrRid");
                info.add(new String[]{prgVId, scrRid});
            }
        }
        return results;
    }

    public static String splitEntries(String odbresultAsString) {
        StringBuilder sb = new StringBuilder();
        odbresultAsString = odbresultAsString.substring(odbresultAsString.indexOf("[") + 1, odbresultAsString.indexOf("]"));
        String[] entries = odbresultAsString.split(",");
        int size = entries.length;
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            sb.append(QUOTE.concat(entry.trim()).concat(QUOTE));
            if (--size > 0) {
                sb.append(",");
            }
            ++n2;
        }
        return sb.toString();
    }

    private static void collectInfoFromJob(Map<Pair<String, String>, List<String>> firstMap, String usageRid, String ddnameProxyRid, String jclPgmRid) {
        Pair pair = new Pair((Object)ddnameProxyRid, (Object)jclPgmRid);
        List<String> usages = firstMap.get(pair);
        if (usages == null) {
            usages = new ArrayList<String>();
            firstMap.put((Pair<String, String>)pair, usages);
        }
        usages.add(usageRid);
    }

    public static TSEEdge linkResourceNode(TSEGraphManager graphManager, TSENode prgNode, TSENode node, String stmtRid, String stmtType, Integer bRead) {
        TSENode from = null;
        TSENode to = null;
        if (bRead == 0 || bRead == 2) {
            from = prgNode;
            to = node;
        } else {
            from = node;
            to = prgNode;
        }
        TSEEdge edge = GraphUtils.getOrCreateEdge(graphManager, from, to, stmtRid, stmtType);
        return edge;
    }

    public static TSEEdge getOrCreateEdge(TSEGraphManager graphManager, TSENode from, TSENode to, String stmtRid, String stmtType) {
        TSEEdge edge = null;
        List outs = from.outEdges();
        for (TSEEdge ed : outs) {
            if (!ed.getTargetNode().equals(to) || !ed.hasAttribute("STMT_TYPE") || !stmtType.equals((String)ed.getAttributeValue("STMT_TYPE"))) continue;
            edge = ed;
            break;
        }
        if (edge == null) {
            edge = graphManager.getEdgeBuilder().addEdge(graphManager, from, to);
            CallgraphEdgeLegendInfo edgeType = CallgraphEdgeUtils.getEdgeTypeByStmt((String)stmtType);
            TSEColor edgeColor = TSEColor.black;
            if (edgeType != null) {
                edgeColor = edgeType.getTSEColor();
                HashSet<CallgraphEdgeLegendInfo> edgeForLegend = (HashSet<CallgraphEdgeLegendInfo>)graphManager.getAttributeValue("edge types set for legend");
                if (edgeForLegend == null) {
                    edgeForLegend = new HashSet<CallgraphEdgeLegendInfo>();
                }
                edgeForLegend.add(edgeType);
            }
            edge.setAttribute("Color", (Object)edgeColor);
            edge.setAttribute("STMT_TYPE", (Object)stmtType);
            edge.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)true);
        }
        GraphUtils.collectStmtRidForEdge(edge, stmtRid);
        return edge;
    }

    public static void collectStmtRidForEdge(TSEEdge edge, String stmtRid) {
        if (stmtRid != null) {
            ArrayList<String> list = (ArrayList<String>)edge.getAttributeValue("VERTEX_ID_LIST");
            if (list == null) {
                list = new ArrayList<String>();
                edge.setAttribute("VERTEX_ID_LIST", list);
            }
            list.add(stmtRid);
        }
    }

    public static void setPropertiesViewerForParagraphs(TSENode node, String paraName, String ordinalNumber, boolean isExitParagraph, String referencesNumber, boolean isProgramExit, String paragraphFallThroughtType, String statementsNumber, String linesNumber, String paragraphTypeLbl) {
        ParagraphNode paraNode = new ParagraphNode(paraName, ordinalNumber, isExitParagraph, referencesNumber, isProgramExit, paragraphFallThroughtType, statementsNumber, linesNumber, paragraphTypeLbl);
        node.setAttribute("Node_Mainframe", (Object)paraNode);
    }

    private Triplet<Map<Integer, String>, Map<String, String>, Map<String, String>> getOrCreatePrgsInfoByPrj(String prjName, Map<String, Triplet<Map<Integer, String>, Map<String, String>, Map<String, String>>> prgsByPrj) {
        Triplet triplet = prgsByPrj.get(prjName);
        if (triplet == null) {
            HashMap forwMap = new HashMap();
            HashMap backMap = new HashMap();
            HashMap pMap = new HashMap();
            triplet = new Triplet(pMap, forwMap, backMap);
            prgsByPrj.put(prjName, (Triplet<Map<Integer, String>, Map<String, String>, Map<String, String>>)triplet);
        }
        return triplet;
    }

    public static boolean cgToOtherPrj(TSEGraphManager gManager) {
        return gManager.hasAttribute(CG_OTHER_PRJ_ANALYSIS) && (Boolean)gManager.getAttributeValue(CG_OTHER_PRJ_ANALYSIS) != false;
    }

    public static ExtCallTargetType getExtCallType(String usageInfo, Optional<Integer> bRead) {
        if (EXT_TRAN_USAGE_INFO.equals(usageInfo)) {
            return ExtCallTargetType.TRANSACTION;
        }
        if (EXT_IMSTRAN_USAGE_INFO.equals(usageInfo)) {
            return ExtCallTargetType.IMS_TM;
        }
        if (EXT_SQL_TABLE_USAGE_INFO.equals(usageInfo)) {
            return ExtCallTargetType.SQLTABLE;
        }
        if (EXT_BMS_USAGE_INFO.equals(usageInfo)) {
            return ExtCallTargetType.BMS;
        }
        if (EXT_IMS_MOD_USAGE_INFO.equals(usageInfo)) {
            return ExtCallTargetType.IMS_MOD;
        }
        if (EXT_IMS_SEG_USAGE_INFO.equals(usageInfo)) {
            return ExtCallTargetType.IMS_SEGMENT;
        }
        if (EXT_FILE_USAGE_INFO.equals(usageInfo)) {
            Integer b = bRead.isPresent() ? bRead.get() : 1;
            if (!bRead.isPresent()) {
                L.warn("file access type not specified, consider as default value read corresponding to 1");
            }
            if (b == 1) {
                return ExtCallTargetType.FILE_AT_READ;
            }
            return ExtCallTargetType.FILE_AT_WRITE;
        }
        return ExtCallTargetType.PROGRAM;
    }

    public static ExtCallTargetType getExtCallType(String vertexClass) {
        ExtCallTargetType type = null;
        switch (vertexClass) {
            case "ExtTranProxy": {
                type = ExtCallTargetType.TRANSACTION;
                break;
            }
            case "ExtIMSTranProxy": {
                type = ExtCallTargetType.IMS_TM;
                break;
            }
            case "ExtSQLProxy": {
                type = ExtCallTargetType.SQLTABLE;
                break;
            }
            case "ExtFileProxy": {
                type = ExtCallTargetType.FILE;
                break;
            }
            case "ExtBMSProxy": {
                type = ExtCallTargetType.BMS;
                break;
            }
            case "ExtIMSModProxy": {
                type = ExtCallTargetType.IMS_MOD;
                break;
            }
            case "ExtIMSSegment": {
                type = ExtCallTargetType.IMS_SEGMENT;
                break;
            }
            case "ExtProgramProxy": {
                type = ExtCallTargetType.PROGRAM;
            }
        }
        return type;
    }

    public static Triplet<TSENode, TSENode, String> computeAccesType(TSENode fNode, TSENode sNode, ExtCallTargetType targetType) {
        TSENode t1 = fNode;
        TSENode t2 = sNode;
        String stmtType = ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_STRING;
        if (ExtCallTargetType.FILE_AT_READ.equals((Object)targetType)) {
            t1 = sNode;
            t2 = fNode;
            stmtType = ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_READ_STRING;
        } else if (ExtCallTargetType.FILE_AT_WRITE.equals((Object)targetType)) {
            stmtType = ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_WRITE_STRING;
        }
        return new Triplet((Object)t1, (Object)t2, (Object)stmtType);
    }

    public static void translateCICSRegToPrj(String prjName, ExtCallTargetType ttype, Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> allCicsReg, Map<Pair<String, String>, Set<String>> tgtByCicsReg, Map<String, UserExitsToPrj> localUEByPrj, Map<String, Map<String, UserExitsFromPrg>> ue) {
        GraphUtils.translateCICSRegToPrj(prjName, ttype, allCicsReg, tgtByCicsReg, localUEByPrj, ue, null);
    }

    public static void translateCICSRegToPrj(String prjName, ExtCallTargetType ttype, Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> allCicsReg, Map<Pair<String, String>, Set<String>> tgtByCicsReg, Map<String, UserExitsToPrj> localUEByPrj, Map<String, Map<String, UserExitsFromPrg>> ue, Set<String> filtredPrj) {
        Map<Pair<String, String>, Set<String>> cicsRegByType = GraphUtils.getAllCics(ttype, allCicsReg);
        if (cicsRegByType == null || cicsRegByType.isEmpty()) {
            return;
        }
        for (Pair<String, String> pair : tgtByCicsReg.keySet()) {
            if (!cicsRegByType.containsKey(pair)) continue;
            Set<String> prjs = cicsRegByType.get(pair);
            if (filtredPrj != null) {
                HashSet<String> intersection = new HashSet<String>(prjs);
                intersection.retainAll(filtredPrj);
                if (intersection == null || intersection.isEmpty()) continue;
                tgtByCicsReg.put(pair, intersection);
                continue;
            }
            tgtByCicsReg.put(pair, prjs);
        }
        Map<String, UserExitsFromPrg> map = ue.get(prjName);
        if (map == null) {
            return;
        }
        for (String prgRid : map.keySet()) {
            UserExitsFromPrg uec = map.get(prgRid);
            Map<String, Set<Target>> cicsToTgts = uec.getTgts(ttype, ExtCallLocationType.CICSREGION);
            if (cicsToTgts == null || cicsToTgts.isEmpty()) continue;
            for (String reg : cicsToTgts.keySet()) {
                for (Target t : cicsToTgts.get(reg)) {
                    Pair key = new Pair((Object)reg, (Object)(ExtCallTargetType.BMS.equals((Object)t.getTgtType()) ? t.getParent() : t.getName()));
                    Set<String> prjs = tgtByCicsReg.get(key);
                    if (prjs == null) continue;
                    for (String prj : prjs) {
                        Target tt = new Target(t.getName(), ttype, prj, ExtCallLocationType.APPLICATION, t.getParent());
                        tt.updateStmts(t.getStmts());
                        uec.addTarget(tt);
                        UserExitsToPrj ueprj = localUEByPrj.get(prj);
                        if (ueprj == null) {
                            ueprj = new UserExitsToPrj(prj);
                            localUEByPrj.put(prj, ueprj);
                        }
                        ueprj.addTarget(ttype, QUOTE + t.getQName() + QUOTE);
                    }
                }
            }
        }
    }

    private static Map<Pair<String, String>, Set<String>> getAllCics(ExtCallTargetType ttype, Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> allCicsReg) {
        if (ExtCallTargetType.PROGRAM_COBOL.equals((Object)ttype) || ExtCallTargetType.PROGRAM_PLI.equals((Object)ttype)) {
            return allCicsReg.get((Object)ExtCallTargetType.PROGRAM);
        }
        if (ExtCallTargetType.FILE_AT_READ.equals((Object)ttype) || ExtCallTargetType.FILE_AT_WRITE.equals((Object)ttype)) {
            return allCicsReg.get((Object)ExtCallTargetType.FILE);
        }
        return allCicsReg.get((Object)ttype);
    }
}

