/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programflow;

import com.ez.gdb.core.collectors.ODBProgramCollector;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramFlowInputsFilter
extends ProjectInputsFilter {
    private static final Logger L = LoggerFactory.getLogger(ProgramFlowInputsFilter.class);
    protected ProjectInfo prjInfo;

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            String wizardName = Messages.getString(ProgramFlowInputsFilter.class, "wizzard.title");
            wizard.setWindowTitle(wizardName);
            SingleSelectionPage selectProgramsPage = new SingleSelectionPage("programs page", true);
            ODBProgramCollector pc = new ODBProgramCollector();
            pc.setQuery(ODBProgramCollector.PROGRAM_EXISTENT_QUERY);
            selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
            selectProgramsPage.setTitle(Messages.getString(ProgramFlowInputsFilter.class, "page.title"));
            selectProgramsPage.setDescription(Messages.getString(ProgramFlowInputsFilter.class, "page.description"));
            selectProgramsPage.setErrMsgNoResource(Messages.getString(ProgramFlowInputsFilter.class, "err.message"));
            wizard.addPage((IWizardPage)selectProgramsPage);
            if (System.getProperty("test") != null) {
                SelectPathPage selectPathPage = new SelectPathPage("tests page");
                wizard.addPage((IWizardPage)selectPathPage);
            }
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            HashSet<String> parents = new HashSet<String>();
            ArrayList<ProgramInput> toComplete = new ArrayList<ProgramInput>();
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo prjInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(prjInfo);
            for (BaseMainframeResource4GUI pi4GUI : selected) {
                ProgramInput pi = (ProgramInput)pi4GUI.getObject();
                if (pi.getTypeCode() == 8 || pi.getTypeCode() == 13) {
                    parents.add(pi.getName());
                    toComplete.add(pi);
                    continue;
                }
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(pi.getName(), pi.getProgramID(), pi.getTypeCode());
                entity.addSegment((EZSegment)prgIdSg);
                list.add(entity);
            }
            super.setConToAddChildren(prjIdSg, parents, toComplete, list);
            analysis.addContextValue("input_list", list);
        }
        analysis.addContextValue("available resources", wizard.getValue("available resources"));
        analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
        analysis.addContextValue("selected resources", (Object)wizard.getList("selected resources"));
    }
}

