/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programflow;

import com.ez.cobol.callgraph.nodes.ADSDialogProgramNode;
import com.ez.cobol.callgraph.nodes.AdabasNode;
import com.ez.cobol.callgraph.nodes.AdsMapNode;
import com.ez.cobol.callgraph.nodes.AlgolProgramNode;
import com.ez.cobol.callgraph.nodes.AsmCsectProgramNode;
import com.ez.cobol.callgraph.nodes.AsmEntryProgramNode;
import com.ez.cobol.callgraph.nodes.AssemblerProgramNode;
import com.ez.cobol.callgraph.nodes.CLProgramNode;
import com.ez.cobol.callgraph.nodes.CobolProgramNode;
import com.ez.cobol.callgraph.nodes.DALFileNode;
import com.ez.cobol.callgraph.nodes.DBFileNode;
import com.ez.cobol.callgraph.nodes.DBINode;
import com.ez.cobol.callgraph.nodes.EZRexxProgramNode;
import com.ez.cobol.callgraph.nodes.FortranProgramNode;
import com.ez.cobol.callgraph.nodes.GenericTransactionNode;
import com.ez.cobol.callgraph.nodes.IMSDBLogicSegmentNode;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.IMSDBSegmentNode;
import com.ez.cobol.callgraph.nodes.IMSTransactionNode;
import com.ez.cobol.callgraph.nodes.IdmsRecordNode;
import com.ez.cobol.callgraph.nodes.IdmsSetNode;
import com.ez.cobol.callgraph.nodes.JavaProgramNode;
import com.ez.cobol.callgraph.nodes.NaturalMapNode;
import com.ez.cobol.callgraph.nodes.NaturalProgramNode;
import com.ez.cobol.callgraph.nodes.PLIProgramNode;
import com.ez.cobol.callgraph.nodes.ParagraphNode;
import com.ez.cobol.callgraph.nodes.PrinterFileNode;
import com.ez.cobol.callgraph.nodes.QueueManagerNode;
import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.cobol.callgraph.nodes.ResourceDatacomTableNode;
import com.ez.cobol.callgraph.nodes.ResourceFileNode;
import com.ez.cobol.callgraph.nodes.ResourceSQLTableNode;
import com.ez.cobol.callgraph.nodes.SCLProgramNode;
import com.ez.cobol.callgraph.nodes.ScreenNode;
import com.ez.cobol.callgraph.nodes.SmartDbModuleProgramNode;
import com.ez.cobol.callgraph.nodes.SmartScreenNode;
import com.ez.cobol.callgraph.nodes.SmartSubroutineNode;
import com.ez.cobol.callgraph.nodes.TPMSXMapNode;
import com.ez.cobol.callgraph.nodes.TerminalNode;
import com.ez.cobol.callgraph.nodes.TerminalOrTransactionNode;
import com.ez.cobol.callgraph.nodes.TransactionNode;
import com.ez.cobol.callgraph.nodes.UnknownProgramNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programflow.FlowGraphModel;
import com.ez.graphs.viewer.callgraph.programflow.FlowGraphMouseActionHook;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.ui.ResolutionBaseJob;
import com.ez.graphs.viewer.utils.ProgFlowNodeLegendInfo;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.analysis.config.inputs.EZFlowChartPrg;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.ProgramType;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.EZFitInCanvasCommand;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramFlowGraphJob
extends ResolutionBaseJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramFlowGraphJob.class);
    private Action flowChartAction = null;
    private GraphTSJobAdapter.ProgressAction customLayout = null;
    public static final String PARAGRAPHS_INFO = "paragraphs information";
    public static final String GO_TO_INFO = "go to statements information";
    public static final String PROGRAM_TYPE = "PROGRAM_TYPE";
    public static final String PROGRAM_VERTEX_ID = "PROGRAM_VERTEX_ID";
    public static final String PL1_CALL_INTERNAL_PROC_INFO = "PL1 call internal proc statements information";
    public static final String ADS_CALL_INFO = "ADS call statement";
    public static final String IS_IMS_SEGMENTS_HIERACHY = "is_IMS_segments_hierarchy";
    private static final String query_info = "select @rid.asString() as paraRid, name, ordinalNumber, isPrgExit, isExitPara, referenceCount, parafallthroughtype, numOfStmt, numOfLines,\noutE('GoTo').toOrdinalNumber.asString() as gt1, outE('GoTo').conditionalType.asString() as gt2, out('GoTo').typeId.asString() as gt3, out('GoTo').@rid.asString() as gt4,\noutE('CallProc').toOrdinalNumber.asString() as cp1, out('CallProc').typeId.asString() as cp2, out('CallProc').@rid.asString() as cp3,\noutE('ADSCall').toOrdinalNumber.asString() as ads1, out('ADSCall').typeId.asString() as ads2, out('ADSCall').@rid.asString() as ads3\nfrom (select expand (out('HasCB')[0].out('HasCB')) from @@@@@EZLEGACY@@@@ FETCHPLAN in_*:-2 out_*:-2)";

    public ProgramFlowGraphJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new FlowGraphMouseActionHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new ProgFlowGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.addFilters(this.gfi);
        this.graphModel = new FlowGraphModel(new AnalysisGraphManager(), this.analysis);
        ((FlowGraphModel)this.graphModel).setIMSHierarchicalModel(this.isIMSHierarchicalModel());
        this.graphManager = this.graphModel.getGraphManager();
        this.initContentProviders();
        super.initGraphDetails();
    }

    public boolean isIMSHierarchicalModel() {
        return (Boolean)this.analysis.getContextValue(IS_IMS_SEGMENTS_HIERACHY);
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    private void computeValues(AbstractAnalysisGraphModel graphModel, IProgressMonitor pmonitor, int prgTypeId, int prgId, String programName, String path, OrientBaseGraph dbg, Properties env) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        this.analysis.addContextValue(PROGRAM_TYPE, (Object)prgTypeId);
        String query = "select @rid.asString() as rid from program where sid = ? ";
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{prgId});
        if (res != null && res.iterator().hasNext()) {
            Vertex v = (Vertex)res.iterator().next();
            String pRid = (String)v.getProperty("rid");
            this.analysis.addContextValue(PROGRAM_VERTEX_ID, (Object)pRid);
            long start = System.currentTimeMillis();
            L.debug("start computing paragraphs");
            String infoQuery = query_info.replace("@@@@@EZLEGACY@@@@", pRid);
            res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(infoQuery)).execute(new Object[0]);
            L.info("executed query {}", (Object)infoQuery);
            if (res != null && res.iterator().hasNext()) {
                LinkedHashMap<Integer, Object[]> paraMap = new LinkedHashMap<Integer, Object[]>();
                ArrayList<Object[]> goToInfo = new ArrayList<Object[]>();
                ArrayList<Object[]> callProcInfo = new ArrayList<Object[]>();
                ArrayList<Object[]> adsCallInfo = new ArrayList<Object[]>();
                for (Vertex paraCBV : res) {
                    String paraName = (String)paraCBV.getProperty("name");
                    String paraRid = (String)paraCBV.getProperty("paraRid");
                    Integer ordinalNumber = (Integer)paraCBV.getProperty("ordinalNumber");
                    Boolean isExitPara = (Boolean)paraCBV.getProperty("isExitPara");
                    Boolean isPrgExit = (Boolean)paraCBV.getProperty("isPrgExit");
                    Integer referenceCount = (Integer)paraCBV.getProperty("referenceCount");
                    Integer parafallthroughtype = (Integer)paraCBV.getProperty("parafallthroughtype");
                    Integer numOfStmt = (Integer)paraCBV.getProperty("numOfStmt");
                    Integer numOfLines = (Integer)paraCBV.getProperty("numOfLines");
                    paraCBV.getId().toString();
                    Object[] info = new Object[]{paraRid, paraName, ordinalNumber, isExitPara, isPrgExit, referenceCount, parafallthroughtype, numOfStmt, numOfLines};
                    paraMap.put(ordinalNumber, info);
                    this.processInfo(goToInfo, ordinalNumber, paraCBV, "gt");
                    this.processInfo(callProcInfo, ordinalNumber, paraCBV, "cp");
                    this.processInfo(adsCallInfo, ordinalNumber, paraCBV, "ads");
                }
                L.debug("end computing paragraphs in " + (System.currentTimeMillis() - start) + " ms");
                this.analysis.addContextValue(PARAGRAPHS_INFO, paraMap);
                this.analysis.addContextValue(GO_TO_INFO, goToInfo);
                this.analysis.addContextValue(PL1_CALL_INTERNAL_PROC_INFO, callProcInfo);
                this.analysis.addContextValue(ADS_CALL_INFO, adsCallInfo);
                boolean isIMSHierarchy = this.isIMSHierarchicalModel();
                start = System.currentTimeMillis();
                StringBuilder idsSb = new StringBuilder();
                idsSb.append(pRid);
                for (String resType : GraphUtils.resourceTypes) {
                    long lstart = System.currentTimeMillis();
                    this.analysis.addAllContextValues(GraphUtils.buildResources(null, resType, (OrientExtendedGraph)dbg, idsSb, true, isIMSHierarchy, (IProgressMonitor)monitor.newChild(100)));
                    L.debug("computing " + resType + " in " + (System.currentTimeMillis() - lstart) + " ms");
                    if (monitor.isCanceled()) break;
                }
                for (String resType : GraphUtils.extResourceTypes) {
                    long lstart = System.currentTimeMillis();
                    this.analysis.addAllContextValues(GraphUtils.buildExtResources(null, resType, dbg, idsSb, true, monitor.newChild(100)));
                    L.debug("computing " + resType + " in " + (System.currentTimeMillis() - lstart) + " ms");
                    if (monitor.isCanceled()) break;
                }
                L.debug("computing resouces in " + (System.currentTimeMillis() - start) + " ms");
            }
        } else {
            L.debug("program having id " + prgId + "not found in orientDB");
        }
        if (path != null) {
            graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
            TSEGraph newGraph = graphModel.getGraph();
            ((FlowGraphModel)graphModel).writeGraphToFile(newGraph, programName, path.toString());
            newGraph.dispose();
        }
    }

    private void processInfo(List<Object[]> info, Integer ordinalNumber, Vertex paraCBV, String lbl) {
        block4: {
            String gt1 = (String)paraCBV.getProperty(lbl.concat("1"));
            if (gt1 == null || gt1.length() <= 2) break block4;
            gt1 = gt1.substring(1, gt1.length() - 1);
            String[] i1 = gt1.split(",");
            String gt2 = (String)paraCBV.getProperty(lbl.concat("2"));
            gt2 = gt2.substring(1, gt2.length() - 1);
            String[] i2 = gt2.split(",");
            String gt3 = (String)paraCBV.getProperty(lbl.concat("3"));
            gt3 = gt3.substring(1, gt3.length() - 1);
            String[] i3 = gt3.split(",");
            String gt4 = (String)paraCBV.getProperty(lbl.concat("4"));
            if (gt4 != null) {
                gt4 = gt4.substring(1, gt4.length() - 1);
                String[] i4 = gt4.split(",");
                int i = 0;
                while (i < i1.length) {
                    info.add(new Object[]{ordinalNumber, Integer.valueOf(i1[i].trim()), Integer.valueOf(i2[i].trim()), i3[i].trim(), i4[i].trim()});
                    ++i;
                }
            } else {
                int i = 0;
                while (i < i1.length) {
                    info.add(new Object[]{ordinalNumber, Integer.valueOf(i1[i].trim()), i2[i].trim(), i3[i].trim()});
                    ++i;
                }
            }
        }
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(500 + 100 * GraphUtils.resourceTypes.size()));
        monitor.setTaskName(Messages.getString(ProgramFlowGraphJob.class, "collectingData.taskName"));
        super.computeResults(graphModel, (IProgressMonitor)monitor.newChild(100));
        Properties env = (Properties)this.analysis.getContextValue("env");
        OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        try {
            List inputs = this.analysis.getContextListValue("input_list");
            Object path = this.analysis.getContextValue("selected path");
            if (path != null && !path.toString().trim().equals("")) {
                List progrID = this.analysis.getContextListValue("available resources");
                for (BaseMainframeResource4GUI element4GUI : progrID) {
                    PrgOrIncludeWithPathInput element = (PrgOrIncludeWithPathInput)element4GUI.getObject();
                    int prgTypeId = element.getTypeCode();
                    int prgId = element.getProgramID();
                    String programName = element.getListableName();
                    this.computeValues(graphModel, pmonitor, prgTypeId, prgId, programName, path.toString(), dbg, env);
                }
            } else {
                EZEntityID entity = (EZEntityID)inputs.get(0);
                EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                int prgId = prgIdSg.getProgramId();
                int prgTypeId = prgIdSg.getTypeId();
                String emptyName = "";
                this.computeValues(graphModel, pmonitor, prgTypeId, prgId, emptyName, null, dbg, env);
            }
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
            dbg = null;
        }
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        int dl = this.getDefaultLayout();
        this.customLayout = new GraphTSJobAdapter.ProgressAction((GraphTSJobAdapter)this, Messages.getString(ProgramFlowGraphJob.class, "resLayout.action.text"), 8){

            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString(ProgramFlowGraphJob.class, "resourceLay.task.text"), -1);
                List cmds = ProgramFlowGraphJob.this.doLayout(5);
                ProgramFlowGraphJob.this.transmitCommands(cmds);
                ProgramFlowGraphJob.this.currentLayoutType = 5;
                monitor.done();
            }
        };
        if (dl == 5) {
            this.customLayout.setChecked(true);
        } else {
            this.customLayout.setChecked(false);
        }
        this.customLayout.setToolTipText(Messages.getString(ProgramFlowGraphJob.class, "resLay.action.tooltip"));
        ImageDescriptor id = Activator.getImageDescriptor("icons//resourcesLayout.png");
        this.customLayout.setImageDescriptor(id);
        this.createEdgesActions();
        this.createIconActions();
        List inputs = this.analysis.getContextListValue("input_list");
        final EZEntityID inputEntityId = (EZEntityID)inputs.get(0);
        EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)inputEntityId.getSegment(EZSourceProgramIDSg.class);
        int programType = prgIdSg.getTypeId();
        if (programType != ProgramType.ADS_PROCESS.getProgramTypeId()) {
            L.debug("create 'flow chart' action for program type id " + programType);
            this.flowChartAction = new Action(){

                public void run() {
                    EZFlowChartPrg inputType = new EZFlowChartPrg();
                    if (inputType != null) {
                        L.debug("analysis inputType" + inputType.getName());
                        inputType.setEntID(inputEntityId);
                        List analysisType = EZWorkspace.getInstance().getSpecificAnalysisType((EZObjectType)inputType);
                        if (analysisType != null) {
                            L.debug("analysisType:" + ((EZAnalysisType)analysisType.get(0)).getName());
                            EZAnalysis analysis = ((EZAnalysisType)analysisType.get(0)).getImplementorInstance();
                            ArrayList<EZFlowChartPrg> inputs = new ArrayList<EZFlowChartPrg>();
                            inputs.add(inputType);
                            analysis.setInputs(inputs);
                            L.debug("before execute flow chart");
                            analysis.execute();
                            ProgramFlowGraphJob.this.flowChartAction.setChecked(false);
                        }
                    }
                }
            };
            this.flowChartAction.setText(Messages.getString(ProgramFlowGraphJob.class, "flowchart.action.text"));
            this.flowChartAction.setToolTipText(Messages.getString(ProgramFlowGraphJob.class, "flowchart.action.tooltip"));
            id = Activator.getImageDescriptor("icons/programflowchart.png");
            this.flowChartAction.setImageDescriptor(id);
            this.flowChartAction.setChecked(false);
        }
    }

    public List getMenuItems() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(new ActionContributionItem((IAction)this.fitAction));
        menuItems.add(new Separator());
        menuItems.add(new ActionContributionItem((IAction)this.select));
        menuItems.add(new ActionContributionItem((IAction)this.pan));
        menuItems.add(new ActionContributionItem((IAction)this.mzoom));
        menuItems.add(new ActionContributionItem((IAction)this.izoom));
        menuItems.add(new ActionContributionItem((IAction)this.nedges));
        menuItems.add(new Separator());
        menuItems.add(new ActionContributionItem((IAction)this.customLayout));
        menuItems.add(new ActionContributionItem((IAction)this.hierarchical));
        menuItems.add(new ActionContributionItem((IAction)this.symmetric));
        menuItems.add(new ActionContributionItem((IAction)this.circular));
        menuItems.add(new ActionContributionItem((IAction)this.orthogonal));
        this.contributeRedrawEntry(menuItems);
        this.contributeEdgesEntries(menuItems);
        this.contributeIconEntries(menuItems);
        return menuItems;
    }

    public List getToolBarItems() {
        ArrayList<Object> toolbars = new ArrayList<Object>();
        if (this.flowChartAction != null) {
            L.debug("add 'flow chart' toolbar action");
            toolbars.add(new Separator());
            toolbars.add(new ActionContributionItem((IAction)this.flowChartAction));
        }
        this.contributeIconEntries(toolbars);
        this.contributeEdgesEntries(toolbars);
        this.contributeRedrawEntry(toolbars);
        toolbars.add(new Separator());
        toolbars.add(new ActionContributionItem((IAction)this.fitAction));
        toolbars.add(new Separator());
        toolbars.add(new ActionContributionItem((IAction)this.select));
        toolbars.add(new ActionContributionItem((IAction)this.pan));
        toolbars.add(new ActionContributionItem((IAction)this.mzoom));
        toolbars.add(new ActionContributionItem((IAction)this.izoom));
        toolbars.add(new ActionContributionItem((IAction)this.nedges));
        toolbars.add(new Separator());
        toolbars.add(new ActionContributionItem((IAction)this.customLayout));
        toolbars.add(new ActionContributionItem((IAction)this.hierarchical));
        toolbars.add(new ActionContributionItem((IAction)this.symmetric));
        toolbars.add(new ActionContributionItem((IAction)this.circular));
        toolbars.add(new ActionContributionItem((IAction)this.orthogonal));
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
        if (this.customLayout != null) {
            this.customLayout.setEnabled(state);
        }
        if (this.flowChartAction != null) {
            this.flowChartAction.setEnabled(state);
        }
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        IStatus statusResult = super.finalTSGraphOperations(monitor, result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            List graphs = this.graphModel.getGraphs();
            for (TSEGraph gr : graphs) {
                allNodes.addAll(gr.nodes());
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        return statusResult;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        Utils.setImageProvider((LegendPanel)legend);
        this.addNodesToLegend(legend, uiStyle);
        this.addEdgesToLegend(legend);
    }

    private void addNodesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
                if (nodeLegendInfo instanceof ProgFlowNodeLegendInfo) {
                    imagePath = nodeLegendInfo.getColorboxImagePath();
                }
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(nodeLegendInfo.getNodeTypeClass(), imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(ParagraphNode.class);
        gfi.registerFilterType(ADSDialogProgramNode.class);
        gfi.registerFilterType(AlgolProgramNode.class);
        gfi.registerFilterType(AssemblerProgramNode.class);
        gfi.registerFilterType(AsmCsectProgramNode.class);
        gfi.registerFilterType(AsmEntryProgramNode.class);
        gfi.registerFilterType(CLProgramNode.class);
        gfi.registerFilterType(CobolProgramNode.class);
        gfi.registerFilterType(FortranProgramNode.class);
        gfi.registerFilterType(NaturalProgramNode.class);
        gfi.registerFilterType(PLIProgramNode.class);
        gfi.registerFilterType(EZRexxProgramNode.class);
        gfi.registerFilterType(SCLProgramNode.class);
        gfi.registerFilterType(SmartDbModuleProgramNode.class);
        gfi.registerFilterType(SmartSubroutineNode.class);
        gfi.registerFilterType(JavaProgramNode.class);
        gfi.registerFilterType(UnknownProgramNode.class);
        gfi.registerFilterType(AdabasNode.class);
        gfi.registerFilterType(AdsMapNode.class);
        gfi.registerFilterType(ResourceFileNode.class);
        gfi.registerFilterType(IdmsRecordNode.class);
        gfi.registerFilterType(IdmsSetNode.class);
        gfi.registerFilterType(IMSDBNode.class);
        gfi.registerFilterType(NaturalMapNode.class);
        gfi.registerFilterType(PrinterFileNode.class);
        gfi.registerFilterType(QueueNode.class);
        gfi.registerFilterType(QueueManagerNode.class);
        gfi.registerFilterType(SmartScreenNode.class);
        gfi.registerFilterType(ResourceSQLTableNode.class);
        gfi.registerFilterType(TerminalNode.class);
        gfi.registerFilterType(TerminalOrTransactionNode.class);
        gfi.registerFilterType(TransactionNode.class);
        gfi.registerFilterType(ResourceDatacomTableNode.class);
        gfi.registerFilterType(TPMSXMapNode.class);
        gfi.registerFilterType(DBFileNode.class);
        gfi.registerFilterType(DALFileNode.class);
        gfi.registerFilterType(DBINode.class);
        gfi.registerFilterType(IMSDBSegmentNode.class);
        gfi.registerFilterType(IMSDBLogicSegmentNode.class);
        gfi.registerFilterType(ScreenNode.class);
        gfi.registerFilterType(IMSTransactionNode.class);
        gfi.registerFilterType(GenericTransactionNode.class);
    }

    protected int getDefaultLayout() {
        return 5;
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        if (type == 5) {
            if (this.isIMSHierarchicalModel()) {
                ((FlowGraphModel)this.graphModel).customIMSHierarchicalLayout();
            } else {
                ((FlowGraphModel)this.graphModel).customLayout();
            }
            layoutCommand = new EZFitInCanvasCommand(this.canvas);
        } else {
            layoutCommand = super.doLayout(type, graph);
        }
        return layoutCommand;
    }

    public void closing() {
        this.customLayout = null;
        super.closing();
    }

    public class ProgFlowGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;

        public ProgFlowGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage((String)"programFlow", (String)"icons/resourcesLayout.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage((String)"programFlow");
            }
            return this.image;
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            List inputs = ProgramFlowGraphJob.this.analysis.getContextListValue("input_list");
            for (Object obj : inputs) {
                if (!(obj instanceof EZEntityID)) continue;
                EZEntityID entity = (EZEntityID)obj;
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                buf.append(prgSg.getProgramName());
                if (inputs.indexOf(entity) == inputs.size() - 1) continue;
                buf.append(", ");
            }
            return Messages.getString(ProgramFlowGraphJob.class, "prg.flow.graph.analysis", new String[]{buf.toString(), ProgramFlowGraphJob.this.analysis.getContextValue("input_project_names").toString()});
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){
                private LegendPanel legend;

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    this.legend = new LegendPanel((Composite)sc, 0);
                    int uiStyle = ProgramFlowGraphJob.this.graphModel.getUIStyle();
                    ProgramFlowGraphJob.this.addEntriesToLegend(this.legend, uiStyle, ProgFlowGraphInfo.this.gfi);
                    sc.setContent((Control)this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    this.legend.pack();
                    sc.setMinSize(this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = this.legend.getSize().x;
                    int x = this.legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            ProgramFlowGraphJob.this.legend = null;
            super.dispose();
        }
    }
}

