/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programflow;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programflow.ProgramFlowGraphJob;
import com.ez.graphs.viewer.callgraph.programflow.ProgramFlowInputsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import java.util.List;

public class ProgramFlowGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static final String PROGRAM_INPUT_KEY = "programInput";
    protected ProgramFlowGraphJob job = null;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (ProgramFlowGraphJob)wk.getJob(id, ProgramFlowGraphJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public void setInputs(List inputs) {
        EZSourceProgram inpt;
        super.setInputs(inputs);
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProgram && (inpt = (EZSourceProgram)inputs.get(0)) != null) {
            this.addContextValue(PROGRAM_INPUT_KEY, inpt);
        }
        String prjName = (String)this.getContextValue("input_project_names");
        this.addContextValue("env", ConnectionUtils.getODBSettings((String)prjName));
        Boolean imsHierarchy = false;
        this.addContextValue("is_IMS_segments_hierarchy", imsHierarchy);
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public String getLabelType() {
        return Messages.getString(ProgramFlowGraphAnalysis.class, "properties.labelType");
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_PROGRAM_FLOW_ANALYSIS;
    }

    protected InputsFilter getInputsFilter() {
        ProgramFlowInputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            iFilter = new ProgramFlowInputsFilter();
        }
        return iFilter;
    }

    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (ret) {
            AbstractAnalysis a2 = (AbstractAnalysis)obj;
            Boolean is_hierarchy = (Boolean)this.getContextValue("is_IMS_segments_hierarchy");
            is_hierarchy = is_hierarchy == null ? false : is_hierarchy;
            Boolean is_hierarchy1 = (Boolean)a2.getContextValue("is_IMS_segments_hierarchy");
            if (!is_hierarchy.equals(is_hierarchy1 = Boolean.valueOf(is_hierarchy1 == null ? false : is_hierarchy1))) {
                ret = false;
            }
        }
        return ret;
    }
}

