/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programflow;

import com.ez.cobol.callgraph.CallgraphEdgeLegendInfo;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import com.ez.graphs.viewer.callgraph.programflow.TSENodeComparator;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.ui.ResolutionBasedGraphModel;
import com.ez.graphs.viewer.utils.ProgFlowEdgeLegendInfo;
import com.ez.graphs.viewer.utils.ProgFlowNodeLegendInfo;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.MappingConstants;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.geometry.shared.TSConstSize;
import com.tomsawyer.drawing.geometry.shared.TSPolygonShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.complexity.TSENestingManager;
import com.tomsawyer.graphicaldrawing.ui.composite.TSCompositeNodeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSImageUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSSplitterUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSTextUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElementPoint;
import com.tomsawyer.interactive.command.TSCommandInterface;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.interactive.service.layout.client.TSEApplyLayoutResults;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.TSServiceOutputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.TSRoutingInputTailor;
import com.tomsawyer.service.layout.client.TSLayoutProxy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowGraphModel
extends ResolutionBasedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FlowGraphModel.class);
    private static final String SCREEN_OCCUR_ID_ATTRIBUTE = "ScreenOccurId Attribute";
    private static final String SCREEN_ID = "ScreenID attribute";
    private static final String BOUNDS = "Bounds";
    private static final String HAS_PROPERTIES_IN_PROPVIEW = "HAS_PROPERTIES_IN_PROPVIEW";
    private static final String VERTEX_ID = "VERTEX_ID";
    private static final String NODE_MAINFRAME = "Node_Mainframe";
    private static final String APPLICABLE_INPUT = "APPLICABLE_INPUT";
    private static final String TEXT_COLOR = "Text_Color";
    private static final String FILL_COLOR = "Fill_Color";
    private static final String EDGE_DIRECTION = "edge direction";
    private boolean IS_FILTER_EXIT_PARAGRAPHS_COBOL_CALLGRAPH = false;
    private static final String PROG_USAGE_INFO_VERTEX = "ProgramUsageInfo";
    private static final String TRANSACTION_MAPPING_EDGE = "TranMapping";
    private static final String SCREEN_MAPPING_EDGE = "tranCODE";
    private static final String RESOURCE_TYPE_NODE_ATTR = "resourceType";
    private MainframeGraphAnalysis analysis;
    private OrientBaseGraph dbg;
    private Properties env;
    private TSNodeBuilder nodeBuilder;
    private TSEdgeBuilder edgeBuilder;
    private List<TSENode> paraNodes = new ArrayList<TSENode>();
    private List<TSENode> resNodes = new ArrayList<TSENode>();
    public String[][] links;
    public String[][] programPaths;
    public EZSourceProjectIDSg projectIdSg;
    private Map<Integer, TSENode> paragraphNodes = new HashMap<Integer, TSENode>();
    private String inputProgramName;
    private EZObjectType inputObjType;
    int minParagraphHeightNode = 40;
    int minResHeightNode = 40;
    int minVerticalParagraphSpace = 60;
    int paragraphEdgeSpacingCoeficient = 1;
    int resXDisplacement = 400;
    Set<String> standardProcs;
    private boolean isIMSHierarchicalModel;

    public FlowGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = (MainframeGraphAnalysis)analysis;
        this.ezsourcePrj = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
        this.initialize();
    }

    private void initialize() {
        this.outForGISV.clear();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        Map paragraphs = (Map)this.analysis.getContextValue("paragraphs information");
        if (paragraphs == null) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(FlowGraphModel.class, "noresults.node.name"));
            L.debug("no paragraphs ");
        } else {
            DIRECTION direction;
            TSENode source;
            this.initGraph();
            boolean showStandardSCLProcs = PreferenceUtils.isShowingSCLProcs();
            HashMap tsNodes = new HashMap();
            this.graph.setAttribute("TS nodes per project", tsNodes);
            this.env = (Properties)this.analysis.getContextValue("env");
            this.dbg = ConnectionUtils.getNoTxGraph((Properties)this.env);
            this.paraNodes.clear();
            this.resNodes.clear();
            this.projectIdSg = new EZSourceProjectIDSg((ProjectInfo)this.analysis.getContextValue("PROJECT_INFO"));
            this.graph.setAttribute("MAINFRAME_PROJECT_ID_SG", (Object)this.projectIdSg);
            this.paragraphNodes.clear();
            int prevFallThroughType = 0;
            TSENode prevNode = null;
            Integer prgType = (Integer)this.analysis.getContextValue("PROGRAM_TYPE");
            List gotoStmts = (List)this.analysis.getContextValue("go to statements information");
            List procCallStmts = (List)this.analysis.getContextValue("PL1 call internal proc statements information");
            List adsCallStmts = (List)this.analysis.getContextValue("ADS call statement");
            for (Integer ordinalNumber : paragraphs.keySet()) {
                Object[] paragraph = (Object[])paragraphs.get(ordinalNumber);
                boolean createNode = false;
                if (this.IS_FILTER_EXIT_PARAGRAPHS_COBOL_CALLGRAPH) {
                    int isExitPara = (Integer)paragraph[3];
                    if (isExitPara != -1) {
                        createNode = true;
                    } else if (gotoStmts != null) {
                        for (Object[] gotoStmt : gotoStmts) {
                            int type = Integer.valueOf((String)gotoStmt[3]);
                            if (!gotoStmt[1].equals(ordinalNumber) || type != 22) continue;
                            createNode = true;
                            break;
                        }
                    }
                } else {
                    createNode = true;
                }
                if (createNode) {
                    IGraphNodeLegendInfo paraType = FlowGraphModel.getParaTypeByPrgType(prgType);
                    TSENode para = this.nodeBuilder.addNode(this.graph);
                    String paraName = paragraph[1].toString();
                    String ordinalNum = paragraph[2].toString();
                    boolean isExitParagraph = (Boolean)paragraph[3];
                    String referencesNumber = paragraph[5].toString();
                    boolean isProgramExit = (Boolean)paragraph[4];
                    String paragraphFallThroughtType = paragraph[6].toString();
                    String numOfStmt = paragraph[7].toString();
                    String numOfLines = paragraph[8].toString();
                    GraphUtils.setPropertiesViewerForParagraphs(para, paraName, ordinalNum, isExitParagraph, referencesNumber, isProgramExit, paragraphFallThroughtType, numOfStmt, numOfLines, paraType.getLegendLabel());
                    para.setAttribute(HAS_PROPERTIES_IN_PROPVIEW, (Object)Boolean.TRUE);
                    para.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
                    para.setAttribute(FILL_COLOR, (Object)paraType.getTSEColor());
                    para.setAttribute(VERTEX_ID, paragraph[0]);
                    para.setName((Object)paraName);
                    para.setTooltipText(paraName);
                    if (prevFallThroughType > 0 && prevNode != null) {
                        TSEEdge fallThrough = this.edgeBuilder.addEdge(this.graphManager, prevNode, para);
                        GraphUtils.collectStmtRidForEdge(fallThrough, (String)paragraph[0]);
                        if (prevFallThroughType == 1) {
                            fallThrough.setAttribute("Color", (Object)ProgFlowEdgeLegendInfo.FALLTHROUGH.getTSEColor());
                            this.edgeTypesSetForLegend.add(ProgFlowEdgeLegendInfo.FALLTHROUGH);
                            fallThrough.setAttribute("STMT_TYPE", (Object)ResourceLink.FAKE_STMT_TYPE_FOR_FALL_THROUGH_STRING);
                        } else {
                            fallThrough.setAttribute("Color", (Object)ProgFlowEdgeLegendInfo.COND_FALLTHROUGH.getTSEColor());
                            this.edgeTypesSetForLegend.add(ProgFlowEdgeLegendInfo.COND_FALLTHROUGH);
                            fallThrough.setAttribute("STMT_TYPE", (Object)ResourceLink.FAKE_STMT_TYPE_FOR_COND_FALL_THROUGH_STRING);
                        }
                        fallThrough.setAttribute(HAS_PROPERTIES_IN_PROPVIEW, (Object)true);
                    }
                    prevFallThroughType = (Integer)paragraph[6];
                    prevNode = para;
                    this.paraNodes.add(para);
                    this.paragraphNodes.put(ordinalNumber, para);
                    para.setAttribute("class_name", (Object)paraType.getNodeTypeClass());
                    this.putEntriesInGISV(null, paraType.getLegendLabel(), para);
                    this.nodeTypesSetForLegend.add(paraType);
                    continue;
                }
                prevNode = null;
            }
            if (gotoStmts != null) {
                for (Object[] gotoStmt : gotoStmts) {
                    int type = Integer.valueOf((String)gotoStmt[3]);
                    TSENode source2 = this.paragraphNodes.get(gotoStmt[0]);
                    TSENode dest = this.paragraphNodes.get(gotoStmt[1]);
                    if (dest == null) continue;
                    Object edgeType = null;
                    DIRECTION direction2 = DIRECTION.RIGHT_TO_RIGHT;
                    int conditionalType = (Integer)gotoStmt[2];
                    if (type == 22) {
                        edgeType = conditionalType == 1 ? ProgFlowEdgeLegendInfo.COND_GOTO : CallgraphEdgeLegendInfo.GOTO;
                    } else {
                        edgeType = conditionalType == 1 ? ProgFlowEdgeLegendInfo.COND_PERFORM : ProgFlowEdgeLegendInfo.PERFORM;
                        direction2 = DIRECTION.LEFT_TO_LEFT;
                    }
                    TSEEdge gotoEdge = this.getEdgeIfExists(source2, dest, (String)gotoStmt[3], edgeType.getTSEColor());
                    if (gotoEdge == null) {
                        gotoEdge = this.edgeBuilder.addEdge(this.graphManager, source2, dest);
                        gotoEdge.setAttribute("STMT_TYPE", gotoStmt[3]);
                        gotoEdge.setAttribute("Color", (Object)edgeType.getTSEColor());
                        gotoEdge.setAttribute(EDGE_DIRECTION, (Object)direction2);
                    }
                    gotoEdge.setAttribute(HAS_PROPERTIES_IN_PROPVIEW, (Object)Boolean.TRUE);
                    GraphUtils.collectStmtRidForEdge(gotoEdge, (String)gotoStmt[4]);
                    this.edgeTypesSetForLegend.add(edgeType);
                }
            }
            if (procCallStmts != null) {
                for (Object[] procCallStmt : procCallStmts) {
                    source = this.paragraphNodes.get(procCallStmt[0]);
                    TSENode dest = this.paragraphNodes.get(procCallStmt[1]);
                    if (dest == null) continue;
                    CallgraphEdgeLegendInfo edgeType = CallgraphEdgeLegendInfo.PROCEDURE_CALL;
                    direction = DIRECTION.LEFT_TO_LEFT;
                    TSEEdge callProcEdge = this.getEdgeIfExists(source, dest, (String)procCallStmt[2], edgeType.getTSEColor());
                    if (callProcEdge == null) {
                        callProcEdge = this.edgeBuilder.addEdge(this.graphManager, source, dest);
                        callProcEdge.setAttribute("STMT_TYPE", procCallStmt[2]);
                        callProcEdge.setAttribute("Color", (Object)edgeType.getTSEColor());
                        callProcEdge.setAttribute(EDGE_DIRECTION, (Object)direction);
                    }
                    callProcEdge.setAttribute(HAS_PROPERTIES_IN_PROPVIEW, (Object)Boolean.TRUE);
                    GraphUtils.collectStmtRidForEdge(callProcEdge, (String)procCallStmt[3]);
                    this.edgeTypesSetForLegend.add(edgeType);
                }
            }
            if (adsCallStmts != null) {
                for (Object[] adsCallStmt : adsCallStmts) {
                    source = this.paragraphNodes.get(adsCallStmt[0]);
                    TSENode dest = this.paragraphNodes.get(adsCallStmt[1]);
                    if (dest == null) continue;
                    CallgraphEdgeLegendInfo edgeType = CallgraphEdgeLegendInfo.ADS_CALL;
                    direction = DIRECTION.LEFT_TO_LEFT;
                    TSEEdge adsCallEdge = this.getEdgeIfExists(source, dest, (String)adsCallStmt[2], edgeType.getTSEColor());
                    if (adsCallEdge == null) {
                        adsCallEdge = this.edgeBuilder.addEdge(this.graphManager, source, dest);
                        adsCallEdge.setAttribute("STMT_TYPE", adsCallStmt[2]);
                        adsCallEdge.setAttribute("Color", (Object)edgeType.getTSEColor());
                        adsCallEdge.setAttribute(EDGE_DIRECTION, (Object)direction);
                    }
                    adsCallEdge.setAttribute(HAS_PROPERTIES_IN_PROPVIEW, (Object)Boolean.TRUE);
                    GraphUtils.collectStmtRidForEdge(adsCallEdge, (String)adsCallStmt[3]);
                    this.edgeTypesSetForLegend.add(edgeType);
                }
            }
            String pVRid = (String)this.analysis.getContextValue("PROGRAM_VERTEX_ID");
            OrientVertex pV = this.dbg.getVertex((Object)pVRid);
            TextSelectionInFile prgTsf = com.ez.graphs.viewer.odb.utils.Utils.computeSourceInfoForVertex((Vertex)pV);
            this.inputObjType = com.ez.graphs.viewer.odb.utils.Utils.getResourceType((Vertex)pV, (ProjectInfo)this.ezsourcePrj, (boolean)false);
            this.inputObjType.addProperty("program_path", (Object)prgTsf.getFileName());
            EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)this.inputObjType.getEntID().getSegment(EZSourceProgramIDSg.class);
            this.inputProgramName = prgSg.getListableName();
            this.inputObjType.addProperty("program name", (Object)this.inputProgramName);
            HashSet<TextSelectionInFile> prgs = new HashSet<TextSelectionInFile>();
            prgs.add(prgTsf);
            this.inputObjType.addProperty("FILE", prgs);
            long lstart = System.currentTimeMillis();
            for (String res : GraphUtils.resourceTypes) {
                L.debug("add resources ts nodes " + res);
                this.buildResources(res, (IProgressMonitor)monitor.newChild(10));
            }
            L.debug("total time for adding resources in " + (System.currentTimeMillis() - lstart) + " ms");
            lstart = System.currentTimeMillis();
            for (String res : GraphUtils.extResourceTypes) {
                L.debug("add ext resources ts nodes " + res);
                this.buildExtResources(res, (IProgressMonitor)monitor.newChild(10));
            }
            L.debug("total time for adding external resources in " + (System.currentTimeMillis() - lstart) + " ms");
            lstart = System.currentTimeMillis();
            Iterator callIt = pV.getEdges(Direction.OUT, new String[]{"ProgramCall"}).iterator();
            L.debug("add program calls");
            while (callIt.hasNext()) {
                Edge callEdge = (Edge)callIt.next();
                Vertex proxyVertex2 = callEdge.getVertex(Direction.IN);
                String prgTypeIdString = proxyVertex2.getProperty("type").toString();
                String name = (String)proxyVertex2.getProperty("name");
                if (!showStandardSCLProcs && MappingConstants.SCL_Procedure_Type_STRING.equals(prgTypeIdString) && Utils.isSCLStandardProcedure((String)name)) continue;
                this.drawCallEdge(callEdge, proxyVertex2);
            }
            L.debug("total time for adding program calls " + (System.currentTimeMillis() - lstart) + " ms");
            this.postLoadGraph(monitor);
            ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
            this.dbg = null;
            this.env = null;
        }
        monitor.done();
    }

    private void buildExtResources(String usageInfo, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(FlowGraphModel.class, "loading.ext.resources.graph"));
        List usages = this.analysis.getContextListValue("resources_Info_" + usageInfo);
        if (usages == null) {
            return;
        }
        for (String[] info : usages) {
            Integer ordinalNum = Integer.valueOf(info[8]);
            Optional<Integer> bRead = null;
            TSENode paraNode = this.paragraphNodes.get(ordinalNum);
            if (paraNode == null) {
                L.debug("statement hasn't paragraph information");
                continue;
            }
            if ("ExtFileUsageInfo".equals(usageInfo)) {
                bRead = Optional.of(Integer.valueOf(info[9]));
            }
            ExtCallTargetType tgtType = GraphUtils.getExtCallType(usageInfo, bRead);
            TSENode extNode = this.addExtResourceNode(info, tgtType);
            HashSet<String> stmts = new HashSet<String>();
            stmts.add(info[1]);
            Triplet<TSENode, TSENode, String> triplet = GraphUtils.computeAccesType(paraNode, extNode, tgtType);
            TSEEdge edge = this.makeCallExtEdge((TSENode)triplet.getFirst(), (TSENode)triplet.getSecond(), stmts, (String)triplet.getThird());
            if (edge == null || edge.hasAttribute(EDGE_DIRECTION)) continue;
            if (((String)triplet.getThird()).equals(ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_READ_STRING)) {
                edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.LEFT_TO_RIGHT);
                continue;
            }
            edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.RIGHT_TO_LEFT);
        }
    }

    public void setIMSHierarchicalModel(boolean isIMSHierarchicalModel) {
        this.isIMSHierarchicalModel = isIMSHierarchicalModel;
    }

    private void buildResources(String usageInfo, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(FlowGraphModel.class, "loading.resources.graph"));
        List usages = this.analysis.getContextListValue("resources_Info_" + usageInfo);
        if (usages == null) {
            return;
        }
        switch (usageInfo) {
            case "FileUsageInfo": {
                this.buildFileResource(usages);
                break;
            }
            case "IMSSegmentUsageInfo": {
                List pcbUsages;
                this.buildIMSSegmentResource(usages);
                if (!this.isIMSHierarchicalModel || (pcbUsages = this.analysis.getContextListValue("resources_Info_IMSPCBUsageInfo")) == null) break;
                this.buildIMSSegmentByPCBResource(pcbUsages);
                break;
            }
            default: {
                for (String[] info : usages) {
                    String stmtRid = info[1];
                    Integer ordinalNum = Integer.valueOf(info[5]);
                    TSENode paraNode = this.paragraphNodes.get(ordinalNum);
                    if (paraNode == null) {
                        L.debug("statement hasn't paragraph information");
                        continue;
                    }
                    Integer bRead = Integer.valueOf(info[2]);
                    OrientVertex proxy = this.dbg.getVertex((Object)info[3]);
                    String stmtType = info[4];
                    if ("TranUsageInfo".equals(usageInfo) || "IMSTransactionUsageInfo".equals(usageInfo)) {
                        boolean isMapped = this.searchMappBetweenTransactionAndProgram(stmtRid, paraNode, (Vertex)proxy, stmtType);
                        if (isMapped) continue;
                        this.addResourceNode(paraNode, stmtRid, stmtType, (Vertex)proxy, null, bRead);
                        continue;
                    }
                    this.addResourceNode(paraNode, stmtRid, stmtType, (Vertex)proxy, null, bRead);
                }
            }
        }
    }

    private void buildFileResource(List<String[]> usages) {
        Map resDatasets = (Map)this.analysis.getContextValue("resources_Info_Datasets");
        for (String[] info : usages) {
            String stmtRid = info[1];
            Integer ordinalNum = Integer.valueOf(info[5]);
            TSENode paraNode = this.paragraphNodes.get(ordinalNum);
            Integer bRead = Integer.valueOf(info[2]);
            OrientVertex usage = this.dbg.getVertex((Object)info[3]);
            String usageRid = usage.getId().toString();
            String stmtType = info[4];
            String fileName = com.ez.graphs.viewer.odb.utils.Utils.getTSNodeName((Vertex)usage);
            if (resDatasets != null && resDatasets.containsKey(usageRid)) {
                List ddCardRids = (List)resDatasets.get(usageRid);
                for (String ddcardRid : ddCardRids) {
                    OrientVertex ddCardV = this.dbg.getVertex((Object)ddcardRid);
                    OrientVertex dsV = null;
                    Iterator iterator = ddCardV.getVertices(Direction.OUT, new String[]{"MappedTo"}).iterator();
                    if (iterator.hasNext()) {
                        dsV = (OrientVertex)iterator.next();
                        String dsid = (String)dsV.getProperty("dsid");
                        Pair pair = com.ez.gdb.core.utils.Utils.splitDSid((String)dsid);
                        String dsWithFileName = String.valueOf((String)pair.getFirst()) + fileName;
                        this.addResourceNode(paraNode, stmtRid, stmtType, (Vertex)dsV, dsWithFileName, bRead);
                        continue;
                    }
                    this.addResourceNode(paraNode, stmtRid, stmtType, (Vertex)usage, fileName, bRead);
                }
                continue;
            }
            fileName = this.addPhysicalNameToFile((Vertex)usage, fileName);
            this.addResourceNode(paraNode, stmtRid, stmtType, (Vertex)usage, fileName, bRead);
        }
    }

    private void buildIMSSegmentResource(List<String[]> usages) {
        for (String[] info : usages) {
            String[] entries;
            Integer ordinalNum = Integer.valueOf(info[5]);
            TSENode paraNode = this.paragraphNodes.get(ordinalNum);
            if (paraNode == null) {
                L.debug("statement hasn't paragraph information");
                continue;
            }
            String stmtRid = info[1];
            String stmtType = info[4];
            Integer bRead = Integer.valueOf(info[2]);
            OrientVertex proxy = this.dbg.getVertex((Object)info[3]);
            String physicalRids = info[6];
            boolean isLogical = physicalRids.length() > 2;
            OrientVertex imsProxy = proxy.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().hasNext() ? (Vertex)proxy.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().next() : proxy;
            TSENode node = this.addResourceNode(paraNode, stmtRid, stmtType, (Vertex)imsProxy, null, bRead);
            if (!isLogical || node == null) continue;
            node.setAttribute("linked", (Object)true);
            physicalRids = physicalRids.substring(physicalRids.indexOf("[") + 1, physicalRids.indexOf("]"));
            String[] stringArray = entries = physicalRids.split(",");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                OrientVertex pproxyV;
                String entrie = stringArray[n2];
                OrientVertex v = pproxyV = this.dbg.getVertex((Object)entrie);
                if (pproxyV.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().hasNext()) {
                    v = (Vertex)pproxyV.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().next();
                }
                this.linkToAnoterResource((Vertex)v, node);
                ++n2;
            }
        }
    }

    private void buildIMSSegmentByPCBResource(List<String[]> usages) {
        HashMap<String, TSENode> pcbNodeMap = new HashMap<String, TSENode>();
        TSENode node = null;
        for (String[] info : usages) {
            TSENode pcbNode;
            Integer ordinalNum = Integer.valueOf(info[5]);
            TSENode paraNode = this.paragraphNodes.get(ordinalNum);
            if (paraNode == null) {
                L.debug("statement hasn't paragraph information");
                continue;
            }
            String stmtRid = info[1];
            String stmtType = info[4];
            Integer bRead = Integer.valueOf(info[2]);
            OrientVertex pcbProxy = this.dbg.getVertex((Object)info[3]);
            String pcbId = (String)pcbProxy.getProperty("pcbId");
            String pcbOrdNum = (String)pcbProxy.getProperty("pcbOrdNum");
            Iterable segProxysV = pcbProxy.getVertices(Direction.OUT, new String[]{"IMSPCBToSegLink"});
            ArrayList<String> segProxyIdList = new ArrayList<String>();
            if (segProxysV != null) {
                Iterator it = segProxysV.iterator();
                while (it != null && it.hasNext()) {
                    Vertex proxy = (Vertex)it.next();
                    segProxyIdList.add(proxy.getId().toString());
                }
            }
            if ((pcbNode = (TSENode)pcbNodeMap.get(pcbId)) == null) {
                pcbNode = this.graphManager.getNodeBuilder().addNode(this.graph);
                pcbNodeMap.put(pcbId, pcbNode);
                this.resNodes.add(pcbNode);
                TSEGraph childGraph = (TSEGraph)this.graphManager.addGraph();
                pcbNode.setChildGraph((TSGraph)childGraph);
                childGraph.setAttribute("TS nodes per project", new HashMap());
                childGraph.setAttribute("MAINFRAME_PROJECT_ID_SG", (Object)this.projectIdSg);
                childGraph.setName((Object)("IMS" + pcbId));
                TSENestingManager.expand((TSDNode)pcbNode);
                String pcbCateg = Messages.getString(FlowGraphModel.class, "legend.label.imsdb.pcb");
                this.putEntriesInGISV(null, pcbCateg, pcbNode);
                String dbnameStr = null;
                String pcbLbl = "PCB[".concat(pcbOrdNum).concat("]");
                for (String segProxyId : segProxyIdList) {
                    OrientVertex proxy = this.dbg.getVertex((Object)segProxyId);
                    OrientVertex imsSegmentV = proxy.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().hasNext() ? (Vertex)proxy.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().next() : proxy;
                    node = this.getOrCreateTSNode(childGraph, (Vertex)imsSegmentV, null, false);
                    TSENode parentN = null;
                    Vertex parentV = imsSegmentV.getVertices(Direction.OUT, new String[]{"IMSSParent"}).iterator().hasNext() ? (Vertex)imsSegmentV.getVertices(Direction.OUT, new String[]{"IMSSParent"}).iterator().next() : null;
                    Vertex parentProxy = null;
                    if (parentV != null && segProxyIdList.contains((parentProxy = (Vertex)parentV.getVertices(Direction.IN, new String[]{"IMSProxyOf"}).iterator().next()).getId().toString())) {
                        parentN = this.getOrCreateTSNode(childGraph, parentV, null, false);
                        FlowGraphModel.getOrCreateHierarchyEdge(childGraph, parentN, node);
                    }
                    if (!node.hasAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY")) {
                        String inventoryLbl = node.getName().toString().concat(" - ").concat(pcbLbl);
                        node.setAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY", (Object)inventoryLbl);
                    }
                    dbnameStr = (String)proxy.getProperty("dbName");
                }
                pcbNode.setName((Object)dbnameStr.concat(".").concat(pcbLbl));
                pcbNode.setAttribute(NODE_MAINFRAME, (Object)new GenericProgramRelatedNode(pcbLbl, ResultElementType.IMSDB_PCB.getDisplayName()));
            }
            GraphUtils.linkResourceNode(this.graphManager, paraNode, pcbNode, stmtRid, stmtType, bRead);
        }
    }

    private static TSEdge getOrCreateHierarchyEdge(TSEGraph graph, TSENode from, TSENode to) {
        TSEdge edge = null;
        List outs = from.outEdges();
        for (TSEEdge ed : outs) {
            if (!ed.getTargetNode().equals(to)) continue;
            edge = ed;
            break;
        }
        if (edge == null) {
            edge = graph.addEdge((TSNode)from, (TSNode)to);
        }
        return edge;
    }

    private boolean searchMappBetweenTransactionAndProgram(String stmtRid, TSENode paraNode, Vertex proxy, String stmtType) {
        Iterator it = proxy.getVertices(Direction.OUT, new String[]{TRANSACTION_MAPPING_EDGE}).iterator();
        boolean isMapped = false;
        while (it.hasNext()) {
            TSEEdge edge;
            Vertex mappedPrgProxyV = (Vertex)it.next();
            String programName = (String)mappedPrgProxyV.getProperty("name");
            L.debug("transaction is mapped with program " + programName);
            if (this.inputProgramName.equalsIgnoreCase(programName)) {
                TSENode firstParagraph = this.paraNodes.get(0);
                edge = GraphUtils.getOrCreateEdge(this.graphManager, paraNode, firstParagraph, stmtRid, stmtType);
                edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.RIGHT_TO_RIGHT);
            } else {
                TSENode mappedPrgNode = this.getOrCreateTSNode(mappedPrgProxyV, null, true);
                if (mappedPrgNode == null) {
                    L.warn("ts node for mapped program not found");
                } else {
                    edge = GraphUtils.getOrCreateEdge(this.graphManager, paraNode, mappedPrgNode, stmtRid, stmtType);
                    edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.RIGHT_TO_LEFT);
                }
            }
            isMapped = true;
        }
        return isMapped;
    }

    private void linkToAnoterResource(Vertex v, TSENode node) {
        TSENode physicalNode = this.getOrCreateTSNode(v, null, false);
        GraphUtils.getOrCreateEdge(this.graphManager, node, physicalNode, null, ResourceLink.FAKE_STMT_TYPE_IMS_LOGIC_TO_PHYSIC_SEGMENT_STRING);
    }

    private TSENode addExtResourceNode(String[] info, ExtCallTargetType ttype) {
        String tgName = info[4];
        String location = info[5];
        String pType = info[7];
        String addinfo = info[10];
        if (addinfo != null) {
            tgName = addinfo.concat("-").concat(tgName);
        }
        ExtCallLocationType locationType = ExtCallLocationType.getLocType(Integer.valueOf(info[6]));
        if (pType != null && ttype.equals((Object)ExtCallTargetType.PROGRAM)) {
            ttype = String.valueOf(ProgramType.COBOL.getProgramTypeId()).equals(pType) ? ExtCallTargetType.PROGRAM_COBOL : ExtCallTargetType.PROGRAM_PLI;
        }
        TSENode node = this.getOrCreateExtNode(tgName, ttype.getDescription(), ttype.getTSType(), location, locationType.getDescription(), pType);
        this.resNodes.add(node);
        return node;
    }

    private TSENode addResourceNode(TSENode prgNode, String stmtRid, String stmtType, Vertex resV, String dsName, Integer bRead) {
        TSENode node = this.getOrCreateTSNode(resV, dsName, false);
        TSEEdge edge = GraphUtils.linkResourceNode(this.graphManager, prgNode, node, stmtRid, stmtType, bRead);
        if (bRead == 0 || 2 == bRead) {
            edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.RIGHT_TO_LEFT);
        } else {
            edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.LEFT_TO_RIGHT);
        }
        return node;
    }

    protected TSENode getOrCreateTSNode(Vertex proxyV, String fileName, boolean isPrg) {
        TSENode node = super.getOrCreateTSNode(proxyV, fileName, isPrg);
        this.resNodes.add(node);
        return node;
    }

    private void drawCallEdge(Edge callEdge, Vertex proxyVertex2) {
        OrientVertex prgUsageV = (OrientVertex)callEdge.getProperty("prgUsage");
        if (prgUsageV.getProperty("@class").equals(PROG_USAGE_INFO_VERTEX)) {
            TSENode prgNode = this.getOrCreateTSNode(proxyVertex2, null, true);
            OrientVertex stmtV = (OrientVertex)prgUsageV.getVertices(Direction.IN, new String[]{"UsesPUI"}).iterator().next();
            String stmtRid = stmtV.getId().toString();
            String stmtTpe = (String)stmtV.getProperty("typeId");
            Integer cbOrdinalNumber = (Integer)stmtV.getProperty("codeBlockOrdinalNumber");
            TSENode paraNode = this.paragraphNodes.get(cbOrdinalNumber);
            TSEEdge edge = GraphUtils.getOrCreateEdge(this.graphManager, paraNode, prgNode, stmtRid, stmtTpe);
            edge.setAttribute(EDGE_DIRECTION, (Object)DIRECTION.RIGHT_TO_LEFT);
        } else {
            L.debug("ignore call between programs via CICS");
        }
    }

    private TSEEdge getEdgeIfExists(TSENode parent, TSENode childTS, String edgeType, TSEColor color) {
        TSEEdge edgeResult = null;
        List outs = parent.outEdges();
        for (TSEEdge edge : outs) {
            if (!edge.getTargetNode().equals(childTS) || !edge.hasAttribute("STMT_TYPE") || !edgeType.equals((String)edge.getAttributeValue("STMT_TYPE"))) continue;
            if (color != null) {
                if (!edge.hasAttribute("Color") || !color.equals((Object)((TSEColor)edge.getAttributeValue("Color")))) continue;
                edgeResult = edge;
                continue;
            }
            edgeResult = edge;
            break;
        }
        return edgeResult;
    }

    private void makeFileAttribute(TSGraphMember nodeOrEdge, String fileName, String fileType, String ... positionInfos) {
        TextSelectionInFile infoSel = new TextSelectionInFile(fileName, fileType, positionInfos);
        com.ez.cobol.callgraph.utils.Utils.setFileAttribute((TSGraphMember)nodeOrEdge, (TextSelectionInFile)infoSel);
    }

    private boolean useAncestorInformation(String ancestor, String prgTypeIdString) {
        return !MappingConstants.SCL_Procedure_Type_STRING.equals(prgTypeIdString) && Utils.filterNullValue((String)ancestor) != null && !ancestor.isEmpty();
    }

    protected static IGraphNodeLegendInfo getParaTypeByPrgType(int prgTypeId) {
        ProgFlowNodeLegendInfo paraType = null;
        switch (prgTypeId) {
            case 1: 
            case 9: {
                paraType = ProgFlowNodeLegendInfo.PARAGRAPH;
                break;
            }
            case 3: 
            case 10: {
                paraType = ProgFlowNodeLegendInfo.SUBROUTINE;
                break;
            }
            case 2: {
                paraType = ProgFlowNodeLegendInfo.PROCEDURE;
            }
        }
        return paraType;
    }

    protected static IGraphNodeLegendInfo getParaTypeByPrgType(String prgType) {
        Integer prgTypeId = Integer.parseInt(prgType);
        return FlowGraphModel.getParaTypeByPrgType(prgTypeId);
    }

    protected void initGraph() {
        super.initGraph();
        this.nodeBuilder = this.graphManager.getNodeBuilder();
        if (this.nodeBuilder == null) {
            this.nodeBuilder = new TSNodeBuilder();
            this.graphManager.setNodeBuilder(this.nodeBuilder);
        }
        this.edgeBuilder = this.graphManager.getEdgeBuilder();
        if (this.edgeBuilder == null) {
            this.edgeBuilder = new TSEdgeBuilder();
            this.graphManager.setEdgeBuilder(this.edgeBuilder);
        }
        this.nodeBuilder.setAttribute("Background_Color", (Object)TSEColor.darkGreen);
        this.nodeBuilder.setShape((TSShape)TSPolygonShape.getInstance((String)"rrect"));
        this.nodeBuilder.setResizability(3);
        TSCompositeNodeUI nodeUI = (TSCompositeNodeUI)this.nodeBuilder.getNodeUI();
        if (nodeUI == null) {
            nodeUI = new TSCompositeNodeUI();
        }
        TSTextUIElement imgTextElement = new TSTextUIElement();
        imgTextElement.setText("$tag()");
        imgTextElement.setName("imgTextElement");
        nodeUI.getStyle().setProperty((TSUIElement)imgTextElement, "TEXT_COLOR", (Serializable)((Object)"<Text_Color>"));
        nodeUI.getStyle().setProperty((TSUIElement)imgTextElement, "TEXT_FONT", (Serializable)((Object)"<Text_Font>"));
        nodeUI.getStyle().setProperty((TSUIElement)imgTextElement, "HORIZONTAL_JUSTIFICATION", (Serializable)Integer.valueOf(2));
        TSImageUIElement imgElement = new TSImageUIElement("image", new TSUIElementPoint(-0.5, 0.0, 0.5, 0.0), new TSUIElementPoint(0.5, 0.0, -0.5, 0.0));
        nodeUI.getStyle().setProperty((TSUIElement)imgElement, "TIGHT_WIDTH", (Serializable)Double.valueOf(40.0));
        nodeUI.getStyle().setProperty((TSUIElement)imgElement, "TIGHT_HEIGHT", (Serializable)Double.valueOf(40.0));
        TSSplitterUIElement splitterElement = new TSSplitterUIElement("splitter", (TSUIElement)imgElement, (TSUIElement)imgTextElement);
        nodeUI.getStyle().setProperty((TSUIElement)splitterElement, "FIXED_ELEMENT_LOCATION", (Serializable)new Integer(0));
    }

    public void customLayout() {
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)this.graphManager);
        this.customTSLayout();
        TSHierarchicalLayoutInputTailor hit = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraph)this.graph);
        hit.setAsCurrentLayoutStyle();
        List edges = this.graph.edges();
        for (TSEdge edge : edges) {
            DIRECTION dir = (DIRECTION)((Object)edge.getAttributeValue(EDGE_DIRECTION));
            if (dir == null) continue;
            int type = dir.ordinal();
            switch (type) {
                case 0: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 1);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 1);
                    break;
                }
                case 1: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 2);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 2);
                    break;
                }
                case 2: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 1);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 2);
                    break;
                }
                case 3: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 2);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 1);
                    break;
                }
                default: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 4);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 8);
                }
            }
        }
        this.doRouting(inputData);
    }

    public void customIMSHierarchicalLayout() {
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)this.graphManager);
        TSELayoutCommand layoutCommand = null;
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        LinkedList graphList = new LinkedList();
        TSENestingManager.buildAllNestedGraphList((TSDGraph)this.graph, graphList, (boolean)false);
        for (TSEGraph graph1 : graphList) {
            TSHierarchicalLayoutInputTailor layoutInputTailor1 = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraph)graph1);
            layoutInputTailor1.setGraph((TSDGraph)graph1);
            layoutInputTailor1.setAsCurrentLayoutStyle();
        }
        layoutCommand = new TSELayoutCommand((TSViewportCanvas)canvas, (TSServiceInputDataInterface)inputData);
        layoutCommand.setCoalesced(true);
        canvas.getCommandManager().transmit((TSCommandInterface)layoutCommand);
        this.customTSLayout();
        TSHierarchicalLayoutInputTailor hit = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraph)this.graph);
        hit.setAsCurrentLayoutStyle();
        List edges = this.graph.edges();
        for (TSEdge edge : edges) {
            DIRECTION dir = (DIRECTION)((Object)edge.getAttributeValue(EDGE_DIRECTION));
            if (dir == null) continue;
            int type = dir.ordinal();
            switch (type) {
                case 0: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 1);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 1);
                    break;
                }
                case 1: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 2);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 2);
                    break;
                }
                case 2: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 1);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 2);
                    break;
                }
                case 3: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 2);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 1);
                    break;
                }
                default: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 4);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 8);
                }
            }
        }
        this.doRouting(inputData);
    }

    private void doRouting(TSEAllOptionsServiceInputData inputData) {
        TSLayoutProxy layoutProxy = new TSLayoutProxy();
        TSRoutingInputTailor routingInputTailor = new TSRoutingInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        routingInputTailor.setFixedPositions(true);
        routingInputTailor.setFixedSizes(false);
        routingInputTailor.setEdgeList(this.graphManager.getMainDisplayGraph().edges());
        routingInputTailor.setAsCurrentOperation();
        TSServiceOutputData outputData = new TSServiceOutputData();
        layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        TSEApplyLayoutResults applyResult = new TSEApplyLayoutResults();
        applyResult.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
    }

    private void customTSLayout() {
        Map<Double, TSENode> paraCenters = this.positionParagraphNodes();
        HashMap<Double, List<TSENode>> resPositions = new HashMap<Double, List<TSENode>>();
        TSConstSize resNodeSize = null;
        block0: for (TSENode resNode : this.resNodes) {
            List<Double> ry = this.computeResourcePosition(resNode);
            if (resNodeSize == null) {
                resNodeSize = resNode.getSize();
            } else if (resNodeSize.getWidth() < resNode.getWidth()) {
                resNodeSize = resNode.getSize();
            }
            resNode.setResizability(0x1000000);
            for (double d : ry) {
                ArrayList<TSENode> nodes = (ArrayList<TSENode>)resPositions.get(d);
                if (nodes != null && ry.size() - 1 != ry.indexOf(d)) continue;
                if (nodes == null) {
                    nodes = new ArrayList<TSENode>();
                }
                resPositions.put(d, nodes);
                nodes.add(resNode);
                continue block0;
            }
        }
        this.positionResources(paraCenters, resPositions, resNodeSize);
    }

    private Map<Double, TSENode> positionParagraphNodes() {
        double y = 0.0;
        TSConstSize nodeS = null;
        for (TSENode paraNode : this.paraNodes) {
            int edges = paraNode.inEdges().size();
            y = y - (double)this.minVerticalParagraphSpace - (double)((edges += paraNode.outEdges().size()) * this.paragraphEdgeSpacingCoeficient);
            paraNode.setCenter(0.0, y);
            paraNode.setAttribute("para", (Object)true);
            y -= (double)(edges * this.paragraphEdgeSpacingCoeficient);
            TSConstSize paraS = paraNode.getSize();
            if (nodeS == null) {
                nodeS = paraS;
                continue;
            }
            if (!(nodeS.getWidth() < paraS.getWidth())) continue;
            nodeS = paraS;
        }
        return this.adjustParaSizes(nodeS);
    }

    private Map<Double, TSENode> adjustParaSizes(TSConstSize maxWidthNode) {
        HashMap<Double, TSENode> centers = new HashMap<Double, TSENode>();
        for (TSENode paraNode : this.paraNodes) {
            paraNode.setSize(new TSConstSize(maxWidthNode.getWidth(), Math.max(paraNode.getHeight(), (double)this.minParagraphHeightNode)));
            double ycenter = paraNode.getCenterY();
            centers.put(ycenter, paraNode);
            paraNode.setResizability(0x1000000);
        }
        return centers;
    }

    private void positionResources(Map<Double, TSENode> paraCenters, Map<Double, List<TSENode>> resPositions, TSConstSize resNodeSize) {
        ArrayList<Double> paraPos = new ArrayList<Double>(paraCenters.keySet());
        Collections.sort(paraPos);
        int minVerticalParagraphSpace = 60;
        double y = 0.0;
        for (Double paray : paraPos) {
            TSENode paraNode = paraCenters.remove(paray);
            List<TSENode> resNodes = resPositions.remove(paray);
            if (y == 0.0) {
                y = paraNode.getCenterY();
            }
            if (resNodes != null) {
                int maxDispl = resNodes.size();
                int nDispl = maxDispl / 2;
                int i = 0;
                for (TSENode node : resNodes) {
                    node.setSize(new TSConstSize(resNodeSize.getWidth(), Math.max(paraNode.getHeight(), (double)this.minResHeightNode)));
                    node.setCenter((double)this.resXDisplacement, y);
                    if (i == nDispl) {
                        paraNode.setCenterY(y);
                    }
                    y += (double)minVerticalParagraphSpace;
                    ++i;
                }
                continue;
            }
            paraNode.setCenterY(y);
            y += (double)minVerticalParagraphSpace;
        }
    }

    private List<Double> computeResourcePosition(TSENode resNode) {
        int level;
        double y;
        ArrayList<Double> positions = new ArrayList<Double>();
        HashMap<Double, Integer> posMap = new HashMap<Double, Integer>();
        this.buildConnectivityMap(resNode, posMap, true);
        this.buildConnectivityMap(resNode, posMap, false);
        int maxLevel = -1;
        Iterator iterator = posMap.keySet().iterator();
        while (iterator.hasNext()) {
            y = (Double)iterator.next();
            level = (Integer)posMap.get(y);
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        iterator = posMap.keySet().iterator();
        while (iterator.hasNext()) {
            y = (Double)iterator.next();
            level = (Integer)posMap.get(y);
            if (level != maxLevel) continue;
            positions.add(y);
        }
        if (positions.isEmpty()) {
            double pos = 0.0;
            positions.add(pos);
        }
        return positions;
    }

    private void buildConnectivityMap(TSENode resNode, Map<Double, Integer> posMap, boolean inDirection) {
        List edgeList = null;
        edgeList = inDirection ? resNode.inEdges() : resNode.outEdges();
        for (Object oEdge : edgeList) {
            TSEEdge edge = (TSEEdge)oEdge;
            TSENode node = null;
            node = inDirection ? (TSENode)edge.getSourceNode() : (TSENode)edge.getTargetNode();
            if (node.hasAttribute("para") && ((Boolean)node.getAttributeValue("para")).booleanValue()) {
                double ny = node.getCenterY();
                Integer edges = posMap.get(ny);
                if (edges == null) {
                    edges = new Integer(1);
                    posMap.put(ny, 1);
                    continue;
                }
                posMap.put(ny, edges + 1);
                continue;
            }
            if (!node.hasAttribute("linked") || !((Boolean)node.getAttributeValue("linked")).booleanValue()) continue;
            HashMap<Double, Integer> parentPosMap = new HashMap<Double, Integer>();
            this.buildConnectivityMap(node, parentPosMap, true);
            this.buildConnectivityMap(node, parentPosMap, false);
            posMap.putAll(parentPosMap);
        }
    }

    public void updateDrawing() {
        TSDGraph hide;
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    public void clear() {
        this.links = null;
        this.programPaths = null;
    }

    protected OrientExtendedGraph getOrientDbg() {
        if (this.dbg == null) {
            if (this.env == null) {
                this.env = (Properties)this.analysis.getContextValue("env");
            }
            this.dbg = ConnectionUtils.getNoTxGraph((Properties)this.env);
        }
        return this.dbg;
    }

    protected OrientExtendedGraph getOrientDbg(String prjName) {
        return this.getOrientDbg();
    }

    public void dispose() {
        block8: {
            this.analysis = null;
            this.links = null;
            this.programPaths = null;
            this.edgeBuilder = null;
            this.nodeBuilder = null;
            this.inputObjType = null;
            try {
                try {
                    if (this.dbg != null) {
                        ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
                    }
                }
                catch (Exception e) {
                    L.error("while clearing", (Throwable)e);
                    this.env = null;
                    this.dbg = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.env = null;
                this.dbg = null;
                throw throwable;
            }
            this.env = null;
            this.dbg = null;
        }
        if (this.paragraphNodes != null) {
            this.paragraphNodes.clear();
            this.paragraphNodes = null;
        }
        if (this.paraNodes != null) {
            this.paraNodes.clear();
            this.paraNodes = null;
        }
        super.dispose();
    }

    EZObjectType getInputTypeObj() {
        return this.inputObjType;
    }

    protected String[] getInputNameAndPath(TSEdge e) {
        return new String[]{(String)this.getInputTypeObj().getProperty("program name"), (String)this.getInputTypeObj().getProperty("program_path")};
    }

    public void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
        String newLine = System.getProperty("line.separator");
        try {
            FileWriter fw;
            File f;
            File firstProg;
            boolean found;
            if ("full".equals(System.getProperty("test"))) {
                found = false;
                firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                    pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt") - 2)) + ".txt";
                }
                fw = new FileWriter(pathToWrite, true);
                fw.write(newLine);
                fw.write("Program name :" + fileName);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
            } else {
                File file;
                found = false;
                firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
            }
            List graphNodes = graph.nodes();
            TSENodeComparator comparator = new TSENodeComparator();
            Collections.sort(graphNodes, comparator);
            for (TSENode node : graphNodes) {
                String name = node.getText();
                fw.write(newLine);
                fw.write(name);
                for (Object allAttrNames : node.getAttributeNames()) {
                    if (allAttrNames.toString().equals("FILE")) {
                        Set locations = (Set)node.getAttributeValue("FILE");
                        if (locations == null) continue;
                        for (TextSelectionInFile tsf : locations) {
                            fw.write(newLine);
                            fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                            fw.write(newLine);
                            fw.write("Program type :" + tsf.getPrgType());
                            fw.write(newLine);
                        }
                        continue;
                    }
                    if (allAttrNames.toString().trim().equals(SCREEN_OCCUR_ID_ATTRIBUTE) || allAttrNames.toString().trim().equals(SCREEN_ID) || allAttrNames.toString().trim().equals(BOUNDS) || allAttrNames.toString().trim().equals(HAS_PROPERTIES_IN_PROPVIEW) || allAttrNames.toString().trim().equals(VERTEX_ID) || allAttrNames.toString().trim().equals(NODE_MAINFRAME) || allAttrNames.toString().trim().equals(APPLICABLE_INPUT)) continue;
                    fw.write(newLine);
                    fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                }
                List inEdges = node.inEdges();
                fw.write(newLine);
                fw.write(newLine);
                fw.write("The in edges :");
                this.writeEdge(inEdges, node, fw);
                List outEdges = node.outEdges();
                fw.write(newLine);
                fw.write("The out edges :");
                this.writeEdge(outEdges, node, fw);
                fw.write(newLine);
            }
            fw.close();
        }
        catch (IOException iOException) {
            L.error("Couldn't write to file");
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                DIRECTION edgeDirection = null;
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute(EDGE_DIRECTION)) {
                    edgeDirection = (DIRECTION)((Object)tSEEdge.getAttributeValue(EDGE_DIRECTION));
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                value.append("Statement Type: ");
                value.append(stmtType);
                value.append("  with direction : ");
                value.append((Object)edgeDirection);
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }

    public List<TSEGraph> getGraphs() {
        ArrayList<TSEGraph> graphList = new ArrayList<TSEGraph>();
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        graphList.add(mainGraph);
        TSENestingManager.buildAllNestedGraphList((TSDGraph)this.graph, graphList, (boolean)false);
        return graphList;
    }

    static enum DIRECTION {
        LEFT_TO_LEFT,
        RIGHT_TO_RIGHT,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

