/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph.ue;

import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserExitsToPrj {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String prjName;
    private Map<ExtCallTargetType, Set<String>> ue = new HashMap<ExtCallTargetType, Set<String>>();
    private Set<Integer> prgForForward = new HashSet<Integer>();
    private Set<Integer> prgForBackward = new HashSet<Integer>();
    private Set<String> prgRidForForward = new HashSet<String>();
    private Set<String> prgRidForBackward = new HashSet<String>();

    public UserExitsToPrj(String prjName) {
        this.prjName = prjName;
    }

    public void addTarget(ExtCallTargetType ttype, String targetName) {
        Set<String> ue = this.getExtCallsByType(ttype);
        ue.add(targetName);
    }

    public Set<String> getExtCallsByType(ExtCallTargetType ttype) {
        Set<String> ec = this.ue.get((Object)ttype);
        if (ec == null) {
            ec = new HashSet<String>();
            this.ue.put(ttype, ec);
        }
        return ec;
    }

    public void addPrgForForw(Set<Integer> sids) {
        this.prgForForward.addAll(sids);
    }

    public Set<Integer> getPrgForForward() {
        return this.prgForForward;
    }

    public void addPrgRidForForw(Set<String> rids) {
        this.prgRidForForward.addAll(rids);
    }

    public Set<String> getPrgRidForForward() {
        return this.prgRidForForward;
    }

    public void addPrgForBack(Set<Integer> sids) {
        this.prgForBackward.addAll(sids);
    }

    public Set<Integer> getPrgForBackward() {
        return this.prgForBackward;
    }

    public void addPrgRidForBack(Set<String> rids) {
        this.prgRidForBackward.addAll(rids);
    }

    public Set<String> getPrgRidForBackward() {
        return this.prgRidForBackward;
    }
}

