/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph.ue;

import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.Target;
import com.ez.internal.utils.Pair;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserExitsFromPrg {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UserExitsFromPrg.class);
    private TSENode prgGraphNode;
    private String prgRid;
    private String sourcePrjName;
    private Map<Pair<ExtCallTargetType, ExtCallLocationType>, Map<String, Set<Target>>> ue = new HashMap<Pair<ExtCallTargetType, ExtCallLocationType>, Map<String, Set<Target>>>();
    private Map<String, Set<Pair<String, String>>> mqNames = new HashMap<String, Set<Pair<String, String>>>();
    private Map<String, Set<String>> queueNames = new HashMap<String, Set<String>>();

    public UserExitsFromPrg(String sourcePrjName, String prgRid) {
        this.sourcePrjName = sourcePrjName;
        this.prgRid = prgRid;
    }

    public String getPrgRid() {
        return this.prgRid;
    }

    public void setPrgGraphNode(TSENode prgGraphNode) {
        this.prgGraphNode = prgGraphNode;
    }

    public void setSourcePrjName(String sourcePrjName) {
        this.sourcePrjName = sourcePrjName;
    }

    public String getSourcePrjName() {
        return this.sourcePrjName;
    }

    public TSENode getPrgGraphNode() {
        return this.prgGraphNode;
    }

    public void addTarget(Target t) {
        ExtCallLocationType locType;
        ExtCallTargetType tgtType = t.getTgtType();
        Map<String, Set<Target>> prgNamesInPrj = this.getTgts(tgtType, locType = t.getLocType());
        if (prgNamesInPrj != null) {
            String prjName = t.getLocation();
            Set<Target> programsByPrj = prgNamesInPrj.get(prjName);
            if (programsByPrj == null) {
                programsByPrj = new HashSet<Target>();
                prgNamesInPrj.put(prjName, programsByPrj);
            }
            if (programsByPrj.contains(t)) {
                Iterator<Target> it = programsByPrj.iterator();
                while (it.hasNext()) {
                    Target e = it.next();
                    if (!e.equals(t)) continue;
                    Set<String> eStmts = e.getStmts();
                    t.updateStmts(eStmts);
                    it.remove();
                    break;
                }
            }
            programsByPrj.add(t);
        }
    }

    public Map<String, Set<Target>> getTgts(ExtCallTargetType tgtType, ExtCallLocationType locType) {
        Pair key = new Pair((Object)tgtType, (Object)locType);
        Map<String, Set<Target>> tgtCollection = this.ue.get(key);
        if (tgtCollection == null) {
            tgtCollection = new HashMap<String, Set<Target>>();
            this.ue.put((Pair<ExtCallTargetType, ExtCallLocationType>)key, tgtCollection);
        }
        return tgtCollection;
    }

    public boolean hasTgt() {
        return this.getTgts(ExtCallTargetType.PROGRAM_COBOL, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.PROGRAM_PLI, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.TRANSACTION, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.IMS_TM, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.FILE_AT_READ, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.FILE_AT_WRITE, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.SQLTABLE, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.BMS, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.IMS_MOD, ExtCallLocationType.APPLICATION).size() + this.getTgts(ExtCallTargetType.IMS_SEGMENT, ExtCallLocationType.APPLICATION).size() > 0;
    }

    public void addMq(String prjName, String mq, String mqManager) {
        Set<Pair<String, String>> mqsByPrj = this.mqNames.get(prjName);
        if (mqsByPrj == null) {
            mqsByPrj = new HashSet<Pair<String, String>>();
            this.mqNames.put(prjName, mqsByPrj);
        }
        mqsByPrj.add((Pair<String, String>)new Pair((Object)mq, (Object)mqManager));
        Set<String> queueByPrj = this.queueNames.get(prjName);
        if (queueByPrj == null) {
            queueByPrj = new HashSet<String>();
            this.queueNames.put(prjName, queueByPrj);
        }
        queueByPrj.add(mq);
    }

    public Map<String, Set<Pair<String, String>>> getMqNames() {
        return this.mqNames;
    }

    public Map<String, Set<String>> getQueueNames() {
        return this.queueNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return true;
        }
        if (o instanceof UserExitsFromPrg) {
            return false;
        }
        UserExitsFromPrg o2 = (UserExitsFromPrg)o;
        return o2.sourcePrjName.equals(this.sourcePrjName) && o2.prgRid.equals(this.prgRid);
    }
}

