/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph.ue;

import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.ui.ResolutionBasedMouseHook;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UEMouseActionsHook
extends ResolutionBasedMouseHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private GraphAnalysisJob job = null;
    private static final Logger L = LoggerFactory.getLogger(UEMouseActionsHook.class);
    private GraphAnalysisJob.ExpandAction expandAction = null;
    private GraphAnalysisJob.CollapseAction collapseAction = null;
    private GraphAnalysisJob.ExpandAllAction expandAllApps = null;
    private GraphAnalysisJob.CollapseAllAction collapseAllApps = null;

    public UEMouseActionsHook(EZEntityID entityId, GraphAnalysisJob job) {
        super(entityId);
        this.job = job;
    }

    public List getRightClickContributions(TSENode node) {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        if (node != null && node.hasAttribute("is ts node for project") && !node.isExpanded()) {
            if (this.expandAction == null) {
                this.expandAction = new GraphAnalysisJob.ExpandAction(this.job);
            }
            this.expandAction.setChecked(false);
            this.expandAction.setNodeToExpand(node);
            String expandLabel = Messages.getString(UEMouseActionsHook.class, "expand.text", new String[]{node.getText()});
            this.expandAction.setText(expandLabel);
            this.expandAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.expandAction));
        }
        if (node != null && node.hasAttribute("is ts node for project") && node.isExpanded()) {
            if (this.collapseAction == null) {
                this.collapseAction = new GraphAnalysisJob.CollapseAction(this.job);
            }
            this.collapseAction.setChecked(false);
            this.collapseAction.overview = (TSEOverviewComponent)this.graphInfo.getOverviewComponent();
            EZSourceProjectIDSg sg = (EZSourceProjectIDSg)node.getAttributeValue("MAINFRAME_PROJECT_ID_SG");
            this.collapseAction.toCollapseNode = node;
            String collapseLabel = Messages.getString(UEMouseActionsHook.class, "collapse.text", new String[]{sg.getProjectName()});
            this.collapseAction.setText(collapseLabel);
            this.collapseAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
        }
        contextItems.add(new Separator());
        contextItems.addAll(super.getRightClickContributions(node));
        return contextItems;
    }

    public List getRightClickContributions() {
        ArrayList<ActionContributionItem> contextItems = new ArrayList<ActionContributionItem>();
        if (this.expandAllApps == null) {
            this.expandAllApps = new GraphAnalysisJob.ExpandAllAction(this.job);
        }
        this.expandAllApps.setChecked(false);
        String expandLabel = Messages.getString(UEMouseActionsHook.class, "expand.all.text");
        this.expandAllApps.setText(expandLabel);
        this.expandAllApps.setEnabled(TSNestingManager.hasCollapsedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        contextItems.add(new ActionContributionItem((IAction)this.expandAllApps));
        if (this.collapseAllApps == null) {
            this.collapseAllApps = new GraphAnalysisJob.CollapseAllAction(this.job);
        }
        this.collapseAllApps.setChecked(false);
        String collaspseLabel = Messages.getString(UEMouseActionsHook.class, "collapse.all.text");
        this.collapseAllApps.setText(collaspseLabel);
        this.collapseAllApps.setEnabled(TSNestingManager.hasExpandedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        contextItems.add(new ActionContributionItem((IAction)this.collapseAllApps));
        contextItems.addAll(super.getRightClickContributions());
        return contextItems;
    }

    protected String getInputProjectsName(TSGraphMember tsMember) {
        String inputProjectName = null;
        if (tsMember != null && tsMember.getOwnerGraph().hasAttribute("mainframe project name")) {
            inputProjectName = (String)tsMember.getOwnerGraph().getAttributeValue("mainframe project name");
        } else {
            L.warn("mainframe project not set for {} ts member", tsMember != null ? tsMember.getName() : "which is null");
        }
        return inputProjectName;
    }

    public boolean containsInput(EZObjectType objType) {
        return false;
    }

    public void dispose() {
        if (this.expandAction != null) {
            this.expandAction.dispose();
            this.expandAction = null;
        }
        if (this.collapseAction != null) {
            this.collapseAction.dispose();
            this.collapseAction = null;
        }
        if (this.expandAllApps != null) {
            this.expandAllApps.dispose();
            this.expandAllApps = null;
        }
        if (this.collapseAllApps != null) {
            this.collapseAllApps.dispose();
            this.collapseAllApps = null;
        }
        super.dispose();
    }
}

