/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph.ue;

import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CgBuilder;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.Target;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsFromPrg;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsToPrj;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.ui.ResolutionBasedGraphModel;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.gui.graphs.GraphRestrictionsLegendInfo;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.utils.LevelObject;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSBaseLayoutWorker;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSLayoutOperationCommand;
import com.tomsawyer.interactive.command.editing.TSSwingLayoutWorker;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UEBasedGraphModel
extends ResolutionBasedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UEBasedGraphModel.class);
    protected OrientBaseGraph dbg;
    protected Properties env;
    protected AbstractSharedAnalysis analysis;
    protected TSEGraph cg;
    protected boolean used4Cross = false;
    private static final String prg_details_query = "select ifnull(out('ProxyFor')[0].@rid, @rid).asString() as proxyRid, name as proxyName, sid, \n if(eval(\"sid = -1\"), type.append(name), null) as pNoSid from ProgramProxy where type = ? and name in ";
    private static final String tran_details_query_all = "select @rid.asString() as tproxyRid, name as tname, ifnull($mp.sid, -1) as sid, \n ifnull($mp.out('ProxyFor')[0].@rid, $mp.@rid).asString() as proxyRid,\n $mp.name as proxyName,\n if(eval(\"$mp.sid = -1\"), $mp.type.append($mp.name), \"null\") as pNoSid from TranProxy \n let $mp = out('TranMapping')[0] where name in ";
    private static final String tran_details_query = "select out.@rid.asString() as tproxyRid, out.name as tname, ifnull(in.sid, -1) as sid, \n ifnull(in.out('ProxyFor')[0].@rid, in.@rid).asString() as proxyRid, in.name as proxyName, \n if(eval(\"in.sid = -1\"), in.type.append(in.name), null) as pNoSid from TranMapping where out.@class = @@@@@EZLEGACY@@@@ and out.name in ";
    private static final String file_details_query = "select localName, out('ResourceLink')[0].@rid.asString() as fproxyRid from FileUsageInfo \n where localName in ";
    private static final String table_details_query = "select @rid.asString() as tproxyRid,  name as tname from SQLTableProxy\n where name in ";
    private static final String bms_details_query = "select @rid.asString() as sproxyRid, $s as sname from BMSProxy\n let $s = mapSet.append('-').append(name)\n where $s in ";
    private static final String ims_sg_details_query = "select if (eval(\"out('IMSProxyOf').size()=0\"), @rid, out('IMSProxyOf')[0].@rid).asString() as sproxyRid, $s as sname from IMSSegmentProxy\n let $s = dbName.append('-').append(name)\n where $s in ";
    private static final String ims_mod_details_query = "select @rid.asString() as sproxyRid, name as sname from IMSMODProxy\n where name in ";
    protected Set<Pair<String, String>> processedUE = new HashSet<Pair<String, String>>();
    protected static final String NAME_TO_RIDS = "NameToRids Attribute";
    protected static final String TRANSACTION_MAPPING_EDGE = "TranMapping";
    protected static final String SCREEN_MAPPING_EDGE = "tranCODE";
    protected static final String RESOURCE_TYPE_NODE_ATTR = "resourceType";
    protected static final String LEVEL_NODE_ATTR = "level";
    protected static final String PROGRAM_TYPE_NODE_ATTR = "program_type";
    private static final double DISTANCE_BETWEEN_INPUTPRGLEVEL_NEXT_OR_PREVIOUS_PRGLEVEL = 200.0;
    private static final double DISTANCE_BETWEEN_PRGLEVELS = 100.0;
    private static final double DISTANCE_BETWEEN_PRGLEVEL_RESLEVEL = 10.0;
    protected static LevelObject programLevel = new LevelObject(Integer.valueOf(0));
    protected static final LevelObject jobsLevel = new LevelObject(Integer.valueOf(-2));
    protected static LevelObject pgmLevel = new LevelObject(Integer.valueOf(0));
    protected static LevelObject transactionLevel = new LevelObject(Integer.valueOf(-2), true);
    protected static final LevelObject screenLevel = new LevelObject(Integer.valueOf(0));
    protected static final LevelObject transactionBackLevel = new LevelObject(Integer.valueOf(2));

    protected void initGraph() {
        this.processedUE.clear();
        this.graphManager.setAttribute(NAME_TO_RIDS, new HashMap());
        super.initGraph();
    }

    protected void processCFExitsToPrj(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        this.processTransactions(ExtCallTargetType.TRANSACTION, prjName, uePrj, idsSet, prgSids, prgWithoutSid);
        this.processTransactions(ExtCallTargetType.IMS_TM, prjName, uePrj, idsSet, prgSids, prgWithoutSid);
        this.processPrograms(prjName, uePrj, idsSet, prgSids, prgWithoutSid, ExtCallTargetType.PROGRAM_COBOL);
        this.processPrograms(prjName, uePrj, idsSet, prgSids, prgWithoutSid, ExtCallTargetType.PROGRAM_PLI);
    }

    protected void processDAExitsToPrj(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid, Map<String, String> resMap) {
        resMap.putAll(this.processFiles(prjName, uePrj, idsSet, prgWithoutSid));
        resMap.putAll(this.processTables(prjName, uePrj, idsSet, prgSids, prgWithoutSid));
        resMap.putAll(this.processBMS(prjName, uePrj, idsSet, prgSids, prgWithoutSid));
        resMap.putAll(this.processIMS(prjName, uePrj, idsSet, prgSids, prgWithoutSid));
        resMap.putAll(this.processIMSSeg(prjName, uePrj, idsSet, prgSids, prgWithoutSid));
    }

    private Map<String, String> processTables(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        Set<String> tableNames = uePrj.getExtCallsByType(ExtCallTargetType.SQLTABLE);
        HashMap<String, String> tmap = new HashMap<String, String>();
        if (!tableNames.isEmpty()) {
            CloseableIterable tqueryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(table_details_query + tableNames)).execute(new Object[0]);
            for (OrientElement elem : tqueryRes) {
                String tproxyRid = (String)elem.getProperty("tproxyRid");
                String tname = (String)elem.getProperty("tname");
                this.addToNamesToRid(prjName, tname, tproxyRid);
                tmap.put(tproxyRid, null);
            }
        }
        return tmap;
    }

    private Map<String, String> processIMS(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        Set<String> screenNames = uePrj.getExtCallsByType(ExtCallTargetType.IMS_MOD);
        HashMap<String, String> smap = new HashMap<String, String>();
        if (!screenNames.isEmpty()) {
            CloseableIterable tqueryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(ims_mod_details_query + screenNames)).execute(new Object[0]);
            for (OrientElement elem : tqueryRes) {
                String sproxyRid = (String)elem.getProperty("sproxyRid");
                String sname = (String)elem.getProperty("sname");
                this.addToNamesToRid(prjName, sname, sproxyRid);
                smap.put(sproxyRid, null);
            }
        }
        return smap;
    }

    private Map<String, String> processIMSSeg(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        Set<String> sgsNames = uePrj.getExtCallsByType(ExtCallTargetType.IMS_SEGMENT);
        HashMap<String, String> smap = new HashMap<String, String>();
        if (!sgsNames.isEmpty()) {
            CloseableIterable tqueryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(ims_sg_details_query + sgsNames)).execute(new Object[0]);
            for (OrientElement elem : tqueryRes) {
                String sproxyRid = (String)elem.getProperty("sproxyRid");
                String sname = (String)elem.getProperty("sname");
                this.addToNamesToRid(prjName, sname, sproxyRid);
                smap.put(sproxyRid, null);
            }
        }
        return smap;
    }

    private Map<String, String> processBMS(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        Set<String> screenNames = uePrj.getExtCallsByType(ExtCallTargetType.BMS);
        HashMap<String, String> smap = new HashMap<String, String>();
        if (!screenNames.isEmpty()) {
            CloseableIterable tqueryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(bms_details_query + screenNames)).execute(new Object[0]);
            for (OrientElement elem : tqueryRes) {
                String sproxyRid = (String)elem.getProperty("sproxyRid");
                String sname = (String)elem.getProperty("sname");
                this.addToNamesToRid(prjName, sname, sproxyRid);
                smap.put(sproxyRid, null);
            }
        }
        return smap;
    }

    private Map<String, String> processFiles(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<String> prgWithoutSid) {
        HashMap<String, String> fmap = new HashMap<String, String>();
        Set<String> fileNames = uePrj.getExtCallsByType(ExtCallTargetType.FILE_AT_WRITE);
        fileNames.addAll(uePrj.getExtCallsByType(ExtCallTargetType.FILE_AT_READ));
        if (!fileNames.isEmpty()) {
            CloseableIterable fqueryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(file_details_query + fileNames)).execute(new Object[0]);
            for (OrientElement elem : fqueryRes) {
                String localName = (String)elem.getProperty("localName");
                String fproxyRid = (String)elem.getProperty("fproxyRid");
                this.addToNamesToRid(prjName, localName, localName);
                fmap.put(fproxyRid, localName);
            }
        }
        return fmap;
    }

    private void processTransactions(ExtCallTargetType trtype, String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        Set<String> tranNames = uePrj.getExtCallsByType(trtype);
        if (!tranNames.isEmpty()) {
            String query = tran_details_query.replace("@@@@@EZLEGACY@@@@", ExtCallTargetType.TRANSACTION.equals((Object)trtype) ? "'TranProxy'" : "'IMSTransactionProxy'");
            CloseableIterable tqueryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(String.valueOf(query) + tranNames)).execute(new Object[0]);
            HashMap<String, ArrayList<String>> tranmapp = (HashMap<String, ArrayList<String>>)this.analysis.getContextValue(CgBuilder.getKey(prjName, "Tran map"));
            if (tranmapp == null) {
                tranmapp = new HashMap<String, ArrayList<String>>();
                this.analysis.addContextValue(CgBuilder.getKey(prjName, "Tran map"), tranmapp);
            }
            for (OrientElement elem : tqueryRes) {
                String tproxyRid = (String)elem.getProperty("tproxyRid");
                String tname = (String)elem.getProperty("tname");
                this.addToNamesToRid(prjName, tname, tproxyRid);
                this.prepareProgram(prjName, elem, idsSet, prgSids, prgWithoutSid);
                String mappedPrg = (String)elem.getProperty("proxyRid");
                ArrayList<String> list = (ArrayList<String>)tranmapp.get(tproxyRid);
                if (list == null) {
                    list = new ArrayList<String>();
                    tranmapp.put(tproxyRid, list);
                }
                if (mappedPrg == null) continue;
                list.add(mappedPrg);
            }
        }
    }

    private void processPrograms(String prjName, UserExitsToPrj uePrj, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid, ExtCallTargetType ttype) {
        Set<String> prgNames = uePrj.getExtCallsByType(ttype);
        if (!prgNames.isEmpty()) {
            CloseableIterable queryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(prg_details_query + prgNames)).execute(new Object[]{ttype.getPrgType()});
            for (OrientElement elem : queryRes) {
                this.prepareProgram(prjName, elem, idsSet, prgSids, prgWithoutSid);
            }
        }
    }

    private void prepareProgram(String prjName, OrientElement elem, Set<String> idsSet, Set<Integer> prgSids, Set<String> prgWithoutSid) {
        String proxyRid = (String)elem.getProperty("proxyRid");
        String proxyName = (String)elem.getProperty("proxyName");
        Integer pSid = (Integer)elem.getProperty("sid");
        String pNoSid = (String)elem.getProperty("pNoSid");
        Pair toProcess = new Pair((Object)prjName, (Object)pNoSid);
        if (pSid != null && pSid != -1) {
            prgSids.add(pSid);
            toProcess.setSecond((Object)pSid.toString());
        }
        if (proxyName != null) {
            this.addToNamesToRid(prjName, proxyName, proxyRid);
        } else {
            L.debug("transaction not mapped with a program");
        }
        if (!this.processedUE.contains(toProcess)) {
            L.debug("add from user exit the pair {} ", (Object)toProcess);
            boolean add = false;
            if (pSid != null && pSid != -1) {
                prgSids.add(pSid);
                add = true;
            } else if (pNoSid != null) {
                prgWithoutSid.add("'" + pNoSid + "'");
                add = true;
            }
            if (add) {
                this.processedUE.add((Pair<String, String>)toProcess);
                idsSet.add(proxyRid);
            }
        }
    }

    protected void buildResources(TSEGraph gr, String prjName, String usageInfo, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UEBasedGraphModel.class, "loading.resources.graph"));
        List usages = (List)this.analysis.removeContextValue(CgBuilder.getKey(prjName, "resources_Info_" + usageInfo));
        if (usages == null) {
            return;
        }
        Map prgRIDs = (Map)gr.getAttributeValue("TS nodes per project");
        switch (usageInfo) {
            case "FileUsageInfo": {
                Map resDatasets = (Map)this.analysis.removeContextValue(CgBuilder.getKey(prjName, "resources_Info_Datasets"));
                HashMap<String, Vertex> cacheDD = new HashMap<String, Vertex>();
                if (resDatasets != null) {
                    for (List l : resDatasets.values()) {
                        for (String r : l) {
                            cacheDD.put(r, null);
                        }
                    }
                    if (!cacheDD.isEmpty()) {
                        String q = String.format("select @rid.asString() as dd, out('MappedTo')[0] as dsv from %s ", cacheDD.keySet());
                        CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(q)).execute(new Object[0]);
                        for (OrientElement oe : res) {
                            String dd = (String)oe.getProperty("dd");
                            Vertex dsv = (Vertex)oe.getProperty("dsv");
                            cacheDD.put(dd, dsv);
                        }
                    }
                }
                for (String[] info : usages) {
                    String prgId = info[0];
                    TSENode prgNode = (TSENode)prgRIDs.get(prgId);
                    String stmtRid = info[1];
                    Integer bRead = Integer.valueOf(info[2]);
                    OrientVertex usage = this.dbg.getVertex((Object)info[3]);
                    String usageRid = usage.getId().toString();
                    String stmtType = info[4];
                    String fileName = Utils.getTSNodeName((Vertex)usage);
                    Integer type = (Integer)prgNode.getAttributeValue("prg type id");
                    if (type != null && (type == 13 || type == 19)) {
                        String physicalName = (String)usage.getProperty("physicalName");
                        if (physicalName.isEmpty()) continue;
                        fileName = physicalName.concat(fileName);
                        continue;
                    }
                    if (resDatasets != null && resDatasets.containsKey(usageRid)) {
                        List ddCardRids = (List)resDatasets.get(usageRid);
                        for (String ddcardRid : ddCardRids) {
                            Vertex dsV = (Vertex)cacheDD.get(ddcardRid);
                            if (dsV != null) {
                                String dsid = (String)dsV.getProperty("dsid");
                                Pair pair = com.ez.gdb.core.utils.Utils.splitDSid((String)dsid);
                                String dsWithFileName = String.valueOf((String)pair.getFirst()) + fileName;
                                TSENode dsNode = this.addResourceNodeWithUsageEdge(gr, prgNode, stmtRid, stmtType, dsV, dsWithFileName, bRead);
                                dsNode.setAttribute("logical file attribute", usage.getProperty("localName"));
                                continue;
                            }
                            this.addResourceNodeWithUsageEdge(gr, prgNode, stmtRid, stmtType, (Vertex)usage, fileName, bRead);
                        }
                        continue;
                    }
                    fileName = this.addPhysicalNameToFile((Vertex)usage, fileName);
                    this.addResourceNodeWithUsageEdge(gr, prgNode, stmtRid, stmtType, (Vertex)usage, fileName, bRead);
                }
                cacheDD.clear();
                break;
            }
            case "IMSSegmentUsageInfo": {
                for (String[] info : usages) {
                    String[] entries;
                    String prgId = info[0];
                    TSENode prgNode = (TSENode)prgRIDs.get(prgId);
                    String stmtRid = info[1];
                    String stmtType = info[4];
                    Integer bRead = Integer.valueOf(info[2]);
                    OrientVertex proxy = this.dbg.getVertex((Object)info[3]);
                    String physicalRids = info[6];
                    boolean isLogical = physicalRids.length() > 2;
                    OrientVertex proxyV = proxy.countEdges(Direction.OUT, new String[]{"IMSProxyOf"}) > 0L ? (Vertex)proxy.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().next() : proxy;
                    TSENode node = this.addResourceNodeWithUsageEdge(gr, prgNode, stmtRid, stmtType, (Vertex)proxyV, null, bRead);
                    if (!isLogical) continue;
                    physicalRids = physicalRids.substring(physicalRids.indexOf("[") + 1, physicalRids.indexOf("]"));
                    String[] stringArray = entries = physicalRids.split(",");
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entrie = stringArray[n2];
                        OrientVertex pproxyV = this.dbg.getVertex((Object)entrie);
                        OrientVertex sourceVertex = pproxyV.countEdges(Direction.OUT, new String[]{"IMSProxyOf"}) > 0L ? (Vertex)pproxyV.getVertices(Direction.OUT, new String[]{"IMSProxyOf"}).iterator().next() : null;
                        TSENode physicalNode = this.getOrCreateTSNode(gr, (Vertex)(sourceVertex != null ? sourceVertex : pproxyV), null, false);
                        GraphUtils.getOrCreateEdge(this.graphManager, node, physicalNode, null, ResourceLink.FAKE_STMT_TYPE_IMS_LOGIC_TO_PHYSIC_SEGMENT_STRING);
                        ++n2;
                    }
                }
                break;
            }
            default: {
                for (String[] info : usages) {
                    Vertex mflInfo;
                    Iterator itt;
                    Iterator it;
                    String prgId = info[0];
                    TSENode prgNode = (TSENode)prgRIDs.get(prgId);
                    String stmtRid = info[1];
                    String stmtType = info[4];
                    Integer bRead = Integer.valueOf(info[2]);
                    OrientVertex proxy = this.dbg.getVertex((Object)info[3]);
                    boolean isIMSTranUsageInfo = "IMSTransactionUsageInfo".equals(usageInfo);
                    TSENode resnode = this.addResourceNodeWithUsageEdge(gr, prgNode, stmtRid, stmtType, (Vertex)proxy, null, bRead);
                    if ("TranUsageInfo".equals(usageInfo) || isIMSTranUsageInfo) {
                        if (!isIMSTranUsageInfo) {
                            resnode.setAttribute(RESOURCE_TYPE_NODE_ATTR, (Object)14);
                        } else {
                            resnode.setAttribute(RESOURCE_TYPE_NODE_ATTR, (Object)20);
                        }
                        it = proxy.getVertices(Direction.OUT, new String[]{TRANSACTION_MAPPING_EDGE}).iterator();
                        while (it.hasNext()) {
                            OrientVertex ppV = (OrientVertex)it.next();
                            String mappedRid = this.getPrgOrProxyRid((Vertex)ppV);
                            this.makeMappedToPrgEdge(resnode, mappedRid, new String[0]);
                        }
                    }
                    if (!"IMSMODUsageInfo".equals(usageInfo) || !(it = proxy.getVertices(Direction.OUT, new String[]{"IMSModProxyOf"}).iterator()).hasNext() || !(itt = (mflInfo = (Vertex)it.next()).getVertices(Direction.IN, new String[]{SCREEN_MAPPING_EDGE}).iterator()).hasNext()) continue;
                    Vertex tranProxy = (Vertex)itt.next();
                    this.makeMappedToTranEdge(resnode, tranProxy);
                }
            }
        }
    }

    public String getPrgOrProxyRid(Vertex ppV) {
        String mappedRid = ppV.getId().toString();
        if (((OrientVertex)ppV).countEdges(Direction.OUT, new String[]{"ProxyFor"}) > 0L) {
            mappedRid = String.valueOf(((Vertex)ppV.getVertices(Direction.OUT, new String[]{"ProxyFor"}).iterator().next()).getId());
        }
        return mappedRid;
    }

    protected void searchMappBetweenTransactionAndProgram(String proxyVertexRid, Vertex proxyV, TSENode node) {
        Vertex proxyVV = proxyV;
        String mappedRid = proxyVertexRid;
        if (proxyV.getProperty("@class").equals("ProgramProxy")) {
            mappedRid = this.getPrgOrProxyRid(proxyV);
        } else {
            Iterable itProxys = proxyV.getVertices(Direction.IN, new String[]{"ProxyFor"});
            for (Vertex itProxy : itProxys) {
                if (((OrientVertex)itProxy).countEdges(Direction.IN, new String[]{TRANSACTION_MAPPING_EDGE}) <= 0L) continue;
                proxyVV = itProxy;
                break;
            }
        }
        Iterable it = proxyVV.getVertices(Direction.IN, new String[]{TRANSACTION_MAPPING_EDGE});
        for (Vertex tranV : it) {
            TSENode tranNode = this.addResourceNode(tranV, node, null);
            tranNode.setAttribute(RESOURCE_TYPE_NODE_ATTR, (Object)14);
            this.makeMappedToPrgEdge(tranNode, mappedRid, new String[0]);
        }
    }

    private TSENode addResourceNodeWithUsageEdge(TSEGraph gr, TSENode prgNode, String stmtRid, String stmtType, Vertex resV, String fileName, Integer bRead) {
        TSENode node = this.addResourceNode(resV, prgNode, fileName);
        GraphUtils.linkResourceNode(this.graphManager, prgNode, node, stmtRid, stmtType, bRead);
        return node;
    }

    protected TSENode addResourceNode(Vertex resV, TSENode prgNode, String fileName) {
        Integer lvl = (Integer)prgNode.getAttributeValue(LEVEL_NODE_ATTR);
        lvl = lvl + 1;
        TSENode node = this.getOrCreateTSNode(resV, fileName, false, new LevelObject(lvl, true));
        return node;
    }

    protected void drawTranToMappedPrg(String prjName) {
        Map tranInfo = (Map)this.analysis.removeContextValue(CgBuilder.getKey(prjName, "Tran map"));
        if (tranInfo != null) {
            for (String trRid : tranInfo.keySet()) {
                List mappedPrg = (List)tranInfo.get(trRid);
                if (mappedPrg != null) {
                    TSENode tranNode = this.getOrCreateTSNode((Vertex)this.dbg.getVertex((Object)trRid), null, false, transactionLevel);
                    for (String mappedProxyRid : mappedPrg) {
                        L.debug("transaction is mapped with program {}", (Object)mappedProxyRid);
                        this.makeMappedToPrgEdge(tranNode, mappedProxyRid, new String[0]);
                    }
                    continue;
                }
                OrientVertex tranProxy = this.dbg.getVertex((Object)trRid);
                this.getOrCreateTSNode((Vertex)tranProxy, null, false, transactionBackLevel);
                Iterator itt = tranProxy.getVertices(Direction.OUT, new String[]{SCREEN_MAPPING_EDGE}).iterator();
                if (!itt.hasNext()) continue;
                Vertex sRid = (Vertex)((Vertex)itt.next()).getVertices(Direction.IN, new String[]{"IMSModProxyOf"}).iterator().next();
                TSENode resnode = this.getOrCreateTSNode((Vertex)this.dbg.getVertex((Object)sRid), null, false, screenLevel);
                this.makeMappedToTranEdge(resnode, (Vertex)tranProxy);
            }
        }
    }

    protected void makeMappedToPrgEdge(TSENode tranNode, String mappedProxyRid, String ... edgeType) {
        L.debug("transaction/screen {} is mapped with program proxy rid {}", tranNode.getName(), (Object)mappedProxyRid);
        Map tsNodes = (Map)this.cg.getAttributeValue("TS nodes per project");
        TSENode mappedPrgNode = (TSENode)tsNodes.get(mappedProxyRid);
        if (mappedPrgNode == null) {
            L.warn("ts node for mapped program not found");
        } else {
            String fakeStmtType = edgeType != null && edgeType.length > 0 ? edgeType[0] : ResourceLink.FAKE_STMT_TYPE_FOR_TRANSACTION_TO_MAPPED_PRG_STRING;
            TSEEdge mappedEdge = GraphUtils.getOrCreateEdge(this.graphManager, tranNode, mappedPrgNode, null, fakeStmtType);
            if (!mappedEdge.hasAttribute("Statement Node_Mainframe")) {
                StatementNode sn = new StatementNode(fakeStmtType);
                mappedEdge.setAttribute("Statement Node_Mainframe", (Object)sn);
            }
        }
    }

    protected void makeMappedToTranEdge(TSENode resnode, Vertex tranProxy) {
        TSEEdge mappedEdge;
        String tranRid = tranProxy.getId().toString();
        Map tsNodes = (Map)this.cg.getAttributeValue("TS nodes per project");
        TSENode mappTranNode = (TSENode)tsNodes.get(tranRid);
        if (mappTranNode == null) {
            L.warn("ts node for mapped transaction not found");
            mappTranNode = this.getOrCreateTSNode(this.cg, tranProxy, null, false);
        }
        if (!(mappedEdge = GraphUtils.getOrCreateEdge(this.graphManager, resnode, mappTranNode, null, ResourceLink.FAKE_STMT_TYPE_IMS_MID_MOD_TO_TRANSACTION_STRING)).hasAttribute("Statement Node_Mainframe")) {
            StatementNode sn = new StatementNode(ResourceLink.FAKE_STMT_TYPE_IMS_MID_MOD_TO_TRANSACTION_STRING);
            mappedEdge.setAttribute("Statement Node_Mainframe", (Object)sn);
        }
    }

    protected TSENode getOrCreateTSNode(Vertex proxyV, String fileName, boolean isPrg, LevelObject lvlObj) {
        HashSet undexpandedResources = (HashSet)this.analysis.getContextValue(CgBuilder.getKey(this.ezsourcePrj.getName(), "lastLevelResourcestoMark"));
        String[] restrictions = (String[])this.analysis.getContextValue("while restrictions resources tag");
        TSENode node = super.getOrCreateTSNode(this.cg, proxyV, fileName, isPrg);
        if (isPrg) {
            node.setAttribute("prg_name", node.getName());
            node.setAttribute(PROGRAM_TYPE_NODE_ATTR, (Object)Boolean.TRUE);
        }
        Set inputRids = this.analysis.getContextSetValue(CgBuilder.getKey(this.ezsourcePrj.getName(), "input orids as string"));
        String rid = proxyV.getId().toString();
        boolean isRestrictedbyName = this.checkRestrictionByName(node.getText(), isPrg, restrictions);
        if (isRestrictedbyName) {
            node.setAttribute("node with restrictions, in callgraph ", (Object)Boolean.TRUE);
        }
        if (undexpandedResources != null && undexpandedResources.contains(rid)) {
            node.setAttribute("node is not expanded, but can be expanded, in callgraph", (Object)Boolean.TRUE);
            if (!isRestrictedbyName) {
                this.restrictionTypesSetForLegend.add(GraphRestrictionsLegendInfo.LIMIT_RESTRICTION);
            }
        }
        if (!this.isSrvCross && inputRids != null && inputRids.contains(rid) && !this.isUsed4Cross()) {
            node.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
        }
        this.setNodeUI(node);
        this.setLevel(node, isPrg, lvlObj);
        return node;
    }

    protected void setLevel(TSENode node, boolean isPrg, LevelObject lvlObj) {
        if (!node.hasAttribute(LEVEL_NODE_ATTR)) {
            Map tsLevels;
            ArrayList<TSENode> currentLevel;
            if (lvlObj == null) {
                lvlObj = new LevelObject(Integer.valueOf(0), isPrg);
            }
            if ((currentLevel = (ArrayList<TSENode>)(tsLevels = (Map)this.cg.getAttributeValue("levelMap")).get(lvlObj)) == null) {
                currentLevel = new ArrayList<TSENode>();
                tsLevels.put(lvlObj, currentLevel);
            }
            currentLevel.add(node);
            node.setAttribute(LEVEL_NODE_ATTR, (Object)lvlObj.getLevel());
        }
    }

    private boolean checkRestrictionByName(String name, boolean isPrg, String[] restrictions) {
        if (restrictions != null && restrictions.length > 0 && isPrg && !Utils.isValidName((String)name, (String[])restrictions)) {
            this.restrictionTypesSetForLegend.add(GraphRestrictionsLegendInfo.PATTERN_RESTRICTION);
            return true;
        }
        return false;
    }

    protected boolean isUsed4Cross() {
        return this.used4Cross;
    }

    public void searchCICSRegions(Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> cicsReg, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UEBasedGraphModel.class, "finding.cics.task"));
        if (!monitor.isCanceled()) {
            List prjList = (List)this.graphManager.getAttributeValue("projects");
            L.debug("will open {} projects ", (Object)prjList.size());
            long start = System.currentTimeMillis();
            int prjCount = 0;
            for (ProjectInfo pi : prjList) {
                if (pi.isEclipse()) continue;
                ++prjCount;
                String prjName = pi.getName();
                this.searchCICSRegPerPrj(prjName, cicsReg, monitor);
            }
            L.debug("end search CICS regions in {} ms for {} projects", (Object)(System.currentTimeMillis() - start), (Object)prjCount);
        }
    }

    protected void searchCICSRegPerPrj(final String prjName, final Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> cicsReg, SubMonitor monitor) {
        if (cicsReg.isEmpty()) {
            return;
        }
        try {
            L.debug("will open project " + prjName);
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(prjName, null);
            if (!monitor.isCanceled()) {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)120);
                        if (!sm.isCanceled()) {
                            for (ExtCallTargetType ttype : cicsReg.keySet()) {
                                if (ttype.getCICSRegQuery() == null) {
                                    L.warn("CICS regions not suported for {} ", (Object)ttype);
                                    continue;
                                }
                                String[][] prgResults = conn.executeSQL(ttype.getCICSRegQuery());
                                this.processResults((Map)cicsReg.get((Object)ttype), prjName, prgResults);
                            }
                        }
                    }

                    private void processResults(Map<Pair<String, String>, Set<String>> tgByCicsReg, String prjName2, String[][] tgResults) {
                        if (tgResults != null) {
                            L.debug("targets having CICS region {}", (Object)tgResults.length);
                            String[][] stringArray = tgResults;
                            int n = tgResults.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] res = stringArray[n2];
                                String cicsReg2 = res[0];
                                if (cicsReg2 != null && !cicsReg2.isEmpty()) {
                                    String tg = res[1];
                                    Pair key = new Pair((Object)cicsReg2, (Object)tg);
                                    Set<String> prjs = tgByCicsReg.get(key);
                                    if (prjs == null) {
                                        prjs = new HashSet<String>();
                                        tgByCicsReg.put((Pair<String, String>)key, prjs);
                                    }
                                    prjs.add(prjName2);
                                }
                                ++n2;
                            }
                        }
                    }
                }, LockType.Shared, (IProgressMonitor)monitor.newChild(90));
            }
            monitor.setWorkRemaining(0);
            monitor.done();
        }
        catch (Exception e) {
            L.error("while computing cics region information", (Throwable)e);
            GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
        }
    }

    protected void drawCrossPrjEdges(IProgressMonitor pmonitor) {
        Map ue = (Map)this.analysis.getContextValue("ue map");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)ue.keySet().size());
        for (String sourceprj : ue.keySet()) {
            Map vMap = (Map)ue.get(sourceprj);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)vMap.keySet().size());
            for (String sourceRid : vMap.keySet()) {
                UserExitsFromPrg uep = (UserExitsFromPrg)vMap.get(sourceRid);
                this.crossEdgesByTgtType(ExtCallTargetType.PROGRAM_COBOL, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.PROGRAM_PLI, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.TRANSACTION, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.SQLTABLE, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.FILE_AT_READ, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.FILE_AT_WRITE, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.BMS, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.IMS_MOD, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.IMS_SEGMENT, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
                this.crossEdgesByTgtType(ExtCallTargetType.IMS_TM, uep, sourceprj, sourceRid, (IProgressMonitor)sm.newChild(1));
            }
        }
    }

    private void crossEdgesByTgtType(ExtCallTargetType ttype, UserExitsFromPrg uep, String sPrj, String sRid, IProgressMonitor pmonitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)20);
        TSENode sourceNode = uep.getPrgGraphNode();
        Map<String, Set<Target>> resPerPrj = uep.getTgts(ttype, ExtCallLocationType.APPLICATION);
        for (String tPrj : resPerPrj.keySet()) {
            TSEGraph gr = TSGraphUtils.getPrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (String)tPrj, (boolean)true);
            if (gr == null) {
                L.debug("project {} not found, so skip to display resources", (Object)tPrj);
                continue;
            }
            Set<Target> tgts = resPerPrj.get(tPrj);
            for (Target t : tgts) {
                Map nameTorids = (Map)this.graphManager.getAttributeValue(NAME_TO_RIDS);
                Map namesPerPrj = (Map)nameTorids.get(tPrj);
                if (namesPerPrj != null && namesPerPrj.containsKey(t.getQName())) {
                    TSENode node;
                    String key = (String)namesPerPrj.get(t.getQName());
                    HashMap tsNodes = (HashMap)gr.getAttributeValue("TS nodes per project");
                    if (tsNodes == null) {
                        tsNodes = new HashMap();
                        gr.setAttribute("TS nodes per project", tsNodes);
                    }
                    if ((node = (TSENode)tsNodes.get(key)) != null) {
                        if (sourceNode == null && (sourceNode = this.makeSourceNode(uep, sPrj, sRid, (IProgressMonitor)sm.newChild(10))) == null) {
                            return;
                        }
                        this.makeCrossPrjEdge(t, sourceNode, node);
                        continue;
                    }
                    L.warn("tsnode for {} not found", (Object)t.getQName());
                    continue;
                }
                L.warn("rid for node {} not found", (Object)t.getQName());
            }
        }
    }

    protected TSENode makeSourceNode(UserExitsFromPrg uep, String prjName, String pRid, IProgressMonitor pmonitor) {
        TSENode node = uep.getPrgGraphNode();
        if (node == null) {
            if (!this.isGraphThruPrjs() || uep.hasTgt()) {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)10);
                Map<String, TSENode> pNodes = null;
                if (!this.isGraphThruPrjs()) {
                    pNodes = (Map<String, TSENode>)this.cg.getAttributeValue("TS nodes per project");
                } else {
                    this.dbg = null;
                    this.env = ConnectionUtils.getODBSettings((String)prjName);
                    try {
                        this.dbg = this.getOrientDbg();
                        HashSet<String> pRidSet = new HashSet<String>();
                        pRidSet.add(pRid);
                        pNodes = this.drawGraph(prjName, pRidSet, (IProgressMonitor)monitor.newChild(10));
                    }
                    catch (Exception exception) {
                        L.warn("no graph database for the project having external calls : {}", (Object)prjName);
                    }
                }
                if (pNodes != null) {
                    node = (TSENode)pNodes.get(pRid);
                    uep.setPrgGraphNode(node);
                }
            } else {
                L.debug("skip prgrid {} for projectc {} because doesn't have resolved target", (Object)pRid, (Object)prjName);
            }
        }
        return node;
    }

    protected boolean isGraphThruPrjs() {
        return GraphUtils.cgToOtherPrj(this.graphManager);
    }

    protected void addToNamesToRid(String prjName, String name, String rid) {
        Map existent = (Map)this.graphManager.getAttributeValue(NAME_TO_RIDS);
        HashMap<String, String> nameToRids = (HashMap<String, String>)existent.get(prjName);
        if (nameToRids == null) {
            nameToRids = new HashMap<String, String>();
            existent.put(prjName, nameToRids);
        }
        nameToRids.put(name, rid);
    }

    protected Map<String, TSENode> drawGraph(String prjName, Set<String> prgRids, IProgressMonitor pmonitor) {
        return null;
    }

    private void makeCrossPrjEdge(Target tgt, TSENode sourceNode, TSENode n) {
        Triplet<TSENode, TSENode, String> triplet = GraphUtils.computeAccesType(sourceNode, n, tgt.getTgtType());
        TSEEdge e = this.makeCallExtEdge((TSENode)triplet.getFirst(), (TSENode)triplet.getSecond(), tgt.getStmts(), (String)triplet.getThird());
        if (e != null && !e.hasAttribute("MAINFRAME_PROJECT_ID_SG")) {
            EZSourceProjectIDSg sg = (EZSourceProjectIDSg)sourceNode.getOwnerGraph().getAttributeValue("MAINFRAME_PROJECT_ID_SG");
            e.setAttribute("MAINFRAME_PROJECT_ID_SG", (Object)sg);
        }
    }

    public Map getOutForStructView() {
        if (this.graphManager.hasAttribute("ue inventory")) {
            return (Map)this.graphManager.getAttributeValue("ue inventory");
        }
        return this.outForGISV;
    }

    public TSCommand createCustomHLayoutCommand(TSDGraph graph) {
        TSELayoutCommand layoutCommand = null;
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSLayoutInputTailor inputTaylor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        Map currentTSNodeLevels = (Map)graph.getAttributeValue("levelMap");
        if (currentTSNodeLevels == null) {
            return null;
        }
        Set keys = currentTSNodeLevels.keySet();
        ArrayList keysList = new ArrayList(keys);
        Collections.sort(keysList);
        L.debug("levels: {}", keysList);
        int i = 0;
        while (i < keysList.size() - 1) {
            LevelObject pos1 = (LevelObject)keysList.get(i);
            List list1 = (List)currentTSNodeLevels.get(pos1);
            LevelObject pos2 = (LevelObject)keysList.get(i + 1);
            List list2 = (List)currentTSNodeLevels.get(pos2);
            double distance = 100.0;
            if (pos1.isInputLevel() || pos2.isInputLevel() && !pos1.isResourcesLevel()) {
                distance = 200.0;
            }
            if (pos2.isResourcesLevel()) {
                inputTaylor.addSeparationConstraint(list1, list2, 3, 10.0, 0);
                inputTaylor.addAlignmentConstraint(list2, 1, 0, 0);
                if (i + 2 < keysList.size()) {
                    LevelObject pos3 = (LevelObject)keysList.get(i + 2);
                    List list3 = (List)currentTSNodeLevels.get(pos3);
                    if (pos3.isInputLevel()) {
                        distance = 200.0;
                    }
                    inputTaylor.addSeparationConstraint(list1, list3, 3, distance, 0);
                    inputTaylor.addSeparationConstraint(list2, list3, 3, distance - 50.0, 0);
                    if (i + 2 == keysList.size() - 1) {
                        inputTaylor.addAlignmentConstraint(list3, 1, 0, 0);
                    }
                    ++i;
                }
            } else {
                inputTaylor.addSeparationConstraint(list1, list2, 3, distance, 0);
            }
            inputTaylor.addAlignmentConstraint(list1, 1, 0, 0);
            ++i;
        }
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        layoutCommand = new TSELayoutCommand((TSEGraph)graph, (TSViewportCanvas)canvas, (TSServiceInputDataInterface)inputData, 1){

            protected TSBaseLayoutWorker createLayoutWorker() {
                return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                    public void processEventsAfterLayout() {
                        L.debug("nothing to process after layout");
                    }
                };
            }
        };
        layoutCommand.setCoalesced(true);
        return layoutCommand;
    }

    protected OrientBaseGraph getOrientDbg() {
        if (this.dbg == null) {
            if (this.env == null) {
                this.env = (Properties)this.analysis.getContextValue("env");
            }
            this.dbg = ConnectionUtils.getNoTxGraph((Properties)this.env);
        }
        return this.dbg;
    }

    protected OrientBaseGraph getOrientDbg(String prjName) {
        if (this.dbg != null && this.env != null && this.env.get("db").equals("EZ_" + prjName)) {
            return this.dbg;
        }
        this.env = ConnectionUtils.getODBSettings((String)prjName);
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)this.env);
        return this.dbg;
    }

    public void dispose() {
        block6: {
            this.processedUE = null;
            try {
                try {
                    if (this.dbg != null) {
                        ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
                    }
                }
                catch (Exception e) {
                    L.error("while clearing", (Throwable)e);
                    this.env = null;
                    this.dbg = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.env = null;
                this.dbg = null;
                throw throwable;
            }
            this.env = null;
            this.dbg = null;
        }
        super.dispose();
    }
}

