/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph.ue;

import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import java.util.HashSet;
import java.util.Set;

public class Target {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String name;
    private String parent;
    private ExtCallTargetType type;
    private String location;
    private ExtCallLocationType locationType;
    private Set<String> stmts = new HashSet<String>();

    public Target(String name, ExtCallTargetType type, String location, ExtCallLocationType locType, String parent) {
        this.name = name;
        this.type = type;
        this.location = location;
        this.locationType = locType;
        this.parent = parent;
    }

    public ExtCallLocationType getLocType() {
        return this.locationType;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getQName() {
        return this.parent == null ? this.name : this.parent.concat("-").concat(this.name);
    }

    public ExtCallTargetType getTgtType() {
        return this.type;
    }

    public Set<String> getStmts() {
        return this.stmts;
    }

    public void addStmt(String stmt) {
        this.stmts.add(stmt);
    }

    public void updateStmts(Set<String> stmtsToAdd) {
        this.stmts.addAll(stmtsToAdd);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.locationType == null ? 0 : this.locationType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Target other = (Target)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.locationType != other.locationType) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }
}

