/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph.ue;

import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.mainframe.model.ProgramType;

public enum ExtCallTargetType {
    PROGRAM_COBOL,
    PROGRAM_PLI,
    PROGRAM,
    TRANSACTION,
    SQLTABLE,
    FILE,
    FILE_AT_READ,
    FILE_AT_WRITE,
    BMS,
    IMS_MOD,
    IMS_SEGMENT,
    IMS_TM,
    UNDEFINED;


    public String getDescription() {
        if (this.equals((Object)PROGRAM_COBOL) || this.equals((Object)PROGRAM_PLI)) {
            return Messages.getString(ExtCallTargetType.class, "ext.prg");
        }
        if (this.equals((Object)TRANSACTION)) {
            return Messages.getString(ExtCallTargetType.class, "ext.tr");
        }
        if (this.equals((Object)IMS_TM)) {
            return Messages.getString(ExtCallTargetType.class, "ext.ims.tr");
        }
        if (this.equals((Object)SQLTABLE)) {
            return Messages.getString(ExtCallTargetType.class, "ext.sql");
        }
        if (this.equals((Object)FILE_AT_READ) || this.equals((Object)FILE_AT_WRITE)) {
            return Messages.getString(ExtCallTargetType.class, "ext.file");
        }
        if (this.equals((Object)BMS)) {
            return Messages.getString(ExtCallTargetType.class, "ext.bms");
        }
        if (this.equals((Object)IMS_MOD)) {
            return Messages.getString(ExtCallTargetType.class, "ext.ims");
        }
        if (this.equals((Object)IMS_SEGMENT)) {
            return Messages.getString(ExtCallTargetType.class, "ext.ims.seg");
        }
        return Messages.getString(ExtCallTargetType.class, "undef");
    }

    public String getTSType() {
        if (this.equals((Object)PROGRAM_COBOL) || this.equals((Object)PROGRAM_PLI)) {
            return "ProgramProxy";
        }
        if (this.equals((Object)TRANSACTION)) {
            return "TranProxy";
        }
        if (this.equals((Object)IMS_TM)) {
            return "IMSTransactionProxy";
        }
        if (this.equals((Object)SQLTABLE)) {
            return "SQLTableProxy";
        }
        if (this.equals((Object)FILE_AT_READ) || this.equals((Object)FILE_AT_WRITE)) {
            return "DDNameProxy";
        }
        if (this.equals((Object)BMS)) {
            return "BMSProxy";
        }
        if (this.equals((Object)IMS_MOD)) {
            return "IMSModProxy";
        }
        if (this.equals((Object)IMS_SEGMENT)) {
            return "IMSSegmentProxy";
        }
        return "Undefined";
    }

    public String getInfoAttribute() {
        if (this.equals((Object)PROGRAM)) {
            return "resources_Info_ExtProgramUsageInfo";
        }
        if (this.equals((Object)TRANSACTION)) {
            return "resources_Info_ExtTranUsageInfo";
        }
        if (this.equals((Object)IMS_TM)) {
            return "resources_Info_ExtIMSTranUsageInfo";
        }
        if (this.equals((Object)SQLTABLE)) {
            return "resources_Info_ExtSQLUsageInfo";
        }
        if (this.equals((Object)FILE)) {
            return "resources_Info_ExtFileUsageInfo";
        }
        if (this.equals((Object)BMS)) {
            return "resources_Info_ExtBMSUsageInfo";
        }
        if (this.equals((Object)IMS_MOD)) {
            return "resources_Info_ExtIMSMODUsageInfo";
        }
        if (this.equals((Object)IMS_SEGMENT)) {
            return "resources_Info_ExtIMSSegmentUsageInfo";
        }
        return null;
    }

    public Integer getPrgType() {
        if (this.equals((Object)PROGRAM_COBOL)) {
            return ProgramType.COBOL.getProgramTypeId();
        }
        if (this.equals((Object)PROGRAM_PLI)) {
            return ProgramType.PL1.getProgramTypeId();
        }
        return null;
    }

    public String getCICSRegQuery() {
        if (this.equals((Object)PROGRAM)) {
            return "SELECT MFCICSInfo.CICSName, MFCICSProgram.ProgName \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSProgram ON MFCICSGroupVsEntityLinks.ProgID = MFCICSProgram.ProgID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 1) ";
        }
        if (this.equals((Object)TRANSACTION)) {
            return "SELECT MFCICSInfo.CICSName, MFCICSTransaction.TransCode \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSTransaction ON MFCICSGroupVsEntityLinks.TransID = MFCICSTransaction.TransID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 2) ";
        }
        if (this.equals((Object)SQLTABLE)) {
            return null;
        }
        if (this.equals((Object)FILE)) {
            return "SELECT MFCICSInfo.CICSName, MFCICSFile.DDName \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSFile ON MFCICSGroupVsEntityLinks.FileID = MFCICSFile.FileID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 0) ";
        }
        if (this.equals((Object)BMS)) {
            return "SELECT MFCICSInfo.CICSName, MFCICSMap.MapName \n FROM   MFCICSInfo INNER JOIN \n MFCICSList ON MFCICSInfo.CICSID = MFCICSList.CICSID INNER JOIN \n MFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \n MFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \n MFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \n MFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \n MFCICSMap ON MFCICSGroupVsEntityLinks.MapID = MFCICSMap.MapID \n WHERE (MFCICSGroupVsEntity.EntityTypeID = 3) ";
        }
        return null;
    }

    public ExtCallTargetType getLabelForCICSInfo() {
        if (this.equals((Object)PROGRAM_COBOL) || this.equals((Object)PROGRAM_PLI)) {
            return PROGRAM;
        }
        if (this.equals((Object)FILE_AT_READ) || this.equals((Object)FILE_AT_WRITE)) {
            return FILE;
        }
        return this;
    }
}

