/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.common.model.BaseResourceInput;
import com.ez.gdb.core.collectors.ODBProgramCollector;
import com.ez.gdb.core.collectors.ODBProgramProxyCollector;
import com.ez.gdb.core.ui.ODBCallGraphWizardDialog;
import com.ez.gdb.core.ui.ODBCallgraphWizard;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBJobCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBScreenCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBTransactionCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.TransactionInput;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.JobInput;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.model.ScreenInput;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ProgramCallGraphInputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String AVAILABLE_CHILDREN_RESOURCES = "AVAILABLE_CHILDREN_RESOURCES";
    public static final String SCREENS_FOR_CALLGRAPH_PAGE_NAME = "screens for callgraph page";
    public static final String TRANSACTIONS_FOR_CALLGRAPH_PAGE_NAME = "transactions for callgraph page";
    private ProjectInfo prjInfo;
    private AnalysisType analysisType;
    private String wizardName;
    private String pageDescription;
    private boolean withResourceOption = true;

    public ProgramCallGraphInputsFilter(ProjectInfo prjInfo, AnalysisType analysisType, String wizardName, String pageDescription) {
        this.prjInfo = prjInfo;
        this.analysisType = analysisType;
        this.wizardName = wizardName;
        this.pageDescription = pageDescription == null ? Messages.getString(ProgramCallGraphInputsFilter.class, "page.description") : pageDescription;
    }

    public ProgramCallGraphInputsFilter(ProjectInfo prjInfo, AnalysisType analysisType, String wizardName, String pageDescription, boolean withResourceOption) {
        this(prjInfo, analysisType, wizardName, pageDescription);
        this.withResourceOption = withResourceOption;
    }

    protected PrepareReportWizard getWizard() {
        ODBCallgraphWizard wizard = new ODBCallgraphWizard();
        boolean hasShowDirection = !this.analysisType.equals((Object)AnalysisType.EZSOURCE_GDB_JOB_CALLGRAPH_ANALYSIS);
        InputsWithSettingsPage selectProgramsPage = new InputsWithSettingsPage("programs for callgraph page", hasShowDirection, true, this.withResourceOption);
        selectProgramsPage.setTitle(Messages.getString(ProgramCallGraphInputsFilter.class, "page.title"));
        switch (this.analysisType) {
            case EZSOURCE_GDB_JOB_CALLGRAPH_ANALYSIS: {
                selectProgramsPage.setLeftGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "av.jobs.type"));
                selectProgramsPage.setRightGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "sel.jobs.type"));
                ODBProgramProxyCollector pc = new ODBJobCollector();
                selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
                selectProgramsPage.setDirectionGroupText(Messages.getString(ProgramCallGraphInputsFilter.class, "call.jobs.limit"));
                break;
            }
            case EZSOURCE_GDB_PROGRAM_CALLGRAPH_ANALYSIS: {
                ODBProgramProxyCollector pc = new ODBProgramProxyCollector();
                selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
                break;
            }
            case EZSOURCE_GDB_SCREEN_CALLGRAPH_ANALYSIS: {
                selectProgramsPage.setLeftGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "av.screens.type"));
                selectProgramsPage.setRightGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "sel.screens.type"));
                ODBScreenCollector sc = new ODBScreenCollector();
                selectProgramsPage.setResourcesCollector((ResourcesCollector)sc);
                break;
            }
            case EZSOURCE_GDB_TRANSACTION_CALLGRAPH_ANALYSIS: {
                selectProgramsPage.setLeftGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "av.transactions.type"));
                selectProgramsPage.setRightGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "sel.transactions.type"));
                ODBTransactionCollector tc = new ODBTransactionCollector();
                selectProgramsPage.setResourcesCollector((ResourcesCollector)tc);
            }
        }
        selectProgramsPage.setDescription(this.pageDescription);
        selectProgramsPage.setErrMsgNoResource(Messages.getString(ProgramCallGraphInputsFilter.class, "err.message"));
        wizard.addPage((IWizardPage)selectProgramsPage);
        if (System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        } else if (AnalysisType.EZSOURCE_GDB_PROGRAM_CALLGRAPH_ANALYSIS.equals((Object)this.analysisType)) {
            SelectProgramsPage selectAssemblerPage = new SelectProgramsPage("children_page", true, false);
            selectAssemblerPage.setSelectedPropName("selected ass resources");
            selectAssemblerPage.setAvailablePropName(AVAILABLE_CHILDREN_RESOURCES);
            selectAssemblerPage.setTitle(Messages.getString(ProgramCallGraphInputsFilter.class, "ass.page.title"));
            selectAssemblerPage.setDescription(Messages.getString(ProgramCallGraphInputsFilter.class, "ass.page.description"));
            selectAssemblerPage.setLeftGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "av.assembler.type"));
            selectAssemblerPage.setRightGroupLabel(Messages.getString(ProgramCallGraphInputsFilter.class, "sel.assembler.type"));
            selectAssemblerPage.setErrMsgNoResource(Messages.getString(ProgramCallGraphInputsFilter.class, "err.message"));
            ODBProgramCollector asspc = new ODBProgramCollector();
            selectAssemblerPage.setResourcesCollector((ResourcesCollector)asspc);
            wizard.addPage((IWizardPage)selectAssemblerPage);
        }
        wizard.setWindowTitle(this.wizardName);
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        EZSourceProgramIDSg prgIdSg;
        List assChilden = wizard.getList("selected ass resources");
        List selObjs = wizard.getList("selected resources");
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(this.prjInfo);
        List allChildren = wizard.getList(AVAILABLE_CHILDREN_RESOURCES);
        for (BaseMainframeResource4GUI input4GUI : selObjs) {
            EZEntityID entity;
            BaseResourceInput input = input4GUI.getObject();
            if (input instanceof ProgramInput) {
                ProgramInput pi = (ProgramInput)input;
                prgIdSg = this.checkAndAdd(pi, assChilden, allChildren);
                if (prgIdSg == null) continue;
                EZEntityID entity2 = new EZEntityID();
                entity2.addSegment((EZSegment)prjIdSg);
                entity2.addSegment((EZSegment)prgIdSg);
                list.add(entity2);
                continue;
            }
            if (input instanceof JobInput) {
                JobInput ji = (JobInput)input;
                entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceJobIDSg jobIdSg = new EZSourceJobIDSg(ji.getJobName(), ji.getJobID(), Integer.valueOf(22), ji.getMemberName());
                entity.addSegment((EZSegment)jobIdSg);
                entity.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(ji.getJobName(), null));
                list.add(entity);
                continue;
            }
            if (input instanceof ScreenInput) {
                ScreenInput si = (ScreenInput)input;
                entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceScreenIDSg screenIdSg = new EZSourceScreenIDSg(si.getScreenName(), si.getMapSet(), null, si.getType(), si.getOdbRID());
                entity.addSegment((EZSegment)screenIdSg);
                list.add(entity);
                continue;
            }
            if (!(input instanceof TransactionInput)) continue;
            TransactionInput ti = (TransactionInput)input;
            entity = new EZEntityID();
            entity.addSegment((EZSegment)prjIdSg);
            EZSourceTransactionIDSg tranIdSg = new EZSourceTransactionIDSg(ti.getName());
            tranIdSg.setTransactionType(ti.getTypeCode().intValue());
            entity.addSegment((EZSegment)tranIdSg);
            list.add(entity);
        }
        if (assChilden != null) {
            for (BaseMainframeResource4GUI assChild4GUI : assChilden) {
                ProgramInput assChild = (ProgramInput)assChild4GUI.getObject();
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                prgIdSg = new EZSourceProgramIDSg(assChild.getName(), assChild.getProgramID(), assChild.getTypeCode(), Boolean.valueOf(true));
                prgIdSg.setOdbRID(assChild.getOdbRID());
                prgIdSg.setAncestorName(assChild.getAncestorName());
                prgIdSg.setAncestorId(assChild.getAncestorDBId());
                entity.addSegment((EZSegment)prgIdSg);
                list.add(entity);
            }
        }
        analysis.addContextValue("input_list", list);
        analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        ODBCallGraphWizardDialog dialog = new ODBCallGraphWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }
}

