/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphJob;
import com.ez.graphs.viewer.callgraph.programcallgraph.ProgramCallGraphInputsFilter;
import com.ez.graphs.viewer.callgraph.programcallgraph.ProgramCallGraphSettingsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.List;
import java.util.Map;

public class ProgramCallGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected CallGraphJob job = null;
    private static final String wizardName = Messages.getString(ProgramCallGraphAnalysis.class, "wizard.title.progcallgraph");

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CallGraphJob)wk.getJob(id, CallGraphJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public void setInputs(List inputs) {
        super.setInputs(inputs);
        Boolean showOtherPrj = WorkspacePrefUtils.getPreferenceStore().getBoolean("showCgOtherPrj");
        this.addContextValue("continueCG_otherPrj_analysis", showOtherPrj);
        this.addContextValue("PROGRAM_CALLGRAPH", Boolean.TRUE);
        String prjName = (String)this.getContextValue("input_project_names");
        this.addContextValue("env", ConnectionUtils.getODBSettings((String)prjName));
    }

    public String getLabelType() {
        return Messages.getString(ProgramCallGraphAnalysis.class, "properties.labelType");
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_PROGRAM_CALLGRAPH_ANALYSIS;
    }

    protected InputsFilter getInputsFilter() {
        Object iFilter = null;
        List inputs = this.getContextListValue("input_list");
        String prgPageDesc = Messages.getString(ProgramCallGraphAnalysis.class, "page.description");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            EZEntityID entID = ((EZObjectType)inputs.get(0)).getEntID();
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entID.getSegment(EZSourceProjectIDSg.class);
            iFilter = new ProgramCallGraphInputsFilter(prjSg.getProjectInfo(), this.getAnalysisType(), wizardName, prgPageDesc);
        } else {
            iFilter = new ProgramCallGraphSettingsFilter(wizardName, true);
        }
        return iFilter;
    }

    public boolean equals(Object obj) {
        Boolean isLimited1;
        boolean ret = super.equals(obj);
        if (!ret) {
            return ret;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        Direction cgDirection = (Direction)this.getContextValue("graph direction: forward or backward or both");
        cgDirection = cgDirection == null ? Direction.BOTH : cgDirection;
        Direction cgDirection1 = (Direction)a2.getContextValue("graph direction: forward or backward or both");
        Direction direction = cgDirection1 = cgDirection1 == null ? Direction.BOTH : cgDirection1;
        if (!cgDirection.equals((Object)cgDirection1)) {
            return false;
        }
        Boolean limitResources = (Boolean)this.getContextValue("graph without resources");
        limitResources = limitResources == null ? false : limitResources;
        Boolean limitResources1 = (Boolean)a2.getContextValue("graph without resources");
        if (!limitResources.equals(limitResources1 = Boolean.valueOf(limitResources1 == null ? false : limitResources1))) {
            return false;
        }
        if (!limitResources.booleanValue()) {
            Map r1 = (Map)this.getContextValue("graph resources checked or not");
            Map r2 = (Map)a2.getContextValue("graph resources checked or not");
            if (r1 == null || r2 == null || !r1.values().toString().equals(r2.values().toString())) {
                return false;
            }
        }
        isLimited1 = (isLimited1 = (Boolean)this.getContextValue("is graph limited")) == null ? false : isLimited1;
        Boolean isLimited2 = (Boolean)a2.getContextValue("is graph limited");
        if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
            return false;
        }
        if (isLimited1.booleanValue()) {
            Integer cgLimitation1 = (Integer)this.getContextValue("limit number for graph levels");
            Integer cgLimitation2 = (Integer)a2.getContextValue("limit number for graph levels");
            if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                return false;
            }
        }
        Boolean showOtherPrj = (Boolean)this.getContextValue("continueCG_otherPrj_analysis");
        ret = showOtherPrj.equals(a2.getContextValue("continueCG_otherPrj_analysis"));
        return ret;
    }
}

