/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphJob;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphModel;
import com.ez.graphs.viewer.callgraph.programcallgraph.CgBuilder;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.mainframe.gui.graphs.AnnotationPartStateManager;
import com.ez.mainframe.gui.graphs.AnnotationStateListener;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.IEZStateListener;
import com.ez.workspace.state.StateManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeGraphBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeGraphBuilder.class);
    AbstractSharedAnalysis analysis;
    AnnotationPartStateManager annStateManager;
    AnnotationStateListener annStateListener;
    StateManager stateManager = StateManager.getInstance();
    private String projName;
    private static final String RID_MARKER = "@@@@@EZLEGACY@@@@";
    private Map<Integer, String> programs4ODB;
    private Map<Integer, String> programProxy;
    private static final String cicsTransactions_ODB = "select @rid.asString() as trProxyRid,  $a.asSet().sid.asString() as prgCallingSid, $a.asSet().@rid.asString() as prgCallingRid  from TranProxy  let $a=unionall(in('ResourceLink')[bRead = 1],in('ResourceLink')[bRead = 2]).in('UsesTran').in('HasS') where name in list(@@@@@EZLEGACY@@@@)";
    private static final String prgs_query_ODB = "select @rid as startRid from Program where name in list(@@@@@EZLEGACY@@@@)";
    private static final String ims_trans_query_ODB = "select @rid.asString() as trProxyRid,  $a.asSet().sid.asString() as prgCallingSid, $a.asSet().@rid.asString() as prgCallingRid  from IMSTransactionProxy  let $a=unionall(in('ResourceLink')[bRead = 1],in('ResourceLink')[bRead = 2]).in('UsesIMSTransaction').in('HasS') where name in list(@@@@@EZLEGACY@@@@)";
    private static final String mqqueue_query_ODB = "select @rid.asString() as mqProxyRid,  $a.asSet().sid.asString() as prgCallingSid, $a.asSet().@rid.asString() as prgCallingRid from MQQueueProxy  let $a=unionall(in('ResourceLink')[bRead = 1], in('ResourceLink')[bRead = 2]).in('UsesMQQ').in('HasS') where name in list(@@@@@EZLEGACY@@@@)";
    private static final String commandForward = "select @rid.asString() as startRid , $a.@rid.asString() as endCallRids, $a.in.@rid.asString() as calledProxies, $a.in.name.asString() as calledProxiesName \n from (traverse out('ProgramCall','ProxyFor') from (select from ProgramProxy where @@@@@EZLEGACY@@@@ FETCHPLAN in_*:-2 out_*:-2   )  )  let $a = out('ProxyFor').outE('ProgramCall') \nwhere @class='ProgramProxy'";

    public MainframeGraphBuilder(AbstractSharedAnalysis analysis) {
        this.analysis = analysis;
        ProjectInfo pi = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
        this.projName = pi.getName();
    }

    public Map<Integer, Map> getData(String projName, Map<String, List<TSENode>> unexistingProgramNodes, Map<Integer, Set<String>> inputsMap) {
        Properties env = ConnectionUtils.getODBSettings((String)projName);
        this.analysis.addContextValue("env", (Object)env);
        HashSet<String> inputORIDs = new HashSet<String>();
        this.analysis.addContextValue(CgBuilder.getKey(projName, "input orids as string"), inputORIDs);
        this.programs4ODB = new HashMap<Integer, String>();
        this.programProxy = new HashMap<Integer, String>();
        HashMap<Integer, Map> p = new HashMap<Integer, Map>();
        OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        try {
            String query;
            if (inputsMap.containsKey(14)) {
                query = this.getQuery((Collection<String>)inputsMap.get(14), cicsTransactions_ODB);
                p.put(14, this.getTransactionData(projName, dbg, query));
            }
            if (inputsMap.containsKey(5)) {
                query = this.getQuery((Collection<String>)inputsMap.get(5), prgs_query_ODB);
                this.getProgramsData(dbg, unexistingProgramNodes, query);
            }
            if (inputsMap.containsKey(20)) {
                query = this.getQuery((Collection<String>)inputsMap.get(20), ims_trans_query_ODB);
                p.put(20, this.getTransactionData(projName, dbg, query));
            }
            if (inputsMap.containsKey(81)) {
                query = this.getQuery((Collection<String>)inputsMap.get(81), mqqueue_query_ODB);
                p.put(81, this.getMQQueueData(dbg, query));
            }
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
            dbg = null;
        }
        inputORIDs.addAll(this.programProxy.values());
        return p;
    }

    private void getProgramsData(OrientBaseGraph dbg, Map<String, List<TSENode>> unexistingProgramNodes, String query) {
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        if (res != null && res.iterator().hasNext()) {
            for (OrientElement elem : res) {
                OrientVertex vertex = (OrientVertex)elem.getProperty("startRid");
                String prgName = (String)vertex.getProperty("name");
                Integer prgId = (Integer)vertex.getProperty("sid");
                String proxyRid = vertex.getId().toString();
                this.programProxy.put(prgId, proxyRid);
                unexistingProgramNodes.remove(prgName);
                L.debug("programs: {}", (Object)prgName);
            }
        }
        L.debug("unexistingProgramNodes: {}", unexistingProgramNodes);
    }

    private Map<String, String> getTransactionData(String prjName, OrientBaseGraph dbg, String query) {
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashMap<String, ArrayList<String>> info = new HashMap<String, ArrayList<String>>();
        HashMap<String, String> allTransactions = new HashMap<String, String>();
        if (res != null && res.iterator().hasNext()) {
            for (OrientElement oe : res) {
                Iterator it;
                String tRid = (String)oe.getProperty("trProxyRid");
                OrientVertex tRidV = dbg.getVertex((Object)tRid);
                String name = (String)tRidV.getProperty("name");
                allTransactions.put(name, tRid);
                info.put(tRid, null);
                String prgs = (String)oe.getProperty("prgCallingSid");
                String prgsRid = (String)oe.getProperty("prgCallingRid");
                prgs = prgs.substring(1, prgs.length() - 1);
                prgsRid = prgsRid.substring(1, prgsRid.length() - 1);
                if (!prgs.isEmpty()) {
                    String[] prgSids = prgs.split(",");
                    String[] prgRids = prgsRid.split(",");
                    int i = 0;
                    while (i < prgSids.length) {
                        this.programs4ODB.put(Integer.valueOf(prgSids[0].trim()), prgRids[0]);
                        ++i;
                    }
                }
                if ((it = tRidV.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"TranMapping"}).iterator()).hasNext()) {
                    Vertex mappedPrgProxyV = (Vertex)it.next();
                    Integer prgSid = (Integer)mappedPrgProxyV.getProperty("sid");
                    String proxyRid = mappedPrgProxyV.getId().toString();
                    this.programProxy.put(prgSid, proxyRid);
                    ArrayList<String> list = (ArrayList<String>)info.get(tRid);
                    if (list == null) {
                        list = new ArrayList<String>();
                        info.put(tRid, list);
                    }
                    list.add(proxyRid);
                }
                this.analysis.addContextValue(CgBuilder.getKey(prjName, "Tran map"), info);
            }
        }
        return allTransactions;
    }

    private Map<String, String> getMQQueueData(OrientBaseGraph dbg, String query) {
        HashMap<String, String> mqqueues = new HashMap<String, String>();
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashMap<String, Object> info = new HashMap<String, Object>();
        for (OrientElement oe : res) {
            String tRid = (String)oe.getProperty("mqProxyRid");
            OrientVertex tRidV = dbg.getVertex((Object)tRid);
            String name = (String)tRidV.getProperty("name");
            mqqueues.put(name, tRid);
            info.put(tRid, null);
            String prgs = (String)oe.getProperty("prgCallingSid");
            String prgsRid = (String)oe.getProperty("prgCallingRid");
            prgs = prgs.substring(1, prgs.length() - 1);
            prgsRid = prgsRid.substring(1, prgsRid.length() - 1);
            if (prgs.isEmpty()) continue;
            String[] prgSids = prgs.split(",");
            String[] prgRids = prgsRid.split(",");
            int i = 0;
            while (i < prgSids.length) {
                this.programs4ODB.put(Integer.valueOf(prgSids[i].trim()), prgRids[i].trim());
                ++i;
            }
        }
        return mqqueues;
    }

    private String getQuery(Collection<String> inputs, String query) {
        StringBuilder sbInfo = new StringBuilder();
        for (String input : inputs) {
            if (sbInfo.length() > 0) {
                sbInfo.append(", ");
            }
            sbInfo.append("'" + input + "'");
        }
        query = query.replace(RID_MARKER, sbInfo.toString());
        return query;
    }

    public void buildGraph(SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "collectingData.taskName"));
        Properties env = (Properties)this.analysis.getContextValue("env");
        HashSet<Integer> prgForwardSid = new HashSet<Integer>();
        HashSet<String> prgIdsSet = new HashSet<String>();
        if (this.programs4ODB != null) {
            prgForwardSid.addAll(this.programs4ODB.keySet());
            prgIdsSet.addAll(this.programs4ODB.values());
        }
        HashSet<String> idsSet = new HashSet<String>();
        if (this.programProxy != null) {
            idsSet.addAll(this.programProxy.values());
            prgForwardSid.addAll(this.programProxy.keySet());
        }
        OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        try {
            this.computePrgCalls(dbg, prgForwardSid, idsSet);
            L.debug("all program proxy ids: {}", idsSet);
            if (!idsSet.isEmpty()) {
                String commandQuery = String.format("select out('ProxyFor')[0].@rid.asString() as prgRid, @rid.asString() as proxyRid, out('ProxyFor')[0].sid from ProgramProxy where @rid in %s ", idsSet);
                CloseableIterable resPrg = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(commandQuery)).execute(new Object[0]);
                for (OrientElement elem : resPrg) {
                    String prgRid = (String)elem.getProperty("prgRid");
                    if (prgRid == null) continue;
                    prgIdsSet.add(prgRid);
                }
            }
            L.debug("all programs ids: {}", prgIdsSet);
            if (!prgIdsSet.isEmpty()) {
                StringBuilder prgIdsSb = com.ez.gdb.core.utils.Utils.makeStringBuilder(prgIdsSet);
                ProjectInfo pi = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
                long start = System.currentTimeMillis();
                for (String res : GraphUtils.resourceTypes) {
                    long lstart = System.currentTimeMillis();
                    this.analysis.addAllContextValues(GraphUtils.buildResources(pi.getName(), res, (OrientExtendedGraph)dbg, prgIdsSb, false, (IProgressMonitor)monitor.newChild(10)));
                    L.debug("computing {} in {}ms", (Object)res, (Object)(System.currentTimeMillis() - lstart));
                    if (monitor.isCanceled()) break;
                }
                L.debug("computing resources in {}ms", (Object)(System.currentTimeMillis() - start));
                CgBuilder cgb = new CgBuilder(pi.getName(), dbg, this.analysis, Direction.FORWARD);
                cgb.searchAfterExtCalls(dbg, GraphUtils.extCFResourceTypes, prgIdsSb, (IProgressMonitor)monitor.newChild(50));
                cgb.searchAfterExtCalls(dbg, GraphUtils.extDAResourceTypes, prgIdsSb, (IProgressMonitor)monitor.newChild(50));
            }
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
            dbg = null;
        }
        monitor.setWorkRemaining(0);
    }

    private void computePrgCalls(OrientBaseGraph dbg, Set<Integer> prgForwardSid, Set<String> idsSet) {
        long start = System.currentTimeMillis();
        if (prgForwardSid.size() > 0) {
            String query = commandForward.replace(RID_MARKER, " sid in " + prgForwardSid.toString());
            L.debug("executed query: {}", (Object)query);
            long startLocal = System.currentTimeMillis();
            Object res = dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
            L.debug("execute forward query with traverse in: {}ms", (Object)(System.currentTimeMillis() - startLocal));
            this.collectPrgInfo(idsSet, res);
        }
        L.debug("program calls computing in : {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void collectPrgInfo(Set<String> idsSet, Object res) {
        boolean restrictedVisibilityStatus = WorkspacePrefUtils.getPreferenceStore().getBoolean("callgraphRestrictedNodesVisibility");
        String[] cgRestrictions = PreferenceUtils.getCallgraphNamesCheckedRestrictions();
        LinkedHashMap info = new LinkedHashMap();
        this.analysis.addContextValue(CgBuilder.getKey(this.projName, "programs_Info_forward"), info);
        for (Object r : (CloseableIterable)res) {
            OrientElement elem = (OrientElement)r;
            String proxyRid = (String)elem.getProperty("startRid");
            ArrayList<String> prgCallRids = new ArrayList<String>();
            String endCallRids = (String)elem.getProperty("endCallRids");
            String calledProxies = (String)elem.getProperty("calledProxies");
            String calledProxiesName = (String)elem.getProperty("calledProxiesName");
            if (endCallRids != null) {
                endCallRids = endCallRids.substring(1, endCallRids.length() - 1);
                calledProxies = calledProxies.substring(1, calledProxies.length() - 1);
                calledProxiesName = calledProxiesName.substring(1, calledProxiesName.length() - 1);
                if (!endCallRids.isEmpty()) {
                    String[] callRids = endCallRids.split(",");
                    String[] proxyRids = calledProxies.split(",");
                    String[] proxysName = calledProxiesName.split(",");
                    int i = 0;
                    while (i < callRids.length) {
                        boolean doCollectInfo;
                        String ridStr = callRids[i].trim();
                        String calledProxyRid = proxyRids[i].trim();
                        String proxyName = proxysName[i].trim();
                        boolean bl = doCollectInfo = restrictedVisibilityStatus ? Utils.isValidName((String)proxyName, (String[])cgRestrictions) : true;
                        if (doCollectInfo) {
                            prgCallRids.add(ridStr);
                            idsSet.add(calledProxyRid);
                        }
                        ++i;
                    }
                }
            }
            info.put(proxyRid, prgCallRids);
        }
        for (String id : idsSet) {
            if (info.containsKey(id)) continue;
            info.put(id, new ArrayList());
        }
    }

    public void addAnnotations(CallGraphModel graphModel) {
    }

    protected void setAnnotationsContext(TSSwingCanvas canvas) {
        if (this.annStateManager == null) {
            this.annStateManager = new AnnotationPartStateManager();
            this.annStateListener = new AnnotationStateListener(this.annStateManager);
            this.annStateManager.setCanvas(canvas);
            EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
            this.stateManager.register((IEZStateListener)this.annStateListener, evType);
        } else {
            this.annStateManager.clear();
        }
    }

    protected void unsetAnnotationsContext() {
        EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
        this.stateManager.unregister((IEZStateListener)this.annStateListener, evType);
        this.annStateListener = null;
        if (this.annStateManager != null) {
            this.annStateManager.dispose();
            this.annStateManager = null;
        }
    }
}

