/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.analysis.config.inputs.EZJavaProgram;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.graph.ExecExportStatus;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAction
extends Action {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExportAction.class);
    private ProgressJob job;
    private TSEGraphManager graphManager;
    private String file = null;
    private boolean exportStatus = true;

    public ExportAction(String name, int style, TSEGraphManager graphManager) {
        super(name, style);
        this.graphManager = graphManager;
        this.job = new ProgressJob();
        this.job.setUser(true);
        this.setId("export.paths");
    }

    public void run() {
        String filePath = this.getExportPath();
        L.debug("paths will be exported in {} file", (Object)filePath);
        this.job.setFilePath(filePath);
        this.job.setName(this.getText());
        this.job.schedule();
    }

    private String getExportPath() {
        final String[] results = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
                    IViewPart viewPart = page.showView("com.ez.analysis.display.view.GraphsView");
                    FileDialog fDialog = new FileDialog(viewPart.getViewSite().getShell(), 8192);
                    fDialog.setFilterNames(new String[]{"Comma Separated Values Files (*.csv)", "All files (*.*)"});
                    fDialog.setFilterExtensions(new String[]{".csv", "*.*"});
                    fDialog.setText(Messages.getString(ExportAction.class, "export.csvfile.txt"));
                    fDialog.setFilterIndex(0);
                    fDialog.setOverwrite(true);
                    results[0] = fDialog.open();
                    if (results[0] != null && !results[0].isEmpty()) {
                        new File(results[0]).createNewFile();
                    }
                }
                catch (IOException | PartInitException e) {
                    L.error("Can't open file dialog {}", e);
                }
            }
        });
        return results[0];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExportAction)) {
            return false;
        }
        return this.getId().equals(((ExportAction)((Object)obj)).getId());
    }

    protected class ProgressJob
    extends Job {
        private static final String EMPTY_STRING = "";
        private String filePath;

        public ProgressJob() {
            super(Messages.getString(ExportAction.class, "progress.job.text"));
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (ExportAction.this.exportStatus) {
                        ExecExportStatus ees = new ExecExportStatus();
                        ees.exportStatus = true;
                        ees.exportFile = ExportAction.this.file;
                        Display.getDefault().syncExec((Runnable)ees);
                    }
                }
            });
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.execute(this.filePath, monitor);
            return Status.OK_STATUS;
        }

        public void dispose() {
            ExportAction.this.job = null;
        }

        public void execute(String filePath, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(ExportAction.class, "collectingData.taskName"));
            ExportAction.this.file = filePath;
            if (filePath != null && !filePath.isEmpty()) {
                L.debug("paths will be exported in {} file", (Object)filePath);
                monitor.worked(10);
                List selected = null;
                selected = ExportAction.this.graphManager.selectedNodes();
                L.debug("selected {} ", (Object)selected);
                if (selected == null || selected.isEmpty()) {
                    selected = ExportAction.this.graphManager.getMainDisplayGraph().nodes();
                    L.debug("selected from MainDisplayGraph {} ", (Object)selected);
                }
                final HashSet<Integer> programIDs = new HashSet<Integer>();
                final HashMap<Integer, Boolean> programIdInfo = new HashMap<Integer, Boolean>();
                final HashSet<Integer> jclIDs = new HashSet<Integer>();
                final HashSet<String> screenNames = new HashSet<String>();
                for (TSENode gNode : selected) {
                    if (gNode.hasAttribute("APPLICABLE_INPUT")) {
                        EZObjectType objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
                        EZSourceProgramIDSg program = (EZSourceProgramIDSg)objType.getEntID().getSegment(EZSourceProgramIDSg.class);
                        if (program != null) {
                            programIDs.add(program.getProgramId());
                            programIdInfo.put(program.getTypeId(), this.checkNode(gNode));
                            continue;
                        }
                        EZSourceJobIDSg jcl = (EZSourceJobIDSg)objType.getEntID().getSegment(EZSourceJobIDSg.class);
                        if (jcl != null) {
                            jclIDs.add(jcl.getJobId());
                            continue;
                        }
                        EZSourceScreenIDSg screen = (EZSourceScreenIDSg)objType.getEntID().getSegment(EZSourceScreenIDSg.class);
                        if (screen == null) continue;
                        screenNames.add(screen.getMapSet());
                        screenNames.add(screen.getScreenName());
                        continue;
                    }
                    L.warn("this node {} will be skipped; no applicable input type!!!", gNode.getName());
                }
                L.debug("selected programs {} ", programIDs);
                L.debug("selected jobs {} ", jclIDs);
                L.debug("selected screens {} ", screenNames);
                EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)ExportAction.this.graphManager.getMainDisplayGraph().getAttributeValue("MAINFRAME_PROJECT_ID_SG");
                String prjName = prjSg.getProjectName();
                L.debug("selected prjName {} ", (Object)prjName);
                monitor.worked(20);
                final ArrayList<String[]> sources = new ArrayList<String[]>();
                try {
                    L.debug("will open project " + prjName);
                    IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                    IMFProjectHandler ph = service.getProjectHandler(prjName, null);
                    if (!monitor.isCanceled()) {
                        ph.executeWithLock(ph, new IMFRunnable(){

                            public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                                SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)120);
                                if (!sm.isCanceled()) {
                                    String[][] result;
                                    sources.add(new String[]{"SOURCE_TYPE", "SOURCE_NAME", "SOURCE_PATH"});
                                    if (!programIDs.isEmpty()) {
                                        result = Utils.runProc((EZSourceConnection)conn, (String)"EZViewer_CallGraph_ExportToCSV_Programs", (Collection)programIDs, (EZSourceDataType)EZSourceDataType.Integer);
                                        L.debug("querying programs results {} ", new Object[]{result});
                                        ProgressJob.this.addToSourcesListFromResult(result, sources, programIdInfo);
                                    }
                                    sm.worked(40);
                                    if (!jclIDs.isEmpty()) {
                                        result = Utils.runProc((EZSourceConnection)conn, (String)"EZViewer_CallGraph_ExportToCSV_Jobs", (Collection)jclIDs, (EZSourceDataType)EZSourceDataType.Integer);
                                        L.debug("querying jcl results {} ", new Object[]{result});
                                        ProgressJob.this.addToSourcesListFromResult(result, sources);
                                    }
                                    sm.worked(30);
                                    if (!screenNames.isEmpty()) {
                                        result = Utils.runProc((EZSourceConnection)conn, (String)"EZViewer_CallGraph_ExportToCSV_ScreenMaps", (Collection)screenNames, (EZSourceDataType)EZSourceDataType.String);
                                        L.debug("querying screens results {} ", new Object[]{result});
                                        ProgressJob.this.addToSourcesListFromResult(result, sources);
                                    }
                                    sm.done();
                                }
                            }
                        }, LockType.Shared, (IProgressMonitor)monitor.newChild(60));
                    }
                }
                catch (Exception e) {
                    L.error("while getting db connection ", (Throwable)e);
                    GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
                }
                if (!monitor.isCanceled()) {
                    L.debug("before writing in file ");
                    this.writeToCSV(sources, filePath);
                } else {
                    ExportAction.this.exportStatus = false;
                }
                monitor.done();
            } else {
                ExportAction.this.exportStatus = false;
            }
        }

        private boolean checkNode(TSENode node) {
            EZObjectType ezObjectType = (EZObjectType)node.getAttributeValue("APPLICABLE_INPUT");
            return ezObjectType instanceof EZJavaProgram;
        }

        private void addToSourcesListFromResult(String[][] result, List<String[]> sources, Map<Integer, Boolean> programIdInfo) {
            if (result != null) {
                String[][] stringArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] res = stringArray[n2];
                    if (res[2] == null) {
                        res[2] = EMPTY_STRING;
                    }
                    int type = Integer.valueOf(res[0]);
                    boolean skip = false;
                    if (type == 22 && programIdInfo.get(22).booleanValue()) {
                        res[0] = "JAVA PROGRAM";
                        sources.add(res);
                        return;
                    }
                    this.processResult(res, type, skip);
                    if (!skip) {
                        sources.add(res);
                    }
                    ++n2;
                }
            }
        }

        private void addToSourcesListFromResult(String[][] result, List<String[]> sources) {
            if (result != null) {
                String[][] stringArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] res = stringArray[n2];
                    int type = Integer.valueOf(res[0]);
                    if (res[2] == null) {
                        res[2] = EMPTY_STRING;
                    }
                    boolean skip = false;
                    this.processResult(res, type, skip);
                    if (!skip) {
                        sources.add(res);
                    }
                    ++n2;
                }
            }
        }

        private void processResult(String[] res, int type, boolean skip) {
            switch (type) {
                case 1: {
                    res[0] = "COBOL";
                    break;
                }
                case 13: {
                    res[0] = "COBOL_INCLUDE";
                    if (!res[2].equals(res[1])) break;
                    L.debug("path for include identical with the name {}, replaced with empty string", (Object)res[2]);
                    res[2] = EMPTY_STRING;
                    break;
                }
                case 2: {
                    res[0] = "PL1";
                    break;
                }
                case 67: {
                    res[0] = "PL1_INCLUDE";
                    if (!res[2].equals(res[1])) break;
                    L.debug("path for include identical with the name {}, replaced with empty string", (Object)res[2]);
                    res[2] = EMPTY_STRING;
                    break;
                }
                case 8: 
                case 15: 
                case 16: {
                    res[0] = "ASSEMBLER";
                    break;
                }
                case 99: {
                    res[0] = "ASSEMBLER_INCLUDE";
                    if (!res[2].equals(res[1])) break;
                    L.debug("path for include identical with the name {}, replaced with empty string", (Object)res[2]);
                    res[2] = EMPTY_STRING;
                    break;
                }
                case 98: {
                    res[0] = "ASSEMBLER_MACRO";
                    break;
                }
                case 3: {
                    res[0] = "NATURAL";
                    break;
                }
                case 60: {
                    res[0] = "NATURAL_INCLUDE";
                    if (!res[2].equals(res[1])) break;
                    L.debug("path for include identical with the name {}, replaced with empty string", (Object)res[2]);
                    res[2] = EMPTY_STRING;
                    break;
                }
                case 57: {
                    res[0] = "NATURAL_DATA_AREA";
                    break;
                }
                case 22: {
                    res[0] = "JCL_JOB";
                    break;
                }
                case 25: {
                    res[0] = "JCL_PROC";
                    break;
                }
                case 204: {
                    res[0] = "JCL_INCLUDE";
                    break;
                }
                case 205: {
                    res[0] = "JCL_CTRL";
                    break;
                }
                case 6: {
                    res[0] = "BMS_FILE";
                    break;
                }
                case 65: {
                    res[0] = "MFS_FILE";
                    break;
                }
                case 61: {
                    res[0] = "NATURAL_MAP_FILE";
                    break;
                }
                default: {
                    L.warn("Information not exported to CSV. Unknown file type. SOURCE_TYPE: {} SOURCE_NAME: {} SOURCE_PATH: {}", new Object[]{type, res[1], res[2]});
                    skip = true;
                }
            }
        }

        private String convertToCSV(String[] data) {
            return Stream.of(data).collect(Collectors.joining(";"));
        }

        private void writeToCSV(List<String[]> dataLines, String filePath) {
            L.debug("writeToCSV dataLines: {} ", dataLines);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (PrintWriter pw = new PrintWriter(new File(filePath));){
                    dataLines.stream().map(this::convertToCSV).forEach(pw::println);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                L.error("IOException: " + e.getMessage());
            }
        }
    }
}

