/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphJob;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.Direction;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CgBuilder.class);
    private static final String commandForward = "select @rid.asString() as startRid , $a.@rid.asString() as endCallRids, $a.in.@rid.asString() as calledProxies,  sum($depth,2) as level, $a.in.name.asString() as calledProxiesName \n from (traverse out('ProgramCall','ProxyFor') from (select from ProgramProxy where @@@@@EZLEGACY@@@@ FETCHPLAN in_*:-2 out_*:-2   ) @@@@@EZLEGACY@MAXDEPTH@@@@@@@@@WHILE@EZLEGACY@@@@ STRATEGY BREADTH_FIRST )  let $a = out('ProxyFor').outE('ProgramCall') \nwhere @class='ProgramProxy'";
    private static final String commandBackward1 = "select startRid, level, calls.@rid.asString() as endCallRids, $a.out.in('ProxyFor').@rid.asString() as calledProxies,\n $a.out.name as calledProxiesName \n from (select @rid.asString() as startRid, sum($depth,2) as level, inE('ProgramCall') as calls from (traverse in('ProgramCall','ProxyFor')  \n from (select from ProgramProxy  where @@@@@EZLEGACY@@@@ FETCHPLAN in_*:-2 out_*:-2 ) @@@@@EZLEGACY@MAXDEPTH@@@@@@@@@WHILE@EZLEGACY@@@@ STRATEGY BREADTH_FIRST ) \n where @class='ProgramProxy' unwind calls) \n let $a = $current.calls";
    private static final String commandLimit0 = "select @rid.asString() as startRid , null as endProxyRids, null as calledProxies \nfrom ProgramProxy where @@@@@EZLEGACY@@@@";
    private static final String commandSidLimit0 = "select @rid.asString() as startRid , null as endProxyRids, null as calledProxies \nfrom Program where @@@@@EZLEGACY@@@@";
    private static final String queryFW = "select @rid.asString() as proxyRid from ProgramProxy where out('ProxyFor').outE('ProgramCall').size()>0 and @@@@@EZLEGACY@@@@@@@@@WHILE@EZLEGACY@@@@";
    private static final String queryBW = "select @rid.asString() as proxyRid from ProgramProxy where in('ProgramCall').inE('ProxyFor').size()>0 and @@@@@EZLEGACY@@@@@@@@@WHILE@EZLEGACY@@@@";
    private static final String queryFWStep1 = "select @rid.asString() as startRid , $callE.@rid.asString() as endCallRids, $callE.in.@rid.asString() as calledProxies, 0 as level, $callE.in.name.asString() as calledProxiesName\n from  Program \n let $callE = outE('ProgramCall') where sid in ? and $callE.size() > 0 FETCHPLAN in_*:-2 out_*:-2";
    private static final String queryBWStep1 = "select in.@rid.asString() as startRid, @rid.asString() as endCallRids, \n out.in('ProxyFor').@rid.asString() as calledProxies, \n 0 as level, out.name as calledProxiesName from ProgramCall where in.sid in ? FETCHPLAN in_*:-2 out_*:-2";
    private static final String commandJCL = "select out.@rid.asString() as prgProxyRid, prgRid.asString() as prgRid,in.out('ContextOf').in('ExecPGM').@rid.asString() as steps from InContext  where pgm = 'true' and @@@@@SEL@EZLEGACY@@@@@@@@@EZLEGACY@@@@";
    private OrientBaseGraph dbg;
    private AbstractSharedAnalysis analysis;
    private String prjName;
    private Direction cgDirection;
    private boolean isJobCg = false;
    private boolean isPrgCg = false;

    public CgBuilder(String prjName, OrientBaseGraph dbg, AbstractSharedAnalysis analysis, Direction cgDirection) {
        this(prjName, dbg, analysis, cgDirection, true);
    }

    public CgBuilder(String prjName, OrientBaseGraph dbg, AbstractSharedAnalysis analysis, Direction cgDirection, boolean withNamesRestriction) {
        this.dbg = dbg;
        this.analysis = analysis;
        this.cgDirection = cgDirection;
        this.prjName = prjName;
        Object[] cgRestrictions = null;
        if (withNamesRestriction) {
            cgRestrictions = PreferenceUtils.getCallgraphNamesCheckedRestrictions();
        }
        analysis.addContextValue("while restrictions resources tag", (Object)cgRestrictions);
        L.debug("set restriction names from preferences {}", cgRestrictions);
    }

    public void computeCg(Set<Integer> prgBackwardSid, Set<Integer> prgForwardSid, Set<String> prgWithoutSid, Set<String> idsSet, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        HashSet<String> idsForwSet = new HashSet<String>();
        this.computePrgCalls(prgBackwardSid, prgForwardSid, prgWithoutSid, idsSet, idsForwSet, monitor.newChild(100));
        this.setCgType();
        this.computeResources(prgBackwardSid, prgForwardSid, prgWithoutSid, idsSet, idsForwSet, monitor.newChild(100));
    }

    private void setCgType() {
        this.isJobCg = this.analysis.getContextValue("JOB_CALLGRAPH") != null ? (Boolean)this.analysis.getContextValue("JOB_CALLGRAPH") : false;
        this.isPrgCg = this.analysis.getContextValue("PROGRAM_CALLGRAPH") != null ? (Boolean)this.analysis.getContextValue("PROGRAM_CALLGRAPH") : false;
    }

    private void computePrgCalls(Set<Integer> prgBackwardSid, Set<Integer> prgForwardSid, Set<String> prgWithoutSid, Set<String> idsSet, Set<String> idsForwSet, SubMonitor pmonitor) {
        String query;
        Integer limit;
        long start = System.currentTimeMillis();
        HashSet<String> unexpandedTargets = (HashSet<String>)this.analysis.getContextValue(CgBuilder.getKey(this.prjName, "lastLevelResourcestoMark"));
        if (unexpandedTargets == null) {
            unexpandedTargets = new HashSet<String>();
            this.analysis.addContextValue(CgBuilder.getKey(this.prjName, "lastLevelResourcestoMark"), unexpandedTargets);
        }
        boolean markOnlyExpandable = WorkspacePrefUtils.getPreferenceStore().getBoolean("graphHighlightedOnlyExpandableAtLimit");
        String[] cgRestrictions = (String[])this.analysis.getContextValue("while restrictions resources tag");
        StringBuilder restrictions = com.ez.graphs.viewer.odb.utils.Utils.getWhileRestrictions((String[])cgRestrictions);
        if (restrictions != null && restrictions.length() > 0) {
            L.debug("apply names restriction in callgraph");
        }
        if ((limit = (Integer)this.analysis.getContextValue("CGLIMIT")) != null && limit == 0) {
            prgForwardSid.addAll(prgBackwardSid);
            if (prgForwardSid.size() > 0) {
                String query2 = commandSidLimit0.replace("@@@@@EZLEGACY@@@@", " sid in " + prgForwardSid);
                long startLocal = System.currentTimeMillis();
                Object res = this.dbg.command((OCommandRequest)new OCommandSQL(query2)).execute(new Object[0]);
                L.debug("execute forward, limit 0 the query with traverse in: {}ms", (Object)(System.currentTimeMillis() - startLocal));
                Set<String> unexpandedTgs = this.collectPrgInfo(idsSet, res, "programs_Info_forward", limit);
                if (!unexpandedTgs.isEmpty() && markOnlyExpandable) {
                    if (Direction.doForward((Direction)this.cgDirection)) {
                        query2 = queryFW.replace("@@@@@EZLEGACY@@@@", " @rid in " + unexpandedTgs);
                        query2 = restrictions != null && !restrictions.toString().isEmpty() ? query2.replace("@@@@@WHILE@EZLEGACY@@@@", " and (" + restrictions.toString() + ")") : query2.replace("@@@@@WHILE@EZLEGACY@@@@", "");
                        this.collectExpandableTargets(query2, this.dbg, unexpandedTgs);
                    }
                    if (Direction.doBackward((Direction)this.cgDirection)) {
                        query2 = queryBW.replace("@@@@@EZLEGACY@@@@", " @rid in " + unexpandedTgs);
                        query2 = restrictions != null && !restrictions.toString().isEmpty() ? query2.replace("@@@@@WHILE@EZLEGACY@@@@", " and (" + restrictions.toString() + ")") : query2.replace("@@@@@WHILE@EZLEGACY@@@@", "");
                        this.collectExpandableTargets(query2, this.dbg, unexpandedTgs);
                    }
                } else {
                    unexpandedTargets.addAll(unexpandedTgs);
                }
                idsForwSet.addAll(idsSet);
            }
        } else {
            Set<String> proxiesFromStep1;
            Object resStep1;
            if (Direction.doForward((Direction)this.cgDirection) && prgForwardSid.size() > 0) {
                resStep1 = this.dbg.command((OCommandRequest)new OCommandSQL(queryFWStep1)).execute(new Object[]{prgForwardSid});
                Set<String> unexpandedTargetsFW = this.collectPrgInfo(idsSet, resStep1, "programs_Info_forward", limit);
                resStep1 = this.dbg.command((OCommandRequest)new OCommandSQL(queryFWStep1)).execute(new Object[]{prgForwardSid});
                proxiesFromStep1 = this.collectCalledProxies(resStep1);
                if (proxiesFromStep1 != null && proxiesFromStep1.size() > 0 && (limit == null || limit > 1)) {
                    query = commandForward.replace("@@@@@EZLEGACY@@@@", " @rid in " + proxiesFromStep1);
                    query = this.replaceMarkersInQuery(query, restrictions, limit != null ? Integer.valueOf(limit - 1) : null);
                    L.debug("executed query: {}", (Object)query);
                    long startLocal = System.currentTimeMillis();
                    Object res = this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                    L.debug("execute forward query with traverse in: {}ms", (Object)(System.currentTimeMillis() - startLocal));
                    unexpandedTargetsFW.addAll(this.collectPrgInfo(idsSet, res, "programs_Info_forward", limit));
                }
                if (!unexpandedTargetsFW.isEmpty() && markOnlyExpandable) {
                    query = queryFW.replace("@@@@@EZLEGACY@@@@", " @rid in " + unexpandedTargetsFW);
                    query = this.replaceMarkersInQuery(query, restrictions, limit);
                    this.collectExpandableTargets(query, this.dbg, unexpandedTargetsFW);
                } else {
                    unexpandedTargets.addAll(unexpandedTargetsFW);
                }
                idsForwSet.addAll(idsSet);
            }
            if (Direction.doBackward((Direction)this.cgDirection) && prgBackwardSid.size() > 0) {
                resStep1 = this.dbg.command((OCommandRequest)new OCommandSQL(queryBWStep1)).execute(new Object[]{prgBackwardSid});
                Set<String> unexpandedTargetsBW = this.collectPrgInfoBW(idsSet, resStep1, "programs_Info_backward", limit);
                resStep1 = this.dbg.command((OCommandRequest)new OCommandSQL(queryBWStep1)).execute(new Object[]{prgBackwardSid});
                proxiesFromStep1 = this.collectCalledProxies(resStep1);
                if (proxiesFromStep1 != null && proxiesFromStep1.size() > 0 && (limit == null || limit > 1)) {
                    query = commandBackward1.replace("@@@@@EZLEGACY@@@@", " @rid in " + proxiesFromStep1);
                    query = this.replaceMarkersInQuery(query, restrictions, limit != null ? Integer.valueOf(limit - 1) : null);
                    Object res = this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                    unexpandedTargetsBW = this.collectPrgInfoBW(idsSet, res, "programs_Info_backward", limit);
                }
                if (!unexpandedTargetsBW.isEmpty() && markOnlyExpandable) {
                    query = queryBW.replace("@@@@@EZLEGACY@@@@", " @rid in " + unexpandedTargetsBW);
                    query = this.replaceMarkersInQuery(query, restrictions, limit);
                    this.collectExpandableTargets(query, this.dbg, unexpandedTargetsBW);
                } else {
                    unexpandedTargets.addAll(unexpandedTargetsBW);
                }
            }
        }
        if (!prgWithoutSid.isEmpty()) {
            L.debug("compute callgraph for programs having sid -1");
            CloseableIterable queryRes = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(String.format("select @rid.asString() as proxyRid from ProgramProxy where type.append(name) in %s ", prgWithoutSid))).execute(new Object[0]);
            HashSet<String> proxyRids = new HashSet<String>();
            Set<String> inputORIDs = this.getInputOrids(this.prjName);
            for (OrientElement elem : queryRes) {
                String proxyRid = (String)elem.getProperty("proxyRid");
                proxyRids.add(proxyRid);
                inputORIDs.add(proxyRid);
            }
            if (!proxyRids.isEmpty()) {
                Object res;
                if (Direction.doBackward((Direction)this.cgDirection)) {
                    if (limit == null || limit != 0) {
                        query = commandBackward1.replace("@@@@@EZLEGACY@@@@", " @rid in " + ((Object)proxyRids).toString());
                        query = this.replaceMarkersInQuery(query, restrictions, limit);
                        res = this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                        this.collectPrgInfoBW(idsSet, res, "programs_Info_backward", limit);
                    } else {
                        query = commandLimit0.replace("@@@@@EZLEGACY@@@@", " @rid in " + ((Object)proxyRids).toString());
                        res = this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                        this.collectPrgInfo(idsSet, res, "programs_Info_forward", limit);
                    }
                } else if (Direction.FORWARD.equals((Object)this.cgDirection)) {
                    query = commandLimit0.replace("@@@@@EZLEGACY@@@@", " @rid in " + ((Object)proxyRids).toString());
                    res = this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                    this.collectPrgInfo(idsSet, res, "programs_Info_forward", limit);
                }
            }
        }
        L.debug("program calls computing in : {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private Set<String> collectPrgInfo(Set<String> idsSet, Object res, String key, Integer cgLimit) {
        boolean restrictedVisibilityStatus = WorkspacePrefUtils.getPreferenceStore().getBoolean("callgraphRestrictedNodesVisibility");
        String[] cgRestrictions = PreferenceUtils.getCallgraphNamesCheckedRestrictions();
        LinkedHashMap info = (LinkedHashMap)this.analysis.getContextValue(CgBuilder.getKey(this.prjName, key));
        HashSet<String> unexpandedTargets = new HashSet<String>();
        if (info == null) {
            info = new LinkedHashMap();
            this.analysis.addContextValue(CgBuilder.getKey(this.prjName, key), info);
        }
        for (Object r : (CloseableIterable)res) {
            OrientElement elem = (OrientElement)r;
            String proxyRid = (String)elem.getProperty("startRid");
            boolean isLimitLevel = false;
            Integer level = (Integer)elem.getProperty("level");
            if (level != null && cgLimit != null && level == 2 * (cgLimit - 1)) {
                isLimitLevel = true;
            }
            ArrayList<String> prgCallRids = new ArrayList<String>();
            String endCallRids = (String)elem.getProperty("endCallRids");
            String calledProxies = (String)elem.getProperty("calledProxies");
            String calledProxiesName = (String)elem.getProperty("calledProxiesName");
            if (endCallRids != null) {
                endCallRids = endCallRids.substring(1, endCallRids.length() - 1);
                calledProxies = calledProxies.substring(1, calledProxies.length() - 1);
                calledProxiesName = calledProxiesName.substring(1, calledProxiesName.length() - 1);
                if (!endCallRids.isEmpty()) {
                    String[] callRids = endCallRids.split(",");
                    String[] proxyRids = calledProxies.split(",");
                    String[] proxysName = calledProxiesName.split(",");
                    int i = 0;
                    while (i < callRids.length) {
                        boolean doCollectInfo;
                        String ridStr = callRids[i].trim();
                        String calledProxyRid = proxyRids[i].trim();
                        String proxyName = proxysName[i].trim();
                        boolean bl = doCollectInfo = restrictedVisibilityStatus ? com.ez.graphs.viewer.odb.utils.Utils.isValidName((String)proxyName, (String[])cgRestrictions) : true;
                        if (doCollectInfo) {
                            prgCallRids.add(ridStr);
                            if (isLimitLevel && !idsSet.contains(calledProxyRid) && !proxyRid.equals(calledProxyRid)) {
                                unexpandedTargets.add(calledProxyRid);
                            }
                            idsSet.add(calledProxyRid);
                        }
                        ++i;
                    }
                }
            }
            info.put(proxyRid, prgCallRids);
            if (cgLimit == null || cgLimit != 0) continue;
            unexpandedTargets.add(proxyRid);
        }
        for (String id : idsSet) {
            if (info.containsKey(id)) continue;
            info.put(id, new ArrayList());
        }
        return unexpandedTargets;
    }

    private Set<String> collectPrgInfoBW(Set<String> idsSet, Object res, String key, Integer cgLimit) {
        boolean restrictedVisibilityStatus = WorkspacePrefUtils.getPreferenceStore().getBoolean("callgraphRestrictedNodesVisibility");
        String[] cgRestrictions = PreferenceUtils.getCallgraphNamesCheckedRestrictions();
        LinkedHashMap info = (LinkedHashMap)this.analysis.getContextValue(CgBuilder.getKey(this.prjName, key));
        HashSet<String> unexpandedTargets = new HashSet<String>();
        if (info == null) {
            info = new LinkedHashMap();
            this.analysis.addContextValue(CgBuilder.getKey(this.prjName, key), info);
        }
        for (Object r : (CloseableIterable)res) {
            OrientElement elem = (OrientElement)r;
            String proxyRid = (String)elem.getProperty("startRid");
            boolean isLimitLevel = false;
            Integer level = (Integer)elem.getProperty("level");
            if (level != null && cgLimit != null && level == 2 * (cgLimit - 1)) {
                isLimitLevel = true;
            }
            String endCallRid = (String)elem.getProperty("endCallRids");
            String calledProxies = (String)elem.getProperty("calledProxies");
            String proxyName = (String)elem.getProperty("calledProxiesName");
            ArrayList<String> prgCallRids = (ArrayList<String>)info.get(proxyRid);
            if (prgCallRids == null) {
                prgCallRids = new ArrayList<String>();
                info.put(proxyRid, prgCallRids);
            }
            if (endCallRid != null) {
                calledProxies = calledProxies.substring(1, calledProxies.length() - 1);
                String[] proxyRids = calledProxies.split(",");
                int i = 0;
                while (i < proxyRids.length) {
                    boolean doCollectInfo;
                    String calledProxyRid = proxyRids[i].trim();
                    boolean bl = doCollectInfo = restrictedVisibilityStatus ? com.ez.graphs.viewer.odb.utils.Utils.isValidName((String)proxyName, (String[])cgRestrictions) : true;
                    if (doCollectInfo) {
                        prgCallRids.add(endCallRid);
                        if (isLimitLevel && !idsSet.contains(calledProxyRid) && !proxyRid.equals(calledProxyRid)) {
                            unexpandedTargets.add(calledProxyRid);
                        }
                        idsSet.add(calledProxyRid);
                    }
                    ++i;
                }
            }
            if (cgLimit == null || cgLimit != 0) continue;
            unexpandedTargets.add(proxyRid);
        }
        for (String id : idsSet) {
            if (info.containsKey(id)) continue;
            info.put(id, new ArrayList());
        }
        return unexpandedTargets;
    }

    private void computeResources(Set<Integer> prgBackwardSid, Set<Integer> prgForwardSid, Set<String> prgWithoutSid, Set<String> idsSet, Set<String> idsForwSet, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CgBuilder.class, "collectingResources.taskName"));
        if (idsSet.size() > 0) {
            L.debug("all program proxy ids: {}", idsSet);
            String commandQuery = String.format("select $prg.@rid.asString() as prgRid, @rid.asString() as proxyRid, sid from ProgramProxy\n let $prg = out('ProxyFor')[0] where @rid in %s ", idsSet);
            CloseableIterable resPrg = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(commandQuery)).execute(new Object[0]);
            HashSet<String> prgIdsSet = new HashSet<String>();
            for (OrientElement elem : resPrg) {
                String prgRid = (String)elem.getProperty("prgRid");
                if (prgRid != null && !prgRid.isEmpty()) {
                    prgIdsSet.add(prgRid);
                }
                if (!this.isPrgCg) continue;
                Integer sid = (Integer)elem.getProperty("sid");
                String proxyrid = (String)elem.getProperty("proxyRid");
                if (sid == null || sid == -1 || !prgBackwardSid.contains(sid) && !prgForwardSid.contains(sid)) continue;
                Set<String> inputORIDs = this.getInputOrids(this.prjName);
                inputORIDs.add(proxyrid);
            }
            String commandQueryPrg = String.format("select @rid.asString() as prgRid from Program where @rid in %s ", idsSet);
            resPrg = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(commandQueryPrg)).execute(new Object[0]);
            for (OrientElement elem : resPrg) {
                String prgRid = (String)elem.getProperty("prgRid");
                if (prgRid == null) continue;
                prgIdsSet.add(prgRid);
            }
            L.debug("all programs ids: {}", prgIdsSet);
            if (!prgIdsSet.isEmpty()) {
                StringBuilder prgIdsSb = com.ez.gdb.core.utils.Utils.makeStringBuilder(prgIdsSet);
                if (!this.isJobCg) {
                    StringBuilder sb;
                    long start = System.currentTimeMillis();
                    if (((Boolean)this.analysis.hasContextKey("program's rid from screen cg")).booleanValue()) {
                        sb = (StringBuilder)this.analysis.getContextValue("program's rid from screen cg");
                        L.debug("For Screen Callgraph, sb is: {}", (Object)sb);
                        this.analysis.addAllContextValues(GraphUtils.buildResources(this.prjName, "ScreenUsageInfo", (OrientExtendedGraph)this.dbg, sb, false, (IProgressMonitor)monitor.newChild(10)));
                        this.analysis.addAllContextValues(GraphUtils.buildResources(this.prjName, "IMSMODUsageInfo", (OrientExtendedGraph)this.dbg, sb, false, (IProgressMonitor)monitor.newChild(10)));
                    } else if (((Boolean)this.analysis.hasContextKey("program's rid from transaction cg")).booleanValue()) {
                        sb = (StringBuilder)this.analysis.getContextValue("program's rid from transaction cg");
                        L.debug("For Transaction Callgraph, sb is: {}", (Object)sb);
                        this.analysis.addAllContextValues(GraphUtils.buildResources(this.prjName, "TranUsageInfo", (OrientExtendedGraph)this.dbg, sb, false, (IProgressMonitor)monitor.newChild(10)));
                        this.analysis.addAllContextValues(GraphUtils.buildResources(this.prjName, "IMSTransactionUsageInfo", (OrientExtendedGraph)this.dbg, sb, false, (IProgressMonitor)monitor.newChild(10)));
                    }
                    Boolean isCgWithoutResources = (Boolean)this.analysis.getContextValue("graph without resources");
                    isCgWithoutResources = isCgWithoutResources == null ? false : isCgWithoutResources;
                    if (!isCgWithoutResources.booleanValue()) {
                        ArrayList resource = new ArrayList();
                        Map rStates = (Map)this.analysis.getContextValue("graph resources checked or not");
                        for (String lbl : Utils.resourceTypesLbl.keySet()) {
                            if (this.analysis.getContextValue("API_CALLGRAPH") != null && ((Boolean)this.analysis.getContextValue("API_CALLGRAPH")).booleanValue()) {
                                resource.addAll((Collection)Utils.resourceTypesLbl.get(lbl));
                                continue;
                            }
                            boolean isChecked = (Boolean)rStates.get(lbl);
                            if (!isChecked) continue;
                            resource.addAll((Collection)Utils.resourceTypesLbl.get(lbl));
                        }
                        for (String res : resource) {
                            long lstart = System.currentTimeMillis();
                            this.analysis.addAllContextValues(GraphUtils.buildResources(this.prjName, res, (OrientExtendedGraph)this.dbg, prgIdsSb, false, (IProgressMonitor)monitor.newChild(10)));
                            L.debug("computing {} in {}ms", (Object)res, (Object)(System.currentTimeMillis() - lstart));
                            if (monitor.isCanceled()) break;
                        }
                    }
                    this.analysis.addAllContextValues(GraphUtils.buildScreenMapping(this.prjName, (OrientExtendedGraph)this.dbg, prgIdsSb, (IProgressMonitor)monitor.newChild(10)));
                    L.debug("computing resources in {}ms", (Object)(System.currentTimeMillis() - start));
                }
                HashSet<String> forwPrgIds = new HashSet<String>();
                String cmd = String.format("select if (eval (\"@class='Program'\"), @rid,out('ProxyFor')[0].@rid).asString() as prgRid from %s ", idsForwSet);
                resPrg = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(cmd)).execute(new Object[0]);
                for (OrientElement elem : resPrg) {
                    String prgRid = (String)elem.getProperty("prgRid");
                    if (prgRid == null) continue;
                    forwPrgIds.add(prgRid);
                }
                this.searchAfterExtCalls(this.dbg, GraphUtils.extCFResourceTypes, com.ez.gdb.core.utils.Utils.makeStringBuilder(forwPrgIds), (IProgressMonitor)monitor.newChild(50));
                this.searchAfterExtCalls(this.dbg, GraphUtils.extDAResourceTypes, prgIdsSb, (IProgressMonitor)monitor.newChild(50));
            }
            if (Direction.doBackward((Direction)this.cgDirection)) {
                long start = System.currentTimeMillis();
                String query = commandJCL.replace("@@@@@SEL@EZLEGACY@@@@", " out.out('ProxyFor')[0] in ");
                this.processJobs(this.dbg, query, idsSet);
                String queryWithProxies = commandJCL.replace("@@@@@SEL@EZLEGACY@@@@", " out in ");
                this.processJobs(this.dbg, queryWithProxies, idsSet);
                L.debug("computing job resources in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    public void searchAfterExtCalls(OrientBaseGraph dbg, Set<String> extTypes, StringBuilder prgIdsSb, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(extTypes.size() * 100));
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "userExits.taskName"));
        long start = System.currentTimeMillis();
        for (String res : extTypes) {
            long lstart = System.currentTimeMillis();
            this.analysis.addAllContextValues(GraphUtils.buildExtResources(this.prjName, res, dbg, prgIdsSb, false, monitor.newChild(100)));
            L.debug("computing {} in {}ms", (Object)res, (Object)(System.currentTimeMillis() - lstart));
            if (monitor.isCanceled()) break;
        }
        L.debug("computing resources in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void processJobs(OrientBaseGraph dbg, String query, Set<String> idsSet) {
        query = query.replace("@@@@@EZLEGACY@@@@", idsSet.toString());
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        ArrayList<String[]> info = (ArrayList<String[]>)this.analysis.getContextValue("JCLStep_Info");
        if (info == null) {
            info = new ArrayList<String[]>();
        }
        if (res != null && res.iterator().hasNext()) {
            for (OrientElement elem : res) {
                String[] sRids;
                String prgProxyRid = (String)elem.getProperty("prgProxyRid");
                String prgRid = (String)elem.getProperty("prgRid");
                String stepsRid = (String)elem.getProperty("steps");
                if (stepsRid == null || (stepsRid = stepsRid.substring(1, stepsRid.length() - 1)).isEmpty()) continue;
                String[] stringArray = sRids = stepsRid.split(",");
                int n = sRids.length;
                int n2 = 0;
                while (n2 < n) {
                    String stepRid = stringArray[n2];
                    if (prgRid != null) {
                        info.add(new String[]{prgRid, stepRid.trim()});
                    } else {
                        info.add(new String[]{prgProxyRid, stepRid.trim()});
                    }
                    ++n2;
                }
            }
            this.analysis.addContextValue("JCLStep_Info", info);
        }
    }

    private Set<String> collectCalledProxies(Object resStep1) {
        HashSet<String> calledProxies = null;
        for (OrientElement elem : (CloseableIterable)resStep1) {
            String cProxies = (String)elem.getProperty("calledProxies");
            if (cProxies == null || cProxies.length() <= 2) continue;
            cProxies = cProxies.substring(1, cProxies.length() - 1);
            String[] proxyRids = cProxies.split(",");
            int i = 0;
            while (i < proxyRids.length) {
                String calledProxyRid = proxyRids[i].trim();
                if (calledProxies == null) {
                    calledProxies = new HashSet<String>();
                }
                calledProxies.add(calledProxyRid);
                ++i;
            }
        }
        return calledProxies;
    }

    private void collectExpandableTargets(String query, OrientBaseGraph dbg, Set<String> unexpandedTgs) {
        HashSet<String> unexpandedTargets = (HashSet<String>)this.analysis.getContextValue(CgBuilder.getKey(this.prjName, "lastLevelResourcestoMark"));
        if (unexpandedTargets == null) {
            unexpandedTargets = new HashSet<String>();
            this.analysis.addContextValue(CgBuilder.getKey(this.prjName, "lastLevelResourcestoMark"), unexpandedTargets);
        }
        unexpandedTargets.removeAll(unexpandedTgs);
        CloseableIterable childrenPrg = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        for (OrientElement elem : childrenPrg) {
            String rid = (String)elem.getProperty("proxyRid");
            unexpandedTargets.add(rid);
        }
        if (unexpandedTargets.isEmpty()) {
            unexpandedTargets.addAll(unexpandedTgs);
        }
    }

    private String replaceMarkersInQuery(String query, StringBuilder restrictions, Integer limit) {
        boolean hasWhile = false;
        if (limit != null && limit > 0) {
            query = query.replace("@@@@@EZLEGACY@MAXDEPTH@@@@", " while ($depth <= " + 2 * (limit - 1) + ") ");
            hasWhile = true;
        } else {
            query = query.replace("@@@@@EZLEGACY@MAXDEPTH@@@@", "");
        }
        query = restrictions != null && restrictions.length() > 0 ? (hasWhile ? query.replace("@@@@@WHILE@EZLEGACY@@@@", " and (" + restrictions.toString() + ")") : query.replace("@@@@@WHILE@EZLEGACY@@@@", " while (" + restrictions.toString() + ")")) : query.replace("@@@@@WHILE@EZLEGACY@@@@", "");
        return query;
    }

    public static String getKey(String prjName, String key) {
        return prjName == null ? key : prjName.concat(key);
    }

    private Set<String> getInputOrids(String prjName) {
        String key = CgBuilder.getKey(prjName, "input orids as string");
        HashSet inps = this.analysis.getContextSetValue(key);
        if (inps == null) {
            inps = new HashSet();
            this.analysis.addContextValue(key, inps);
        }
        return inps;
    }
}

