/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.cross.CrossExtGraphModel;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CgBuilder;
import com.ez.graphs.viewer.callgraph.programcallgraph.ExportAction;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.Target;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UEBasedGraphModel;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsFromPrg;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsToPrj;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.analysis.config.inputs.CatalogAPIInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.gui.graphs.GraphRestrictionsLegendInfo;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.MappingConstants;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.utils.LevelObject;
import com.ibm.ez.analysis.api.model.APIRelatedNode;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.ApiTargetType;
import com.ibm.ez.analysis.api.model.CatalogAPISg;
import com.ibm.ez.analysis.api.model.IAPIFillerService;
import com.ibm.ez.analysis.api.model.Node;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.ui.TSObjectUI;
import com.tomsawyer.graphicaldrawing.ui.simple.TSECurvedEdgeUI;
import com.tomsawyer.util.shared.TSProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallGraphModel
extends UEBasedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CallGraphModel.class);
    private static final String ext_prg_tr_query = "select name, type, in('ResourceLink')[0].@class as usageClass, in('ResourceLink').prgRid.asList().asString() as rids, $u.asList().asString() as stmts,$u.in('HasS').sid.asList().asString() as sids\n from ExtCFProxy \n let $w = format(\"%s%s%s%d\", name, if (eval(\"type is null\"), \"\", type), location, locationType),\n $u = in('ResourceLink').in('Uses') where $w in [@@@@@EZLEGACY@@@@]";
    private static final String ext_scr_query = "select name, type, in('ResourceLink')[0].@class as usageClass, in('ResourceLink').prgRid.asList().asString() as rids, $u.asList().asString() as stmts,$u.in('HasS').sid.asList().asString() as sids\n from ExtDAScreenProxy \n let $w = format(\"%s%s%s%d\", if (eval(\"mapSet is null\"), \"\", mapSet), name, location, locationType),\n $u = in('ResourceLink').in('Uses') where $w in [@@@@@EZLEGACY@@@@]";
    private static final String ext_query = "select expand( $ext ) let $scr = (\n select name, type, in('ResourceLink')[0].@class as usageClass, in('ResourceLink').prgRid.asList().asString() as rids, $u.asList().asString() as stmts,$u.in('HasS').sid.asList().asString() as sids\n from ExtDAScreenProxy \n let $w = format(\"%s%s%s%d\", if (eval(\"mapSet is null\"), \"\", mapSet), name, location, locationType),\n $u = in('ResourceLink').in('Uses') where $w in [@@@@@EZLEGACY@@@@]), \n $pt = ( select name, type, in('ResourceLink')[0].@class as usageClass, in('ResourceLink').prgRid.asList().asString() as rids, $u.asList().asString() as stmts,$u.in('HasS').sid.asList().asString() as sids\n from ExtCFProxy \n let $w = format(\"%s%s%s%d\", name, if (eval(\"type is null\"), \"\", type), location, locationType),\n $u = in('ResourceLink').in('Uses') where $w in [@@@@@EZLEGACY@@@@]), $ext = UNIONALL( $scr, $pt )";
    private static final String rid_query = "select if (eval (\"out('ProxyFor').size()>0\"), out('ProxyFor')[0].@rid, @rid).asString() as rid from ";
    private static final String prg_query = "select @class, name, @rid.asString() as prid, type, \n if (eval(\"@class='Program'\"), in('ProxyFor')[0].in('TranMapping').name.asString(), in('TranMapping').name.asString()) as tranname, \n if (eval(\"@class='Program'\"), in('ProxyFor')[0].in('TranMapping').@rid.asString(), in('TranMapping').@rid.asString()) as tranrid from ";
    private static final String tran_info_query = "select name as tranname, @rid.asString() as tranrid, if(eval('@class=\\'TranProxy\\''), false, true) as isims  from ";
    private static final String prgs_info_query = "select @rid as proxyV, @rid.asString() as proxyVRid from ";
    private static final String call_edges_F_info_query = "select $stmt.@rid.asString() as sRid, $stmt.typeId as typeId, @rid.asString() as eRid, out as o, in as i from @@@@@EZLEGACY@@@@\n let $stmt = prgUsage.in('UsesPUI')[0] \n where prgUsage.@class = 'ProgramUsageInfo'";
    private static final String call_edges_B_info_query = "select $stmt.@rid.asString() as sRid, $stmt.typeId as typeId, @rid.asString() as eRid, out as o from @@@@@EZLEGACY@@@@\n let $stmt = prgUsage.in('UsesPUI')[0] \n where prgUsage.@class = 'ProgramUsageInfo'";
    private static final String NEW_ANALYSIS_INPUT_KEY = "analysisInput";
    protected Direction cgDirection;
    private Integer cgLimitation;
    private Set<String> processedExt = new HashSet<String>();
    private boolean computeRegion = true;
    private Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> allCicsReg = new HashMap<ExtCallTargetType, Map<Pair<String, String>, Set<String>>>();
    public static final String INVENTORY_MAP_ATTRIBUTE = "outForGISV";
    public static final String TS_LEVEL_MAP = "levelMap";
    private Map<String, UserExitsToPrj> ueByPrj = new HashMap<String, UserExitsToPrj>();
    private ExportAction exportAction;
    public static final String PRG_EXCLUDED_KEY = "PROGRAM_EXCLUDED_FROM_GRAPH";

    public CallGraphModel(AnalysisGraphManager graphManager, Direction cgDirection, Integer cgLimitation, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.cgDirection = cgDirection;
        this.cgLimitation = cgLimitation;
        this.analysis = analysis;
    }

    public CallGraphModel(AnalysisGraphManager graphManager, Direction cgDirection, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.cgDirection = cgDirection;
        this.analysis = analysis;
        this.outForGISV = (Map)graphManager.getAttributeValue(INVENTORY_MAP_ATTRIBUTE);
        if (this.outForGISV == null) {
            this.outForGISV = new HashMap();
        }
    }

    @Override
    protected void initGraph() {
        super.initGraph();
        if (this.dbg != null) {
            ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
            this.dbg = null;
            this.env = null;
        }
        this.graphManager.removeAttribute("child_graphs");
        this.computeRegion = true;
        if (GraphUtils.cgToOtherPrj(this.graphManager)) {
            HashMap ueOutForGISV = new HashMap();
            this.graphManager.setAttribute("ue inventory", ueOutForGISV);
        } else if (this.outForGISV != null) {
            this.outForGISV.clear();
        }
        this.processedExt.clear();
        this.edgeTypesSetForLegend.clear();
        this.restrictionTypesSetForLegend.clear();
        this.initMapCicsRegion();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        this.ueByPrj.clear();
        this.no_path_legend_entry = false;
    }

    public List<TSEGraph> getGraphs() {
        ArrayList<TSEGraph> graphsList = new ArrayList<TSEGraph>();
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        Set childGraphs = (Set)this.graphManager.getAttributeValue("child_graphs");
        if (childGraphs != null) {
            graphsList.addAll(childGraphs);
        } else {
            graphsList.add(mainGraph);
        }
        return graphsList;
    }

    private void initMapCicsRegion() {
        this.allCicsReg.clear();
        this.allCicsReg.put(ExtCallTargetType.FILE, new HashMap());
        this.allCicsReg.put(ExtCallTargetType.TRANSACTION, new HashMap());
        this.allCicsReg.put(ExtCallTargetType.PROGRAM, new HashMap());
        this.allCicsReg.put(ExtCallTargetType.BMS, new HashMap());
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)240);
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "loading.graph"));
        this.ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(this.ezsourcePrj);
        if (!this.used4Cross) {
            this.initGraph();
        }
        if (!this.used4Cross && GraphUtils.cgToOtherPrj(this.graphManager)) {
            List prjList = (List)this.graphManager.getAttributeValue("projects");
            Map prjSgMap = TSGraphUtils.computeAllPrj((Collection)prjList);
            this.graphManager.setAttribute("mf_projects_sgs", (Object)prjSgMap);
        } else {
            this.graph.setAttribute("MAINFRAME_PROJECT_ID_SG", (Object)prjIdSg);
        }
        this.analysis.addContextValue("ue map", new HashMap());
        if (GraphUtils.cgToOtherPrj(this.graphManager) && !this.used4Cross) {
            String currentPrjName = this.ezsourcePrj.getName();
            this.prepareAllTargets(currentPrjName, this.ueByPrj, monitor.newChild(10));
            this.prepareCFExtSources(currentPrjName, this.ueByPrj, true, monitor.newChild(10));
        }
        this.drawCg(this.ezsourcePrj.getName(), monitor.newChild(100));
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "loading.graph.ue"));
        if (GraphUtils.cgToOtherPrj(this.graphManager)) {
            if (!this.used4Cross) {
                this.doCgOtherPrj(monitor.newChild(100));
                this.drawCrossPrjEdges((IProgressMonitor)monitor.newChild(20));
            }
        } else {
            this.doExtCalls(this.ezsourcePrj.getName());
        }
        this.finalDraw4API();
        if (!this.used4Cross) {
            this.postLoadGraph(monitor.newChild(20));
        }
        ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
        this.dbg = null;
        this.env = null;
    }

    private void finalDraw4API() {
        if (this.analysis.getContextValue("API_CALLGRAPH") != null) {
            List ids = (List)this.analysis.getContextValue("input_list");
            block4: for (EZEntityID id : ids) {
                CatalogAPISg sg = (CatalogAPISg)id.getSegment(CatalogAPISg.class);
                if (sg == null) continue;
                Node n = (Node)sg.getNode();
                switch (n.getType()) {
                    case API: {
                        for (Node serviceNode : n.getChildren()) {
                            this.finalTouch4APIs(serviceNode);
                        }
                        continue block4;
                    }
                    case SERVICE: {
                        this.finalTouch4APIs(n);
                        break;
                    }
                }
            }
        }
    }

    private void finalTouch4APIs(Node n) {
        String targetName = (String)n.getInfo().get("target");
        ApiTargetType targetType = n.getTargetType();
        if (targetName != null && targetType != null) {
            TSENode servTSNode = this.getOrCreateTSApiNode(this.graph, (ApiInterface)n, false);
            boolean found = false;
            List outs = servTSNode.buildIncidentIntergraphEdgeList(true, true, true, true, true);
            outs.addAll(servTSNode.buildOutEdges());
            for (TSEEdge ed : outs) {
                TSNode targetNode = ed.getTargetNode();
                if (!targetNode.getName().equals(targetName)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.buildUnreachableAPITargets(servTSNode, targetName, targetType);
            }
        }
    }

    private void doExtCalls(String prjName) {
        HashMap<String, UserExitsToPrj> localUEByPrj = new HashMap<String, UserExitsToPrj>();
        this.prepareTargets(prjName, ExtCallTargetType.TRANSACTION, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.IMS_TM, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.PROGRAM, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.SQLTABLE, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.FILE, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.BMS, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.IMS_MOD, localUEByPrj, null);
        this.prepareTargets(prjName, ExtCallTargetType.IMS_SEGMENT, localUEByPrj, null);
        Map ue = (Map)this.analysis.getContextValue("ue map");
        for (String sourceprj : ue.keySet()) {
            Map vMap = (Map)ue.get(sourceprj);
            for (String sourceRid : vMap.keySet()) {
                UserExitsFromPrg uep = (UserExitsFromPrg)vMap.get(sourceRid);
                this.createTargetAndLink(uep, ExtCallTargetType.PROGRAM_COBOL, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.PROGRAM_COBOL, ExtCallLocationType.CICSREGION);
                this.createTargetAndLink(uep, ExtCallTargetType.PROGRAM_PLI, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.PROGRAM_PLI, ExtCallLocationType.CICSREGION);
                this.createTargetAndLink(uep, ExtCallTargetType.TRANSACTION, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.TRANSACTION, ExtCallLocationType.CICSREGION);
                this.createTargetAndLink(uep, ExtCallTargetType.SQLTABLE, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.FILE_AT_READ, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.FILE_AT_READ, ExtCallLocationType.CICSREGION);
                this.createTargetAndLink(uep, ExtCallTargetType.FILE_AT_WRITE, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.FILE_AT_WRITE, ExtCallLocationType.CICSREGION);
                this.createTargetAndLink(uep, ExtCallTargetType.BMS, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.BMS, ExtCallLocationType.CICSREGION);
                this.createTargetAndLink(uep, ExtCallTargetType.IMS_MOD, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.IMS_SEGMENT, ExtCallLocationType.APPLICATION);
                this.createTargetAndLink(uep, ExtCallTargetType.IMS_TM, ExtCallLocationType.APPLICATION);
            }
        }
    }

    private void createTargetAndLink(UserExitsFromPrg uep, ExtCallTargetType targetType, ExtCallLocationType locType) {
        Map<String, Set<Target>> targetsMap = uep.getTgts(targetType, locType);
        if (targetsMap != null) {
            for (String targetLoc : targetsMap.keySet()) {
                Set<Target> targets = targetsMap.get(targetLoc);
                for (Target t : targets) {
                    String ltype = locType.getDescription();
                    String ttype = targetType.getTSType();
                    String pType = null;
                    if (targetType.equals((Object)ExtCallTargetType.PROGRAM_COBOL)) {
                        pType = String.valueOf(ProgramType.COBOL.getProgramTypeId());
                    } else if (targetType.equals((Object)ExtCallTargetType.PROGRAM_PLI)) {
                        pType = String.valueOf(ProgramType.PL1.getProgramTypeId());
                    }
                    TSENode node = this.getOrCreateExtNode(t.getQName(), targetType.getDescription(), ttype, targetLoc, ltype, pType);
                    TSENode sourceNode = uep.getPrgGraphNode();
                    if (sourceNode == null && (sourceNode = this.makeSourceNode(uep, uep.getSourcePrjName(), uep.getPrgRid(), (IProgressMonitor)new NullProgressMonitor())) == null) {
                        L.warn("couldn't find sourcenode for external call {} ", (Object)uep.getPrgRid());
                        return;
                    }
                    Integer lvl = (Integer)sourceNode.getAttributeValue("level");
                    lvl = lvl + 1;
                    this.setLevel(node, true, new LevelObject(lvl, false));
                    Triplet<TSENode, TSENode, String> triplet = GraphUtils.computeAccesType(sourceNode, node, targetType);
                    this.makeCallExtEdge((TSENode)triplet.getFirst(), (TSENode)triplet.getSecond(), t.getStmts(), (String)triplet.getThird());
                }
            }
        }
    }

    private void drawCg(String prjName, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(400 + 10 * GraphUtils.resourceTypes.size()));
        this.cg = this.graph;
        if (!this.used4Cross && GraphUtils.cgToOtherPrj(this.graphManager)) {
            Map prjMap = (Map)this.graphManager.getAttributeValue("mf_projects_sgs");
            EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)prjMap.get(prjName);
            if (prjIdSg != null) {
                String startPrj;
                this.ezsourcePrj = prjIdSg.getProjectInfo();
                if (this.analysis.getContextValue("API_CALLGRAPH") != null && prjName.equals(startPrj = (String)this.analysis.getContextValue("input_project_names"))) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(prjName);
                    this.graphManager.setAttribute("markPrjAsInput", set);
                }
                this.cg = TSGraphUtils.getOrCreatePrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (EZSourceProjectIDSg)prjIdSg, (boolean)true);
            } else {
                L.warn("Project {} not found in workspace", (Object)prjName);
            }
        }
        HashMap tsLevels = (HashMap)this.cg.getAttributeValue(TS_LEVEL_MAP);
        if (!this.used4Cross) {
            if (tsLevels != null) {
                tsLevels.clear();
            } else {
                tsLevels = new HashMap();
                this.cg.setAttribute(TS_LEVEL_MAP, tsLevels);
            }
        } else {
            pgmLevel = new LevelObject(Integer.valueOf(tsLevels.size()));
            transactionLevel = new LevelObject(Integer.valueOf(tsLevels.size() - 2), true);
            programLevel = new LevelObject(Integer.valueOf(tsLevels.size()), false);
        }
        HashMap prgRIDs = new HashMap();
        this.cg.setAttribute("PROGRAM_TS_NODES", prgRIDs);
        HashMap tsNodes = (HashMap)this.cg.getAttributeValue("TS nodes per project");
        if (tsNodes == null) {
            tsNodes = new HashMap();
            this.cg.setAttribute("TS nodes per project", tsNodes);
        }
        this.dbg = this.getOrientDbg();
        String inputPrj = (String)this.analysis.getContextValue("input_project_names");
        boolean isStartProject = prjName.equals(inputPrj);
        if (isStartProject) {
            this.buildAPIpart(this.graph, this.cg);
        }
        this.drawScreenToMappedPrg();
        Map forwardPrg = (Map)this.analysis.removeContextValue(CgBuilder.getKey(prjName, "programs_Info_forward"));
        if (!monitor.isCanceled() && forwardPrg != null) {
            long start = System.currentTimeMillis();
            L.debug("start forward cg ts build");
            this.drawPrgCallgraph(forwardPrg, true, (IProgressMonitor)monitor.newChild(100));
            L.debug("end forward tsBuild in {} ms", (Object)(System.currentTimeMillis() - start));
        } else {
            L.debug("calgraph is not forward direction");
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(100);
        Map backwardPrg = (Map)this.analysis.removeContextValue(CgBuilder.getKey(prjName, "programs_Info_backward"));
        if (!monitor.isCanceled() && backwardPrg != null) {
            long start = System.currentTimeMillis();
            L.debug("start backward cg ts build");
            this.drawPrgCallgraph(backwardPrg, false, (IProgressMonitor)monitor.newChild(100));
            L.debug("end backward tsBuild in {} ms", (Object)(System.currentTimeMillis() - start));
        } else {
            L.debug("calgraph is not backward direction");
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(100);
        this.drawTranToMappedPrg(prjName);
        if (!monitor.isCanceled() && backwardPrg != null) {
            for (String proxyVertexRid : backwardPrg.keySet()) {
                TSENode prgNode = (TSENode)tsNodes.get(proxyVertexRid);
                OrientVertex proxyV = this.dbg.getVertex((Object)proxyVertexRid);
                if (prgNode == null) {
                    String rid = this.getPrgOrProxyRid((Vertex)proxyV);
                    prgNode = (TSENode)tsNodes.get(rid);
                }
                this.searchMappBetweenTransactionAndProgram(proxyVertexRid, (Vertex)proxyV, prgNode);
            }
        }
        long time = System.currentTimeMillis();
        this.doCgJobToPgm(monitor.newChild(100));
        L.debug("doCgJobToPgm in {} ms", (Object)(System.currentTimeMillis() - time));
        if (monitor.isCanceled()) {
            return;
        }
        for (String res : GraphUtils.resourceTypes) {
            time = System.currentTimeMillis();
            this.buildResources(this.cg, this.ezsourcePrj.getName(), res, (IProgressMonitor)monitor.newChild(10));
            L.debug("added resources ts nodes {} in {} ms", (Object)res, (Object)(System.currentTimeMillis() - time));
            if (!monitor.isCanceled()) continue;
            return;
        }
        this.drawGenericScrMapping(this.cg, this.ezsourcePrj.getName(), monitor.newChild(10));
        time = System.currentTimeMillis();
        this.doJCLInCg(monitor.newChild(100));
        L.debug("doJCLInCg in {} ms", (Object)(System.currentTimeMillis() - time));
        if (this.graph.nodes().size() == 0) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)NO_RESULTS_NODE_LABEL);
            L.debug("no results");
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (!isStartProject) {
            monitor.setTaskName(Messages.getString(CallGraphModel.class, "api.build"));
            this.buildAPI4Project(this.graph, this.cg);
        }
        prgRIDs = null;
        tsNodes = null;
    }

    private void drawGenericScrMapping(TSEGraph gr, String prjName, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "loading.scrMapp.graph"));
        List mapping = (List)this.analysis.removeContextValue(CgBuilder.getKey(prjName, "generic screen mapp"));
        if (mapping == null) {
            return;
        }
        Map prgRIDs = (Map)gr.getAttributeValue("TS nodes per project");
        for (String[] info : mapping) {
            if (info[0] == null || info[1] == null) {
                L.warn("ignore generic screen mapping, missing scrid {} or prg {}", (Object)info[0], (Object)info[1]);
                continue;
            }
            String prgId = info[0];
            TSENode prgNode = (TSENode)prgRIDs.get(prgId);
            String scrRid = info[1];
            OrientVertex scrV = this.dbg.getVertex((Object)scrRid);
            TSENode scrNode = this.addResourceNode((Vertex)scrV, prgNode, null);
            this.makeMappedToPrgEdge(scrNode, prgId, ResourceLink.FAKE_STMT_TYPE_FOR_GENERICSCR_TO_MAPPED_PRG_STRING);
        }
    }

    private void drawExtRes(String prjName, Map<String, String> resMap, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)10);
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "drawing.cg", new String[]{prjName}));
        if (resMap.isEmpty()) {
            return;
        }
        try {
            try {
                this.env = ConnectionUtils.getODBSettings((String)prjName);
                this.dbg = this.getOrientDbg();
                for (String rRid : resMap.keySet()) {
                    this.getOrCreateTSNode((Vertex)this.dbg.getVertex((Object)rRid), resMap.get(rRid), false, new LevelObject(Integer.valueOf(1), true));
                }
            }
            catch (Exception exception) {
                L.warn("no graph database for the project {} ", (Object)prjName);
                ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
                this.dbg = null;
                this.env = null;
            }
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
            this.dbg = null;
            this.env = null;
        }
    }

    private void doCgOtherPrj(SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)130);
        boolean compute = true;
        while (compute) {
            int count = this.processedExt.size();
            HashMap<String, UserExitsToPrj> localueByPrj = new HashMap<String, UserExitsToPrj>();
            for (String prjName : this.ueByPrj.keySet()) {
                Map prjMap = (Map)this.graphManager.getAttributeValue("mf_projects_sgs");
                EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)prjMap.get(prjName);
                if (prjIdSg == null) {
                    L.debug("skip external call to project {} because is not in workspace", (Object)prjName);
                    continue;
                }
                this.dbg = null;
                this.env = ConnectionUtils.getODBSettings((String)prjName);
                try {
                    this.dbg = this.getOrientDbg();
                }
                catch (Exception exception) {
                    L.warn("no graph database for the project {} ", (Object)prjName);
                    continue;
                }
                UserExitsToPrj uePrj = this.ueByPrj.get(prjName);
                HashSet<String> idsSet = new HashSet<String>();
                HashSet<Integer> prgSids = new HashSet<Integer>();
                HashSet<String> prgWithoutSid = new HashSet<String>();
                HashMap<String, String> resMap = new HashMap<String, String>();
                if (Direction.doForward((Direction)this.cgDirection)) {
                    this.processCFExitsToPrj(prjName, uePrj, idsSet, prgSids, prgWithoutSid);
                }
                this.processDAExitsToPrj(prjName, uePrj, idsSet, prgSids, prgWithoutSid, resMap);
                HashSet<Integer> forw = new HashSet<Integer>();
                forw.addAll(prgSids);
                forw.addAll(uePrj.getPrgForForward());
                idsSet.addAll(uePrj.getPrgRidForForward());
                HashSet<Integer> back = new HashSet<Integer>();
                back.addAll(uePrj.getPrgForBackward());
                idsSet.addAll(uePrj.getPrgRidForBackward());
                if (resMap.isEmpty() && back.isEmpty() && prgWithoutSid.isEmpty() && forw.isEmpty()) continue;
                L.debug("following programs will be sent to callgraph {} and programs without sid {} in project {} ", new Object[]{prgSids, prgWithoutSid, prjName});
                if (!(back.isEmpty() && prgWithoutSid.isEmpty() && forw.isEmpty())) {
                    CgBuilder cgb = new CgBuilder(prjName, this.dbg, this.analysis, this.cgDirection);
                    cgb.computeCg(back, forw, prgWithoutSid, idsSet, monitor.newChild(10));
                    this.prepareAllTargets(prjName, localueByPrj, monitor.newChild(50));
                    if (!back.isEmpty()) {
                        this.prepareCFExtSources(prjName, localueByPrj, false, monitor.newChild(50));
                    }
                }
                this.drawCg(prjName, monitor.newChild(10));
                this.drawExtRes(prjName, resMap, monitor.newChild(10));
            }
            this.ueByPrj = localueByPrj;
            boolean bl = compute = this.processedExt.size() - count > 0;
        }
    }

    private void prepareCFExtSources(String currentPrjName, Map<String, UserExitsToPrj> ueByPrj, boolean isFirstStep, SubMonitor pmonitor) {
        boolean isScrCg;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "start.loading.graph.ue"));
        boolean bl = isScrCg = this.analysis.getContextValue("SCREEN_CALLGRAPH") != null ? (Boolean)this.analysis.getContextValue("SCREEN_CALLGRAPH") : false;
        if (!isScrCg && !Direction.doBackward((Direction)this.cgDirection)) {
            return;
        }
        Map backwardPrg = (Map)this.analysis.getContextValue(CgBuilder.getKey(currentPrjName, "programs_Info_backward"));
        this.dbg = this.getOrientDbg();
        HashSet<String> extToSearch = !Direction.doBackward((Direction)this.cgDirection) ? null : new HashSet<String>();
        HashSet<String> extScrToSearch = isScrCg ? new HashSet<String>() : null;
        boolean foundBMSScr = false;
        HashSet<String> scrnames = new HashSet<String>();
        if (isScrCg && isFirstStep) {
            Set scrRids = this.analysis.getContextSetValue(CgBuilder.getKey(currentPrjName, "input orids as string"));
            String q = String.format("select name as scrname, mapSet, @rid.asString() as scrrid, @class as cls from %s ", scrRids);
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(q)).execute(new Object[0]);
            for (OrientElement oe : res) {
                String cls = (String)oe.getProperty("cls");
                if (!"BMSProxy".equals(cls) && !"IMSModProxy".equals(cls)) continue;
                String scr = (String)oe.getProperty("scrname");
                String mapset = (String)oe.getProperty("mapSet");
                Object key = scr;
                if (mapset != null && !mapset.isEmpty()) {
                    key = mapset.concat(scr);
                    scr = mapset.concat("-").concat(scr);
                }
                String scrRid = (String)oe.getProperty("scrrid");
                extScrToSearch.add(String.valueOf(((String)key).concat(currentPrjName)) + ExtCallLocationType.APPLICATION.getId());
                scrnames.add(scr);
                this.addToNamesToRid(currentPrjName, scr, scrRid);
                if (!"BMSProxy".equals(cls)) continue;
                foundBMSScr = true;
            }
        }
        boolean isTranCg = this.analysis.getContextValue("TRANSACTION_CALLGRAPH") != null ? (Boolean)this.analysis.getContextValue("TRANSACTION_CALLGRAPH") : false;
        boolean foundTran = false;
        boolean foundPrg = false;
        HashSet<String> trnames = new HashSet<String>();
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        if (extToSearch != null && isFirstStep && isTranCg) {
            Set tranRids = this.analysis.getContextSetValue(CgBuilder.getKey(currentPrjName, "input orids as string"));
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(tran_info_query + tranRids)).execute(new Object[0]);
            for (OrientElement oe : res) {
                boolean isims = (Boolean)oe.getProperty("isims");
                String trans = (String)oe.getProperty("tranname");
                String transRid = (String)oe.getProperty("tranrid");
                if (!isims) {
                    trnames.add(trans);
                    foundTran = true;
                }
                extToSearch.add(String.valueOf(trans.concat(currentPrjName)) + ExtCallLocationType.APPLICATION.getId());
                this.addToNamesToRid(currentPrjName, trans, transRid);
            }
        }
        if (extToSearch != null && backwardPrg != null) {
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(rid_query + backwardPrg.keySet())).execute(new Object[0]);
            HashSet<String> rids = new HashSet<String>();
            for (OrientElement oe : res) {
                String rid = (String)oe.getProperty("rid");
                rids.add(rid);
            }
            res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(prg_query + rids)).execute(new Object[0]);
            for (OrientElement oe : res) {
                String name = (String)oe.getProperty("name");
                Integer type = (Integer)oe.getProperty("type");
                String rid = (String)oe.getProperty("prid");
                foundPrg = true;
                names.put(name, type);
                this.addToNamesToRid(currentPrjName, name, rid);
                extToSearch.add(String.valueOf(name) + type.toString().concat(currentPrjName) + ExtCallLocationType.APPLICATION.getId());
                String transStr = (String)oe.getProperty("tranname");
                String transRidStr = (String)oe.getProperty("tranrid");
                if (transStr.isEmpty() || transStr.length() <= 2) continue;
                String[] tranNames = transStr.substring(1, transStr.length() - 1).split(", ");
                String[] tranRids = transRidStr.substring(1, transRidStr.length() - 1).split(", ");
                int i = 0;
                while (i < tranNames.length) {
                    extToSearch.add(String.valueOf(tranNames[i].concat(currentPrjName)) + ExtCallLocationType.APPLICATION.getId());
                    trnames.add(tranNames[i]);
                    this.addToNamesToRid(currentPrjName, tranNames[i], tranRids[i]);
                    foundTran = true;
                    ++i;
                }
            }
        }
        Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> cicsReg = new HashMap<ExtCallTargetType, Map<Pair<String, String>, Set<String>>>();
        if (foundPrg) {
            cicsReg.put(ExtCallTargetType.PROGRAM, new HashMap());
        }
        if (foundTran) {
            cicsReg.put(ExtCallTargetType.TRANSACTION, new HashMap());
        }
        if (foundBMSScr) {
            cicsReg.put(ExtCallTargetType.BMS, new HashMap());
        }
        if (this.computeRegion) {
            this.searchCICSRegPerPrj(currentPrjName, cicsReg, monitor.newChild(20));
        } else {
            cicsReg = this.allCicsReg;
        }
        if (foundPrg) {
            for (Pair<String, String> pair : cicsReg.get((Object)ExtCallTargetType.PROGRAM).keySet()) {
                if (((String)pair.getSecond()).trim().isEmpty()) continue;
                String prgName = (String)pair.getSecond();
                if (!names.keySet().contains(prgName) || !cicsReg.get((Object)ExtCallTargetType.PROGRAM).get(pair).contains(currentPrjName)) continue;
                extToSearch.add(String.valueOf(prgName.concat(((Integer)names.get(prgName)).toString()).concat((String)pair.getFirst())) + ExtCallLocationType.CICSREGION.getId());
            }
        }
        if (foundTran) {
            this.addResToExt(ExtCallTargetType.TRANSACTION, currentPrjName, extToSearch, trnames, cicsReg);
        }
        if (foundBMSScr) {
            this.addResToExt(ExtCallTargetType.BMS, currentPrjName, extToSearch, trnames, cicsReg);
        }
        this.processCFExtSources(currentPrjName, extToSearch, extScrToSearch, ueByPrj, monitor.newChild(80));
    }

    private void addResToExt(ExtCallTargetType ttype, String currentPrjName, Set<String> extToSearch, Set<String> resnames, Map<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> cicsReg) {
        for (Pair<String, String> pair : cicsReg.get((Object)ttype).keySet()) {
            String rName;
            if (((String)pair.getSecond()).trim().isEmpty() || !resnames.contains(rName = (String)pair.getSecond()) || !cicsReg.get((Object)ttype).get(pair).contains(currentPrjName)) continue;
            extToSearch.add(String.valueOf(rName.concat((String)pair.getFirst())) + ExtCallLocationType.CICSREGION.getId());
        }
    }

    private void processCFExtSources(String currentPrjName, Set<String> extToSearch, Set<String> extScrToSearch, Map<String, UserExitsToPrj> ueByPrj, SubMonitor pmonitor) {
        if ((extToSearch == null || extToSearch.isEmpty()) && (extScrToSearch == null || extScrToSearch.isEmpty())) {
            return;
        }
        Map prjSgMap = (Map)this.graphManager.getAttributeValue("mf_projects_sgs");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(100 * prjSgMap.size()));
        for (String prjName : prjSgMap.keySet()) {
            boolean ok;
            String msg = Messages.getString(CallGraphModel.class, "loading.graph.ue", new String[]{prjName});
            monitor.setTaskName(msg);
            if (monitor.isCanceled()) break;
            if (prjName.equals(currentPrjName)) continue;
            IODBAdminService service = (IODBAdminService)ServiceUtils.getService(IODBAdminService.class);
            if (service != null && !(ok = service.hasDatabase(prjName))) {
                L.warn("can't access gdb for project {}", (Object)prjName);
                GraphsErrorLog.warn((String)Messages.getString(CallGraphModel.class, "gdb.not.found", new String[]{prjName}), null);
                continue;
            }
            OrientBaseGraph dbg = null;
            Properties env = ConnectionUtils.getODBSettings((String)prjName);
            monitor.worked(1);
            try {
                try {
                    UserExitsToPrj uep;
                    Pair<Set<Integer>, Set<String>> p;
                    dbg = ConnectionUtils.getNoTxGraph((Properties)env);
                    if (extToSearch != null && !((Set)(p = this.prepareExtSources(dbg, currentPrjName, ext_prg_tr_query, extToSearch, prjName)).getFirst()).isEmpty()) {
                        uep = ueByPrj.get(prjName);
                        if (uep == null) {
                            uep = new UserExitsToPrj(prjName);
                            ueByPrj.put(prjName, uep);
                        }
                        uep.addPrgForBack((Set)p.getFirst());
                        uep.addPrgRidForBack((Set)p.getSecond());
                    }
                    if (extScrToSearch != null && !((Set)(p = this.prepareExtSources(dbg, currentPrjName, ext_scr_query, extScrToSearch, prjName)).getFirst()).isEmpty()) {
                        uep = ueByPrj.get(prjName);
                        if (uep == null) {
                            uep = new UserExitsToPrj(prjName);
                            ueByPrj.put(prjName, uep);
                        }
                        if (Direction.doBackward((Direction)this.cgDirection)) {
                            uep.addPrgForBack((Set)p.getFirst());
                            uep.addPrgRidForBack((Set)p.getSecond());
                        }
                        if (Direction.doForward((Direction)this.cgDirection)) {
                            uep.addPrgForForw((Set)p.getFirst());
                            uep.addPrgRidForForw((Set)p.getSecond());
                        }
                    }
                }
                catch (Exception e) {
                    L.error("while accesing graph db for project " + prjName, (Throwable)e);
                    GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
                    if (dbg != null) {
                        ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                    }
                    dbg = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (dbg != null) {
                    ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                }
                dbg = null;
                throw throwable;
            }
            if (dbg != null) {
                ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
            }
            dbg = null;
        }
    }

    private Pair<Set<Integer>, Set<String>> prepareExtSources(OrientBaseGraph dbg, String currentPrjName, String query, Set<String> extToSearch, String prjName) {
        query = query.replaceFirst("@@@@@EZLEGACY@@@@", GraphUtils.splitEntries(extToSearch.toString()));
        CloseableIterable resExt = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashSet<Integer> newsids = new HashSet<Integer>();
        HashSet<String> newrids = new HashSet<String>();
        Pair p = new Pair(newsids, newrids);
        for (OrientElement elem : resExt) {
            String sidsStr;
            String name = (String)elem.getProperty("name");
            String uClass = (String)elem.getProperty("usageClass");
            Integer pType = (Integer)elem.getProperty("type");
            ExtCallTargetType ttype = GraphUtils.getExtCallType(uClass, null);
            if (pType != null && ttype.equals((Object)ExtCallTargetType.PROGRAM)) {
                ExtCallTargetType extCallTargetType = ttype = ProgramType.COBOL.getProgramTypeId() == pType.intValue() ? ExtCallTargetType.PROGRAM_COBOL : ExtCallTargetType.PROGRAM_PLI;
            }
            if ((sidsStr = (String)elem.getProperty("sids")).isEmpty() || sidsStr.length() <= 2) continue;
            String[] prgSids = sidsStr.substring(1, sidsStr.length() - 1).split(", ");
            String ridsStr = (String)elem.getProperty("rids");
            String[] prgRids = ridsStr.substring(1, ridsStr.length() - 1).split(", ");
            String stmtsStr = (String)elem.getProperty("stmts");
            String[] sRids = stmtsStr.substring(1, stmtsStr.length() - 1).split(", ");
            int i = 0;
            while (i < prgSids.length) {
                UserExitsFromPrg ue;
                String sid = prgSids[i];
                String rid = prgRids[i];
                String stmt = sRids[i];
                Map targetsPerPrj = (Map)this.analysis.getContextValue("ue map");
                HashMap<String, UserExitsFromPrg> ueprg = (HashMap<String, UserExitsFromPrg>)targetsPerPrj.get(prjName);
                if (ueprg == null) {
                    ueprg = new HashMap<String, UserExitsFromPrg>();
                    targetsPerPrj.put(prjName, ueprg);
                }
                if ((ue = (UserExitsFromPrg)ueprg.get(rid)) == null) {
                    ue = new UserExitsFromPrg(prjName, rid);
                    ueprg.put(rid, ue);
                }
                Target tgt = new Target(name, ttype, currentPrjName, ExtCallLocationType.APPLICATION, null);
                tgt.addStmt(stmt);
                ue.addTarget(tgt);
                String key = prjName.concat("|").concat(sid);
                if (!this.processedExt.contains(key)) {
                    newsids.add(Integer.valueOf(sid));
                    newrids.add(rid);
                    this.processedExt.add(key);
                }
                ++i;
            }
        }
        return p;
    }

    private void prepareAllTargets(String currentPrjName, Map<String, UserExitsToPrj> localUEByPrj, SubMonitor monitor) {
        HashMap<Pair<String, String>, Set<String>> trByCicsReg = new HashMap<Pair<String, String>, Set<String>>();
        this.prepareTargets(currentPrjName, ExtCallTargetType.TRANSACTION, localUEByPrj, trByCicsReg);
        this.prepareTargets(currentPrjName, ExtCallTargetType.IMS_TM, localUEByPrj, null);
        HashMap<Pair<String, String>, Set<String>> prgByCicsReg = new HashMap<Pair<String, String>, Set<String>>();
        this.prepareTargets(currentPrjName, ExtCallTargetType.PROGRAM, localUEByPrj, prgByCicsReg);
        this.prepareTargets(currentPrjName, ExtCallTargetType.SQLTABLE, localUEByPrj, null);
        HashMap<Pair<String, String>, Set<String>> fByCicsReg = new HashMap<Pair<String, String>, Set<String>>();
        this.prepareTargets(currentPrjName, ExtCallTargetType.FILE, localUEByPrj, fByCicsReg);
        HashMap<Pair<String, String>, Set<String>> bmsByCicsReg = new HashMap<Pair<String, String>, Set<String>>();
        this.prepareTargets(currentPrjName, ExtCallTargetType.BMS, localUEByPrj, bmsByCicsReg);
        this.prepareTargets(currentPrjName, ExtCallTargetType.IMS_MOD, localUEByPrj, null);
        this.prepareTargets(currentPrjName, ExtCallTargetType.IMS_SEGMENT, localUEByPrj, null);
        if (!(trByCicsReg.isEmpty() && prgByCicsReg.isEmpty() && fByCicsReg.isEmpty() && bmsByCicsReg.isEmpty())) {
            if (this.computeRegion) {
                this.searchCICSRegions(this.allCicsReg, monitor.newChild(100));
                this.computeRegion = false;
            }
            if (!this.allCicsReg.isEmpty()) {
                Map ue = (Map)this.analysis.getContextValue("ue map");
                GraphUtils.translateCICSRegToPrj(currentPrjName, ExtCallTargetType.PROGRAM_COBOL, this.allCicsReg, prgByCicsReg, localUEByPrj, ue);
                GraphUtils.translateCICSRegToPrj(currentPrjName, ExtCallTargetType.PROGRAM_PLI, this.allCicsReg, prgByCicsReg, localUEByPrj, ue);
                GraphUtils.translateCICSRegToPrj(currentPrjName, ExtCallTargetType.TRANSACTION, this.allCicsReg, trByCicsReg, localUEByPrj, ue);
                GraphUtils.translateCICSRegToPrj(currentPrjName, ExtCallTargetType.FILE_AT_READ, this.allCicsReg, fByCicsReg, localUEByPrj, ue);
                GraphUtils.translateCICSRegToPrj(currentPrjName, ExtCallTargetType.FILE_AT_WRITE, this.allCicsReg, fByCicsReg, localUEByPrj, ue);
                GraphUtils.translateCICSRegToPrj(currentPrjName, ExtCallTargetType.BMS, this.allCicsReg, bmsByCicsReg, localUEByPrj, ue);
            }
        }
    }

    private void prepareTargets(String prjName, ExtCallTargetType ttype, Map<String, UserExitsToPrj> ueByPrj, Map<Pair<String, String>, Set<String>> ueByCicsReg) {
        List infoPr = (List)this.analysis.removeContextValue(CgBuilder.getKey(prjName, ttype.getInfoAttribute()));
        if (infoPr != null) {
            Map ue = (Map)this.analysis.getContextValue("ue map");
            HashMap<String, UserExitsFromPrg> map = (HashMap<String, UserExitsFromPrg>)ue.get(prjName);
            if (map == null) {
                map = new HashMap<String, UserExitsFromPrg>();
                ue.put(prjName, map);
            }
            for (String[] info : infoPr) {
                String prgRid = info[0];
                UserExitsFromPrg uec = (UserExitsFromPrg)map.get(prgRid);
                if (uec == null) {
                    uec = new UserExitsFromPrg(prjName, prgRid);
                    map.put(prgRid, uec);
                }
                if (uec == null) continue;
                String stmtRid = info[1];
                String tgName = info[4];
                String location = info[5];
                String pType = info[7];
                String parent = info[10];
                ExtCallLocationType locationType = ExtCallLocationType.getLocType(Integer.valueOf(info[6]));
                ExtCallTargetType lttype = ttype;
                if (pType != null && ttype.equals((Object)ExtCallTargetType.PROGRAM)) {
                    lttype = String.valueOf(ProgramType.COBOL.getProgramTypeId()).equals(pType) ? ExtCallTargetType.PROGRAM_COBOL : ExtCallTargetType.PROGRAM_PLI;
                } else if (ttype.equals((Object)ExtCallTargetType.FILE)) {
                    Optional<Integer> bRead = Optional.of(Integer.valueOf(info[9]));
                    lttype = GraphUtils.getExtCallType("ExtFileUsageInfo", bRead);
                }
                Target t = new Target(tgName, lttype, location, locationType, parent);
                t.addStmt(stmtRid);
                uec.addTarget(t);
                if (ExtCallLocationType.APPLICATION.equals((Object)locationType)) {
                    String extKey = this.getExtKey(location, tgName, lttype.toString());
                    if (!this.processedExt.contains(extKey)) {
                        UserExitsToPrj ueprj = ueByPrj.get(location);
                        if (ueprj == null) {
                            ueprj = new UserExitsToPrj(location);
                            ueByPrj.put(location, ueprj);
                        }
                        ueprj.addTarget(lttype, "'" + t.getQName() + "'");
                        this.processedExt.add(extKey);
                        continue;
                    }
                    L.debug("already processed information for project {}, target {} , targetType {}", new Object[]{location, tgName, locationType.getDescription()});
                    continue;
                }
                if (ueByCicsReg != null && ExtCallLocationType.CICSREGION.equals((Object)locationType)) {
                    ueByCicsReg.put((Pair<String, String>)new Pair((Object)location, (Object)(ttype.equals((Object)ExtCallTargetType.BMS) ? parent : tgName)), new HashSet());
                    continue;
                }
                L.debug("for a program, the location type is not suported {} ", (Object)locationType);
            }
        }
    }

    private void drawScreenToMappedPrg() {
        List scrInfo = (List)this.analysis.removeContextValue("SCR_Info");
        if (scrInfo != null) {
            for (String sRid : scrInfo) {
                OrientVertex proxy = this.dbg.getVertex((Object)sRid);
                TSENode resnode = this.getOrCreateTSNode((Vertex)proxy, null, false, screenLevel);
                Iterator it = proxy.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"IMSModProxyOf"}).iterator();
                if (!it.hasNext()) continue;
                Vertex mflInfo = (Vertex)it.next();
                Iterator itt = mflInfo.getVertices(com.tinkerpop.blueprints.Direction.IN, new String[]{"tranCODE"}).iterator();
                if (!itt.hasNext()) continue;
                Vertex tranProxy = (Vertex)itt.next();
                this.makeMappedToTranEdge(resnode, tranProxy);
            }
        }
    }

    private String getExtKey(String location, String tgName, String ttype) {
        return location.concat("|").concat(tgName).concat("|").concat(ttype);
    }

    private void buildAPI4Project(TSEGraph mainGraph, TSEGraph projectGraph) {
        if (this.analysis.getContextValue("API_CALLGRAPH") != null) {
            List ids = (List)this.analysis.getContextValue("input_list");
            List tsNodes = projectGraph.nodes();
            block4: for (EZEntityID id : ids) {
                CatalogAPISg sg = (CatalogAPISg)id.getSegment(CatalogAPISg.class);
                if (sg == null) continue;
                Node n = (Node)sg.getNode();
                switch (n.getType()) {
                    case API: {
                        for (Node serviceNode : n.getChildren()) {
                            this.findTargetOfService(mainGraph, tsNodes, serviceNode);
                        }
                        continue block4;
                    }
                    case SERVICE: {
                        this.findTargetOfService(mainGraph, tsNodes, n);
                        break;
                    }
                }
            }
        }
    }

    private void findTargetOfService(TSEGraph mainGraph, List<TSENode> tsNodes, Node serviceNode) {
        TSENode targetNode = null;
        String targetName = (String)serviceNode.getInfo().get("target");
        ApiTargetType targetType = serviceNode.getTargetType();
        for (TSENode tsNode : tsNodes) {
            if (!targetName.equals(tsNode.getName())) continue;
            if (ApiTargetType.PROGRAM.equals((Object)targetType)) {
                Object v = tsNode.getAttributeValue("program_type");
                if (!Boolean.TRUE.equals(v)) continue;
                targetNode = tsNode;
                break;
            }
            if (!ApiTargetType.IMS_TRANSACTION.equals((Object)targetType)) continue;
            L.debug("IMS_TRANSACTION");
        }
        if (targetNode != null) {
            TSENode servNode = this.getOrCreateTSApiNode(mainGraph, (ApiInterface)serviceNode, true);
            if (servNode != null) {
                this.getOrCreateEdge4Target(servNode, targetNode);
            } else {
                L.warn("service node not found for node={}?!", (Object)serviceNode);
            }
        }
    }

    private void buildAPIpart(TSEGraph mainGraph, TSEGraph projectGraph) {
        if (this.analysis.getContextValue("API_CALLGRAPH") != null) {
            List ids = (List)this.analysis.getContextValue("input_list");
            for (EZEntityID id : ids) {
                Node n;
                TSENode node;
                CatalogAPISg sg = (CatalogAPISg)id.getSegment(CatalogAPISg.class);
                if (sg == null || (node = this.getOrCreateTSApiNode(mainGraph, (ApiInterface)(n = (Node)sg.getNode()), true)) == null) continue;
                if (n.getType().equals((Object)ApiInterface.Type.API)) {
                    List services = n.getChildren();
                    if (services == null) continue;
                    for (Node servNode : services) {
                        this.buildApiServiceNode(mainGraph, projectGraph, node, servNode, false);
                    }
                    continue;
                }
                if (!n.getType().equals((Object)ApiInterface.Type.SERVICE)) continue;
                this.buildApiServiceNode(mainGraph, projectGraph, node, n, true);
            }
        }
    }

    private void buildApiServiceNode(TSEGraph mainGraph, TSEGraph projectGraph, TSENode node, Node servNode, boolean withApiNodes) {
        TSENode servTSNode = this.getOrCreateTSApiNode(mainGraph, (ApiInterface)servNode, false);
        if (servTSNode != null) {
            Collection apis;
            IAPIFillerService service;
            if (node != servTSNode) {
                this.getOrCreateEdge(node, servTSNode);
            }
            this.buildApiTargets(servNode, servTSNode, projectGraph);
            if (withApiNodes && (service = (IAPIFillerService)ServiceUtils.getService(IAPIFillerService.class)) != null && (apis = service.getAPIs(servNode)) != null) {
                for (Node api : apis) {
                    TSENode apinode = this.getOrCreateTSApiNode(mainGraph, (ApiInterface)api, false);
                    if (apinode == null) continue;
                    this.getOrCreateEdge(apinode, servTSNode);
                }
            }
        }
    }

    protected Set<String> createTransactionContext(String prjName, OrientBaseGraph dbg, StringBuilder sbInfo, Set<Integer> prgBackwardSid, Set<Integer> prgForwardSid, Set<Integer> prgSIDs, boolean addToInputs) {
        String query = "select @rid.asString() as trProxyRid, unionall(in('ResourceLink')[bRead = 1],in('ResourceLink')[bRead = 2]).in('Uses').in('HasS').asSet().sid.asString() as prgCalling from Proxy \n where (@class= 'TranProxy' or @class= 'IMSTransactionProxy' or @class= 'GenericTranProxy') and name in list(@@@@@EZLEGACY@@@@)".replace("@@@@@EZLEGACY@@@@", sbInfo.toString());
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        Set<String> inputORIDs = null;
        HashMap info = new HashMap();
        HashSet<String> startPrgs = new HashSet<String>();
        for (OrientElement oe : res) {
            OrientVertex tRidV;
            Iterator it;
            String tRid = (String)oe.getProperty("trProxyRid");
            if (addToInputs) {
                if (inputORIDs == null) {
                    inputORIDs = this.getInputOrids();
                }
                inputORIDs.add(tRid);
            }
            info.put(tRid, null);
            if (Direction.doBackward((Direction)this.cgDirection) && (this.cgLimitation == null || this.cgLimitation > 0)) {
                String prgs = (String)oe.getProperty("prgCalling");
                if (!(prgs = prgs.substring(1, prgs.length() - 1)).isEmpty()) {
                    String[] prgSids;
                    String[] stringArray = prgSids = prgs.split(",");
                    int n = prgSids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sid = stringArray[n2];
                        prgBackwardSid.add(Integer.valueOf(sid.trim()));
                        prgSIDs.add(Integer.valueOf(sid.trim()));
                        ++n2;
                    }
                }
            }
            if (!Direction.doForward((Direction)this.cgDirection) || this.cgLimitation != null && this.cgLimitation <= 0 || !(it = (tRidV = dbg.getVertex((Object)tRid)).getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"TranMapping"}).iterator()).hasNext()) continue;
            OrientVertex mappedPrgProxyV = (OrientVertex)it.next();
            Integer prgSid = (Integer)mappedPrgProxyV.getProperty("sid");
            prgForwardSid.add(prgSid);
            startPrgs.add(mappedPrgProxyV.getId().toString());
            ArrayList<String> list = (ArrayList<String>)info.get(tRid);
            if (list == null) {
                list = new ArrayList<String>();
                info.put(tRid, list);
            }
            String mappedRid = this.getPrgOrProxyRid((Vertex)mappedPrgProxyV);
            list.add(mappedRid);
        }
        this.analysis.addContextValue(CgBuilder.getKey(prjName, "Tran map"), info);
        return startPrgs;
    }

    protected Set<String> getInputOrids() {
        String prjName = (String)this.analysis.getContextValue("input_project_names");
        return this.analysis.getContextSetValue(CgBuilder.getKey(prjName, "input orids as string"));
    }

    private void getOrCreateEdge(TSENode apiTSNode, TSENode servTSNode) {
        TSEEdge mappedEdge = GraphUtils.getOrCreateEdge(this.graphManager, apiTSNode, servTSNode, null, ResourceLink.FAKE_STMT_TYPE_FOR_API_TO_SERVICE_STRING);
        StatementNode sn = new StatementNode(ResourceLink.FAKE_STMT_TYPE_FOR_API_TO_SERVICE_STRING);
        mappedEdge.setAttribute("Statement Node_Mainframe", (Object)sn);
        TSECurvedEdgeUI eui = new TSECurvedEdgeUI();
        eui.setProperty(new TSProperty("arrowType", (Object)0));
        mappedEdge.setUI((TSObjectUI)eui);
    }

    private void buildApiTargets(Node serv, TSENode servTSNode, TSEGraph projectGraph) {
        String targetName = (String)serv.getInfo().get("target");
        ApiTargetType targetType = serv.getTargetType();
        if (targetName != null && targetType != null) {
            String query = null;
            boolean isIMSTrans = false;
            boolean isPrg = false;
            if (ApiTargetType.PROGRAM.equals((Object)targetType)) {
                query = String.format("select @rid.asString() as rid from ProgramProxy where name = '%s' ", targetName);
                isPrg = true;
            } else if (ApiTargetType.TRANSACTION.equals((Object)targetType)) {
                targetName = null;
            } else if (ApiTargetType.IMS_TRANSACTION.equals((Object)targetType)) {
                query = String.format("select @rid.asString() as rid from IMSTransactionProxy where name = '%s' ", targetName);
                isIMSTrans = true;
            }
            boolean hadResults = false;
            if (query != null) {
                CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                for (OrientElement oe : res) {
                    String prgRid = (String)oe.getProperty("rid");
                    TSENode targetNode = null;
                    if (isPrg) {
                        targetNode = this.getOrCreateTSNode((Vertex)this.dbg.getVertex((Object)prgRid), null, true, new LevelObject(Integer.valueOf(0), false));
                        serv.getInfo().put("target", targetNode.getName());
                    } else if (isIMSTrans) {
                        targetNode = this.getOrCreateTSNode((Vertex)this.dbg.getVertex((Object)prgRid), null, false, new LevelObject(Integer.valueOf(-1), true));
                    }
                    if (targetNode == null) continue;
                    this.getOrCreateEdge4Target(servTSNode, targetNode);
                    hadResults = true;
                }
            }
        }
    }

    private void buildUnreachableAPITargets(TSENode servTSNode, String targetName, ApiTargetType targetType) {
        L.info("build nodes for targets not in OrientDB");
        if (targetName != null) {
            String nodeType = targetType.toString();
            String nodeTypeStr = targetType.toString();
            switch (targetType) {
                case PROGRAM: {
                    nodeType = "Program";
                    break;
                }
                case IMS_TRANSACTION: {
                    nodeType = "IMSTransactionProxy";
                    nodeTypeStr = CallgraphNodeLegendInfo.IMS_TRANSACTION.getLegendLabel();
                    break;
                }
            }
            TSENode targetNode = this.getOrCreateNodeNoVertex(targetName, nodeType);
            Utils.setResourceUIStyle((TSNode)targetNode, (String)nodeType, (Set)this.nodeTypesSetForLegend, (boolean)false, null);
            this.setNodeUI(targetNode);
            targetNode.setAttribute("API_CG", (Object)NOT_REACHABLE_APITARGETS_INVENTORY_LBL);
            targetNode.setAttribute("API_CG_parent", (Object)Boolean.TRUE);
            this.putEntriesInGISV(this.graphManager, nodeTypeStr, targetNode);
            targetNode.setTooltipText(targetName);
            Integer lvl = (Integer)servTSNode.getAttributeValue("level");
            lvl = lvl + 1;
            this.setLevel(targetNode, false, new LevelObject(lvl));
            this.getOrCreateEdge4Target(servTSNode, targetNode);
        }
    }

    private void getOrCreateEdge4Target(TSENode servTSNode, TSENode targetNode) {
        if (!TSGraphUtils.extCallEdgeExists((TSENode)servTSNode, (TSENode)targetNode)) {
            TSEEdge mappedEdge = GraphUtils.getOrCreateEdge(this.graphManager, servTSNode, targetNode, null, ResourceLink.FAKE_STMT_TYPE_FOR_SERVICE_TO_TARGET_STRING);
            StatementNode sn = new StatementNode(ResourceLink.FAKE_STMT_TYPE_FOR_SERVICE_TO_TARGET_STRING);
            mappedEdge.setAttribute("Statement Node_Mainframe", (Object)sn);
            TSECurvedEdgeUI eui = new TSECurvedEdgeUI();
            eui.setLineStyle(3);
            eui.setProperty(new TSProperty("arrowType", (Object)0));
            mappedEdge.setUI((TSObjectUI)eui);
        }
    }

    private TSENode getOrCreateTSApiNode(TSEGraph gr, ApiInterface n, boolean isInput) {
        HashMap<String, TSENode> tsNodes = (HashMap<String, TSENode>)gr.getAttributeValue("TS nodes per project");
        if (tsNodes == null) {
            tsNodes = new HashMap<String, TSENode>();
            gr.setAttribute("TS nodes per project", tsNodes);
        }
        String key = null;
        String vertexClass = null;
        String name = n.getName();
        switch (n.getType()) {
            case API: {
                key = "#api" + name;
                vertexClass = "api";
                break;
            }
            case SERVICE: {
                key = "#service" + name;
                vertexClass = "api_service";
            }
        }
        TSENode node = null;
        if (!key.isEmpty()) {
            node = (TSENode)tsNodes.get(key);
            if (node == null) {
                node = (TSENode)gr.addNode();
                IGraphNodeLegendInfo info = Utils.setResourceUIStyle((TSNode)node, (String)vertexClass, (Set)this.nodeTypesSetForLegend, (boolean)false, (ProjectInfo)this.ezsourcePrj);
                String lbl = info != null ? info.getLegendLabel() : Utils.getNodeLabel((String)vertexClass, (boolean)false);
                node.setAttribute("TS MEMBER TYPE", (Object)lbl);
                node.setAttribute("Node_Mainframe", (Object)new APIRelatedNode(n));
                node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)true);
                CatalogAPIInputType apiInpt = new CatalogAPIInputType();
                EZEntityID apiID = new EZEntityID();
                apiID.addSegment((EZSegment)new CatalogAPISg(n));
                apiInpt.setEntID(apiID);
                node.setAttribute(NEW_ANALYSIS_INPUT_KEY, (Object)apiInpt);
                node.setAttribute("API_CG", (Object)API_TS_INVENTORY_LBL);
                node.setName((Object)name);
                node.setTooltipText(lbl.concat(": ").concat(name));
                if (isInput) {
                    node.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                }
                node.setAttribute("Color", (Object)TSEColor.white);
                if ("!svg".equals(node.getAttributeValue("uiStyle"))) {
                    node.setAttribute("Text_Color", (Object)TSEColor.white);
                }
                this.setNodeUI(node);
                int level = ApiInterface.Type.API.equals((Object)n.getType()) ? -3 : -2;
                this.setLevel(node, false, new LevelObject(Integer.valueOf(level), true));
                tsNodes.put(key, node);
                this.putEntriesInGISV(this.graphManager, lbl, node);
            } else if (isInput) {
                node.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                this.setNodeUI(node);
            }
        }
        return node;
    }

    protected EZObjectType createApplicableInputType(TSNode gNode) {
        Object n;
        EZObjectType objType = super.createApplicableInputType(gNode);
        if (objType == null && (n = gNode.getAttributeValue(NEW_ANALYSIS_INPUT_KEY)) != null && n instanceof EZObjectType) {
            objType = (EZObjectType)n;
        }
        return objType;
    }

    protected void doJCLInCg(SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "loading.graph.jcl.res"));
        List execSteps = (List)this.analysis.removeContextValue("JCLStep_Info");
        if (execSteps != null) {
            L.debug("add jcl ts nodes");
            Map tsNodes = (Map)this.cg.getAttributeValue("TS nodes per project");
            for (String[] jobStep : execSteps) {
                if (monitor.isCanceled()) break;
                String prgProxyRid = jobStep[0];
                String jobStepRid = jobStep[1];
                OrientVertex jclStepV = this.dbg.getVertex((Object)jobStepRid);
                Vertex jclJobV = (Vertex)jclStepV.getVertices(com.tinkerpop.blueprints.Direction.IN, new String[]{"Steps"}).iterator().next();
                TSENode prgNode = (TSENode)tsNodes.get(prgProxyRid);
                if (prgNode != null) {
                    Integer lvl = (Integer)prgNode.getAttributeValue("level");
                    lvl = lvl + 1;
                    TSENode jobNode = this.getOrCreateTSNode(jclJobV, null, false, new LevelObject(lvl, true));
                    GraphUtils.getOrCreateEdge(this.graphManager, jobNode, prgNode, jobStepRid, ResourceLink.FAKE_STMT_TYPE_FOR_JCL_TO_PGM_STRING);
                    continue;
                }
                L.warn("ts node having prgProxyRid {} not found!", (Object)prgProxyRid);
            }
        }
    }

    private void doCgJobToPgm(SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphModel.class, "loading.graph.pgm"));
        List execPgms = (List)this.analysis.removeContextValue("JCLPGM_Info");
        if (execPgms != null) {
            L.debug("add jcl to pgm edges");
            Map tsNodes = (Map)this.cg.getAttributeValue("TS nodes per project");
            for (String[] jobStep : execPgms) {
                if (monitor.isCanceled()) break;
                OrientVertex jclJobV = this.dbg.getVertex((Object)jobStep[0]);
                TSENode jobNode = this.getOrCreateTSNode((Vertex)jclJobV, null, false, jobsLevel);
                jobNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                String jobStepRid = jobStep[1];
                String prgProxyId = jobStep[2];
                TSENode prgNode = null;
                if (prgProxyId != null && tsNodes.get(prgProxyId) != null) {
                    ArrayList<TSENode> currentLevel;
                    prgNode = (TSENode)tsNodes.get(prgProxyId);
                    Integer lvl = (Integer)prgNode.getAttributeValue("level");
                    Map tsLevels = (Map)this.cg.getAttributeValue(TS_LEVEL_MAP);
                    if (lvl != null) {
                        LevelObject lvlObj = new LevelObject(lvl, true);
                        List nodes = (List)tsLevels.get(lvlObj);
                        nodes.remove(prgNode);
                    }
                    if ((currentLevel = (ArrayList<TSENode>)tsLevels.get(pgmLevel)) == null) {
                        currentLevel = new ArrayList<TSENode>();
                        tsLevels.put(pgmLevel, currentLevel);
                    }
                    currentLevel.add(prgNode);
                    prgNode.setAttribute("level", (Object)pgmLevel.getLevel());
                } else if (jobStep[3] != null) {
                    OrientVertex jclPgmV = this.dbg.getVertex((Object)jobStep[3]);
                    prgNode = this.getOrCreateTSNode((Vertex)jclPgmV, null, true, pgmLevel);
                }
                if (prgNode != null) {
                    GraphUtils.getOrCreateEdge(this.graphManager, jobNode, prgNode, jobStepRid, ResourceLink.FAKE_STMT_TYPE_FOR_JCL_TO_PGM_STRING);
                }
                this.doInvokedJobs(jobStepRid, jobNode);
            }
        }
    }

    private void doInvokedJobs(String jobStepRid, TSENode jobNode) {
        boolean isJobCg;
        boolean bl = isJobCg = this.analysis.getContextValue("JOB_CALLGRAPH") != null ? (Boolean)this.analysis.getContextValue("JOB_CALLGRAPH") : false;
        if (!isJobCg) {
            return;
        }
        OrientVertex stepV = this.dbg.getVertex((Object)jobStepRid);
        Iterator invokedVertexIter = stepV.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"Invokes"}).iterator();
        if (invokedVertexIter != null && invokedVertexIter.hasNext()) {
            while (invokedVertexIter.hasNext()) {
                Vertex invokedVertex = (Vertex)invokedVertexIter.next();
                Iterator invokedJclJobProxyIter = invokedVertex.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"JCLProxyOf"}).iterator();
                if (invokedJclJobProxyIter != null && invokedJclJobProxyIter.hasNext()) {
                    while (invokedJclJobProxyIter.hasNext()) {
                        Vertex jclJobProxyV = (Vertex)invokedJclJobProxyIter.next();
                        Iterator jclJobVertexIter = jclJobProxyV.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"ProxyFor"}).iterator();
                        if (jclJobVertexIter == null || !jclJobVertexIter.hasNext()) continue;
                        while (jclJobVertexIter.hasNext()) {
                            TSENode invokedJobNode = this.getOrCreateTSNode((Vertex)jclJobVertexIter.next(), null, false, jobsLevel);
                            invokedJobNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                            GraphUtils.getOrCreateEdge(this.graphManager, jobNode, invokedJobNode, jobStepRid, ResourceLink.FAKE_STMT_TYPE_FOR_JCL_TO_JCL_STRING);
                        }
                    }
                    continue;
                }
                TSENode invokedJobNode = this.getOrCreateTSNode(invokedVertex, null, false, jobsLevel);
                invokedJobNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                GraphUtils.getOrCreateEdge(this.graphManager, jobNode, invokedJobNode, jobStepRid, ResourceLink.FAKE_STMT_TYPE_FOR_JCL_TO_JCL_STRING);
            }
        }
    }

    protected void drawPrgCallgraph(Map<String, List<String>> info, boolean isForward, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        boolean showStandardSCLProcs = PreferenceUtils.isShowingSCLProcs();
        String query = prgs_info_query.concat(info.keySet().toString());
        CloseableIterable res = (CloseableIterable)this.dbg.command(new OCommandSQL(query).setFetchPlan("in_*:-2 out_*:-2")).execute(new Object[0]);
        if (res == null || !res.iterator().hasNext()) {
            return;
        }
        HashSet edgeRids = new HashSet();
        for (String proxyVertexRid : info.keySet()) {
            edgeRids.addAll(info.get(proxyVertexRid));
        }
        if (edgeRids.size() > 0) {
            L.info("program call edges number {}", (Object)edgeRids.size());
            query = (isForward ? call_edges_F_info_query : call_edges_B_info_query).replace("@@@@@EZLEGACY@@@@", ((Object)edgeRids).toString());
        }
        CloseableIterable resE = (CloseableIterable)this.dbg.command(new OCommandSQL(query).setFetchPlan("in_*:-2 out_*:-2")).execute(new Object[0]);
        HashMap<String, Pair> edgesInfo = new HashMap<String, Pair>();
        HashMap<String, Pair> edgesInfo2 = new HashMap<String, Pair>();
        for (OrientElement oe : resE) {
            String eRid = (String)oe.getProperty("eRid");
            Vertex o = (Vertex)oe.getProperty("o");
            Vertex i = isForward ? (Vertex)oe.getProperty("i") : null;
            String sRid = (String)oe.getProperty("sRid");
            String typeId = (String)oe.getProperty("typeId");
            edgesInfo.put(eRid, new Pair((Object)o, (Object)i));
            edgesInfo2.put(eRid, new Pair((Object)sRid, (Object)typeId));
        }
        for (OrientElement oe : res) {
            boolean toShowStandarProc;
            Vertex proxyV = (Vertex)oe.getProperty("proxyV");
            String proxyVertexRid = (String)oe.getProperty("proxyVRid");
            String prgTypeIdString = proxyV.getProperty("type").toString();
            if (prgTypeIdString.equals(MappingConstants.SCL_Procedure_Type_STRING) && !(toShowStandarProc = this.toShowStandarProc(proxyV, showStandardSCLProcs))) continue;
            TSENode node = null;
            for (String callEdgeRid : info.get(proxyVertexRid)) {
                boolean toShowStandarProc2;
                if (monitor.isCanceled()) {
                    return;
                }
                Vertex proxyVertex2 = null;
                Pair e = (Pair)edgesInfo.get(callEdgeRid);
                if (e == null) {
                    L.debug("ignore edge {} because it is a program call using transcation", (Object)callEdgeRid);
                    continue;
                }
                if (isForward) {
                    if (node == null) {
                        Vertex proxyVertex1 = (Vertex)e.getFirst();
                        node = this.getOrCreateTSNode(proxyVertex1, null, true, programLevel);
                    }
                    proxyVertex2 = (Vertex)e.getSecond();
                } else {
                    if (node == null) {
                        node = this.getOrCreateTSNode(proxyV, null, true, programLevel);
                    }
                    Vertex prgVertex = (Vertex)e.getFirst();
                    proxyVertex2 = (OrientVertex)prgVertex;
                }
                Integer lvl = (Integer)node.getAttributeValue("level");
                lvl = isForward ? lvl + 2 : lvl - 2;
                prgTypeIdString = proxyVertex2.getProperty("type").toString();
                if (prgTypeIdString.equals(MappingConstants.SCL_Procedure_Type_STRING) && !(toShowStandarProc2 = this.toShowStandarProc(proxyVertex2, showStandardSCLProcs))) continue;
                if (!this.shouldNotDrawTSNode(proxyVertex2)) {
                    TSENode node2 = this.getOrCreateTSNode(proxyVertex2, null, true, new LevelObject(lvl, false));
                    this.drawCallEdge((Pair<String, String>)((Pair)edgesInfo2.get(callEdgeRid)), node, node2, isForward);
                    continue;
                }
                L.debug("do not drow edge since the source ts node is null");
            }
            if (node != null || this.shouldNotDrawTSNode(proxyV)) continue;
            node = this.getOrCreateTSNode(proxyV, null, true, programLevel);
        }
        if (this.no_path_legend_entry) {
            this.restrictionTypesSetForLegend.add(GraphRestrictionsLegendInfo.NO_PATH);
        }
    }

    protected boolean shouldNotDrawTSNode(Vertex v) {
        return false;
    }

    private boolean toShowStandarProc(Vertex proxyV, boolean showStandardSCLProcs) {
        boolean isSCLChild = false;
        String name = (String)proxyV.getProperty("name");
        Iterator it = proxyV.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"Ancestor"}).iterator();
        if (it.hasNext()) {
            isSCLChild = true;
        }
        return showStandardSCLProcs || !com.ez.mainframe.data.utils.Utils.isSCLStandardProcedure((String)name) || isSCLChild;
    }

    @Override
    protected Map<String, TSENode> drawGraph(String prjName, Set<String> prgRids, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
        monitor.setTaskName(Messages.getString(CrossExtGraphModel.class, "drawing.cg", new String[]{prjName}));
        if (prgRids.isEmpty()) {
            return null;
        }
        Map prjMap = (Map)this.graphManager.getAttributeValue("mf_projects_sgs");
        EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)prjMap.get(prjName);
        this.cg = TSGraphUtils.getOrCreatePrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (EZSourceProjectIDSg)prjIdSg, (boolean)true);
        return (Map)this.cg.getAttributeValue("TS nodes per project");
    }

    private void drawCallEdge(Pair<String, String> info, TSENode node1, TSENode node2, boolean isForward) {
        TSENode from;
        TSENode to = isForward ? node2 : null;
        TSENode tSENode = from = isForward ? null : node2;
        if (isForward) {
            from = node1;
        } else {
            to = node1;
        }
        GraphUtils.getOrCreateEdge(this.graphManager, from, to, (String)info.getFirst(), (String)info.getSecond());
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
            if (node.hasAttribute("node with restrictions, in callgraph ")) {
                node.setAttribute("Text_Color", (Object)TSEColor.darkRed);
                node.setAttribute("restricted node in callgraph", (Object)true);
            } else if (node.hasAttribute("node is not expanded, but can be expanded, in callgraph")) {
                node.setAttribute("expandable node", (Object)true);
            }
            if (node.hasAttribute("node is input for callgraph") && !this.isUsed4Cross()) {
                node.setAttribute("Text_Color", (Object)TSEColor.blue);
            }
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            Object textColor = node.getAttributeValue("Color");
            if (textColor != null) {
                node.setAttribute("Text_Color", textColor);
                if (node.hasAttribute("node with restrictions, in callgraph ")) {
                    node.setAttribute("restricted node in callgraph", (Object)true);
                } else if (node.hasAttribute("node is not expanded, but can be expanded, in callgraph")) {
                    node.setAttribute("expandable node", (Object)true);
                }
            }
        }
    }

    public void updateDrawing() {
        super.updateDrawing();
        List<TSEGraph> graphs = this.getGraphs();
        for (TSEGraph graph : graphs) {
            TSEGraph hide;
            List nodes = graph.nodes();
            if (nodes != null) {
                for (TSENode node : nodes) {
                    this.setNodeUI(node);
                }
            }
            if ((hide = (TSEGraph)graph.hideOrHideFromGraph) == null || (nodes = hide.nodes()) == null) continue;
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    @Override
    public void dispose() {
        this.analysis = null;
        this.cgDirection = null;
        this.processedExt = null;
        this.allCicsReg = null;
        this.cg = null;
        this.exportAction = null;
        List<TSEGraph> graphs = this.getGraphs();
        for (TSEGraph g : graphs) {
            Map currenttsLevels = (Map)g.getAttributeValue(TS_LEVEL_MAP);
            if (currenttsLevels == null) continue;
            currenttsLevels.clear();
            currenttsLevels = null;
        }
        super.dispose();
    }

    public boolean considerStmtAsDynamic(TSEdge edge) {
        return !this.isUsed4Cross() && super.considerStmtAsDynamic(edge);
    }

    public void setUsed4Cross(boolean used4Cross) {
        this.used4Cross = used4Cross;
    }

    public IAction createExportAction() {
        if (this.exportAction == null) {
            this.exportAction = new ExportAction(Messages.getString(CallGraphModel.class, "export.action.text"), 1, this.graphManager);
            ImageDescriptor id = Activator.getImageDescriptor("icons/impact_graph.png");
            this.exportAction.setImageDescriptor(id);
        }
        return this.exportAction;
    }
}

