/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.programcallgraph;

import com.ez.cobol.callgraph.nodes.ADSDialogProgramNode;
import com.ez.cobol.callgraph.nodes.ADSProcessProgramNode;
import com.ez.cobol.callgraph.nodes.AdabasNode;
import com.ez.cobol.callgraph.nodes.AdsMapNode;
import com.ez.cobol.callgraph.nodes.AlgolProgramNode;
import com.ez.cobol.callgraph.nodes.ApiNode;
import com.ez.cobol.callgraph.nodes.ApiServiceNode;
import com.ez.cobol.callgraph.nodes.AsmCsectProgramNode;
import com.ez.cobol.callgraph.nodes.AsmEntryProgramNode;
import com.ez.cobol.callgraph.nodes.AssemblerProgramNode;
import com.ez.cobol.callgraph.nodes.CLFileNode;
import com.ez.cobol.callgraph.nodes.CLProgramNode;
import com.ez.cobol.callgraph.nodes.CobolProgramNode;
import com.ez.cobol.callgraph.nodes.DALFileNode;
import com.ez.cobol.callgraph.nodes.DBFileNode;
import com.ez.cobol.callgraph.nodes.DBINode;
import com.ez.cobol.callgraph.nodes.EZRexxProgramNode;
import com.ez.cobol.callgraph.nodes.FortranProgramNode;
import com.ez.cobol.callgraph.nodes.GenericMapNode;
import com.ez.cobol.callgraph.nodes.GenericTransactionNode;
import com.ez.cobol.callgraph.nodes.IMSDBLogicSegmentNode;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.IMSDBSegmentNode;
import com.ez.cobol.callgraph.nodes.IMSTransactionNode;
import com.ez.cobol.callgraph.nodes.IdmsRecordNode;
import com.ez.cobol.callgraph.nodes.IdmsSetNode;
import com.ez.cobol.callgraph.nodes.JCLJobNode;
import com.ez.cobol.callgraph.nodes.JCLPgmNode;
import com.ez.cobol.callgraph.nodes.JavaProgramNode;
import com.ez.cobol.callgraph.nodes.NaturalMapNode;
import com.ez.cobol.callgraph.nodes.NaturalProgramNode;
import com.ez.cobol.callgraph.nodes.PLIProgramNode;
import com.ez.cobol.callgraph.nodes.PrinterFileNode;
import com.ez.cobol.callgraph.nodes.QueueManagerNode;
import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.cobol.callgraph.nodes.ResourceDatacomTableNode;
import com.ez.cobol.callgraph.nodes.ResourceFileNode;
import com.ez.cobol.callgraph.nodes.ResourceSQLTableNode;
import com.ez.cobol.callgraph.nodes.SCLProgramNode;
import com.ez.cobol.callgraph.nodes.ScreenNode;
import com.ez.cobol.callgraph.nodes.SmartDbModuleProgramNode;
import com.ez.cobol.callgraph.nodes.SmartScreenNode;
import com.ez.cobol.callgraph.nodes.SmartSubroutineNode;
import com.ez.cobol.callgraph.nodes.TPMSXMapNode;
import com.ez.cobol.callgraph.nodes.TerminalNode;
import com.ez.cobol.callgraph.nodes.TerminalOrTransactionNode;
import com.ez.cobol.callgraph.nodes.TransactionNode;
import com.ez.cobol.callgraph.nodes.UnknownProgramNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphModel;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphMouseActionHook;
import com.ez.graphs.viewer.callgraph.programcallgraph.CgBuilder;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UEMouseActionsHook;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.ui.ResolutionBaseJob;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.model.Direction;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.ExportAsCSV;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.ApiTargetType;
import com.ibm.ez.analysis.api.model.CatalogAPISg;
import com.ibm.ez.analysis.api.model.Node;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallGraphJob
extends ResolutionBaseJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CallGraphJob.class);
    public static final String ANALYSIS_SCREEN_KEY = "SCREEN_CALLGRAPH";
    public static final String ANALYSIS_JOB_KEY = "JOB_CALLGRAPH";
    public static final String ANALYSIS_PROGRAM_KEY = "PROGRAM_CALLGRAPH";
    public static final String ANALYSIS_TRANSACTION_KEY = "TRANSACTION_CALLGRAPH";
    public static final String CGLIMIT = "CGLIMIT";
    private static final String QUOTE = "'";
    public static final String ANALYSIS_API_KEY = "API_CALLGRAPH";
    public static final String LIMITATION_MARKER = "@@@@@EZLEGACY@MAXDEPTH@@@@";
    public static final String RES_TYPE_MARKER = "@@@@@EZLEGACY@RESTYPE@@@@";
    private static final String commandJCL_PGM_WITH_SID = "select @rid.asString() as jobrid, $a as steps from jcljob  let $a = out('Steps')  where sid in list(@@@@@EZLEGACY@@@@) ";
    public static final String command_TRAN_PRG = "select @rid.asString() as trProxyRid, unionall(in('ResourceLink')[bRead = 1],in('ResourceLink')[bRead = 2]).in('Uses').in('HasS').asSet().sid.asString() as prgCalling from Proxy \n where (@class= 'TranProxy' or @class= 'IMSTransactionProxy' or @class= 'GenericTranProxy') and name in list(@@@@@EZLEGACY@@@@)";
    private static final String command_SCREEN_PRG = "select @rid.asString() as scrRid, $a.asString() as prgs from Proxy\nlet $a = set(unionall(in('ResourceLink')[bRead = 1],in('ResourceLink')[bRead = 2]).in('Uses').in('HasS').sid)  where (@class instanceof 'ScreenProxy' or @class='IMSMODProxy' or @class = 'GenericScreenProxy') and name+mapSet in list(@@@@@EZLEGACY@@@@)";
    public static final String PROGRAMS_INFO_FORWARD = "programs_Info_forward";
    public static final String PROGRAMS_INFO_BACKWARD = "programs_Info_backward";
    public static final String RESOURCES_INFO = "resources_Info_";
    public static final String INPUT_ORIDS = "input orids as string";
    protected static final String JCL_INFO = "JCLStep_Info";
    protected static final String JCL_PGM_INFO = "JCLPGM_Info";
    protected static final String SCR_PRG_INFO = "SCR_Info";
    public static final String TRAN_MAPPED_INFO = "Tran map";
    public static final String SCREEN_MAPPED_INFO = "generic screen mapp";
    public static final String SCREEN_PRG_RIDS = "program's rid from screen cg";
    public static final String TRAN_PRG_RIDS = "program's rid from transaction cg";
    private static final int MAXNAMES = 10;
    private String tabName;
    private Direction cgDirection;
    private Boolean isCgLimited;
    private Integer cgLimitation = null;

    public CallGraphJob(EZEntityID ezId) {
        super(ezId);
        this.initGraphDetails();
        this.mouseActionsHook = GraphUtils.cgToOtherPrj(this.graphManager) ? new UEMouseActionsHook(ezId, (GraphAnalysisJob)this) : new CallGraphMouseActionHook(ezId);
        this.initContentProviders();
    }

    protected void initGraphDetails() {
        Boolean isOtherPrj;
        boolean isPrgCallGraph;
        this.graphInfo = new GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.cgDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("callgraph direction: {}", (Object)this.cgDirection);
        this.isCgLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (this.isCgLimited != null && this.isCgLimited.booleanValue()) {
            this.cgLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("callgraph has limit: {}", (Object)this.cgLimitation);
        } else {
            L.debug("callgraph is unlimited");
        }
        this.graphModel = new CallGraphModel(new AnalysisGraphManager(), this.cgDirection, this.cgLimitation, this.analysis);
        this.graphManager = this.graphModel.getGraphManager();
        boolean bl = isPrgCallGraph = this.analysis.getContextValue(ANALYSIS_PROGRAM_KEY) != null ? (Boolean)this.analysis.getContextValue(ANALYSIS_PROGRAM_KEY) : false;
        if (this.cgDirection != null && (this.cgDirection.ordinal() == Direction.BACKWARD.ordinal() || this.cgDirection.ordinal() == Direction.FORWARD.ordinal()) && isPrgCallGraph) {
            ArrayList<Class<ExportAsCSV>> impl = new ArrayList<Class<ExportAsCSV>>();
            impl.add(ExportAsCSV.class);
            this.graphManager.setAttribute("extraExportListImplementors", impl);
            this.graphManager.setAttribute("graph direction", (Object)this.cgDirection.ordinal());
            this.graphManager.setAttribute("mainframe project name", this.analysis.getContextValue("input_project_names"));
            if (this.cgLimitation != null) {
                this.graphManager.setAttribute("graph limitation", (Object)this.cgLimitation);
            }
        }
        this.markAsUECallgraph((isOtherPrj = (Boolean)this.analysis.getContextValue("continueCG_otherPrj_analysis")) != null && isOtherPrj != false);
        super.initGraphDetails();
    }

    private void markAsUECallgraph(boolean b) {
        this.graphManager.setAttribute("continueCG_otherPrj_analysis", (Object)b);
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((com.ez.workspace.analysis.graph.model.GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor pmonitor) {
        super.computeResults(model, pmonitor);
        if (GraphUtils.cgToOtherPrj(this.graphManager)) {
            this.graphManager.setAttribute("projects", this.analysis.getContextValue("projects"));
            this.graphManager.setAttribute("Projects_TS_map", new HashMap());
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "collectingData.taskName"));
        Properties env = (Properties)this.analysis.getContextValue("env");
        OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        try {
            List inputs = this.analysis.getContextListValue("input_list");
            this.computeInputsList(inputs, dbg, env, pmonitor);
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
            dbg = null;
        }
        monitor.setWorkRemaining(0);
    }

    private void computeInputsList(List<EZEntityID> inputs, OrientBaseGraph dbg, Properties env, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)300);
        String prjName = this.getPrjName();
        Triplet<Boolean, Boolean, Boolean> type = this.computeCgType();
        boolean isJobCallGraph = (Boolean)type.getFirst();
        boolean isScreenCallGraph = (Boolean)type.getSecond();
        boolean isTranCallGraph = (Boolean)type.getThird();
        boolean isApiCallGraph = this.analysis.getContextValue(ANALYSIS_API_KEY) != null ? (Boolean)this.analysis.getContextValue(ANALYSIS_API_KEY) : false;
        boolean isPrgCallGraph = !isJobCallGraph && !isScreenCallGraph && !isTranCallGraph && !isApiCallGraph;
        HashSet<String> inputORIDs = new HashSet<String>();
        this.analysis.addContextValue(CgBuilder.getKey(prjName, INPUT_ORIDS), inputORIDs);
        this.analysis.addContextValue(CgBuilder.getKey(prjName, PROGRAMS_INFO_FORWARD), null);
        this.analysis.addContextValue(CgBuilder.getKey(prjName, PROGRAMS_INFO_BACKWARD), null);
        for (String key : GraphUtils.resourceTypes) {
            this.analysis.removeContextValue(CgBuilder.getKey(prjName, RESOURCES_INFO + key));
        }
        this.analysis.removeContextValue(CgBuilder.getKey(prjName, SCREEN_MAPPED_INFO));
        StringBuilder sbInfo = new StringBuilder();
        HashSet<Integer> prgForwORBack = new HashSet<Integer>();
        HashSet<Integer> assPrgForwORBack = new HashSet<Integer>();
        HashSet<String> prgWithoutSid = new HashSet<String>();
        HashSet<Integer> prgSIDs = new HashSet<Integer>();
        for (EZEntityID entity : inputs) {
            if (isPrgCallGraph) {
                EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                Triplet<Integer, Integer, Set<String>> res = this.classifyPrg(dbg, prgIdSg, prgSIDs);
                if (res.getFirst() != null) {
                    prgForwORBack.add((Integer)res.getFirst());
                }
                if (res.getSecond() != null) {
                    assPrgForwORBack.add((Integer)res.getSecond());
                }
                prgWithoutSid.addAll((Collection)res.getThird());
                continue;
            }
            if (sbInfo.length() > 0) {
                sbInfo.append(", ");
            }
            if (isJobCallGraph) {
                EZSourceJobIDSg jobIdSg = (EZSourceJobIDSg)entity.getSegment(EZSourceJobIDSg.class);
                Integer sid = jobIdSg.getJobId();
                sbInfo.append(sid);
                continue;
            }
            if (isScreenCallGraph) {
                EZSourceScreenIDSg scrIdSg = (EZSourceScreenIDSg)entity.getSegment(EZSourceScreenIDSg.class);
                String scr = scrIdSg.getScreenName();
                if (scr.contains(QUOTE)) {
                    scr = scr.replaceAll(QUOTE, "\\\\'");
                }
                if (scrIdSg.getMapSet() != null && scrIdSg.getScreenType() != 65) {
                    sbInfo.append(QUOTE + scr + scrIdSg.getMapSet() + QUOTE);
                    continue;
                }
                sbInfo.append(QUOTE + scr + QUOTE);
                continue;
            }
            if (!isTranCallGraph) continue;
            EZSourceTransactionIDSg trIdSg = (EZSourceTransactionIDSg)entity.getSegment(EZSourceTransactionIDSg.class);
            sbInfo.append(QUOTE + trIdSg.getTransactionName() + QUOTE);
        }
        HashSet<String> startPrgs = new HashSet<String>();
        HashSet<Integer> prgBackwardSid = new HashSet<Integer>();
        HashSet<Integer> prgForwardSid = new HashSet<Integer>();
        if (isScreenCallGraph && sbInfo.length() > 0) {
            StringBuilder tranSB = this.processScrToPrg(dbg, sbInfo, prgForwORBack, prgSIDs);
            if (tranSB.length() > 0) {
                startPrgs.addAll(((CallGraphModel)this.graphModel).createTransactionContext(prjName, dbg, tranSB, prgBackwardSid, prgForwardSid, prgSIDs, false));
            }
        } else if (isTranCallGraph && sbInfo.length() > 0) {
            startPrgs.addAll(((CallGraphModel)this.graphModel).createTransactionContext(prjName, dbg, sbInfo, prgBackwardSid, prgForwardSid, prgSIDs, true));
        } else if (isJobCallGraph && sbInfo.length() > 0) {
            startPrgs.addAll(this.processJclToPrg(dbg, sbInfo, prgForwORBack, prgWithoutSid));
        } else if (isApiCallGraph) {
            this.processApiToPrg(dbg, inputs, startPrgs, prgForwardSid);
        }
        if (!prgSIDs.isEmpty()) {
            String query = "select @rid.asString() as prgRid from Program where sid in ? ";
            CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{prgSIDs});
            if (res.iterator().hasNext()) {
                for (OrientElement elem : res) {
                    String rid = (String)elem.getProperty("prgRid");
                    if (isScreenCallGraph || isTranCallGraph && Direction.doBackward((Direction)this.cgDirection)) {
                        startPrgs.add(rid);
                        continue;
                    }
                    inputORIDs.add(rid);
                }
            }
            prgSIDs.clear();
        }
        prgWithoutSid.addAll(this.resolveAssembler(dbg, prgForwORBack, assPrgForwORBack));
        prgBackwardSid.addAll(prgForwORBack);
        prgForwardSid.addAll(prgForwORBack);
        Integer limit = this.cgLimitation;
        if (isTranCallGraph && this.cgLimitation != null) {
            limit = this.cgLimitation - 1;
        }
        this.analysis.addContextValue(CGLIMIT, (Object)limit);
        String q = String.format("select @rid.asString() as r from %s", inputORIDs);
        CloseableIterable prgUpdate = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(q)).execute(new Object[0]);
        inputORIDs.clear();
        for (OrientElement oe : prgUpdate) {
            inputORIDs.add((String)oe.getProperty("r"));
        }
        L.debug("computing programs calls");
        HashSet<String> idsSet = new HashSet<String>();
        if (!isPrgCallGraph) {
            idsSet.addAll(startPrgs);
            startPrgs.clear();
        } else {
            idsSet.addAll(inputORIDs);
        }
        if (isScreenCallGraph) {
            this.analysis.addContextValue(SCREEN_PRG_RIDS, (Object)com.ez.gdb.core.utils.Utils.makeStringBuilder(idsSet));
        }
        if (isTranCallGraph) {
            this.analysis.addContextValue(TRAN_PRG_RIDS, (Object)com.ez.gdb.core.utils.Utils.makeStringBuilder(idsSet));
        }
        monitor.worked(100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "collectingData.taskName"));
        CgBuilder cgBuilder = new CgBuilder(prjName, dbg, this.analysis, this.cgDirection);
        cgBuilder.computeCg(prgBackwardSid, prgForwardSid, prgWithoutSid, idsSet, monitor.newChild(200));
        monitor.done();
    }

    private Set<String> resolveAssembler(OrientBaseGraph dbg, Set<Integer> prgForwORBack, Set<Integer> assPrgForwORBack) {
        HashSet<String> assWithoutSid = new HashSet<String>();
        if (!assPrgForwORBack.isEmpty()) {
            String crid;
            CloseableIterable childrenPrg = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL("select $child.sid as csid, name, type, $anc.sid as asid, $anc.@rid.asString() as arid,  $child.asString() as crid  from ProgramProxy  \n let $anc = out('Ancestor')[0].out('ProxyFor')[0],  \n $child = ifnull(out('ProxyFor')[0], @rid, out('ProxyFor')[0].@rid) where aliasType = 0 and $anc.sid in ? ")).execute(new Object[]{assPrgForwORBack});
            if (childrenPrg.iterator().hasNext()) {
                Set<String> inputORIDs = this.getInputOrids();
                for (OrientElement elem : childrenPrg) {
                    Integer sid = (Integer)elem.getProperty("csid");
                    crid = (String)elem.getProperty("crid");
                    Integer asid = (Integer)elem.getProperty("asid");
                    inputORIDs.add(crid);
                    if (sid != null && sid != -1) {
                        prgForwORBack.add(sid);
                        String arid = (String)elem.getProperty("arid");
                        prgForwORBack.remove(asid);
                        inputORIDs.remove(arid);
                    } else {
                        String name = (String)elem.getProperty("name");
                        String type = elem.getProperty("type").toString();
                        assWithoutSid.add(QUOTE.concat(type).concat(name).concat(QUOTE));
                    }
                    assPrgForwORBack.remove(asid);
                }
            }
            if (!assPrgForwORBack.isEmpty()) {
                CloseableIterable prgInfo = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL("select @rid.asString() as arid from ProgramProxy where sid in ? ")).execute(new Object[]{assPrgForwORBack});
                Set<String> inputORIDs = this.getInputOrids();
                for (OrientElement elem : prgInfo) {
                    crid = (String)elem.getProperty("arid");
                    inputORIDs.add(crid);
                }
            }
        }
        return assWithoutSid;
    }

    private void processApiToPrg(OrientBaseGraph dbg, List<EZEntityID> inputs, Set<String> startPrgs, Set<Integer> prgSIDs) {
        HashSet<String> progNames = new HashSet<String>();
        HashSet<String> cicsTrans = new HashSet<String>();
        HashSet<String> imsTrans = new HashSet<String>();
        block4: for (EZEntityID id : inputs) {
            CatalogAPISg sg = (CatalogAPISg)id.getSegment(CatalogAPISg.class);
            if (sg == null) continue;
            ApiInterface n = sg.getNode();
            switch (n.getType()) {
                case API: {
                    List nodes = ((Node)n).getChildren();
                    if (nodes == null) break;
                    for (Node serv : nodes) {
                        this.processApiServices(progNames, cicsTrans, imsTrans, serv);
                    }
                    continue block4;
                }
                case SERVICE: {
                    this.processApiServices(progNames, cicsTrans, imsTrans, (Node)n);
                    break;
                }
            }
        }
        if (!progNames.isEmpty()) {
            StringBuilder namesStr = new StringBuilder();
            for (String name : progNames) {
                namesStr.append(QUOTE).append(name).append(QUOTE).append(",");
            }
            namesStr.deleteCharAt(namesStr.length() - 1);
            List<String> namesStrArray = Arrays.asList(namesStr.toString().split(","));
            String query = "select @rid as rid, name, sid, type from ProgramProxy where name in %s";
            query = String.format(query, namesStrArray);
            CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
            for (OrientElement oe : res) {
                String prgRid = ((OrientVertex)oe.getProperty("rid")).getIdentity().toString();
                startPrgs.add(prgRid);
                Integer sid = (Integer)oe.getProperty("sid");
                prgSIDs.add(sid);
            }
        }
        if (!imsTrans.isEmpty()) {
            StringBuilder sbInfo = new StringBuilder();
            for (String name : imsTrans) {
                sbInfo.append(QUOTE).append(name).append(QUOTE).append(",");
            }
            sbInfo.deleteCharAt(sbInfo.length() - 1);
            String prjName = (String)this.graphManager.getAttributeValue("mainframe project name");
            startPrgs.addAll(((CallGraphModel)this.graphModel).createTransactionContext(prjName, dbg, sbInfo, null, prgSIDs, prgSIDs, false));
        }
    }

    private void processApiServices(Set<String> progs, Set<String> cicsTrans, Set<String> imsTrans, Node serv) {
        String targetName = (String)serv.getInfo().get("target");
        ApiTargetType targetType = serv.getTargetType();
        switch (targetType) {
            case PROGRAM: {
                progs.add(targetName);
                break;
            }
            case IMS_TRANSACTION: {
                imsTrans.add(targetName);
                break;
            }
            case TRANSACTION: {
                cicsTrans.add(targetName);
                break;
            }
        }
    }

    private Triplet<Integer, Integer, Set<String>> classifyPrg(OrientBaseGraph dbg, EZSourceProgramIDSg prgIdSg, Set<Integer> prgSIDs) {
        Integer prgForwORBack = null;
        Integer assPrgForwORBack = null;
        HashSet<String> prgWithoutSid = new HashSet<String>();
        Integer sid = prgIdSg.getProgramId();
        if (sid != null && sid != -1 && prgIdSg.getOccur() != null && prgIdSg.getOccur().booleanValue()) {
            prgSIDs.add(sid);
        } else if (prgIdSg.getOdbRID() != null) {
            Set<String> inputORIDs = this.getInputOrids();
            inputORIDs.add(prgIdSg.getOdbRID());
        }
        if (sid == null || sid == -1 || prgIdSg.getOccur() != null && !prgIdSg.getOccur().booleanValue()) {
            String query;
            CloseableIterable res;
            boolean considerPrg = true;
            if (prgIdSg.getTypeId() == 8 && (res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL((query = "select type.append(name) as det from ProgramProxy \n let $a = out('Ancestor')[0] \n where ( type = 15 or type = 16 ) and ( ($a.name= 'MARKER' and $a.type=8) ) ").replace("MARKER", prgIdSg.getProgramName()))).execute(new Object[0])).iterator().hasNext()) {
                considerPrg = false;
                for (OrientElement oe : res) {
                    prgWithoutSid.add(QUOTE.concat((String)oe.getProperty("det")).concat(QUOTE));
                }
            }
            if (considerPrg) {
                prgWithoutSid.add(QUOTE.concat(prgIdSg.getTypeId().toString()).concat(prgIdSg.getProgramName()).concat(QUOTE));
            } else {
                Set<String> inputORIDs = this.getInputOrids();
                inputORIDs.remove(prgIdSg.getOdbRID());
            }
        } else {
            if (prgIdSg.getTypeId() == 8 || prgIdSg.getTypeId() == 13) {
                assPrgForwORBack = sid;
            }
            prgForwORBack = sid;
        }
        return new Triplet((Object)prgForwORBack, (Object)assPrgForwORBack, prgWithoutSid);
    }

    private Set<String> processJclToPrg(OrientBaseGraph dbg, StringBuilder sbInfo, Set<Integer> prgForwORBack, Set<String> prgWithoutSid) {
        String query = commandJCL_PGM_WITH_SID.replace("@@@@@EZLEGACY@@@@", sbInfo.toString());
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        Set<String> inputORIDs = this.getInputOrids();
        ArrayList<String[]> info = new ArrayList<String[]>();
        HashSet<String> startPrgs = new HashSet<String>();
        for (OrientElement oe : res) {
            String jRid = (String)oe.getProperty("jobrid");
            inputORIDs.add(jRid);
            Iterable steps = (Iterable)oe.getProperty("steps");
            for (OrientVertex stepV : steps) {
                Iterator jclPgmVIt = stepV.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"ExecPGM"}).iterator();
                String stepRid = stepV.getId().toString();
                boolean hasPgms = false;
                while (jclPgmVIt.hasNext()) {
                    Vertex jclPgmV = (Vertex)jclPgmVIt.next();
                    Iterator it = jclPgmV.getVertices(com.tinkerpop.blueprints.Direction.IN, new String[]{"ContextOf"}).iterator();
                    hasPgms = true;
                    boolean matchPgmToPrg = false;
                    if (it.hasNext()) {
                        Vertex pgmContextV = (Vertex)it.next();
                        Iterable edges = pgmContextV.getEdges(com.tinkerpop.blueprints.Direction.IN, new String[]{"InContext"});
                        for (Edge e : edges) {
                            Boolean isPgm = (Boolean)e.getProperty("pgm");
                            if (isPgm == null || !isPgm.booleanValue()) continue;
                            OrientVertex prgProxyV = (OrientVertex)e.getVertex(com.tinkerpop.blueprints.Direction.OUT);
                            Integer sid = (Integer)prgProxyV.getProperty("sid");
                            String rid = ((CallGraphModel)this.graphModel).getPrgOrProxyRid((Vertex)prgProxyV);
                            info.add(new String[]{jRid, stepRid, rid});
                            startPrgs.add(rid);
                            if (sid == null || sid == -1) {
                                String name = (String)prgProxyV.getProperty("name");
                                String type = prgProxyV.getProperty("type").toString();
                                prgWithoutSid.add(QUOTE.concat(type).concat(name).concat(QUOTE));
                            } else {
                                prgForwORBack.add(sid);
                            }
                            matchPgmToPrg = true;
                        }
                    }
                    if (matchPgmToPrg) continue;
                    String[] stringArray = new String[4];
                    stringArray[0] = jRid;
                    stringArray[1] = stepRid;
                    stringArray[3] = jclPgmV.getId().toString();
                    info.add(stringArray);
                }
                if (hasPgms) continue;
                String[] stringArray = new String[4];
                stringArray[0] = jRid;
                stringArray[1] = stepRid;
                info.add(stringArray);
            }
        }
        this.analysis.addContextValue(JCL_PGM_INFO, info);
        return startPrgs;
    }

    private StringBuilder processScrToPrg(OrientBaseGraph dbg, StringBuilder sbInfo, Set<Integer> prgForwORBack, Set<Integer> prgSIDs) {
        String query = command_SCREEN_PRG.replace("@@@@@EZLEGACY@@@@", sbInfo.toString());
        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        ArrayList<String> info = new ArrayList<String>();
        StringBuilder tranSB = new StringBuilder();
        String prjName = this.getPrjName();
        Set inputORIDs = this.analysis.getContextSetValue(CgBuilder.getKey(prjName, INPUT_ORIDS));
        for (OrientElement oe : res) {
            Vertex mflInfo;
            Iterator itt;
            OrientVertex tRidV;
            Iterator it;
            String sRid = (String)oe.getProperty("scrRid");
            inputORIDs.add(sRid);
            String prgs = (String)oe.getProperty("prgs");
            prgs = prgs.substring(1, prgs.length() - 1);
            if (!prgs.isEmpty()) {
                String[] prgSids;
                String[] stringArray = prgSids = prgs.split(",");
                int n = prgSids.length;
                int n2 = 0;
                while (n2 < n) {
                    String sid = stringArray[n2];
                    Integer prgSid = Integer.valueOf(sid.trim());
                    prgForwORBack.add(prgSid);
                    prgSIDs.add(prgSid);
                    ++n2;
                }
            } else if (this.cgLimitation == null || this.cgLimitation > 0) {
                L.debug("try to see if the screen is generic and is mapped with a program");
                OrientVertex sRidV = dbg.getVertex((Object)sRid);
                it = sRidV.getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"ScreenMapping"}).iterator();
                if (it.hasNext()) {
                    OrientVertex mappedPrgProxyV = (OrientVertex)it.next();
                    Integer prgSid = (Integer)mappedPrgProxyV.getProperty("sid");
                    prgForwORBack.add(prgSid);
                    prgSIDs.add(prgSid);
                }
            }
            info.add(sRid);
            if (!Direction.doBackward((Direction)this.cgDirection) || this.cgLimitation != null && this.cgLimitation <= 0 || !(it = (tRidV = dbg.getVertex((Object)sRid)).getVertices(com.tinkerpop.blueprints.Direction.OUT, new String[]{"IMSModProxyOf"}).iterator()).hasNext() || !(itt = (mflInfo = (Vertex)it.next()).getVertices(com.tinkerpop.blueprints.Direction.IN, new String[]{"tranCODE"}).iterator()).hasNext()) continue;
            Vertex mappedTranProxy = (Vertex)itt.next();
            String tranName = QUOTE.concat(mappedTranProxy.getProperty("name").toString()).concat(QUOTE);
            if (tranSB.length() > 0) {
                tranSB.append(", ");
            }
            tranSB.append(tranName);
        }
        this.analysis.addContextValue(SCR_PRG_INFO, info);
        return tranSB;
    }

    private String getPrjName() {
        return (String)this.analysis.getContextValue("input_project_names");
    }

    private Set<String> getInputOrids() {
        return ((CallGraphModel)this.graphModel).getInputOrids();
    }

    private Triplet<Boolean, Boolean, Boolean> computeCgType() {
        boolean isJobCg = this.analysis.getContextValue(ANALYSIS_JOB_KEY) != null ? (Boolean)this.analysis.getContextValue(ANALYSIS_JOB_KEY) : false;
        boolean isScreenCg = this.analysis.getContextValue(ANALYSIS_SCREEN_KEY) != null ? (Boolean)this.analysis.getContextValue(ANALYSIS_SCREEN_KEY) : false;
        boolean isTranCg = this.analysis.getContextValue(ANALYSIS_TRANSACTION_KEY) != null ? (Boolean)this.analysis.getContextValue(ANALYSIS_TRANSACTION_KEY) : false;
        return new Triplet((Object)isJobCg, (Object)isScreenCg, (Object)isTranCg);
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor pmonitor, IStatus result) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)monitor, result);
        if (this.gfi != null) {
            this.addFilters(this.gfi);
            HashSet allNodes = new HashSet();
            List graphs = this.graphModel.getGraphs();
            for (TSEGraph gr : graphs) {
                allNodes.addAll(gr.nodes());
            }
            if (this.graphModel != null) {
                this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
            }
        }
        monitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((CallGraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph);
                if (layoutCommand != null) break;
                layoutCommand = super.doLayout(type, graph);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        boolean isJobCallgraph = this.analysis.getContextValue(ANALYSIS_JOB_KEY) != null;
        Utils.addMainframeNodesToLegend((LegendPanel)legend, (int)uiStyle, (boolean)isJobCallgraph, (Set)this.graphModel.getNodeTypesForLegend());
        this.addEdgesToLegend(legend);
        com.ez.gdb.core.utils.Utils.addRestrictionMarkersToLegend((LegendPanel)legend, (Set)this.graphModel.getRestrictionTypesForLegend());
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(ADSDialogProgramNode.class);
        gfi.registerFilterType(ADSProcessProgramNode.class);
        gfi.registerFilterType(AlgolProgramNode.class);
        gfi.registerFilterType(AssemblerProgramNode.class);
        gfi.registerFilterType(AsmCsectProgramNode.class);
        gfi.registerFilterType(AsmEntryProgramNode.class);
        gfi.registerFilterType(CLProgramNode.class);
        gfi.registerFilterType(CobolProgramNode.class);
        gfi.registerFilterType(FortranProgramNode.class);
        gfi.registerFilterType(JCLJobNode.class);
        gfi.registerFilterType(JCLPgmNode.class);
        gfi.registerFilterType(NaturalProgramNode.class);
        gfi.registerFilterType(PLIProgramNode.class);
        gfi.registerFilterType(EZRexxProgramNode.class);
        gfi.registerFilterType(SCLProgramNode.class);
        gfi.registerFilterType(SmartDbModuleProgramNode.class);
        gfi.registerFilterType(SmartSubroutineNode.class);
        gfi.registerFilterType(UnknownProgramNode.class);
        gfi.registerFilterType(AdabasNode.class);
        gfi.registerFilterType(AdsMapNode.class);
        gfi.registerFilterType(ResourceFileNode.class);
        gfi.registerFilterType(ResourceSQLTableNode.class);
        gfi.registerFilterType(ResourceDatacomTableNode.class);
        gfi.registerFilterType(NaturalMapNode.class);
        gfi.registerFilterType(IdmsSetNode.class);
        gfi.registerFilterType(IdmsRecordNode.class);
        gfi.registerFilterType(TransactionNode.class);
        gfi.registerFilterType(QueueNode.class);
        gfi.registerFilterType(QueueManagerNode.class);
        gfi.registerFilterType(PrinterFileNode.class);
        gfi.registerFilterType(SmartScreenNode.class);
        gfi.registerFilterType(CLFileNode.class);
        gfi.registerFilterType(IMSDBNode.class);
        gfi.registerFilterType(TerminalNode.class);
        gfi.registerFilterType(TerminalOrTransactionNode.class);
        gfi.registerFilterType(TPMSXMapNode.class);
        gfi.registerFilterType(DBFileNode.class);
        gfi.registerFilterType(DALFileNode.class);
        gfi.registerFilterType(DBINode.class);
        gfi.registerFilterType(IMSDBSegmentNode.class);
        gfi.registerFilterType(IMSDBLogicSegmentNode.class);
        gfi.registerFilterType(ScreenNode.class);
        gfi.registerFilterType(IMSTransactionNode.class);
        gfi.registerFilterType(ApiNode.class);
        gfi.registerFilterType(ApiServiceNode.class);
        gfi.registerFilterType(GenericTransactionNode.class);
        gfi.registerFilterType(GenericMapNode.class);
        gfi.registerFilterType(JavaProgramNode.class);
    }

    public void closing() {
        super.closing();
    }

    public class GraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;
        private Image screenImage;
        private Image transactionImage;
        private Image jobImage;

        public GraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage((String)"screenCallgraph", (String)"icons/screen_callgraph.png");
            SharedImages.registerImage((String)"transactionCallgraph", (String)"icons/Transaction.png");
            SharedImages.registerImage((String)"jobCallgraph", (String)"icons/jobcallgraph.png");
            SharedImages.registerImage((String)"programCallgraph", (String)"icons/programcall.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_SCREEN_KEY) != null) {
                if (this.screenImage == null) {
                    this.screenImage = SharedImages.getImage((String)"screenCallgraph");
                    return this.screenImage;
                }
            } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_TRANSACTION_KEY) != null) {
                if (this.transactionImage == null) {
                    this.transactionImage = SharedImages.getImage((String)"transactionCallgraph");
                    return this.transactionImage;
                }
            } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_JOB_KEY) != null && this.jobImage == null) {
                this.jobImage = SharedImages.getImage((String)"jobCallgraph");
                return this.jobImage;
            }
            if (this.image == null) {
                this.image = SharedImages.getImage((String)"programCallgraph");
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            StringBuffer buf = new StringBuffer();
            List inputs = CallGraphJob.this.analysis.getContextListValue("input_list");
            String inputsTextCount = "";
            if (inputs != null) {
                int idx = 0;
                int all = inputs.size();
                for (EZEntityID input : inputs) {
                    if (truncate && idx >= 10) {
                        inputsTextCount = String.valueOf(inputsTextCount) + (all - idx);
                        break;
                    }
                    ++idx;
                    if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_TRANSACTION_KEY) != null) {
                        EZSourceTransactionIDSg trIdSg = (EZSourceTransactionIDSg)input.getSegment(EZSourceTransactionIDSg.class);
                        String transactionName = trIdSg.getTransactionName();
                        buf.append(transactionName);
                    } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_SCREEN_KEY) != null) {
                        EZSourceScreenIDSg scrIdSg = (EZSourceScreenIDSg)input.getSegment(EZSourceScreenIDSg.class);
                        buf.append(scrIdSg.getScreenNameToPrint());
                    } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_JOB_KEY) != null) {
                        EZSourceJobIDSg jobIdSg = (EZSourceJobIDSg)input.getSegment(EZSourceJobIDSg.class);
                        buf.append(jobIdSg.getJobExpandedName());
                    } else if (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_API_KEY) != null) {
                        CatalogAPISg apiSg = (CatalogAPISg)input.getSegment(CatalogAPISg.class);
                        buf.append(apiSg.getNode().getName());
                    } else {
                        EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)input.getSegment(EZSourceProgramIDSg.class);
                        buf.append(prgIdSg.getListableName());
                    }
                    if (inputs.indexOf(input) == inputs.size() - 1) continue;
                    buf.append(", ");
                }
            }
            String type = CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_JOB_KEY) != null ? Messages.getString(CallGraphJob.class, "job.type") : (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_SCREEN_KEY) != null ? Messages.getString(CallGraphJob.class, "screen.type") : (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_TRANSACTION_KEY) != null ? Messages.getString(CallGraphJob.class, "transaction.type") : (CallGraphJob.this.analysis.getContextValue(CallGraphJob.ANALYSIS_API_KEY) != null ? Messages.getString(CallGraphJob.class, "api.type") : Messages.getString(CallGraphJob.class, "program.type"))));
            if (inputsTextCount.isEmpty()) {
                CallGraphJob.this.tabName = Messages.getString(CallGraphJob.class, "tab.name", new String[]{buf.toString(), CallGraphJob.this.analysis.getContextValue("input_project_names").toString(), type});
            } else {
                CallGraphJob.this.tabName = Messages.getString(CallGraphJob.class, "tab.name.with.more", new String[]{buf.toString(), inputsTextCount, CallGraphJob.this.analysis.getContextValue("input_project_names").toString(), type});
            }
            return CallGraphJob.this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(CallGraphJob.this.tabName);
            if (CallGraphJob.this.cgDirection != null) {
                if (CallGraphJob.this.isCgLimited != null && CallGraphJob.this.isCgLimited.booleanValue()) {
                    buf.append(Messages.getString(CallGraphJob.class, "tooltip.text.cgDir.cgLim", new String[]{CallGraphJob.this.cgDirection.toString(), CallGraphJob.this.cgLimitation.toString()}));
                } else {
                    buf.append(Messages.getString(CallGraphJob.class, "tooltip.text.cgDir", new String[]{CallGraphJob.this.cgDirection.toString()}));
                }
            } else if (CallGraphJob.this.isCgLimited != null && CallGraphJob.this.isCgLimited.booleanValue()) {
                buf.append(Messages.getString(CallGraphJob.class, "tooltip.text.cgLim", new String[]{CallGraphJob.this.cgLimitation.toString()}));
            }
            if (GraphUtils.cgToOtherPrj(CallGraphJob.this.graphManager)) {
                buf.append(Messages.getString(CallGraphJob.class, "tooltip.expand.other.prj"));
            }
            return buf.toString();
        }

        public ComponentBuilderInterface getLegendControl() {
            ComponentBuilderInterface cbi = new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    CallGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    Utils.setImageProvider((LegendPanel)CallGraphJob.this.legend);
                    int uiStyle = CallGraphJob.this.graphModel.getUIStyle();
                    CallGraphJob.this.addEntriesToLegend(CallGraphJob.this.legend, uiStyle, GraphInfo.this.gfi);
                    sc.setContent((Control)CallGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    CallGraphJob.this.legend.pack();
                    sc.setMinSize(CallGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((CallGraphJob)((GraphInfo)GraphInfo.this).CallGraphJob.this).legend.getSize().x;
                    int x = ((CallGraphJob)((GraphInfo)GraphInfo.this).CallGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
            return cbi;
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            if (CallGraphJob.this.legend != null) {
                CallGraphJob.this.legend.dispose();
                CallGraphJob.this.legend = null;
            }
            if (this.screenImage != null) {
                this.screenImage = null;
            }
            if (this.transactionImage != null) {
                this.transactionImage = null;
            }
            if (this.jobImage != null) {
                this.jobImage = null;
            }
            super.dispose();
        }
    }
}

