/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.jobcg;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphJob;
import com.ez.graphs.viewer.callgraph.programcallgraph.ProgramCallGraphInputsFilter;
import com.ez.graphs.viewer.callgraph.programcallgraph.ProgramCallGraphSettingsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.List;

public class JobCallGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected CallGraphJob job = null;
    private static final String wizardName = Messages.getString(JobCallGraphAnalysis.class, "wizard.title.jobcallgraph");

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CallGraphJob)wk.getJob(id, CallGraphJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public void setInputs(List inputs) {
        super.setInputs(inputs);
        Boolean showOtherPrj = WorkspacePrefUtils.getPreferenceStore().getBoolean("showCgOtherPrj");
        this.addContextValue("continueCG_otherPrj_analysis", showOtherPrj);
        this.addContextValue("JOB_CALLGRAPH", Boolean.TRUE);
        String prjName = (String)this.getContextValue("input_project_names");
        this.addContextValue("env", ConnectionUtils.getODBSettings((String)prjName));
        this.addContextValue("graph direction: forward or backward or both", Direction.FORWARD);
    }

    public String getLabelType() {
        return Messages.getString(JobCallGraphAnalysis.class, "properties.labelType");
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_JOB_CALLGRAPH_ANALYSIS;
    }

    protected InputsFilter getInputsFilter() {
        Object iFilter = null;
        List inputs = this.getContextListValue("input_list");
        String jobPageDesc = Messages.getString(JobCallGraphAnalysis.class, "page.description");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            EZEntityID entID = ((EZObjectType)inputs.get(0)).getEntID();
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entID.getSegment(EZSourceProjectIDSg.class);
            iFilter = new ProgramCallGraphInputsFilter(prjSg.getProjectInfo(), this.getAnalysisType(), wizardName, jobPageDesc, false);
        } else {
            iFilter = new ProgramCallGraphSettingsFilter(wizardName, false, false);
        }
        return iFilter;
    }

    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (ret) {
            AbstractAnalysis a2 = (AbstractAnalysis)obj;
            if (ret) {
                Boolean isLimited1 = (Boolean)this.getContextValue("is graph limited");
                isLimited1 = isLimited1 == null ? false : isLimited1;
                Boolean isLimited2 = (Boolean)a2.getContextValue("is graph limited");
                if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
                    ret = false;
                }
                if (ret && isLimited1.booleanValue()) {
                    Integer cgLimitation1 = (Integer)this.getContextValue("limit number for graph levels");
                    Integer cgLimitation2 = (Integer)a2.getContextValue("limit number for graph levels");
                    if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                        ret = false;
                    }
                }
                if (ret) {
                    Boolean showOtherPrj = (Boolean)this.getContextValue("continueCG_otherPrj_analysis");
                    ret = showOtherPrj.equals(a2.getContextValue("continueCG_otherPrj_analysis"));
                }
            }
        }
        return ret;
    }
}

