/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact.varLvl.singlePath;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.ImpactComponentBuilderAdapter;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphFilterInfo;
import com.ez.graphs.viewer.callgraph.impact.varLvl.ImpactVarLevelGraphAnalysisJob;
import com.ez.graphs.viewer.callgraph.impact.varLvl.ImpactVarLevelGraphModel;
import com.ez.graphs.viewer.callgraph.impact.varLvl.ImpactVarLevelMouseActionHook;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.inputs.EZSourceImpactEdgesIdSg;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactVarLevelSingleGraphAnalysisJob
extends AnnotatedGraphJob {
    private static final Logger L = LoggerFactory.getLogger(ImpactVarLevelGraphAnalysisJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;

    public ImpactVarLevelSingleGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new ImpactVarLevelMouseActionHook(id);
        this.initGraphDetails();
        this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
    }

    protected void initGraphDetails() {
        this.graphInfo = new ImpactVarLvlGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new ImpactGraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.graphModel = new ImpactVarLevelGraphModel(new AnalysisGraphManager(), this.analysis);
        ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
        icp.setHasExport(true);
        this.graphInfo.setContentProvider((StructureContentProvider)icp);
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        L.debug("impact variable level single graph - computeResults");
        super.computeResults(graphModel, monitor);
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(ImpactVarLevelGraphAnalysisJob.class, "collectingData.taskName"));
        this.processInputs((IProgressMonitor)pmonitor.newChild(100));
        pmonitor.setWorkRemaining(0);
    }

    private void processInputs(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        pmonitor.setTaskName(Messages.getString(ImpactVarLevelGraphAnalysisJob.class, "compute.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        Iterator iterator = inputs.iterator();
        if (iterator.hasNext()) {
            EZSourceImpactEdgesIdSg sg = (EZSourceImpactEdgesIdSg)iterator.next();
            Map pathNodes = sg.getEdgeIds();
            this.analysis.addContextValue("edgesPath", (Object)pathNodes);
        }
        pmonitor.setWorkRemaining(0);
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("do specific constraints layout");
                layoutCommand = ((ImpactVarLevelGraphModel)this.graphModel).createCustomHLayoutCommand((TSDGraph)graph);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.getString(ImpactVarLevelGraphAnalysisJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)pmonitor.newChild(50), result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addFilters(GraphFilterInfo gfi) {
    }

    class ImpactVarLvlGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public ImpactVarLvlGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/impact_graph.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            ProjectInfo ezsourcePrj = (ProjectInfo)ImpactVarLevelSingleGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            String inp = (String)ImpactVarLevelSingleGraphAnalysisJob.this.analysis.getContextValue("inputs name string");
            if (inp.length() > 20) {
                inp = inp.substring(0, 17);
                inp = String.valueOf(inp) + "...";
            }
            StringBuilder sb = new StringBuilder(inp);
            sb.append(" ");
            sb.append(Messages.getString(ImpactVarLevelGraphAnalysisJob.class, "tab.lbl", new String[]{ezsourcePrj.getName()}));
            this.tabName = sb.toString();
            return this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(this.tabName);
            return buf.toString();
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ImpactComponentBuilderAdapter(ImpactVarLevelSingleGraphAnalysisJob.this.legend, ImpactVarLevelSingleGraphAnalysisJob.this.graphModel, this.gfi);
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }
}

