/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact.varLvl;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.impact.ImpactAnnotatedGraphModel;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphEdgeLegendInfo;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.PathLabelObj;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.inputs.EZImpactVarLvlSingleInputType;
import com.ez.graphs.viewer.odb.analysis.inputs.EZSourceImpactEdgesIdSg;
import com.ez.graphs.viewer.odb.analysis.inputs.ImpactVarLvlContext;
import com.ez.graphs.viewer.odb.impact.model.ExpandAtOffsets;
import com.ez.graphs.viewer.odb.impact.model.INodeExpander;
import com.ez.graphs.viewer.odb.impact.model.IStopTest;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.MGUtil;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.graphs.viewer.odb.impact.model.disk.DiskGraph;
import com.ez.internal.analysis.config.context.IgnoreContext;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.utils.FileUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.geometry.shared.TSRoundedRectangleShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEConnector;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.ui.TSObjectUI;
import com.tomsawyer.graphicaldrawing.ui.simple.TSECurvedEdgeUI;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSBaseLayoutWorker;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSLayoutOperationCommand;
import com.tomsawyer.interactive.command.editing.TSSwingLayoutWorker;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import com.tomsawyer.util.shared.TSProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactVarLevelGraphModel
extends ImpactAnnotatedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactVarLevelGraphModel.class);
    private static final String RELATED_PRG_TSNODE_ATTRIBUTE = "prgNode realted with variable";
    private static final String VARIABLE_TSNODES = "variable_nodes related to a prg ts node";
    public static final String EDGES_LISTS_FOR_PATH = "list with edges for a specific path";
    private static final String DATA_FLOW_ORID_LIST = "DataFlowORIDList";
    private static final String VERTEX_ID = "VERTEX_ID";
    private static final String STMT_DESCRIPTION_QUERY = "select set(type).asString() as types from ? ";
    private int nn = 0;
    private File igFolder;
    private Integer index = new Integer(0);
    private Integer generalIndex = new Integer(0);
    private Integer maxIndex = 0;
    private int rows = 0;
    private boolean isSinglePath = false;

    public ImpactVarLevelGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = (MainframeGraphAnalysis)analysis;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        nodeBuilder.setShape((TSShape)new TSRoundedRectangleShape(0.2, true));
        nodeBuilder.setAttribute("Line_Width", (Object)0.0);
        this.igFolder = (File)this.analysis.getContextValue("ig folder");
        this.ig = this.igFolder != null ? new DiskGraph(true, this.igFolder, null) : (ImpactGraph)this.analysis.getContextValue("impact graph");
        AtomicInteger diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count");
        diskCount.incrementAndGet();
        this.createOrientGraph((Properties)this.analysis.getContextValue("env"));
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.index = 0;
        this.generalIndex = 0;
        this.maxIndex = 0;
        this.rows = 0;
        this.outForGISV.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)150);
        monitor.setTaskName(Messages.getString(ImpactVarLevelGraphModel.class, "loading.graph"));
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.initGraph();
        this.graphManager.startBatchProcessing(true);
        Boolean forward = (Boolean)this.analysis.getContextValue("forward_key");
        List paths = (List)this.analysis.getContextValue("paths");
        if (paths != null) {
            this.buildAllPaths(forward, paths, (IProgressMonitor)monitor.newChild(100));
        } else {
            this.isSinglePath = true;
            this.buildSinglePath(forward, (IProgressMonitor)monitor.newChild(100));
        }
        monitor.worked(40);
        this.graphManager.endBatchProcessing();
        this.edgeTypesSetForLegend.add(ImpactGraphEdgeLegendInfo.DOTTED_PATH);
        this.findAnnotations(monitor.newChild(10));
        monitor.setWorkRemaining(0);
    }

    private void buildAllPaths(boolean forward, List<Triplet<Long, Long, Set<List<Long>>>> paths, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        boolean found = false;
        Iterator iterator = this.ig.getSpecialNodes(1).iterator();
        if (iterator.hasNext()) {
            Long cfr_ignored_0 = (Long)iterator.next();
            found = true;
        }
        final boolean noDSNode = !found;
        IStopTest stopTester = new IStopTest(){

            public boolean shouldStop(Node node) {
                return noDSNode ? false : 1 == node.value().type();
            }

            public boolean handlePathOnNoExpand() {
                return noDSNode;
            }
        };
        VarPathHandler ph = new VarPathHandler(noDSNode, forward);
        ExpandAtOffsets expOffs = new ExpandAtOffsets();
        for (Triplet<Long, Long, Set<List<Long>>> path : paths) {
            long start = System.currentTimeMillis();
            Long firstNodeLong = (Long)path.getFirst();
            Long lastNodeLong = (Long)path.getSecond();
            Set programIds = (Set)path.getThird();
            ArrayList<Long> startList = new ArrayList<Long>();
            startList.add(firstNodeLong);
            HashMap<TSENode, List<String>> uniquePaths = new HashMap<TSENode, List<String>>();
            ph.setUniquePaths(uniquePaths);
            ph.setLastNodeLong(lastNodeLong);
            ph.setRowNumber(this.rows);
            expOffs.setPrgs(programIds);
            MGUtil.allPathsDepthFirst(startList, (ImpactGraph)this.ig, (boolean)true, (PathHandler)ph, null, (int)1, (IStopTest)stopTester, (INodeExpander)expOffs, null, null, (boolean)false, (IProgressMonitor)monitor.newChild(100));
            this.maxIndex = Math.max(this.maxIndex, this.index);
            String p = this.ig.getNode((Long)path.getFirst()).value() + " to " + this.ig.getNode((Long)path.getSecond()).value();
            L.debug("finished var level for pair {} in {} ms", (Object)p, (Object)(System.currentTimeMillis() - start));
        }
        ph.uniquePaths.clear();
    }

    protected Pair<TSENode, List<String>> verifyIfAlreadyExists(Map<TSENode, List<String>> uniquePaths, List<Pair<Long, Long>> nodes) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Pair<Long, Long> triplet : nodes) {
            String id = String.valueOf(triplet.getFirst());
            ids.add(id);
        }
        for (TSENode key : uniquePaths.keySet()) {
            List<String> l = uniquePaths.get(key);
            if (!l.equals(ids)) continue;
            return new Pair((Object)key, ids);
        }
        return new Pair(null, ids);
    }

    private String getFromToInfo(boolean forward, List<TSNode> listts) {
        StringBuilder sb = new StringBuilder();
        if (listts != null && listts.size() > 1) {
            TSNode tsNode1 = forward ? listts.get(0) : listts.get(listts.size() - 1);
            TSNode tsNode2 = forward ? listts.get(listts.size() - 1) : listts.get(0);
            sb.append(Messages.getString(ImpactVarLevelGraphModel.class, "from.to.lbl", new Object[]{tsNode1.getName(), tsNode2.getName()}));
        }
        return sb.toString();
    }

    private void buildSinglePath(boolean forward, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        LinkedHashMap paths = (LinkedHashMap)this.analysis.getContextValue("edgesPath");
        ArrayList tsNodes = new ArrayList();
        HashMap prgNodesMap = new HashMap();
        this.graph.setAttribute("p" + this.index, prgNodesMap);
        this.graph.setAttribute("t" + this.index, tsNodes);
        HashMap<String, TSENode> sourceTSNodeMap = null;
        for (Long edgeLong : paths.keySet()) {
            TSENode sourceTSNode;
            Link link = this.ig.getLink(edgeLong);
            Set orid = (Set)paths.get(edgeLong);
            TSEEdge edge = null;
            HashMap<String, TSENode> targetTSNodeMap = new HashMap<String, TSENode>();
            long fromLong = link.from();
            long targetLong = link.to();
            Value pv = this.ig.getNode(Long.valueOf(fromLong)).value();
            Value tv = this.ig.getNode(Long.valueOf(targetLong)).value();
            if (link.info("DDCard") != null) {
                sourceTSNode = null;
                sourceTSNode = sourceTSNodeMap == null || sourceTSNodeMap.get(pv.id()) == null ? this.getTSNode(this.index, fromLong, true, true) : (TSENode)sourceTSNodeMap.get(pv.id());
                TSENode targetTSNode = this.getTSNode(this.index, targetLong, true, true);
                edge = forward ? this.graphManager.getEdgeBuilder().addEdge(this.graphManager, sourceTSNode, targetTSNode) : this.graphManager.getEdgeBuilder().addEdge(this.graphManager, targetTSNode, sourceTSNode);
                TSEdgeLabel lbl = edge.addLabel();
                lbl.setName(orid != null ? orid : link.info("link"));
                this.computeStmtsFromDataflow(false, orid, edge);
                targetTSNodeMap.put(tv.id(), targetTSNode);
            } else if (orid != null) {
                TSENode tsNode1;
                sourceTSNode = null;
                if (sourceTSNodeMap == null) {
                    sourceTSNode = this.getTSNode(this.index, fromLong, true, true);
                    sourceTSNodeMap = new HashMap();
                    sourceTSNodeMap.put(pv.id(), sourceTSNode);
                }
                Integer pmo = (Integer)pv.getContext("memOffset");
                Integer pio = (Integer)pv.getContext("impactedOffset");
                Integer pis = (Integer)pv.getContext("impactedSize");
                Integer tmo = (Integer)tv.getContext("memOffset");
                Integer tio = (Integer)tv.getContext("impactedOffset");
                Integer tis = (Integer)tv.getContext("impactedSize");
                HashMap<String, TSENode> firstNodes = new HashMap<String, TSENode>();
                HashMap<String, TSENode> lastNodes = new HashMap<String, TSENode>();
                ArrayList<String> edgesInfo = new ArrayList<String>();
                for (String o : orid) {
                    String secondRid;
                    TSENode tsNode2;
                    OrientElement dfEdge = this.dbg.getElement((Object)o);
                    if ("DataFlow".equals(dfEdge.getProperty("@class"))) {
                        OrientVertex secondV;
                        OrientVertex firstV = ((OrientEdge)dfEdge).getVertex(forward || link.info("reverse impact direction") != null ? Direction.OUT : Direction.IN);
                        String firstRid = firstV.getId().toString();
                        TSENode tsNode12 = (TSENode)firstNodes.get(firstRid);
                        if (tsNode12 == null) {
                            if (sourceTSNodeMap != null && sourceTSNodeMap.get(firstRid) != null) {
                                tsNode12 = (TSENode)sourceTSNodeMap.get(firstRid);
                                firstNodes.put(firstRid, tsNode12);
                            } else {
                                tsNode12 = (TSENode)this.graph.addNode();
                                tsNode12.setAttribute(VERTEX_ID, (Object)firstRid);
                                this.setNodeUI(tsNode12, (String)firstV.getProperty("@class"));
                                ((List)this.graph.getAttributeValue("t" + this.index)).add(tsNode12);
                                String name = (String)firstV.getProperty("name");
                                if ("Variable".equals(firstV.getProperty("@class"))) {
                                    name = com.ez.graphs.viewer.odb.utils.Utils.translateOffToVarChild((Vertex)firstV, (String)pv.getVertexName(), (Integer)pmo, (Integer)pio, (Integer)pis);
                                }
                                tsNode12.setName((Object)name);
                                firstNodes.put(firstRid, tsNode12);
                            }
                        }
                        if ((tsNode2 = (TSENode)lastNodes.get(secondRid = (secondV = ((OrientEdge)dfEdge).getVertex(forward || link.info("reverse impact direction") != null ? Direction.IN : Direction.OUT)).getId().toString())) == null) {
                            tsNode2 = (TSENode)this.graph.addNode();
                            tsNode2.setAttribute(VERTEX_ID, (Object)secondRid);
                            this.setNodeUI(tsNode2, (String)secondV.getProperty("@class"));
                            ((List)this.graph.getAttributeValue("t" + this.index)).add(tsNode2);
                            String name = (String)secondV.getProperty("name");
                            if ("Variable".equals(secondV.getProperty("@class"))) {
                                name = com.ez.graphs.viewer.odb.utils.Utils.translateOffToVarChild((Vertex)secondV, (String)tv.getVertexName(), (Integer)tmo, (Integer)tio, (Integer)tis);
                            } else if ("SQLFieldProxy".equals(secondV.getProperty("@class"))) {
                                String tn = (String)secondV.getProperty("tableName");
                                name = String.valueOf(name) + "-" + tn;
                            }
                            tsNode2.setName((Object)name);
                            lastNodes.put(secondRid, tsNode2);
                            targetTSNodeMap.put(secondRid, tsNode2);
                        }
                        edgesInfo.add(String.valueOf(firstRid) + "|" + secondRid + "|" + o + "|" + true);
                        continue;
                    }
                    OrientVertex apui = (OrientVertex)dfEdge;
                    Vertex firstV = (Vertex)apui.getVertices(Direction.OUT, new String[]{"APDefinedBy"}).iterator().next();
                    String firstRid = firstV.getId().toString();
                    tsNode1 = (TSENode)firstNodes.get(firstRid);
                    if (tsNode1 == null) {
                        if (sourceTSNodeMap != null && sourceTSNodeMap.get(firstRid) != null) {
                            tsNode1 = (TSENode)sourceTSNodeMap.get(firstRid);
                            firstNodes.put(firstRid, tsNode1);
                        } else {
                            tsNode1 = (TSENode)this.graph.addNode();
                            tsNode1.setAttribute(VERTEX_ID, (Object)firstRid);
                            this.setNodeUI(tsNode1, (String)firstV.getProperty("@class"));
                            ((List)this.graph.getAttributeValue("t" + this.index)).add(tsNode1);
                            String name = (String)firstV.getProperty("name");
                            if ("Variable".equals(firstV.getProperty("@class"))) {
                                name = com.ez.graphs.viewer.odb.utils.Utils.translateOffToVarChild((Vertex)firstV, (String)pv.getVertexName(), (Integer)pmo, (Integer)pio, (Integer)pis);
                            }
                            tsNode1.setName((Object)name);
                            firstNodes.put(firstRid, tsNode1);
                        }
                    }
                    if ((tsNode2 = (TSENode)lastNodes.get(secondRid = this.ig.getNode(Long.valueOf(targetLong)).value().id())) == null) {
                        tsNode2 = this.getTSNode(this.index, targetLong, true, true);
                        lastNodes.put(secondRid, tsNode2);
                        targetTSNodeMap.put(secondRid, tsNode2);
                    }
                    edgesInfo.add(String.valueOf(firstRid) + "|" + secondRid + "|" + o + "|" + false);
                }
                if (sourceTSNodeMap != null) {
                    for (String sRid : sourceTSNodeMap.keySet()) {
                        for (String firstRid : firstNodes.keySet()) {
                            if (sourceTSNodeMap.keySet().contains(firstRid)) continue;
                            String fRid = forward ? sRid : firstRid;
                            String tRid = forward ? firstRid : sRid;
                            tsNode1 = (TSENode)firstNodes.get(firstRid);
                            TSENode fNode = forward ? (TSENode)sourceTSNodeMap.get(fRid) : tsNode1;
                            TSENode tNode = forward ? tsNode1 : (TSENode)sourceTSNodeMap.get(tRid);
                            TSEEdge edge1 = this.graphManager.getEdgeBuilder().addEdge(this.graphManager, fNode, tNode);
                            TSEdgeLabel lbl1 = edge1.addLabel();
                            Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select 'Redefines' as relation from ( traverse both('Redefines') from  @@@@@EZLEGACY@@@@) where @rid = ".replace("@@@@@EZLEGACY@@@@", fRid).concat(tRid))).execute(new Object[0]);
                            String lbl = null;
                            Iterator iterator = ret.iterator();
                            if (iterator.hasNext()) {
                                lbl = (String)((OrientElement)iterator.next()).getProperty("relation");
                            }
                            if (lbl == null || lbl.isEmpty()) {
                                ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select 'ChildOf' as relation from (traverse out('ChildOf') from  @@@@@EZLEGACY@@@@ ) where @rid = ".replace("@@@@@EZLEGACY@@@@", fRid).concat(tRid))).execute(new Object[0]);
                                iterator = ret.iterator();
                                lbl = iterator.hasNext() ? (String)((OrientElement)iterator.next()).getProperty("relation") : Messages.getString(ImpactVarLevelGraphModel.class, "parent.lbl");
                            }
                            lbl1.setName((Object)lbl);
                        }
                    }
                }
                for (String einfo : edgesInfo) {
                    TSENode sn;
                    String[] e = einfo.split("\\|");
                    TSENode firstNode = (TSENode)firstNodes.get(e[0]);
                    TSENode secondNode = (TSENode)lastNodes.get(e[1]);
                    String dfRid = e[2];
                    Boolean isDF = Boolean.valueOf(e[3]);
                    TSENode fn = forward ? firstNode : secondNode;
                    edge = (TSEEdge)this.graph.getEdge((TSNode)fn, (TSNode)(sn = forward ? secondNode : firstNode));
                    if (edge == null) {
                        edge = this.graphManager.getEdgeBuilder().addEdge(this.graphManager, fn, sn);
                    }
                    this.computeStmtsFromDataflow(isDF, dfRid, edge);
                }
            }
            sourceTSNodeMap = targetTSNodeMap;
        }
        this.maxIndex = 1;
        monitor.done();
    }

    private void computeStmtsFromDataflow(Boolean isDf, String orid, TSEEdge edge) {
        Iterable ret;
        ArrayList<String> list = (ArrayList<String>)edge.getAttributeValue(DATA_FLOW_ORID_LIST);
        if (list == null) {
            list = new ArrayList<String>();
            edge.setAttribute(DATA_FLOW_ORID_LIST, list);
        }
        String query = "select set(fromUsage.in('Uses')[0]).asString() as stmts, set(fromUsage.in('Uses')[0].type).asString() as names from  ";
        if (!isDf.booleanValue()) {
            query = query.replace("fromUsage.", "");
        }
        if ((ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query.concat(orid.toString()))).execute(new Object[0])).iterator().hasNext()) {
            String[] stmts;
            OrientElement next = (OrientElement)ret.iterator().next();
            String stmtsStr = (String)next.getProperty("stmts");
            stmtsStr = stmtsStr.substring(1, stmtsStr.length() - 1);
            String[] stringArray = stmts = stmtsStr.split(",");
            int n = stmts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.add(s);
                ++n2;
            }
            String property = (String)next.getProperty("names");
            String name = property.substring(1, property.length() - 1);
            String tooltip = edge.getTooltipText();
            if (!tooltip.contains(name)) {
                edge.setTooltipText(String.valueOf(tooltip) + name);
            }
            List lblList = edge.getLabels();
            TSEdgeLabel lbl = null;
            if (lblList == null || lblList.isEmpty()) {
                lbl = edge.addLabel();
                lbl.setName((Object)"");
            } else {
                lbl = (TSEdgeLabel)lblList.get(0);
            }
            if (!((String)lbl.getName()).contains(name)) {
                if (((String)lbl.getName()).isEmpty()) {
                    lbl.setName((Object)name);
                } else {
                    lbl.setName((Object)(lbl.getName() + ", " + name));
                }
            }
        }
    }

    private void computeStmtsFromDataflow(boolean isDF, Set<String> orid, TSEEdge edge) {
        if (orid != null) {
            Iterable ret;
            ArrayList<String> list = (ArrayList<String>)edge.getAttributeValue(DATA_FLOW_ORID_LIST);
            if (list == null) {
                list = new ArrayList<String>();
                edge.setAttribute(DATA_FLOW_ORID_LIST, list);
            }
            String query = "select set(fromUsage.in('Uses')[0]).asString() as stmts, set(fromUsage.in('Uses')[0].type).asString() as names from ";
            if (!isDF) {
                query = query.replace("fromUsage.", "");
            }
            if ((ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query.concat(orid.toString()))).execute(new Object[0])).iterator().hasNext()) {
                String[] stmts;
                OrientElement next = (OrientElement)ret.iterator().next();
                String stmtsStr = (String)next.getProperty("stmts");
                stmtsStr = stmtsStr.substring(1, stmtsStr.length() - 1);
                String[] stringArray = stmts = stmtsStr.split(",");
                int n = stmts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    list.add(s);
                    ++n2;
                }
                String name = (String)next.getProperty("names");
                edge.setTooltipText(name);
                TSEdgeLabel lbl = edge.addLabel();
                lbl.setName((Object)name);
            }
        }
    }

    public static TSECurvedEdgeUI getSpecialEdgeUI(boolean withoutArrow) {
        TSECurvedEdgeUI specialedgeui = new TSECurvedEdgeUI();
        if (withoutArrow) {
            specialedgeui.setProperty(new TSProperty("arrowType", (Object)0));
        }
        specialedgeui.setLineStyle(3);
        return specialedgeui;
    }

    private TSENode getTSNode(int idx, Long nId, boolean addEntryGISV, boolean searchRelated) {
        String stepORID;
        Node node = this.ig.getNode(nId);
        Value value = node.value();
        String cls = "UNKNOWN";
        String relatedResourceCls = "UNKNOWN";
        String relatedResourceName = null;
        String relatedResourceVId = null;
        String relatedResourceEdgeLbl = null;
        Integer relatedPrgTypeId = null;
        if (value instanceof VertexValue && "Variable".equals(cls = value.getVertexClass()) && value.getContext("programName") != null) {
            relatedResourceName = (String)value.getContext("programName");
            relatedPrgTypeId = (Integer)value.getContext("prg type id");
            relatedResourceVId = (String)value.getContext("prog_vertex_id");
            relatedResourceCls = "Program";
        }
        TSENode tsNode = (TSENode)this.graph.addNode();
        tsNode.setAttribute(VERTEX_ID, (Object)value.id());
        if (this.ig.getStartNodes().contains(node)) {
            tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
        }
        if (addEntryGISV) {
            String clsLbl = com.ez.graphs.viewer.odb.utils.Utils.getImpactLabel((String)cls);
            this.putEntryInGraphInventory(clsLbl, (TSNode)tsNode);
        }
        this.setNodeUI(tsNode, cls);
        ((List)this.graph.getAttributeValue("t" + idx)).add(tsNode);
        String name = com.ez.graphs.viewer.odb.utils.Utils.getTSNodeName((OrientExtendedGraph)this.dbg, (Value)value, (String)cls, (boolean)true);
        tsNode.setName((Object)name);
        if (relatedResourceName == null && (stepORID = (String)value.getContext("stepVertexId")) != null) {
            OrientVertex stepVertex = this.dbg.getVertex((Object)stepORID);
            Vertex jobVertex = (Vertex)stepVertex.getVertices(Direction.IN, new String[]{"Steps"}).iterator().next();
            relatedResourceCls = "JCLJob";
            relatedResourceName = (String)jobVertex.getProperty("name");
            relatedResourceVId = jobVertex.getId().toString();
            String jobMember = (String)jobVertex.getProperty("member");
            if (jobMember != null && !jobMember.isEmpty() && !jobMember.equals(relatedResourceName)) {
                relatedResourceName = String.valueOf(relatedResourceName) + "(" + jobMember + ")";
            }
            relatedResourceEdgeLbl = (String)stepVertex.getProperty("name");
        }
        if (relatedResourceName != null) {
            this.buildRelatedNode(idx, tsNode, relatedResourceCls, relatedResourceName, relatedPrgTypeId, relatedResourceVId, relatedResourceEdgeLbl, searchRelated, addEntryGISV);
        }
        return tsNode;
    }

    private void buildRelatedNode(int idx, TSENode tsNode, String relatedResourceCls, String relatedResourceName, Integer relatedPrgTypeId, String relatedResourceVId, String edgeLbl, boolean searchRelated, boolean addEntryGISV) {
        ArrayList<TSENode> varNodes;
        TSENode prgNode = null;
        Map prgNodesMap = (Map)this.graph.getAttributeValue("p" + idx);
        ArrayList<TSENode> prgNodes = (ArrayList<TSENode>)prgNodesMap.get(idx);
        if (prgNodes == null) {
            prgNodes = new ArrayList<TSENode>();
            prgNodesMap.put(this.index, prgNodes);
        } else if (searchRelated) {
            prgNode = (TSENode)prgNodes.get(prgNodes.size() - 1);
            if (!prgNode.getName().equals(relatedResourceName)) {
                prgNode = null;
            } else {
                varNodes = (ArrayList<TSENode>)prgNode.getAttributeValue(VARIABLE_TSNODES);
                tsNode.setAttribute(RELATED_PRG_TSNODE_ATTRIBUTE, (Object)prgNode);
                varNodes.add(tsNode);
            }
        }
        if (prgNode == null) {
            prgNode = (TSENode)this.graph.addNode();
            prgNode.setAttribute(VERTEX_ID, (Object)relatedResourceVId);
            prgNode.setName((Object)relatedResourceName);
            prgNode.setAttribute("prg type id", (Object)relatedPrgTypeId);
            this.setNodeUI(prgNode, relatedResourceCls);
            prgNodes.add(prgNode);
            varNodes = new ArrayList<TSENode>();
            varNodes.add(tsNode);
            tsNode.setAttribute(RELATED_PRG_TSNODE_ATTRIBUTE, (Object)prgNode);
            prgNode.setAttribute(VARIABLE_TSNODES, varNodes);
            if (addEntryGISV) {
                this.putEntryInGraphInventory(relatedResourceCls, (TSNode)prgNode);
            }
        }
        TSEEdge edge = (TSEEdge)this.graphManager.addEdge((TSNode)tsNode, (TSNode)prgNode);
        if (edgeLbl != null) {
            TSEdgeLabel lbl = edge.addLabel();
            lbl.setName((Object)edgeLbl);
        }
        TSEConnector connector = (TSEConnector)tsNode.addConnector();
        connector.setProportionalXOffset(0.5);
        connector.setProportionalYOffset(0.0);
        edge.setSourceConnector((TSConnector)connector);
        edge.setAttribute("notFlow", (Object)Boolean.TRUE);
        TSECurvedEdgeUI eui = ImpactVarLevelGraphModel.getSpecialEdgeUI(true);
        eui.setLineColor(TSEColor.gray);
        edge.setUI((TSObjectUI)eui);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null && img.toString() != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            Object textColor = node.getAttributeValue("Color");
            if (textColor != null) {
                node.setAttribute("Text_Color", textColor);
            }
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        }
    }

    private void putEntryInGraphInventory(String lbl, TSNode node) {
        HashSet<TSNode> nodes = (HashSet<TSNode>)this.outForGISV.get(lbl);
        if (nodes == null) {
            nodes = new HashSet<TSNode>();
            this.outForGISV.put(lbl, nodes);
        }
        nodes.add(node);
    }

    private void putEntryInGraphInventory(boolean forward, int pathid, String lbl, List<TSNode> nodes) {
        PathLabelObj pthObj = new PathLabelObj((Integer)pathid, nodes);
        pthObj.setPath(lbl);
        if (!this.outForGISV.containsKey(pthObj)) {
            this.outForGISV.put(pthObj, nodes);
        }
    }

    public void updateDrawing() {
        TSDGraph hide;
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null) {
            if (gNode.hasAttribute("APPLICABLE_INPUT")) {
                objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
            } else {
                objType = this.createApplicableInputType(gNode);
                gNode.setAttribute("APPLICABLE_INPUT", (Object)objType);
            }
        }
        return objType;
    }

    public EZObjectType getApplicableInputType(List<TSNode> nodelist) {
        EZObjectType objType = null;
        TSNode gNode = null;
        if (nodelist != null && nodelist.size() > 0) {
            gNode = nodelist.get(0);
        }
        Map paths = (Map)gNode.getAttributeValue(EDGES_LISTS_FOR_PATH);
        if (gNode != null && paths != null && paths.size() > 0 && (objType = (EZObjectType)gNode.getAttributeValue("inputTypeForSinglePath")) == null) {
            objType = new EZImpactVarLvlSingleInputType();
            EZEntityID entity = new EZEntityID();
            objType.setEntID(entity);
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg((ProjectInfo)this.analysis.getContextValue("PROJECT_INFO"));
            entity.addSegment((EZSegment)prjIdSg);
            this.addInfoForSinglePathAnalysis(objType, paths);
            gNode.setAttribute("inputTypeForSinglePath", (Object)objType);
        }
        return objType;
    }

    private void addInfoForSinglePathAnalysis(EZObjectType objType, Map<Long, Set<String>> paths) {
        if (paths != null && paths.size() > 0) {
            objType.addProperty("forward_key", this.analysis.getContextValue("forward_key"));
            objType.addProperty("env", this.analysis.getContextValue("env"));
            boolean onDisk = Boolean.parseBoolean(System.getProperty("impactOnDisk", "true"));
            if (!onDisk) {
                objType.addProperty("impact graph", (Object)this.getImpactGraph());
            } else {
                objType.addProperty("ig folder", (Object)this.igFolder.getAbsoluteFile());
            }
            objType.addProperty("disk_count", this.analysis.getContextValue("disk_count"));
            ArrayList<EZSourceImpactEdgesIdSg> sgs = new ArrayList<EZSourceImpactEdgesIdSg>();
            EZSourceImpactEdgesIdSg pathSg = new EZSourceImpactEdgesIdSg(paths);
            sgs.add(pathSg);
            objType.addProperty("processAnalysisInfo", sgs);
            objType.addProperty("impact analysis name", (Object)Messages.getString(ImpactVarLevelGraphModel.class, "df.seg"));
            objType.setContext(ImpactVarLvlContext.class);
        } else if (objType != null) {
            objType.addProperty("processAnalysisInfo", null);
            objType.setContext(IgnoreContext.class);
        }
    }

    private EZObjectType createApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        OrientVertex vertex = null;
        String vertexId = (String)gNode.getAttributeValue(VERTEX_ID);
        if (vertexId != null) {
            vertex = this.dbg.getVertex((Object)vertexId);
            ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
            objType = com.ez.graphs.viewer.odb.utils.Utils.getResourceType((Vertex)vertex, (ProjectInfo)ezsourcePrj, (boolean)true);
            Map paths = (Map)gNode.getAttributeValue(EDGES_LISTS_FOR_PATH);
            this.addInfoForSinglePathAnalysis(objType, paths);
        }
        return objType;
    }

    @Override
    protected Vertex getVertex(TSENode gNode) {
        OrientVertex vertex = null;
        String vertexId = (String)gNode.getAttributeValue(VERTEX_ID);
        if (vertexId != null) {
            vertex = this.dbg.getVertex((Object)vertexId);
        }
        return vertex;
    }

    public TSCommand createCustomHLayoutCommand(TSDGraph graph) {
        List tsNodes;
        int i;
        int direction = 3;
        TSELayoutCommand layoutCommand = null;
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSLayoutInputTailor inputTaylor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        HashMap columnAllNodes = new HashMap();
        ArrayList<TSENode> headerNodes = new ArrayList<TSENode>();
        if (this.isSinglePath) {
            i = 0;
            while (i < this.maxIndex) {
                tsNodes = (List)graph.getAttributeValue("t" + i);
                Map prgNodesMap = (Map)graph.getAttributeValue("p" + i);
                if (tsNodes != null && prgNodesMap != null) {
                    ArrayList prgNodes = new ArrayList();
                    for (List l : prgNodesMap.values()) {
                        prgNodes.addAll(l);
                    }
                    inputTaylor.addSeparationConstraint(tsNodes, prgNodes, 0, 200.0, 0);
                    inputTaylor.addAlignmentConstraint(prgNodes, 0, 0, 1);
                    inputTaylor.addSequenceConstraint(prgNodes, direction, 100.0, 2);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            i = 0;
            while (i < this.maxIndex) {
                tsNodes = (List)graph.getAttributeValue("t" + i);
                Map prgNodesMap = (Map)graph.getAttributeValue("p" + i);
                if (tsNodes == null || prgNodesMap == null) break;
                if (tsNodes.size() > 0 && !headerNodes.contains(tsNodes.get(0))) {
                    headerNodes.add((TSENode)tsNodes.get(0));
                }
                ArrayList prgNodes = new ArrayList();
                for (List l : prgNodesMap.values()) {
                    prgNodes.addAll(l);
                }
                inputTaylor.addSeparationConstraint(tsNodes, prgNodes, 0, 200.0, 0);
                inputTaylor.addAlignmentConstraint(tsNodes, 0, 0, 1);
                inputTaylor.addAlignmentConstraint(prgNodes, 0, 0, 1);
                inputTaylor.addSequenceConstraint(tsNodes, direction, 100.0, 2);
                inputTaylor.addSequenceConstraint(prgNodes, direction, 100.0, 2);
                for (TSENode prgNode : prgNodes) {
                    List varNodes = (List)prgNode.getAttributeValue(VARIABLE_TSNODES);
                    ArrayList<TSENode> nodeList = new ArrayList<TSENode>();
                    nodeList.add((TSENode)varNodes.get(varNodes.size() / 2));
                    nodeList.add(prgNode);
                    inputTaylor.addAlignmentConstraint(nodeList, 1, 0, 0);
                }
                ArrayList colNodes = new ArrayList();
                colNodes.addAll(prgNodes);
                colNodes.addAll(tsNodes);
                columnAllNodes.put(i, colNodes);
                ++i;
            }
            i = 0;
            while (i < columnAllNodes.size() - 1) {
                List first = (List)columnAllNodes.get(i);
                List second = (List)columnAllNodes.get(i + 1);
                inputTaylor.addSeparationConstraint(first, second, 0, 400.0, 2);
                ++i;
            }
            if (headerNodes.size() > 1) {
                inputTaylor.addAlignmentConstraint(headerNodes, 1, 0, 1);
            }
            i = 0;
            while (i < this.rows - 1) {
                List tsNodes1 = (List)graph.getAttributeValue("r" + i);
                List tsNodes2 = (List)graph.getAttributeValue("r" + (i + 1));
                inputTaylor.addSeparationConstraint(tsNodes1, tsNodes2, 3, 200.0, 0);
                ++i;
            }
        }
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        layoutPreferenceTailor.setDrawingFitToCanvas();
        layoutCommand = new TSELayoutCommand((TSEGraph)graph, (TSViewportCanvas)canvas, (TSServiceInputDataInterface)inputData, 1){

            protected TSBaseLayoutWorker createLayoutWorker() {
                return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                    public void processEventsAfterLayout() {
                        L.debug("nothing to process after layout");
                    }
                };
            }
        };
        layoutCommand.setCoalesced(true);
        return layoutCommand;
    }

    public OrientExtendedGraph createOrientGraph(Properties env) {
        if (this.dbg != null) {
            throw new IllegalStateException("graph already instantiated");
        }
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        this.env = env;
        return this.dbg;
    }

    private ImpactGraph getImpactGraph() {
        if (this.ig == null) {
            this.ig = new DiskGraph(true, this.igFolder, null);
        }
        return this.ig;
    }

    public void dispose() {
        block14: {
            block12: {
                try {
                    try {
                        ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
                    }
                    catch (Exception e) {
                        L.error("while closing graph", (Throwable)e);
                        this.dbg = null;
                        this.env = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.dbg = null;
                    this.env = null;
                    throw throwable;
                }
                this.dbg = null;
                this.env = null;
            }
            try {
                try {
                    if (this.igFolder != null && this.ig != null) {
                        this.ig.close();
                    }
                }
                catch (Exception e) {
                    L.error("while closing ImpactGraph ", (Throwable)e);
                    this.ig = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.ig = null;
                throw throwable;
            }
            this.ig = null;
        }
        if (this.igFolder != null) {
            AtomicInteger diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count");
            if (diskCount.decrementAndGet() == 0) {
                FileUtils.deleteFolder((File)this.igFolder.getParentFile());
            }
            this.igFolder = null;
        }
        super.dispose();
    }

    public Object computeFileAttribute(TSGraphMember tsmember) {
        String vertexId;
        OrientVertex v;
        TextSelectionInFile tsf;
        Boolean compute = null;
        List orids = (List)tsmember.getAttributeValue(DATA_FLOW_ORID_LIST);
        if (orids != null) {
            HashSet<TextSelectionInFile> tsfSet = new HashSet<TextSelectionInFile>();
            for (String orid : orids) {
                TextSelectionInFile tsf2 = this.computeSourceInfoForDataflow(orid);
                tsfSet.add(tsf2);
            }
            Utils.setFileAttribute((TSGraphMember)tsmember, tsfSet);
            compute = true;
        } else if (tsmember.hasAttribute(VERTEX_ID) && (tsf = com.ez.graphs.viewer.odb.utils.Utils.computeSourceInfoForVertex((Vertex)(v = this.dbg.getVertex((Object)(vertexId = tsmember.getAttributeValue(VERTEX_ID).toString()))))) != null) {
            Utils.setFileAttribute((TSGraphMember)tsmember, (TextSelectionInFile)tsf);
            compute = true;
        }
        return compute;
    }

    private TextSelectionInFile computeSourceInfoForDataflow(String dataFlowORID) {
        if (dataFlowORID == null) {
            return null;
        }
        OrientVertex v = this.dbg.getVertex((Object)dataFlowORID);
        return com.ez.graphs.viewer.odb.utils.Utils.computeSourceInfoForVertex((Vertex)v);
    }

    public String truncate(String edgeLbl) {
        int secondCommaIndex;
        if (edgeLbl == null) {
            return "defaultName";
        }
        String result = edgeLbl;
        int firstCommaIndex = edgeLbl.indexOf(",");
        if (firstCommaIndex > 0 && (secondCommaIndex = edgeLbl.indexOf(",", firstCommaIndex + 1)) > 0) {
            result = edgeLbl.substring(0, secondCommaIndex);
            result = String.valueOf(result) + "[...]";
        }
        return result;
    }

    public class VarPathHandler
    implements PathHandler {
        private boolean noDSNode;
        private boolean forward;
        private Map<TSENode, List<String>> uniquePaths;
        private Long lastNodeLong;
        private int row;

        public VarPathHandler(boolean noDSNode, boolean forward) {
            this.noDSNode = noDSNode;
            this.forward = forward;
        }

        public void setRowNumber(int row) {
            this.row = row;
        }

        public void setUniquePaths(Map<TSENode, List<String>> uniquePaths) {
            this.uniquePaths = uniquePaths;
        }

        public void setLastNodeLong(Long lastNodeLong) {
            this.lastNodeLong = lastNodeLong;
        }

        public void handlePath(List<Pair<Long, Long>> nodes, Pair<Long, Long> entryCycleNode) {
            if (entryCycleNode != null) {
                nodes.add(entryCycleNode);
            }
            Pair<Long, Long> last = nodes.get(nodes.size() - 1);
            Long lastNodeId = (Long)last.getFirst();
            if (this.noDSNode || lastNodeId.equals(this.lastNodeLong) && this.isSpecial(lastNodeId)) {
                Map<Long, Set<String>> filtered = this.verifyPath(nodes);
                if (filtered == null) {
                    L.debug("remove fake edge");
                    return;
                }
                ArrayList<Object> ll = new ArrayList<Object>();
                for (Pair<Long, Long> triplet : nodes) {
                    ll.add(triplet.getFirst());
                }
                Pair<TSENode, List<String>> pathInfo = ImpactVarLevelGraphModel.this.verifyIfAlreadyExists(this.uniquePaths, nodes);
                if (pathInfo.getFirst() == null) {
                    ImpactVarLevelGraphModel impactVarLevelGraphModel = ImpactVarLevelGraphModel.this;
                    impactVarLevelGraphModel.nn = impactVarLevelGraphModel.nn + 1;
                }
                TSNode tsInPath = (TSNode)pathInfo.getFirst();
                List idsInPath = (List)pathInfo.getSecond();
                if (tsInPath == null) {
                    if (ImpactVarLevelGraphModel.this.maxIndex == 0 || ImpactVarLevelGraphModel.this.index >= ImpactVarLevelGraphModel.this.maxIndex) {
                        ArrayList tsNodes = new ArrayList();
                        HashMap prgNodesMap = new HashMap();
                        ImpactVarLevelGraphModel.this.graph.setAttribute("p" + ImpactVarLevelGraphModel.this.index, prgNodesMap);
                        ImpactVarLevelGraphModel.this.graph.setAttribute("t" + ImpactVarLevelGraphModel.this.index, tsNodes);
                    }
                    TSENode tsNode1 = null;
                    TSENode firstTSNode = null;
                    ArrayList<TSENode> listts = new ArrayList<TSENode>();
                    for (Pair<Long, Long> triplet : nodes) {
                        TSENode tsNode2;
                        Link link;
                        Long nId = (Long)triplet.getFirst();
                        Set<String> orid = null;
                        Long lId = (Long)triplet.getSecond();
                        String edgeLbl = null;
                        boolean isDF = false;
                        boolean drawCallDirection = false;
                        if (lId != null && (link = ImpactVarLevelGraphModel.this.ig.getLink(lId)) != null) {
                            orid = filtered.get(lId);
                            edgeLbl = (String)link.info("link");
                            isDF = link.info("programCallDirection") == null;
                            drawCallDirection = link.info("reverse impact direction") != null;
                        }
                        if (!(tsNode2 = ImpactVarLevelGraphModel.this.getTSNode(ImpactVarLevelGraphModel.this.index, nId, false, !listts.isEmpty())).hasAttribute(ImpactVarLevelGraphModel.EDGES_LISTS_FOR_PATH)) {
                            tsNode2.setAttribute(ImpactVarLevelGraphModel.EDGES_LISTS_FOR_PATH, filtered);
                        }
                        listts.add(tsNode2);
                        if (firstTSNode == null) {
                            firstTSNode = tsNode2;
                        }
                        if (tsNode1 != null) {
                            TSENode from = this.forward ? tsNode1 : tsNode2;
                            TSENode to = this.forward ? tsNode2 : tsNode1;
                            TSEEdge edge = (TSEEdge)ImpactVarLevelGraphModel.this.graph.getEdge((TSNode)from, (TSNode)to);
                            if (edge == null) {
                                edge = ImpactVarLevelGraphModel.this.graphManager.getEdgeBuilder().addEdge(ImpactVarLevelGraphModel.this.graphManager, from, to);
                                tsNode1.setAttribute("GraphEdge", (Object)edge);
                                if (drawCallDirection) {
                                    TSEEdge calledge = ImpactVarLevelGraphModel.this.graphManager.getEdgeBuilder().addEdge(ImpactVarLevelGraphModel.this.graphManager, to, from);
                                    calledge.setAttribute("Color", (Object)TSEColor.blue);
                                }
                            }
                            if (orid != null) {
                                ImpactVarLevelGraphModel.this.computeStmtsFromDataflow(isDF, orid, edge);
                            } else {
                                TSEdgeLabel lbl = edge.addLabel();
                                edge.setTooltipText(edgeLbl);
                                lbl.setName((Object)ImpactVarLevelGraphModel.this.truncate(edgeLbl));
                            }
                        }
                        tsNode1 = tsNode2;
                    }
                    ImpactVarLevelGraphModel impactVarLevelGraphModel = ImpactVarLevelGraphModel.this;
                    impactVarLevelGraphModel.index = impactVarLevelGraphModel.index + 1;
                    ImpactVarLevelGraphModel impactVarLevelGraphModel2 = ImpactVarLevelGraphModel.this;
                    impactVarLevelGraphModel2.generalIndex = impactVarLevelGraphModel2.generalIndex + 1;
                    this.uniquePaths.put(firstTSNode, idsInPath);
                    String fromToInfo = ImpactVarLevelGraphModel.this.getFromToInfo(this.forward, listts);
                    ImpactVarLevelGraphModel.this.putEntryInGraphInventory(true, ImpactVarLevelGraphModel.this.generalIndex, Messages.getString(ImpactVarLevelGraphModel.class, "seg", new Object[]{String.valueOf(ImpactVarLevelGraphModel.this.generalIndex) + fromToInfo}), listts);
                    ImpactVarLevelGraphModel.this.graph.setAttribute("r" + this.row, listts);
                    tsInPath = firstTSNode;
                }
            }
        }

        private Map<Long, Set<String>> verifyPath(List<Pair<Long, Long>> nodes) {
            Map coffMap = null;
            Long clId = null;
            LinkedHashMap<Long, Set<String>> filtered = new LinkedHashMap<Long, Set<String>>();
            for (Pair<Long, Long> triplet : nodes) {
                Link link;
                Map offMap = null;
                Set orids = null;
                Long lId = (Long)triplet.getSecond();
                if (lId == null || (link = ImpactVarLevelGraphModel.this.ig.getLink(lId)) == null) continue;
                orids = filtered.containsKey(lId) ? (Set)filtered.get(lId) : (Set)link.info("nodeORID");
                HashSet<String> goodOrids = link.info("DDCard") == null ? new HashSet<String>() : null;
                offMap = (Map)link.info("impact");
                if (coffMap != null && offMap != null && goodOrids != null) {
                    for (String ckey : coffMap.keySet()) {
                        String[] cim = ((String)coffMap.get(ckey)).split(",");
                        ArrayList<Integer> clist = new ArrayList<Integer>();
                        int i = 1;
                        while (i <= Integer.valueOf(cim[3])) {
                            clist.add(Integer.valueOf(cim[2]) + i);
                            ++i;
                        }
                        boolean found = false;
                        for (String key : orids) {
                            if (!offMap.containsKey(key)) continue;
                            String[] im = ((String)offMap.get(key)).split(",");
                            ArrayList<Integer> list = new ArrayList<Integer>();
                            int i2 = 1;
                            while (i2 <= Integer.valueOf(im[1])) {
                                list.add(Integer.valueOf(im[0]) + i2);
                                ++i2;
                            }
                            if (Collections.disjoint(clist, list)) continue;
                            found = true;
                            goodOrids.add(key);
                        }
                        if (found) continue;
                        Set corids = (Set)filtered.get(clId);
                        corids.remove(ckey);
                        if (!corids.isEmpty()) continue;
                        return null;
                    }
                }
                if (coffMap != null && goodOrids != null && goodOrids.isEmpty()) {
                    return null;
                }
                coffMap = offMap;
                clId = lId;
                filtered.put(lId, goodOrids != null && goodOrids.isEmpty() ? orids : goodOrids);
            }
            return filtered;
        }

        private boolean isSpecial(Long lastNodeId) {
            Iterable it = ImpactVarLevelGraphModel.this.ig.getSpecialNodes(-1);
            for (Long l : it) {
                if (!l.equals(lastNodeId)) continue;
                return false;
            }
            return true;
        }

        public void addPathInfo(Object o) {
        }
    }
}

