/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact.prgLvl;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.ImpactAnnotatedGraphModel;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.ImpactPrgLevelGraphAnalysis;
import com.ez.graphs.viewer.callgraph.impact.varLvl.ImpactVarLevelGraphAnalysis;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.inputs.EZImpactVarLvlInputType;
import com.ez.graphs.viewer.odb.analysis.inputs.EZSourceImpactPathRestrictionIdSg;
import com.ez.graphs.viewer.odb.analysis.inputs.ImpactPrgLvlContext;
import com.ez.graphs.viewer.odb.impact.model.ExpandAtProgramLevel;
import com.ez.graphs.viewer.odb.impact.model.INodeExpander;
import com.ez.graphs.viewer.odb.impact.model.IPathCycleDetector;
import com.ez.graphs.viewer.odb.impact.model.IStopTest;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.MGUtil;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.PrgDetector;
import com.ez.graphs.viewer.odb.impact.model.ProgramValue;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.graphs.viewer.odb.impact.model.disk.DiskGraph;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.utils.FileUtils;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.geometry.shared.TSRoundedRectangleShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSBaseLayoutWorker;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.command.editing.TSLayoutOperationCommand;
import com.tomsawyer.interactive.command.editing.TSSwingLayoutWorker;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactPrgLevelGraphModel
extends ImpactAnnotatedGraphModel {
    private static final Logger L = LoggerFactory.getLogger(ImpactPrgLevelGraphModel.class);
    private static final String PROGRAM_NODES_ATTRIBUTE = "programNodes";
    private Map<TSENode, List<TSENode>> dsToPrgNodes = new HashMap<TSENode, List<TSENode>>();
    private Map<String, TSENode> dsNodes = new HashMap<String, TSENode>();
    private Map<Integer, List<TSENode>> tsNodeLevels = new HashMap<Integer, List<TSENode>>();
    private Map<String, TSENode> varNodes = new HashMap<String, TSENode>();
    private File igFolder = null;
    private EZObjectType varLvlObjType;
    private Action varLvlGraphAction;
    private Map<Pair<Long, Long>, Set<List<Long>>> prgIdsMap = new HashMap<Pair<Long, Long>, Set<List<Long>>>();
    private Map<String, TSNode> tsnodes = new HashMap<String, TSNode>();

    public ImpactPrgLevelGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = (ImpactPrgLevelGraphAnalysis)analysis;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        nodeBuilder.setShape((TSShape)new TSRoundedRectangleShape(0.2, true));
        nodeBuilder.setAttribute("Line_Width", (Object)0.0);
        this.igFolder = (File)this.analysis.getContextValue("ig folder");
        this.ig = this.igFolder != null ? new DiskGraph(true, this.igFolder, null) : (ImpactGraph)this.analysis.getContextValue("impact graph");
        AtomicInteger diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count");
        diskCount.incrementAndGet();
        this.createOrientGraph((Properties)this.analysis.getContextValue("env"));
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.tsNodeLevels.clear();
        this.dsToPrgNodes.clear();
        this.varNodes.clear();
        this.dsNodes.clear();
        this.tsnodes.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
        this.prgIdsMap.clear();
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
        pmonitor.setTaskName(Messages.getString(ImpactPrgLevelGraphModel.class, "loading.graph"));
        this.initGraph();
        this.graphManager.startBatchProcessing(true);
        final Boolean forward = (Boolean)this.analysis.getContextValue("forward_key");
        List paths = this.analysis.getContextListValue("paths");
        final ImpactGraph ig = this.getImpactGraph();
        boolean found = false;
        Iterator iterator = ig.getSpecialNodes(1).iterator();
        if (iterator.hasNext()) {
            Long cfr_ignored_0 = (Long)iterator.next();
            found = true;
        }
        final boolean noDSNode = !found;
        IStopTest stopTester = new IStopTest(){

            public boolean shouldStop(Node node) {
                return noDSNode ? false : 1 == node.value().type();
            }

            public boolean handlePathOnNoExpand() {
                return noDSNode;
            }
        };
        ExpandAtProgramLevel expander = new ExpandAtProgramLevel();
        PrgDetector detector = new PrgDetector(ig);
        for (final Pair path : paths) {
            long start = System.currentTimeMillis();
            ArrayList<Long> startList = new ArrayList<Long>();
            startList.add((Long)path.getFirst());
            final Long lastLongNodeId = (Long)path.getSecond();
            PathHandler ph = new PathHandler(){

                public void handlePath(List<Pair<Long, Long>> nodes, Pair<Long, Long> entryCycleNode) {
                    Long lastNodeId;
                    Long cycleNodeId = entryCycleNode != null ? (Long)entryCycleNode.getFirst() : null;
                    Pair<Long, Long> last = nodes.get(nodes.size() - 1);
                    Long l = lastNodeId = cycleNodeId != null ? cycleNodeId : (Long)last.getFirst();
                    if (lastNodeId.equals(lastLongNodeId) && (noDSNode || this.isDatasource(lastNodeId))) {
                        TSENode firstTsNode = null;
                        Pair key = new Pair((Object)((Long)path.getFirst()), (Object)lastLongNodeId);
                        HashSet prgIds = (HashSet)ImpactPrgLevelGraphModel.this.prgIdsMap.get(key);
                        if (prgIds == null) {
                            prgIds = new HashSet();
                            ImpactPrgLevelGraphModel.this.prgIdsMap.put(key, prgIds);
                        }
                        ArrayList<Long> prgList = new ArrayList<Long>();
                        for (Pair<Long, Long> triplet : nodes) {
                            Long nId = (Long)triplet.getFirst();
                            TSENode tsNode = ImpactPrgLevelGraphModel.this.getTSNode(nId);
                            if (tsNode == null) continue;
                            if (firstTsNode != null) {
                                if (forward.booleanValue() && !ImpactPrgLevelGraphModel.this.graph.hasEdge((TSNode)firstTsNode, (TSNode)tsNode)) {
                                    ImpactPrgLevelGraphModel.this.graphManager.getEdgeBuilder().addEdge(ImpactPrgLevelGraphModel.this.graphManager, firstTsNode, tsNode);
                                } else if (!forward.booleanValue() && !ImpactPrgLevelGraphModel.this.graph.hasEdge((TSNode)tsNode, (TSNode)firstTsNode)) {
                                    ImpactPrgLevelGraphModel.this.graphManager.getEdgeBuilder().addEdge(ImpactPrgLevelGraphModel.this.graphManager, tsNode, firstTsNode);
                                }
                            }
                            prgList.add(nId);
                            firstTsNode = tsNode;
                        }
                        prgIds.add(prgList);
                    }
                }

                private boolean isDatasource(Long lastNodeId) {
                    Iterable specialIterable = ig.getSpecialNodes(1);
                    for (Long l : specialIterable) {
                        if (!l.equals(lastNodeId)) continue;
                        return true;
                    }
                    return false;
                }

                public void addPathInfo(Object o) {
                }
            };
            MGUtil.allPathsDepthFirst(startList, (ImpactGraph)ig, (boolean)true, (PathHandler)ph, null, (int)2, (IStopTest)stopTester, (INodeExpander)expander, (IPathCycleDetector)detector, null, (boolean)false, (IProgressMonitor)monitor.newChild(100));
            String p = path.getFirst() + " to " + path.getSecond();
            L.debug("finished prg level for pair {} in  ms", (Object)p, (Object)(System.currentTimeMillis() - start));
        }
        monitor.setWorkRemaining(10);
        this.graphManager.endBatchProcessing();
        this.findAnnotations(monitor.newChild(10));
        monitor.setWorkRemaining(0);
    }

    private TSENode getTSNode(Long nId) {
        TSENode tsNode;
        Node node = this.ig.getNode(nId);
        Value value = node.value();
        String nameKey = String.valueOf(nId);
        if ("DSName".equals(value.getVertexClass())) {
            nameKey = value.getVertexName();
        }
        if ((tsNode = this.dsNodes.get(nameKey)) == null) {
            OrientVertex vertex = null;
            String cls = "Unknown";
            if (value instanceof VertexValue) {
                vertex = ((VertexValue)value).asVertex((OrientExtendedGraph)this.dbg);
                cls = (String)vertex.getProperty("@class");
                if ("DDNameProxy".equals(cls)) {
                    return null;
                }
            } else if (value instanceof ProgramValue) {
                cls = "Program";
            }
            String name = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, (Value)value, (String)cls, (boolean)false);
            tsNode = (TSENode)this.graph.addNode();
            tsNode.setName((Object)name);
            String clsLbl = Utils.getImpactLabel((String)cls);
            String info = clsLbl.concat(": ").concat(name);
            tsNode.setTooltipText(info);
            tsNode.setAttribute("node_info", (Object)info);
            if (this.ig.getStartNodes().contains(node)) {
                tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            }
            if (!"Program".equals(cls)) {
                tsNode.setAttribute(PROGRAM_NODES_ATTRIBUTE, new HashMap());
            } else {
                tsNode.setAttribute("prg type id", (Object)1);
            }
            this.setNodeUI(tsNode, cls);
            this.dsNodes.put(nameKey, tsNode);
            this.putEntryInGraphInventory(clsLbl, tsNode);
            tsNode.setAttribute("nodeid", (Object)node.getId());
            this.tsnodes.put(nameKey, (TSNode)tsNode);
            if (!nameKey.equals(value.getContextId())) {
                this.tsnodes.put(value.getContextId(), (TSNode)tsNode);
            }
        } else {
            this.tsnodes.put(value.getContextId(), (TSNode)tsNode);
        }
        return tsNode;
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null && img.toString() != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            Object textColor = node.getAttributeValue("Color");
            if (textColor != null) {
                node.setAttribute("Text_Color", textColor);
            }
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        }
    }

    private void putEntryInGraphInventory(String clsLbl, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(clsLbl);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(clsLbl, nodes);
        }
        nodes.add(tsNode);
    }

    public void updateDrawing() {
        TSDGraph hide;
        super.updateDrawing();
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null) {
            if (gNode.hasAttribute("APPLICABLE_INPUT")) {
                objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
            } else {
                objType = this.createApplicableInputType(gNode);
                gNode.setAttribute("APPLICABLE_INPUT", (Object)objType);
            }
        }
        return objType;
    }

    private EZObjectType createApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        long nId = (Long)gNode.getAttributeValue("nodeid");
        Node node = this.ig.getNode(Long.valueOf(nId));
        Value value = node.value();
        OrientVertex vertex = this.dbg.getVertex((Object)value.id());
        if (vertex != null) {
            ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
            objType = Utils.getResourceType((Vertex)vertex, (ProjectInfo)ezsourcePrj, (boolean)true);
            objType.setContext(ImpactPrgLvlContext.class);
            this.addInfoForVarAnalysis(objType);
        } else {
            L.warn("vertex not found. vertex id = " + value.id());
        }
        return objType;
    }

    private EZObjectType makeObjectType() {
        if (this.varLvlObjType == null) {
            this.varLvlObjType = new EZImpactVarLvlInputType();
            EZEntityID entity = new EZEntityID();
            this.varLvlObjType.setEntID(entity);
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg((ProjectInfo)this.analysis.getContextValue("PROJECT_INFO"));
            entity.addSegment((EZSegment)prjIdSg);
            this.addInfoForVarAnalysis(this.varLvlObjType);
        }
        return this.varLvlObjType;
    }

    private void addInfoForVarAnalysis(EZObjectType objType) {
        objType.addProperty("disk_count", this.analysis.getContextValue("disk_count"));
        objType.addProperty("forward_key", this.analysis.getContextValue("forward_key"));
        objType.addProperty("env", this.analysis.getContextValue("env"));
        boolean onDisk = Boolean.parseBoolean(System.getProperty("impactOnDisk", "true"));
        if (!onDisk) {
            objType.addProperty("impact graph", (Object)this.getImpactGraph());
        } else {
            objType.addProperty("ig folder", (Object)this.igFolder.getAbsoluteFile());
        }
        objType.addProperty("impact analysis name", (Object)((String)this.analysis.getContextValue("inputs name string")));
        List paths = this.analysis.getContextListValue("paths");
        ArrayList<EZSourceImpactPathRestrictionIdSg> sgs = new ArrayList<EZSourceImpactPathRestrictionIdSg>();
        String igHashCode = String.valueOf(this.getImpactGraph().hashCode());
        for (Pair pathNodes : paths) {
            Triplet nodeIds = new Triplet((Object)((Long)pathNodes.getFirst()), (Object)((Long)pathNodes.getSecond()), this.prgIdsMap.get(pathNodes));
            EZSourceImpactPathRestrictionIdSg pathSg = new EZSourceImpactPathRestrictionIdSg(igHashCode, nodeIds);
            sgs.add(pathSg);
        }
        objType.addProperty("processAnalysisInfo", sgs);
    }

    public TSCommand createCustomHLayoutCommand(TSDGraph graph) {
        TSELayoutCommand layoutCommand = null;
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSLayoutInputTailor inputTaylor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        Set<Integer> keys = this.tsNodeLevels.keySet();
        ArrayList<Integer> keysList = new ArrayList<Integer>(keys);
        Collections.sort(keysList);
        L.debug("levels: " + keysList);
        int i = 0;
        ArrayList<TSENode> startList = new ArrayList<TSENode>();
        while (i < keysList.size() - 1) {
            Integer pos1 = (Integer)keysList.get(i);
            List<TSENode> list1 = this.tsNodeLevels.get(pos1);
            Integer pos2 = (Integer)keysList.get(i + 1);
            List<TSENode> list2 = this.tsNodeLevels.get(pos2);
            double distance = 100.0;
            inputTaylor.addSeparationConstraint(list1, list2, 0, distance, 100);
            startList.add(list1.get(0));
            if (++i != keysList.size() - 1) continue;
            startList.add(list2.get(0));
        }
        inputTaylor.addAlignmentConstraint(startList, 1, 0, 0);
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        layoutPreferenceTailor.setDrawingFitToCanvas();
        layoutCommand = new TSELayoutCommand((TSEGraph)graph, (TSViewportCanvas)canvas, (TSServiceInputDataInterface)inputData, 1){

            protected TSBaseLayoutWorker createLayoutWorker() {
                return new TSSwingLayoutWorker((TSLayoutOperationCommand)this){

                    public void processEventsAfterLayout() {
                        L.debug("nothing to process after layout");
                    }
                };
            }
        };
        layoutCommand.setCoalesced(true);
        return layoutCommand;
    }

    public OrientExtendedGraph createOrientGraph(Properties env) {
        if (this.dbg != null) {
            throw new IllegalStateException("graph already instantiated");
        }
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        this.env = env;
        return this.dbg;
    }

    private ImpactGraph getImpactGraph() {
        if (this.ig == null) {
            this.ig = new DiskGraph(true, this.igFolder, null);
        }
        return this.ig;
    }

    public void dispose() {
        block14: {
            block12: {
                try {
                    try {
                        ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
                    }
                    catch (Exception e) {
                        L.error("while closing graph", (Throwable)e);
                        this.dbg = null;
                        this.env = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.dbg = null;
                    this.env = null;
                    throw throwable;
                }
                this.dbg = null;
                this.env = null;
            }
            try {
                try {
                    if (this.igFolder != null && this.ig != null) {
                        this.ig.close();
                    }
                }
                catch (Exception e) {
                    L.error("while closing ImpactGraph ", (Throwable)e);
                    this.ig = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.ig = null;
                throw throwable;
            }
            this.ig = null;
        }
        if (this.igFolder != null) {
            AtomicInteger diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count");
            if (diskCount.decrementAndGet() == 0) {
                FileUtils.deleteFolder((File)this.igFolder.getParentFile());
            }
            this.igFolder = null;
        }
        super.dispose();
    }

    public Action createCustomAction() {
        if (this.varLvlGraphAction == null) {
            this.varLvlGraphAction = new Action(){

                public void run() {
                    EZObjectType inputType = ImpactPrgLevelGraphModel.this.makeObjectType();
                    if (inputType != null) {
                        L.debug("analysis inputType" + inputType.getName());
                        EZAnalysisType analysisType = EZWorkspace.getInstance().getSpecificAnalysisType(inputType, ImpactVarLevelGraphAnalysis.class);
                        if (analysisType != null) {
                            L.debug("analysisType:" + analysisType.getName());
                            EZAnalysis analysis = analysisType.getImplementorInstance();
                            ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
                            inputs.add(inputType);
                            analysis.setInputs(inputs);
                            analysis.addContextValue("projects", ImpactPrgLevelGraphModel.this.analysis.getContextValue("projects"));
                            L.debug("before execute varLvlGraphAction");
                            analysis.execute();
                        }
                    }
                }
            };
            this.varLvlGraphAction.setText(Messages.getString(ImpactPrgLevelGraphModel.class, "varLvl.action.text"));
            this.varLvlGraphAction.setToolTipText(Messages.getString(ImpactPrgLevelGraphModel.class, "varLvl.action.tooltip"));
            ImageDescriptor id = Activator.getImageDescriptor("icons/impact_graph.png");
            this.varLvlGraphAction.setImageDescriptor(id);
            this.varLvlGraphAction.setEnabled(false);
        }
        return this.varLvlGraphAction;
    }
}

