/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact.prgLvl;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.ImpactComponentBuilderAdapter;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphFilterInfo;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.ImpactPrgLevelGraphModel;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.ImpactPrgLevelMouseActionsHook;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.inputs.EZSourceImpactPathIdSg;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactPrgLevelGraphAnalysisJob
extends AnnotatedGraphJob {
    private static final Logger L = LoggerFactory.getLogger(ImpactPrgLevelGraphAnalysisJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;
    protected static final String PATHS = "paths";
    private Action varLvlGraphAction = null;

    public ImpactPrgLevelGraphAnalysisJob(EZEntityID id) {
        super(id);
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.mouseActionsHook = new ImpactPrgLevelMouseActionsHook(id);
        this.initGraphDetails();
        this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
    }

    protected void initGraphDetails() {
        this.graphInfo = new ImpactPrgLvlGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new ImpactGraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.graphModel = new ImpactPrgLevelGraphModel(new AnalysisGraphManager(), this.analysis);
        ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
        icp.setHasExport(true);
        this.graphInfo.setContentProvider((StructureContentProvider)icp);
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        L.debug("impact process level graph - computeResults");
        super.computeResults(graphModel, monitor);
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(ImpactPrgLevelGraphAnalysisJob.class, "collectingData.taskName"));
        this.processInputs((IProgressMonitor)pmonitor.newChild(100));
        pmonitor.setWorkRemaining(0);
    }

    private void processInputs(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        pmonitor.setTaskName(Messages.getString(ImpactPrgLevelGraphAnalysisJob.class, "compute.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        ArrayList<Pair> filteredPaths = new ArrayList<Pair>();
        for (EZSourceImpactPathIdSg sg : inputs) {
            Pair pathNodes = sg.getNodeIds();
            filteredPaths.add(pathNodes);
        }
        this.analysis.addContextValue(PATHS, filteredPaths);
        pmonitor.setWorkRemaining(0);
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.getString(ImpactPrgLevelGraphAnalysisJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)pmonitor.newChild(50), result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            List nodesSetsList = this.graphModel.getGraph().nodes();
            allNodes.addAll(nodesSetsList);
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
        this.varLvlGraphAction = ((ImpactPrgLevelGraphModel)this.graphModel).createCustomAction();
        this.varLvlGraphAction.setEnabled(true);
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Object> toolbars = new ArrayList<Object>();
        if (this.varLvlGraphAction != null) {
            L.debug("add 'var level impact' toolbar action");
            toolbars.add(new Separator());
            toolbars.add(new ActionContributionItem((IAction)this.varLvlGraphAction));
        }
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
        this.varLvlGraphAction.setEnabled(state);
    }

    class ImpactPrgLvlGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public ImpactPrgLvlGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/impact_graph.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            ProjectInfo ezsourcePrj = (ProjectInfo)ImpactPrgLevelGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            String inp = (String)ImpactPrgLevelGraphAnalysisJob.this.analysis.getContextValue("inputs name string");
            if (inp.length() > 20) {
                inp = inp.substring(0, 17);
                inp = String.valueOf(inp) + "...";
            }
            StringBuilder sb = new StringBuilder(inp);
            sb.append(Messages.getString(ImpactPrgLevelGraphAnalysisJob.class, "tab.lbl", new String[]{ezsourcePrj.getName()}));
            this.tabName = sb.toString();
            return this.tabName;
        }

        public String getTooltip() {
            ProjectInfo ezsourcePrj = (ProjectInfo)ImpactPrgLevelGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            StringBuilder sb = new StringBuilder((String)ImpactPrgLevelGraphAnalysisJob.this.analysis.getContextValue("inputs name string"));
            sb.append(Messages.getString(ImpactPrgLevelGraphAnalysisJob.class, "tab.lbl", new String[]{ezsourcePrj.getName()}));
            return sb.toString();
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ImpactComponentBuilderAdapter(ImpactPrgLevelGraphAnalysisJob.this.legend, ImpactPrgLevelGraphAnalysisJob.this.graphModel, this.gfi);
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }
}

