/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact.prgLvl;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.ImpactPrgLevelGraphAnalysisJob;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactPrgLevelGraphAnalysis
extends MainframeGraphAnalysis {
    private static final Logger L = LoggerFactory.getLogger(ImpactPrgLevelGraphAnalysis.class);
    private ImpactPrgLevelGraphAnalysisJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (ImpactPrgLevelGraphAnalysisJob)wk.getJob(id, ImpactPrgLevelGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public String getLabelType() {
        return Messages.getString(ImpactPrgLevelGraphAnalysis.class, "impact.graph");
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_IMPACT_GRAPH_ANALYSIS;
    }

    public void setInputs(List inputs) {
        if (inputs != null && inputs.size() == 1) {
            String prjName = null;
            EZObjectType inpObj = (EZObjectType)inputs.get(0);
            EZEntityID entity = inpObj.getEntID();
            this.addContextValue("inputs name string", inpObj.getProperty("impact analysis name"));
            this.addContextValue("forward_key", inpObj.getProperty("forward_key"));
            this.addContextValue("env", inpObj.getProperty("env"));
            this.addContextValue("impact graph", inpObj.getProperty("impact graph"));
            this.addContextValue("ig folder", inpObj.getProperty("ig folder"));
            this.addContextValue("disk_count", inpObj.getProperty("disk_count"));
            List list = (List)inpObj.getProperty("processAnalysisInfo");
            if (entity != null) {
                ProjectInfo pi = ((EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class)).getProjectInfo();
                this.addContextValue("PROJECT_INFO", pi);
                prjName = pi.getName();
            }
            if (!list.isEmpty()) {
                this.addContextValue("input_list", list);
            }
            this.addContextValue("input_project_names", prjName);
        } else {
            L.warn("Wrong input for Impact process level analysis");
        }
    }
}

