/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact;

import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.GraphInnerElementWithPath;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.PathLabelObj;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class InventoryContentProvider
extends ContentProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private boolean forward = true;

    public InventoryContentProvider(boolean forward, MouseActionsHook mouseActionsHook) {
        super(mouseActionsHook);
        this.hasStringSorter = false;
        this.forward = forward;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GraphInnerElement) {
            GraphInnerElement elm = (GraphInnerElement)parentElement;
            List elems = elm.getElems();
            Collections.sort(elems, new Comparator<GraphInnerElement>(){

                @Override
                public int compare(GraphInnerElement o1, GraphInnerElement o2) {
                    if (o1 instanceof GraphInnerElementWithPath && o2 instanceof GraphInnerElementWithPath) {
                        return ((GraphInnerElementWithPath)o1).getPathid().compareTo(((GraphInnerElementWithPath)o2).getPathid());
                    }
                    return 0;
                }
            });
            return elems.toArray();
        }
        return EMPTY_ARRAY;
    }

    public ImageDescriptor getToolbarImage() {
        return Activator.getImageDescriptor("icons/sortByModule.png");
    }

    public String getToolbarName() {
        return Messages.getString(InventoryContentProvider.class, "toolbar.name");
    }

    protected GraphInnerElement getGIE(Object o1) {
        String name = null;
        TSGraphMember node = null;
        Integer pathId = null;
        GraphInnerElement gie = null;
        if (o1 instanceof PathLabelObj) {
            PathLabelObj pathLabelObj = (PathLabelObj)o1;
            pathId = pathLabelObj.getPathId();
            if (pathLabelObj.getNode() != null) {
                TSNode tnode = pathLabelObj.getNode();
                gie = new GraphInnerElementWithPath(this.computeName(tnode), pathId, (TSGraphMember)tnode);
            } else {
                List<TSNode> nodes = pathLabelObj.getNodes();
                node = (TSGraphMember)nodes.get(0);
                name = pathLabelObj.getPath();
                gie = new GraphInnerElementWithPath(name, pathId, (TSGraphMember)(this.forward ? ((TSENode)node).outEdge() : ((TSENode)node).inEdge()));
            }
        } else {
            gie = super.getGIE(o1);
        }
        return gie;
    }
}

