/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.ImpactAnnotatedGraphModel;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphAnalysis;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphEdgeLegendInfo;
import com.ez.graphs.viewer.callgraph.impact.prgLvl.ImpactPrgLevelGraphAnalysis;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.inputs.EZImpactPrgLvlInputType;
import com.ez.graphs.viewer.odb.analysis.inputs.EZSourceImpactPathIdSg;
import com.ez.graphs.viewer.odb.analysis.inputs.ImpactGraphContext;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.ProgramValue;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.graphs.viewer.odb.impact.model.disk.DiskGraph;
import com.ez.graphs.viewer.odb.impact.model.mem.MemGraph;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.analysis.config.context.IgnoreContext;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.utils.FileUtils;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.geometry.shared.TSRoundedRectangleShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactGraphModel
extends ImpactAnnotatedGraphModel {
    private static final Logger L = LoggerFactory.getLogger(ImpactGraphModel.class);
    private Map<Integer, List<TSENode>> tsNodeLevels = new HashMap<Integer, List<TSENode>>();
    private Map<String, TSNode> tsnodes = new HashMap<String, TSNode>();
    private Map<Long, String> tsNodesMap = new HashMap<Long, String>();
    public static final String SEL_PATH_NODES = "selpathNode";
    private static final String SEL_PATH_EDGE_LIST = "selpath";
    private File dbFile = null;
    private Properties metadata = null;
    private Action processLvlGraphAction;
    private Boolean forward;

    public ImpactGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = (ImpactGraphAnalysis)analysis;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        nodeBuilder.setShape((TSShape)new TSRoundedRectangleShape(0.2, true));
        nodeBuilder.setAttribute("Line_Width", (Object)0.0);
    }

    private void clearModel() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.tsNodeLevels.clear();
        this.tsnodes.clear();
        this.tsNodesMap.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void clearImpactModel() {
        AtomicInteger diskCount;
        block14: {
            block12: {
                try {
                    try {
                        if (this.dbg != null) {
                            ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)this.env);
                        }
                        this.dbg = null;
                    }
                    catch (Exception e) {
                        L.error("while clearing", (Throwable)e);
                        this.dbg = null;
                        this.env = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.dbg = null;
                    this.env = null;
                    throw throwable;
                }
                this.dbg = null;
                this.env = null;
            }
            try {
                try {
                    if (this.ig != null) {
                        this.ig.close();
                    }
                    this.ig = null;
                }
                catch (Throwable e) {
                    L.error("while closing ImpactGraph ", e);
                    this.ig = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.ig = null;
                throw throwable;
            }
            this.ig = null;
        }
        if (this.dbFile != null && (diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count")).decrementAndGet() == 0) {
            FileUtils.deleteFolder((File)this.dbFile.getParentFile());
        }
        this.dbFile = null;
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        L.debug("loading ImpactGraphModel");
        monitor.setTaskName(Messages.getString(ImpactGraphModel.class, "loading.graph"));
        this.clearModel();
        this.graphManager.startBatchProcessing(true);
        this.forward = (Boolean)this.analysis.getContextValue("forward_key");
        if (this.forward == null) {
            this.forward = Boolean.parseBoolean(this.getMetadata().getProperty("direction.forward", "true"));
        }
        HashSet<Long> processed = new HashSet<Long>();
        for (Node nn : this.ig.getStartNodes()) {
            ArrayList<Long> toExp = new ArrayList<Long>();
            toExp.add(nn.getId());
            while (!toExp.isEmpty()) {
                Long nid = (Long)toExp.remove(0);
                Node n = this.ig.getNode(nid);
                processed.add(nid);
                TSENode currentTSNode = this.getTSNode(n);
                List nextEdges = n.out(4);
                for (Long eId : nextEdges) {
                    Link e = this.ig.getLink(eId);
                    long toLong = e.to();
                    Node toProcessNode = this.ig.getNode(Long.valueOf(toLong));
                    if (!processed.contains(toLong)) {
                        toExp.add(0, toLong);
                    }
                    TSENode childTSNode = this.getTSNode(toProcessNode);
                    TSENode from = this.forward != false ? currentTSNode : childTSNode;
                    TSENode to = this.forward != false ? childTSNode : currentTSNode;
                    TSEdge edge = this.graph.getEdge((TSNode)from, (TSNode)to);
                    HashSet<ArrayList<Long>> ids = null;
                    if (edge == null) {
                        edge = this.graphManager.getEdgeBuilder().addEdge(this.graphManager, from, to);
                        ids = new HashSet<ArrayList<Long>>();
                        edge.setAttribute("nodeidSet", ids);
                    } else {
                        ids = (HashSet<ArrayList<Long>>)edge.getAttributeValue("nodeidSet");
                    }
                    ArrayList<Long> list = new ArrayList<Long>();
                    Long fromId = this.forward != false ? nid : toLong;
                    Long toId = this.forward != false ? toLong : nid;
                    list.add(fromId);
                    if (!this.forward.booleanValue()) {
                        list.add(0, toId);
                    } else {
                        list.add(toId);
                    }
                    ids.add(list);
                }
            }
        }
        if (this.graph.nodes().size() == 0) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(ImpactGraphModel.class, "no.results"));
        }
        this.graphManager.endBatchProcessing();
        this.edgeTypesSetForLegend.add(ImpactGraphEdgeLegendInfo.SELECTED_PATH);
        this.findAnnotations(monitor.newChild(10));
        monitor.setWorkRemaining(0);
    }

    private TSENode getTSNode(Node node) {
        TSENode tsNode;
        Value value = node.value();
        long nid = node.getId();
        String cls = "Unknown";
        if (value instanceof VertexValue) {
            cls = ((VertexValue)value).getVertexClass();
        } else if (value instanceof ProgramValue) {
            cls = "Program";
        }
        String nameKey = value.getContextId();
        if ("DSName".equals(cls)) {
            nameKey = value.getVertexName();
        }
        if ((tsNode = (TSENode)this.tsnodes.get(nameKey)) == null) {
            tsNode = (TSENode)this.graph.addNode();
            String name = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, (Value)value, (String)cls, (boolean)false);
            String prgName = (String)node.value().getContext("programName");
            if (prgName != null) {
                tsNode.setName((Object)(String.valueOf(name) + "(" + prgName + ")"));
            } else {
                tsNode.setName((Object)name);
            }
            if (this.ig.getStartNodes().contains(node)) {
                tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            }
            if (node.value().getContext("node is not expanded in callgraph") != null) {
                tsNode.setAttribute("node is not expanded in callgraph", (Object)Boolean.TRUE);
            }
            String clsLbl = Utils.getImpactLabel((String)cls);
            String info = clsLbl.concat(": ").concat(tsNode.getText());
            tsNode.setTooltipText(info);
            if ("Program".equals(cls)) {
                tsNode.setAttribute("prg type id", value.getContext("prg type id"));
            }
            this.setNodeUI(tsNode, cls);
            this.tsnodes.put(nameKey, (TSNode)tsNode);
            this.putEntryInGraphInventory(clsLbl, (TSNode)tsNode);
            tsNode.setAttribute("nodeid", (Object)nid);
            this.tsNodesMap.put(nid, name);
        } else {
            this.tsNodesMap.put(nid, (String)tsNode.getName());
        }
        return tsNode;
    }

    public void selectPath(TSGraphMember member, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ImpactGraphModel.class, "search.path.graph"));
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ImpactGraphModel.class.getClassLoader());
        this.clearPath();
        List<Long> currentPath = null;
        if (this.graph.hasSelectedNodes()) {
            ArrayList markedNodes = new ArrayList();
            markedNodes.addAll(this.graph.selectedNodes());
            HashSet<Long> selIds = new HashSet<Long>();
            for (TSENode tsn : markedNodes) {
                Long nId = (Long)tsn.getAttributeValue("nodeid");
                selIds.add(nId);
            }
        }
        if (currentPath != null) {
            Boolean forward = (Boolean)this.analysis.getContextValue("forward_key");
            this.markPath(forward, currentPath);
        }
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    public void clearPath() {
        this.graphManager.getEdgeBuilder().setAttribute("Color", (Object)TSEColor.black);
        List oldedgesList = (List)this.graphManager.getAttributeValue(SEL_PATH_EDGE_LIST);
        if (oldedgesList != null) {
            for (TSEdge e : oldedgesList) {
                e.setAttribute("Color", (Object)TSEColor.black);
                e.setAttribute("Edge_Style", (Object)0);
            }
            TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
            canvas.addInvalidRegion(oldedgesList);
            canvas.updateInvalidRegion(true);
        }
        this.graphManager.removeAttribute(SEL_PATH_EDGE_LIST);
        this.graphManager.removeAttribute(SEL_PATH_NODES);
        this.processLvlGraphAction.setEnabled(false);
    }

    private void markPath(boolean forward, List<Long> allNodes) {
        ArrayList<TSEdge> edgesList = new ArrayList<TSEdge>();
        int i = 0;
        while (i < allNodes.size() - 1) {
            TSENode toNode;
            Node from = this.ig.getNode(allNodes.get(i));
            Node to = this.ig.getNode(allNodes.get(i + 1));
            TSENode fromNode = forward ? this.getTSNode(from) : this.getTSNode(to);
            TSEdge edge = this.graph.getEdge((TSNode)fromNode, (TSNode)(toNode = forward ? this.getTSNode(to) : this.getTSNode(from)));
            if (edge != null) {
                edgesList.add(edge);
                edge.setAttribute("Color", (Object)TSEColor.red);
                edge.setAttribute("Edge_Style", (Object)3);
            }
            ++i;
        }
        TSSwingCanvas canvas = (TSSwingCanvas)this.graphManager.getCurrentCanvas();
        canvas.addInvalidRegion(edgesList);
        canvas.updateInvalidRegion(true);
        this.graphManager.setAttribute(SEL_PATH_EDGE_LIST, edgesList);
        this.graphManager.setAttribute(SEL_PATH_NODES, allNodes);
        if (edgesList.size() > 0) {
            this.processLvlGraphAction.setEnabled(true);
        }
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null && img.toString() != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
            if (node.hasAttribute("node is input for callgraph") && ((Boolean)node.getAttributeValue("node is input for callgraph")).booleanValue()) {
                node.setAttribute("Text_Color", (Object)TSEColor.blue);
            } else if (node.hasAttribute("node is not expanded in callgraph")) {
                node.setAttribute("Text_Color", (Object)TSEColor.darkRed);
            }
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            Object textColor = node.getAttributeValue("Color");
            if (textColor != null) {
                node.setAttribute("Text_Color", textColor);
            }
        }
    }

    public void updateDrawing() {
        TSDGraph hide;
        super.updateDrawing();
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    private void putEntryInGraphInventory(String lbl, TSNode node) {
        HashSet<TSNode> nodes;
        HashMap<String, HashSet<TSNode>> pm = (HashMap<String, HashSet<TSNode>>)this.outForGISV.get(ContentProvider.class.getName());
        if (pm == null) {
            pm = new HashMap<String, HashSet<TSNode>>();
            this.outForGISV.put(ContentProvider.class.getCanonicalName(), pm);
        }
        if ((nodes = (HashSet<TSNode>)pm.get(lbl)) == null) {
            nodes = new HashSet<TSNode>();
            pm.put(lbl, nodes);
        }
        nodes.add(node);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        if (objType == null) {
            objType = this.createApplicableInputType(gNode);
            gNode.setAttribute("APPLICABLE_INPUT", (Object)objType);
        }
        Set<List<Long>> dsPath = this.computePathForProcessAnalysis(gNode);
        this.addInfoForProcessAnalysis(objType, dsPath);
        return objType;
    }

    private EZObjectType createApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        long nId = (Long)gNode.getAttributeValue("nodeid");
        Node node = this.ig.getNode(Long.valueOf(nId));
        Value value = node.value();
        OrientVertex vertex = this.dbg.getVertex((Object)value.id());
        if (vertex != null) {
            ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
            objType = Utils.getResourceType((Vertex)vertex, (ProjectInfo)ezsourcePrj, (boolean)true);
        }
        return objType;
    }

    public EZObjectType getApplicableInputType(List<TSNode> gNodeList) {
        EZImpactPrgLvlInputType objType = null;
        Set<List<Long>> dsPath = this.computePathForProcessAnalysis(null);
        if (dsPath != null) {
            objType = new EZImpactPrgLvlInputType();
            EZEntityID entity = new EZEntityID();
            objType.setEntID(entity);
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg((ProjectInfo)this.analysis.getContextValue("PROJECT_INFO"));
            entity.addSegment((EZSegment)prjIdSg);
            this.addInfoForProcessAnalysis((EZObjectType)objType, dsPath);
        }
        return objType;
    }

    private void addInfoForProcessAnalysis(EZObjectType objType, Set<List<Long>> dsPath) {
        if (dsPath != null && !dsPath.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String impactGraphHashCode = String.valueOf(this.ig.hashCode());
            ArrayList<EZSourceImpactPathIdSg> sgs = new ArrayList<EZSourceImpactPathIdSg>();
            for (List<Long> dsInfo : dsPath) {
                Long firstId = dsInfo.get(0);
                Long lastId = dsInfo.get(1);
                EZSourceImpactPathIdSg pathSg = new EZSourceImpactPathIdSg(impactGraphHashCode, firstId, lastId);
                sgs.add(pathSg);
                if (sb.length() != 0) continue;
                sb.append(this.tsNodesMap.get(firstId));
                sb.append(", ");
                sb.append(this.tsNodesMap.get(lastId));
            }
            objType.addProperty("processAnalysisInfo", sgs);
            objType.addProperty("impact analysis name", (Object)sb.toString());
            objType.addProperty("disk_count", this.analysis.getContextValue("disk_count"));
            objType.addProperty("env", this.analysis.getContextValue("env"));
            boolean onDisk = Boolean.parseBoolean(System.getProperty("impactOnDisk", "true"));
            if (!onDisk) {
                objType.addProperty("impact graph", (Object)this.getImpactGraph());
            } else {
                objType.addProperty("ig folder", (Object)this.dbFile.getAbsoluteFile());
            }
            objType.addProperty("forward_key", this.analysis.getContextValue("forward_key"));
            objType.setContext(ImpactGraphContext.class);
        } else if (objType != null) {
            objType.addProperty("processAnalysisInfo", null);
            objType.setContext(IgnoreContext.class);
        }
    }

    private Set<List<Long>> computePathForProcessAnalysis(TSNode gNode) {
        Set<List<Long>> result = null;
        List dsPath = (List)this.graphManager.getAttributeValue(SEL_PATH_NODES);
        boolean foundTSNodeInPath = false;
        if (gNode == null) {
            foundTSNodeInPath = true;
        }
        if (dsPath == null) {
            List selEdges = this.graph.selectedEdges();
            if (selEdges.size() == 1) {
                TSEdge edge = (TSEdge)selEdges.get(0);
                result = (Set)edge.getAttributeValue("nodeidSet");
            } else {
                L.warn("no path and no edge selected!");
            }
        } else {
            result = new HashSet<List<Long>>();
            result.add(dsPath);
        }
        if (gNode != null && result != null) {
            Long glNode = (Long)gNode.getAttributeValue("nodeid");
            if (result.toString().contains(String.valueOf(glNode))) {
                foundTSNodeInPath = true;
            }
        }
        if (!foundTSNodeInPath) {
            return null;
        }
        return result;
    }

    public void dispose() {
        this.processLvlGraphAction = null;
        this.clearModel();
        this.clearImpactModel();
        super.dispose();
    }

    public OrientExtendedGraph createOrientGraph(Properties env) {
        if (this.dbg != null) {
            throw new IllegalStateException("graph already instantiated");
        }
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        this.env = env;
        return this.dbg;
    }

    public ImpactGraph getImpactGraph() {
        return this.ig;
    }

    public ImpactGraph createImpactGraph(boolean onDisk, boolean loadFromDisk, String modelFile, File dbFileP, PrintWriter impactResPW) {
        AtomicInteger diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count");
        if (diskCount == null) {
            diskCount = new AtomicInteger();
            diskCount.set(0);
            this.analysis.addContextValue("disk_count", (Object)diskCount);
        }
        diskCount.incrementAndGet();
        if (this.ig != null) {
            throw new IllegalStateException("impact graph already instantiated");
        }
        if (onDisk) {
            if (loadFromDisk) {
                this.metadata = (Properties)this.analysis.getContextValue("metadata");
                try {
                    File f = (File)this.analysis.getContextValue("tempfile");
                    this.dbFile = new File(f, "ig");
                }
                catch (Exception e) {
                    throw new IllegalStateException("could not continue without necessary temporary folders", e);
                }
            } else {
                this.metadata = null;
                this.dbFile = dbFileP;
            }
            this.ig = new DiskGraph(loadFromDisk, this.dbFile, impactResPW);
        } else {
            this.ig = new MemGraph();
        }
        return this.ig;
    }

    public File getModelFile() {
        return this.dbFile == null ? null : this.dbFile.getParentFile();
    }

    public Properties getMetadata() {
        return this.metadata;
    }

    public Action createCustomAction() {
        if (this.processLvlGraphAction == null) {
            this.processLvlGraphAction = new Action(){

                public void run() {
                    List<TSNode> list = null;
                    EZObjectType inputType = ImpactGraphModel.this.getApplicableInputType(list);
                    if (inputType != null) {
                        L.debug("analysis inputType {}", (Object)inputType.getName());
                        EZAnalysisType analysisType = EZWorkspace.getInstance().getSpecificAnalysisType(inputType, ImpactPrgLevelGraphAnalysis.class);
                        if (analysisType != null) {
                            L.debug("analysisType: {}", (Object)analysisType.getName());
                            EZAnalysis analysis = analysisType.getImplementorInstance();
                            ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
                            inputs.add(inputType);
                            analysis.setInputs(inputs);
                            analysis.addContextValue("projects", ImpactGraphModel.this.analysis.getContextValue("projects"));
                            L.debug("before execute processLvlGraphAction");
                            analysis.execute();
                        }
                    }
                }
            };
            this.processLvlGraphAction.setText(Messages.getString(ImpactGraphModel.class, "processLvl.action.text"));
            this.processLvlGraphAction.setToolTipText(Messages.getString(ImpactGraphModel.class, "processLvl.action.tooltip"));
            ImageDescriptor id = Activator.getImageDescriptor("icons/impact_graph.png");
            this.processLvlGraphAction.setImageDescriptor(id);
            this.processLvlGraphAction.setEnabled(false);
        }
        return this.processLvlGraphAction;
    }
}

