/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.ImpactComponentBuilderAdapter;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphFilterInfo;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphModel;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphMouseActionsHook;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.wizard.ExcludedResourcesFromImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Expander;
import com.ez.graphs.viewer.odb.impact.model.ExportImpactModel;
import com.ez.graphs.viewer.odb.impact.model.Impact;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.NodeExpander;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.preferences.Utils;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactGraphAnalysisJob
extends AnnotatedGraphJob {
    private static final Logger L = LoggerFactory.getLogger(ImpactGraphAnalysisJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;
    private PrintWriter impactResPW = null;
    private Action processLvlGraphAction = null;
    private boolean ignoreCancel = false;

    public ImpactGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new ImpactGraphMouseActionsHook(id);
        this.initGraphDetails();
        this.mouseActionsHook.setGraphModel(this.graphModel);
        this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
    }

    protected boolean shouldStop(IProgressMonitor monitor) {
        return !this.ignoreCancel && monitor.isCanceled();
    }

    protected void initGraphDetails() {
        boolean onDisk;
        this.graphInfo = new ImpactGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphManager = new AnalysisGraphManager();
        this.gfi = new ImpactGraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.graphModel = new ImpactGraphModel((AnalysisGraphManager)this.graphManager, this.analysis);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            icp.setToolbarImage(Activator.getImageDescriptor("icons/sortByType.png"));
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        if (onDisk = Boolean.parseBoolean(System.getProperty("impactOnDisk", "true"))) {
            ArrayList<Class<ExportImpactModel>> impl = new ArrayList<Class<ExportImpactModel>>();
            impl.add(ExportImpactModel.class);
            this.graphManager.setAttribute("extraExportListImplementors", impl);
            HashMap<String, File> prop = new HashMap<String, File>();
            prop.put("impactGraphModelFile", ((ImpactGraphModel)this.graphModel).getModelFile());
            this.graphManager.setAttribute("exportImpactProperties", prop);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        super.computeResults(graphModel, monitor);
        L.debug("impact graph - computeResults");
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(ImpactGraphAnalysisJob.class, "collectingData.taskName"));
        this.processInputs((IProgressMonitor)pmonitor.newChild(100));
        pmonitor.setWorkRemaining(0);
    }

    private void processInputs(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)300);
        monitor.setTaskName(Messages.getString(ImpactGraphAnalysisJob.class, "compute.taskName"));
        Properties env = (Properties)this.analysis.getContextValue("env");
        try {
            this.impact(env, (IProgressMonitor)monitor.newChild(300));
        }
        catch (IOException e) {
            L.error("while generating model", (Throwable)e);
        }
        monitor.setWorkRemaining(0);
    }

    private void impact(Properties env, IProgressMonitor pmonitor) throws IOException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        boolean onDisk = Boolean.parseBoolean(System.getProperty("impactOnDisk", "true"));
        boolean loadFromDisk = false;
        String modelPath = (String)env.get("loadModelFile");
        if (modelPath != null) {
            loadFromDisk = true;
        }
        ((ImpactGraphModel)this.graphModel).clearImpactModel();
        File dbFile = null;
        if (!loadFromDisk) {
            dbFile = this.createDBFile();
        }
        ImpactGraph ig = ((ImpactGraphModel)this.graphModel).createImpactGraph(onDisk, loadFromDisk, modelPath, dbFile, this.impactResPW);
        OrientExtendedGraph graph = ((ImpactGraphModel)this.graphModel).createOrientGraph(env);
        File location = ((ImpactGraphModel)this.graphModel).getModelFile();
        Properties metadata = ((ImpactGraphModel)this.graphModel).getMetadata();
        if (!onDisk || !loadFromDisk) {
            String outFile = env.getProperty("impact.outFile");
            BufferedWriter out = null;
            if (outFile != null) {
                out = new BufferedWriter(new FileWriter(outFile));
            }
            List resources = this.analysis.getContextListValue("resource_name_key");
            int maxLvl = (Integer)this.analysis.getContextValue("max cycles");
            boolean forward = (Boolean)this.analysis.getContextValue("forward_key");
            String program = (String)this.analysis.getContextValue("program");
            String resType = (String)this.analysis.getContextValue("res_type");
            List varIds = this.analysis.getContextListValue("var_ids_key");
            Map dalRes = (Map)this.analysis.getContextValue("dal_ids_key");
            Map bmsProxyRes = (Map)this.analysis.getContextValue("bmsproxy_ids_key");
            Map resRids = null;
            if (dalRes != null) {
                resRids = dalRes;
            } else if (bmsProxyRes != null) {
                resRids = bmsProxyRes;
            }
            String filePath = (String)this.analysis.getContextValue("excludeResFromFile");
            HashMap excludedRes = null;
            if (filePath != null) {
                excludedRes = ExcludedResourcesFromImpactGraph.readExcludedResFromFile((String)filePath);
            }
            this.ignoreCancel = new Impact(graph, (Writer)out).doImpact(ig, (NodeExpander)new Expander(graph, forward), forward, maxLvl, resType, resources, program, varIds, resRids, true, location, excludedRes, metadata, (IProgressMonitor)monitor.newChild(100));
            if (this.impactResPW != null) {
                this.impactResPW.close();
            } else {
                L.warn("the impact-results.imx wasn't created for this impact graph.");
            }
        }
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.getString(ImpactGraphAnalysisJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)pmonitor.newChild(50), result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            List nodesSetsList = this.graphModel.getGraph().nodes();
            allNodes.addAll(nodesSetsList);
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
        this.processLvlGraphAction = ((ImpactGraphModel)this.graphModel).createCustomAction();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Object> toolbars = new ArrayList<Object>();
        if (this.processLvlGraphAction != null) {
            L.debug("add 'process level impact' toolbar action");
            toolbars.add(new Separator());
            toolbars.add(new ActionContributionItem((IAction)this.processLvlGraphAction));
        }
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    protected File createDBFile() {
        File dbFile = null;
        String temp = Utils.getTemporaryFolder();
        String impResFileName = null;
        try {
            File base = new File(temp, "ig");
            base.mkdirs();
            File f = File.createTempFile("inst-", Long.toString(-System.currentTimeMillis()), base);
            f.delete();
            f.mkdirs();
            dbFile = new File(f, "ig");
            impResFileName = String.valueOf(f.getAbsolutePath()) + File.separator + "impact-results.imx";
        }
        catch (Exception e) {
            L.error("could not create temporary file in " + temp, (Throwable)e);
            throw new IllegalStateException("could not create necessary temporary folders in " + temp, e);
        }
        this.setImpactResultsFile(impResFileName);
        return dbFile;
    }

    protected void setImpactResultsFile(String impResFileName) {
        try {
            this.impactResPW = new PrintWriter(new FileWriter(impResFileName));
        }
        catch (IOException ex) {
            System.out.println("ioex when opening impact-results.imx file");
            L.warn("ioex when opening impact-results.imx file", (Throwable)ex);
        }
    }

    class ImpactGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public ImpactGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/impact_graph.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            ProjectInfo ezsourcePrj = (ProjectInfo)ImpactGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            StringBuilder sb = new StringBuilder();
            Object resourceType = ImpactGraphAnalysisJob.this.analysis.getContextValue("res_type");
            if (resourceType != null) {
                sb.append(resourceType);
                sb.append(" ");
                Object resourceName = ImpactGraphAnalysisJob.this.analysis.getContextValue("resource_name_key");
                sb.append(resourceName);
            }
            sb.append(Messages.getString(ImpactGraphAnalysisJob.class, "tabName", new String[]{ezsourcePrj.getName()}));
            this.tabName = sb.toString();
            return this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(this.tabName);
            Boolean direction = (Boolean)ImpactGraphAnalysisJob.this.analysis.getContextValue("forward_key");
            if (direction.booleanValue()) {
                buf.append(Messages.getString(ImpactGraphAnalysisJob.class, "f.option"));
            } else {
                buf.append(Messages.getString(ImpactGraphAnalysisJob.class, "b.option"));
            }
            Integer limit = (Integer)ImpactGraphAnalysisJob.this.analysis.getContextValue("max cycles");
            if (limit != null && limit > 0) {
                buf.append(Messages.getString(ImpactGraphAnalysisJob.class, "l.option"));
                buf.append(limit);
            }
            return buf.toString();
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ImpactComponentBuilderAdapter(ImpactGraphAnalysisJob.this.legend, ImpactGraphAnalysisJob.this.graphModel, this.gfi);
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setContentProviderInputTree(Map map) {
            if (this.contentProviders != null) {
                for (StructureContentProvider provider : this.contentProviders) {
                    provider.setInputTree((Map)ImpactGraphAnalysisJob.this.graphModel.getOutForStructView().get(provider.getClass().getName()));
                }
            }
        }
    }
}

