/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphAnalysisJob;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.analysis.wizard.ImpactInputsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.preferences.Utils;
import com.ez.workspace.utils.FileUtils;
import com.ibm.ad.internal.PasswordUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactGraphAnalysis
extends MainframeGraphAnalysis {
    private static final Logger L = LoggerFactory.getLogger(ImpactGraphAnalysis.class);
    private ImpactGraphAnalysisJob job;

    protected void continueAnalysisForLocal() {
        this.prepareInputs();
        super.continueAnalysisForLocal();
    }

    private void prepareInputs() {
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.error("graphDB is not configured!");
        } else {
            String value = null;
            String host = srv.getString("general.networking.graphdb", "graphdb.host", null, null);
            String port = srv.getString("general.networking.graphdb", "graphdb.port", "2424", null);
            value = srv.getString("general.networking.graphdb", "graphdb.username", null, null);
            String odbUser = value != null ? value : "";
            value = srv.getString("general.networking.graphdb", "graphdb.password", null, null);
            String odbPass = value != null ? value : "";
            odbPass = PasswordUtils.decrypt((String)odbPass);
            ProjectInfo ezsourcePrj = (ProjectInfo)this.getContextValue("PROJECT_INFO");
            String connection = "remote:" + host + ":" + port + "/" + ezsourcePrj.getName();
            L.debug("orientdb connection:" + connection + " with user " + odbUser);
            Properties env = new Properties();
            env.put("gdb.connection", connection);
            env.put("db", "EZ_" + ezsourcePrj.getName());
            env.put("gdb.user", odbUser);
            env.put("gdb.pass", odbPass);
            this.addContextValue("env", env);
            File f = (File)this.getContextValue("loadModelFile");
            if (f != null) {
                env.put("loadModelFile", f.getAbsolutePath());
            } else {
                List inputEntities = this.getContextListValue("inputEntities");
                String resourceType = (String)this.getContextValue("res_type");
                if (inputEntities != null) {
                    ArrayList<String> resNames = new ArrayList<String>();
                    for (EZEntityID id : inputEntities) {
                        EZSourceDatasetIDSg sg;
                        String name = null;
                        if ("dataset".equals(resourceType)) {
                            sg = (EZSourceDatasetIDSg)id.getSegment(EZSourceDatasetIDSg.class);
                            name = sg.getDatasetName();
                        } else if ("sqlField".equals(resourceType)) {
                            sg = (EZSourceSQLFieldTableIDSg)id.getSegment(EZSourceSQLFieldTableIDSg.class);
                            name = String.valueOf(sg.getSQLTableName()) + ":" + sg.getSQLFieldName();
                        } else if ("sqlTable".equals(resourceType)) {
                            sg = (EZSourceSQLTableIDSg)id.getSegment(EZSourceSQLTableIDSg.class);
                            name = sg.getSQLTableName();
                        } else if ("dalFile".equals(resourceType)) {
                            sg = (EZSourceDALIDSg)id.getSegment(EZSourceDALIDSg.class);
                            name = sg.getDALName();
                        } else if ("screen".equals(resourceType)) {
                            sg = (EZSourceScreenIDSg)id.getSegment(EZSourceScreenIDSg.class);
                            name = sg.getScreenName();
                        } else if ("cobolprogram".equals(resourceType)) {
                            sg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
                            name = sg.getProgramName();
                        } else if ("include".equals(resourceType)) {
                            sg = (EZSourceIncludeIDSg)id.getSegment(EZSourceIncludeIDSg.class);
                            name = sg.getIncludeName();
                        }
                        if (name == null) continue;
                        resNames.add(name);
                    }
                    this.addContextValue("resource_name_key", resNames);
                }
                env.put("res_type", resourceType);
                env.put("max cycles", this.getContextValue("max cycles"));
                env.put("forward_key", this.getContextValue("forward_key"));
                if (this.getContextValue("program") != null) {
                    env.put("program", this.getContextValue("program"));
                }
            }
            boolean loadFromDisk = false;
            String modelPath = (String)env.get("loadModelFile");
            if (modelPath != null) {
                loadFromDisk = true;
            }
            if (loadFromDisk) {
                this.loadMetadata(modelPath);
            }
        }
    }

    private void loadMetadata(String modelPath) {
        String temp = Utils.getTemporaryFolder();
        try {
            Properties metadata;
            File ff;
            block14: {
                File base = new File(temp, "ig");
                base.mkdirs();
                ff = File.createTempFile("inst-", Long.toString(-System.currentTimeMillis()), base);
                ff.delete();
                ff.mkdirs();
                boolean ok = FileUtils.unZipIt((String)modelPath, (String)ff.getAbsolutePath());
                if (!ok) {
                    throw new IllegalStateException("impact model " + modelPath + " could not be read");
                }
                metadata = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = new FileInputStream(new File(ff, "metadata.properties"));
                        metadata.load(is);
                        this.putMetadataInAnalysis(metadata);
                    }
                    catch (IOException e) {
                        L.error("could not read metadata", (Throwable)e);
                        try {
                            is.close();
                        }
                        catch (Exception e2) {
                            L.error("could not close stream", (Throwable)e2);
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        L.error("could not close stream", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (Exception e) {
                    L.error("could not close stream", (Throwable)e);
                }
            }
            this.addContextValue("metadata", metadata);
            this.addContextValue("tempfile", ff);
        }
        catch (Exception e) {
            L.error("could not create temporary file in " + temp, (Throwable)e);
            throw new IllegalStateException("could not create necessary temporary folders in " + temp, e);
        }
    }

    private void putMetadataInAnalysis(Properties metadata) {
        String val = metadata.getProperty("direction.forward");
        if (val == null) {
            L.warn("no direction is set!");
        } else {
            this.addContextValue("forward_key", Boolean.parseBoolean(val));
        }
        val = metadata.getProperty("max.level");
        if (val == null) {
            L.warn("no maxLevel is set!");
        } else {
            this.addContextValue("max cycles", Integer.parseInt(val));
        }
        val = metadata.getProperty("resourceType");
        if (val == null) {
            L.info("no resourceType is set!");
        } else {
            this.addContextValue("res_type", val);
        }
        val = metadata.getProperty("programName");
        if (val == null) {
            L.debug("no program is set!");
        } else {
            this.addContextValue("program", val);
        }
        ArrayList<String> resNames = new ArrayList<String>();
        int nr = Integer.valueOf(metadata.getProperty("resources.nr"));
        int i = 0;
        while (i < nr) {
            resNames.add(metadata.getProperty("resource." + i));
            ++i;
        }
        this.addContextValue("resource_name_key", resNames);
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (ImpactGraphAnalysisJob)wk.getJob(id, ImpactGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public String getLabelType() {
        return Messages.getString(ImpactGraphAnalysis.class, "impact.graph");
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_IMPACT_GRAPH_ANALYSIS;
    }

    protected boolean prerequisitesCheck() {
        boolean ret = true;
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.error("graphDB is not configured!");
            ret = false;
        } else {
            String host = srv.getString("general.networking.graphdb", "graphdb.host", null, null);
            String port = srv.getString("general.networking.graphdb", "graphdb.port", "2424", null);
            String odbUser = srv.getString("general.networking.graphdb", "graphdb.username", null, null);
            String odbPass = srv.getString("general.networking.graphdb", "graphdb.password", null, null);
            if (host == null || host.trim().isEmpty() || port == null || port.trim().isEmpty() || odbUser == null || odbUser.trim().isEmpty() || odbPass == null || odbPass.isEmpty()) {
                ret = false;
            }
        }
        if (!ret) {
            String msg = "OrientDB connection details are not set";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            LogUtil.displayErrorMessage((Throwable)e, (String)msg, (String)"inssuficient setup", (Plugin)Activator.getDefault(), (boolean)true);
            L.error(msg, (Throwable)e);
        }
        return true;
    }

    protected InputsFilter getInputsFilter() {
        ImpactInputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        L.debug("start for impact graph on resources.");
        if (inputs != null && inputs.size() >= 1) {
            iFilter = new ImpactInputsFilter(inputs, (ProjectInfo)this.getContextValue("PROJECT_INFO"));
        }
        return iFilter;
    }

    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (ret) {
            Object resourceType2;
            Boolean forward2;
            AbstractAnalysis a2 = (AbstractAnalysis)obj;
            Boolean forward = (Boolean)this.getContextValue("forward_key");
            if (!forward.equals(forward2 = (Boolean)a2.getContextValue("forward_key"))) {
                return false;
            }
            Integer limit = (Integer)this.getContextValue("max cycles");
            Integer limit2 = (Integer)a2.getContextValue("max cycles");
            if (limit != null && limit2 == null || limit2 != null && limit == null || limit2.intValue() != limit.intValue()) {
                return false;
            }
            Object resourceType = this.getContextValue("res_type");
            if (!resourceType.equals(resourceType2 = a2.getContextValue("res_type"))) {
                return false;
            }
            Object resourceName = this.getContextValue("resource_name_key");
            Object resourceName2 = a2.getContextValue("resource_name_key");
            if (resourceName == null || !resourceName.equals(resourceName2)) {
                return false;
            }
            Object prgName = this.getContextValue("program");
            Object prgName2 = a2.getContextValue("program");
            if (prgName != null && !prgName.equals(prgName2) || prgName2 != null && !prgName2.equals(prgName)) {
                return false;
            }
            List varIds = this.getContextListValue("var_ids_key");
            List varIds2 = a2.getContextListValue("var_ids_key");
            if (varIds == null && varIds2 != null || varIds != null && !varIds.equals(varIds2)) {
                return false;
            }
        }
        return ret;
    }
}

