/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.graphs.viewer.callgraph.impact.ImpactGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ImpactComponentBuilderAdapter
implements ComponentBuilderInterface {
    private LegendPanel legend;
    private AbstractAnalysisGraphModel graphModel;
    private GraphFilterInfo gfi;

    public ImpactComponentBuilderAdapter(LegendPanel legend, AbstractAnalysisGraphModel graphModel, GraphFilterInfo gfi) {
        this.legend = legend;
        this.graphModel = graphModel;
        this.gfi = gfi;
    }

    public Composite buildComponent(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        this.legend = new LegendPanel((Composite)sc, 0);
        Utils.setImageProvider((LegendPanel)this.legend);
        int uiStyle = this.graphModel.getUIStyle();
        this.addEntriesToLegend(this.legend, uiStyle, this.gfi);
        sc.setContent((Control)this.legend);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.legend.pack();
        sc.setMinSize(this.legend.getSize());
        return sc;
    }

    public int getPercent() {
        int legendW = this.legend.getSize().x;
        int x = this.legend.getParent().getParent().getSize().x;
        int percent = 100 * (x - legendW) / x;
        return percent;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        Utils.addMainframeNodesToLegend((LegendPanel)legend, (int)uiStyle, (boolean)false, (Set)this.graphModel.getNodeTypesForLegend());
        this.addEdgesToLegend(legend);
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        edgeTypesSetForLegend.add(ImpactGraphEdgeLegendInfo.PATH);
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }
}

