/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.impact;

import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.graphs.AnnotatedGraphModel;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ImpactAnnotatedGraphModel
extends AnnotatedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final String NODE_LONGID_ATTRIBUTE = "nodeid";
    protected static final String NODE_LONGID_ATTRIBUTE_SET = "nodeidSet";
    protected ImpactGraph ig = null;
    protected OrientBaseGraph dbg;
    protected Properties env;
    protected AbstractAnalysis analysis;

    protected Map<EZObjectType, TSENode> prepareInputs(boolean isAnnDbAvailable) {
        HashMap<EZObjectType, TSENode> tmp = new HashMap<EZObjectType, TSENode>();
        ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        List nodes = this.graph.nodes();
        for (TSENode gNode : nodes) {
            Vertex vertex;
            EZObjectType objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
            if (objType == null && (vertex = this.getVertex(gNode)) != null) {
                objType = this.createTempResType(vertex, ezsourcePrj);
            }
            if (objType == null) continue;
            tmp.put(objType, gNode);
            this.annStateManager.register(objType.getEntID(), (Object)gNode);
        }
        return tmp;
    }

    protected Vertex getVertex(TSENode gNode) {
        OrientVertex vertex = null;
        Long nId = (Long)gNode.getAttributeValue(NODE_LONGID_ATTRIBUTE);
        if (nId != null) {
            Node node = this.ig.getNode(nId);
            Value value = node.value();
            vertex = this.dbg.getVertex((Object)value.id());
        }
        return vertex;
    }

    private EZObjectType createTempResType(Vertex v, ProjectInfo ezsourcePrj) {
        EZObjectType inputType = null;
        EZSourceProgramIDSg resourceSg = null;
        String cls = (String)v.getProperty("@class");
        EZEntityID extraInfoEntity = null;
        if ("Program".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1));
            Integer programId = (Integer)v.getProperty("sid");
            String prgName = (String)v.getProperty("name");
            Boolean occur = true;
            inputType.addProperty("program occur", (Object)occur);
            resourceSg = new EZSourceProgramIDSg(prgName, programId, Integer.valueOf(1), occur);
        } else if ("JCLJob".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
            String jobName = (String)v.getProperty("name");
            Integer jobId = (Integer)v.getProperty("sid");
            String memberName = null;
            String ca7JobName = null;
            Integer ca7jobId = null;
            resourceSg = new EZSourceJobIDSg(jobName, jobId.intValue(), Integer.valueOf(22), memberName, ca7JobName, ca7jobId);
            extraInfoEntity = new EZEntityID();
            extraInfoEntity.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(jobName, null));
        }
        if (inputType != null) {
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(ezsourcePrj));
            if (resourceSg != null) {
                entity.addSegment(resourceSg);
                if (extraInfoEntity != null) {
                    entity.addEntitySegments(extraInfoEntity);
                }
            }
            inputType.setEntID(entity);
        }
        return inputType;
    }

    public void setNodeUI(TSENode node, String cls) {
        Utils.setResourceUIStyle((TSNode)node, (String)cls, (Set)this.nodeTypesSetForLegend);
        this.setNodeUI(node);
    }
}

